/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationProgressEvent;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.DetailsDialog;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobHelper;
import oracle.install.commons.util.progress.JobProgressBar;
import oracle.install.commons.util.progress.JobTable;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.ProgressModelEvent;
import oracle.install.commons.util.progress.ProgressModelListener;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Status;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

public class ProgressPane
extends JPanel
implements ProgressUI<Component> {
    private static final Logger logger = Logger.getLogger(ProgressPane.class.getName());
    private ProgressModel progressModel = new ProgressModel();
    private MultiLineLabel lblActivityText;
    private JobProgressBar pbrProgress;
    private JobTable tblTasks;
    private JTextArea txaLog;
    private JButton btnDetails;
    private JButton btnRetry;
    private JButton btnSkip;
    private JButton btnContinue;
    private boolean errorReportingEnabled;
    private Job lastRetriableFailedJob;
    private Job lastWaitingJob;
    private JPanel controlPane;
    private JPanel customPane;
    private boolean retryOrSkipInProgress;

    public ProgressPane() {
        this(true);
    }

    public ProgressPane(boolean initializeView) {
        if (initializeView) {
            this.buildUI();
        }
    }

    public boolean isErrorReportingEnabled() {
        return this.errorReportingEnabled;
    }

    public void setErrorReportingEnabled(boolean errorReportingEnabled) {
        this.errorReportingEnabled = errorReportingEnabled;
    }

    @Override
    public Component getOwner() {
        return this;
    }

    @Override
    public void setCompositeJobs(CompositeJob ... jobs) {
        if (this.progressModel != null) {
            this.progressModel.setCompositeJobs(jobs);
        }
    }

    @Override
    public ProgressModel getProgressModel() {
        return this.progressModel;
    }

    @Override
    public void setProgressModel(ProgressModel progressModel) {
        this.progressModel = progressModel;
        this.tblTasks.setProgressModel(this.progressModel);
        this.pbrProgress.setModel(progressModel);
    }

    @Override
    public void setLogLocation(String logLocation) {
        DetailsDialog.getInstance(this).setLogLocation(logLocation);
    }

    @Override
    public void log(Level level, String message, Object ... args) {
        if (message != null) {
            if (args != null && args.length > 0) {
                try {
                    message = MessageFormat.format(message, args);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, String.format("The given log message \"%s\" do not conform to java.text.MessageFormat specification", message));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, String.format("Failed to format the given message \"%s\"", message), e);
                }
            }
        } else {
            message = "";
        }
        final String messageFinal = message;
        final Level levelFinal = level;
        SwingUtils.invokeTask(new Callable<Void>(){

            @Override
            public Void call() {
                ProgressPane.this.lblActivityText.setText(messageFinal);
                DetailsDialog detailsDialog = DetailsDialog.getInstance(ProgressPane.this);
                detailsDialog.log(levelFinal, messageFinal);
                return null;
            }
        });
        logger.log(level, message);
    }

    @Override
    public void reset() {
        this.txaLog.setText("");
        this.progressModel.clear();
    }

    public void buildUI() {
        this.lblActivityText = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.lblActivityText.setMaximumRows(2);
        this.lblActivityText.setMinimumRows(2);
        this.pbrProgress = new JobProgressBar();
        Application application = Application.getInstance();
        Resource resource = application.getResource(StringResourceBundle.class.getName());
        JPanel pnlProgress = new JPanel(new GridBagLayout());
        pnlProgress.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resource.getString("ProgressPane.pnlProgress.text", "Progress", new Object[0])));
        Insets insets = new Insets(5, 5, 5, 5);
        LayoutUtils.addComponent(this.pbrProgress, pnlProgress, 0, 0, 1, 1, 2, 18, 1.0, 0.0, insets);
        LayoutUtils.addComponent((Component)this.lblActivityText, pnlProgress, 0, 1, 1, 1, 1, 18, 1.0, 1.0, insets);
        this.tblTasks = new JobTable();
        this.setProgressModel(this.progressModel);
        this.txaLog = new JTextArea();
        this.txaLog.setEditable(false);
        JPanel pnlStatus = new JPanel(new GridBagLayout());
        pnlStatus.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resource.getString("ProgressPane.pnlStatus.text", "Status", new Object[0])));
        JScrollPane scrollPane = new JScrollPane(this.tblTasks);
        scrollPane.getViewport().setBackground(this.tblTasks.getBackground());
        LayoutUtils.addComponent(scrollPane, pnlStatus, 0, 0, 1, 1, 1, 18, 1.0, 1.0, insets);
        this.controlPane = new JPanel(new GridBagLayout());
        this.btnDetails = new JButton();
        this.btnDetails.setName("ProgressPane.btnDetails");
        SwingUtils.setText(this.btnDetails, resource.getString("ProgressPane.btnDetails.text", "&Details", new Object[0]));
        this.btnRetry = new JButton();
        this.btnRetry.setName("ProgressPane.btnRetry");
        SwingUtils.setText(this.btnRetry, resource.getString("ProgressPane.btnRetry.text", "&Retry", new Object[0]));
        this.btnRetry.setEnabled(false);
        this.btnSkip = new JButton();
        this.btnSkip.setName("ProgressPane.btnSkip");
        SwingUtils.setText(this.btnSkip, resource.getString("ProgressPane.btnSkip.text", "&Skip", new Object[0]));
        this.btnSkip.setEnabled(false);
        this.btnContinue = new JButton();
        this.btnContinue.setName("ProgressPane.btnContinue");
        SwingUtils.setText(this.btnContinue, resource.getString("ProgressPane.btnContinue.text", "C&ontinue", new Object[0]));
        this.btnContinue.setVisible(false);
        LayoutUtils.addComponent(Box.createGlue(), this.controlPane, 0, 0, 1, 1, 2, 10, 1.0, 0.0, insets);
        LayoutUtils.addComponent(this.btnDetails, this.controlPane, 1, 0, 1, 1, 0, 10, 0.0, 0.0, insets);
        LayoutUtils.addComponent(this.btnRetry, this.controlPane, 2, 0, 1, 1, 0, 10, 0.0, 0.0, insets);
        LayoutUtils.addComponent(this.btnSkip, this.controlPane, 3, 0, 1, 1, 0, 10, 0.0, 0.0, insets);
        LayoutUtils.addComponent(this.btnContinue, this.controlPane, 4, 0, 1, 1, 0, 10, 0.0, 0.0, insets);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(pnlProgress, this, 0, 1, 1, 1, 2, 18, 1.0, 0.0, insets);
        LayoutUtils.addComponent(pnlStatus, this, 0, 2, 1, 1, 1, 18, 1.0, 1.0, insets);
        LayoutUtils.addComponent(this.controlPane, this, 0, 3, 1, 1, 1, 18, 1.0, 0.0, insets);
        if (this.customPane != null) {
            LayoutUtils.addComponent(this.customPane, this, 0, 4, 1, 1, 1, 18, 1.0, 0.0, insets);
        }
        this.progressModel.addProgressModelListener(new ProgressModelListener(){

            @Override
            public void update(ProgressModelEvent e) {
                block0 : switch ((ProgressModelEvent.Type)e.getType()) {
                    case JOB_STATUS_CHANGED: {
                        Job job = e.getJob();
                        Status status = job.getStatus();
                        ProgressPane.this.btnSkip.setVisible(true);
                        ProgressPane.this.btnContinue.setVisible(false);
                        switch (status) {
                            case FAILED: 
                            case CANCELLED: 
                            case ABORTED: {
                                StatusMessages<ErrorMessage> errorMessages;
                                if (!job.isRetryEnabled()) break;
                                if (ProgressPane.this.errorReportingEnabled && !(job instanceof CompositeJob) && (errorMessages = job.getErrorMessages()) != null) {
                                    StandardDialog.showErrors(ProgressPane.this.getOwner(), errorMessages);
                                }
                                ProgressPane.this.btnRetry.setEnabled(true);
                                ProgressPane.this.lastRetriableFailedJob = job;
                                ProgressPane.this.btnSkip.setEnabled(true);
                                break;
                            }
                            case WAITING: {
                                ProgressPane.this.btnSkip.setVisible(false);
                                ProgressPane.this.btnContinue.setVisible(true);
                                ProgressPane.this.btnRetry.setEnabled(false);
                                ProgressPane.this.lastWaitingJob = job;
                                break;
                            }
                            case INPROGRESS: {
                                ProgressPane.this.btnRetry.setEnabled(false);
                                ProgressPane.this.btnSkip.setEnabled(false);
                                break;
                            }
                        }
                        String description = job.getDescription();
                        if (description == null || description.length() <= 0) break;
                        switch (status) {
                            case SUCCEEDED: 
                            case SUCCEEDED_PARTIALLY: {
                                Application.setApplicationProgress(description, description + " successful.", ApplicationProgressEvent.Type.END);
                                break block0;
                            }
                            case FAILED: {
                                Application.setApplicationProgress(description, description + " failed.", ApplicationProgressEvent.Type.END);
                                break block0;
                            }
                            case INPROGRESS: {
                                Application.setApplicationProgress(description, description + " in progress.", ApplicationProgressEvent.Type.START);
                            }
                        }
                    }
                }
            }
        });
        this.btnDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsDialog detailsDialog = DetailsDialog.getInstance(ProgressPane.this);
                detailsDialog.setVisible(true);
            }
        });
        this.btnRetry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ProgressPane.this.retryOrSkipInProgress) {
                    ProgressPane.this.retryOrSkipInProgress = true;
                    ProgressPane.this.doRetry();
                }
            }
        });
        this.btnSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ProgressPane.this.retryOrSkipInProgress) {
                    ProgressPane.this.retryOrSkipInProgress = true;
                    JobHelper.setStatusRecursively(ProgressPane.this.lastRetriableFailedJob, Status.IGNORED);
                    ProgressPane.this.doRetry();
                }
            }
        });
        this.btnContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressPane.this.lastWaitingJob.setStatus(Status.INPROGRESS);
            }
        });
    }

    public void showControlPane(boolean show) {
        this.controlPane.setVisible(show);
    }

    public void setCustomPane(JPanel customPane) {
        this.customPane = customPane;
    }

    private void doRetry() {
        ExecutorService service = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Job Re-Executor Thread");
                return t;
            }
        });
        service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    JobHelper.reexecuteJobs(ProgressPane.this.getProgressModel().getCompositeJobs());
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (ProgressPane.this.retryOrSkipInProgress) {
                        ProgressPane.this.retryOrSkipInProgress = false;
                    }
                }
                return null;
            }
        });
        service.shutdown();
    }
}

