/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;

public class JobHelper {
    private static Logger logger = Logger.getLogger(JobHelper.class.getName());
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS aaa");

    public static void executeJobs(Job ... jobs) throws Exception {
        if (jobs != null) {
            for (Job job : jobs) {
                JobHelper._execute(job);
            }
        }
    }

    private static void _execute(Job job) throws Exception {
        if (job instanceof CompositeJob) {
            CompositeJob compositeJob = (CompositeJob)job;
            List<Job> jobs = compositeJob.getJobs();
            for (Job j : jobs) {
                JobHelper._execute(j);
            }
        } else {
            job.getWork().call();
        }
    }

    public static void reexecuteJobs(List<Job> jobs) throws Exception {
        JobHelper.reexecuteJobs(jobs.toArray(new Job[0]));
    }

    public static void reexecuteJobs(Job ... jobs) throws Exception {
        for (Job job : jobs) {
            if (!JobHelper.reexecute(job)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reexecute(Job job) throws Exception {
        Status s;
        Retriable<?> retriable = job.getRetriable();
        Callable<?> work = job.getWork();
        Status status = job.getStatus();
        if (status == Status.PENDING && work != null) {
            long startTime = 0L;
            Object jobID = job.getId();
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    Date date = JobHelper.getDateTime();
                    logger.log(Level.INFO, "Job :" + jobID + "[ Start Time : " + dateFormat.format(date) + "]");
                    startTime = date.getTime();
                }
                work.call();
            }
            catch (Exception jobException) {
                job.handleException(jobException);
            }
            finally {
                if (logger.isLoggable(Level.FINEST)) {
                    Date date = JobHelper.getDateTime();
                    logger.log(Level.INFO, "Job : " + jobID + "[ End Time : " + dateFormat.format(date) + "]");
                    long endTime = date.getTime();
                    logger.log(Level.INFO, "Job : " + jobID + " - Time Elapsed : " + (endTime - startTime) / 1000L + "seconds.");
                }
            }
        } else if (retriable != null && status != Status.IGNORED && status != Status.SUCCEEDED && status != Status.SUCCEEDED_PARTIALLY) {
            long startTime = 0L;
            Object jobID = job.getId();
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    Date date = JobHelper.getDateTime();
                    logger.log(Level.INFO, "Job :" + jobID + "[ Start Time : " + dateFormat.format(date) + "]");
                    startTime = date.getTime();
                }
                retriable.retry();
            }
            catch (Exception jobException) {
                job.handleException(jobException);
            }
            finally {
                if (logger.isLoggable(Level.FINEST)) {
                    Date date = JobHelper.getDateTime();
                    logger.log(Level.INFO, "Job : " + jobID + "[ End Time : " + dateFormat.format(date) + "]");
                    long endTime = date.getTime();
                    logger.log(Level.INFO, "Job : " + jobID + " - Time Elapsed : " + (endTime - startTime) / 1000L + "seconds.");
                }
            }
        } else if (job instanceof CompositeJob) {
            CompositeJob compositeJob = (CompositeJob)job;
            List<Job> jobs = compositeJob.getJobs();
            JobHelper.reexecuteJobs(jobs);
        }
        boolean success = (s = job.getStatus()) == Status.SUCCEEDED || s == Status.SUCCEEDED_PARTIALLY || s == Status.IGNORED || !job.isRequired();
        return success;
    }

    public static String getJobTreeAsString(CompositeJob compositeJob) {
        StringBuffer buffer = new StringBuffer();
        JobHelper.printJobTree(compositeJob, buffer, 0);
        return buffer.toString();
    }

    private static void printJobTree(Job job, StringBuffer buffer, int level) {
        CompositeJob compositeJob;
        List<Job> jobList;
        String indent = "";
        if (level > 0) {
            char[] ch = new char[level];
            Arrays.fill(ch, ' ');
            indent = new String(ch);
        }
        buffer.append(indent);
        buffer.append("- ");
        buffer.append(job.getDescription());
        buffer.append("[");
        buffer.append((Object)job.getStatus());
        buffer.append("]");
        buffer.append('\n');
        if (job instanceof CompositeJob && (jobList = (compositeJob = (CompositeJob)job).getJobs()) != null) {
            ++level;
            for (Job j : jobList) {
                JobHelper.printJobTree(j, buffer, level);
            }
        }
    }

    public static Job getPreviousLeafJob(CompositeJob[] compositeJobs, Job job) {
        Job previousLeafJob = null;
        CompositeJob parent = job.getParent();
        if (parent != null) {
            Object immediateElder = null;
            List<Job> siblings = parent.getJobs();
            int index = siblings.indexOf(job);
            if (index > 0) {
                immediateElder = siblings.get(index - 1);
            } else {
                CompositeJob grandParent = parent.getParent();
                if (grandParent != null) {
                    List<Job> parentSiblings = grandParent.getJobs();
                    index = parentSiblings.indexOf(parent);
                    if (index > 0) {
                        immediateElder = (Job)parentSiblings.get(--index);
                    }
                } else {
                    for (CompositeJob parentSibling : compositeJobs) {
                        if (parentSibling == parent) break;
                        immediateElder = parentSibling;
                    }
                }
            }
            if (immediateElder != null) {
                if (immediateElder instanceof CompositeJob) {
                    CompositeJob elder = (CompositeJob)immediateElder;
                    while (elder instanceof CompositeJob) {
                        List<Job> children = elder.getJobs();
                        if (children.isEmpty()) continue;
                        Job child = children.get(children.size() - 1);
                        if (child instanceof CompositeJob) {
                            elder = (CompositeJob)child;
                            continue;
                        }
                        previousLeafJob = child;
                        break;
                    }
                } else {
                    previousLeafJob = immediateElder;
                }
            }
        }
        return previousLeafJob;
    }

    public static int getJobCountByStatus(CompositeJob compositeJob, Status status) {
        List<Job> jobs;
        int count = 0;
        if (compositeJob != null && status != null && (jobs = compositeJob.getJobs()) != null) {
            for (Job job : jobs) {
                if (job.getStatus() != status) continue;
                ++count;
            }
        }
        return count;
    }

    public static void setStatusRecursively(Job job, Status status) {
        CompositeJob compositeJob;
        List<Job> subJobs;
        job.setStatus(status);
        if (job instanceof CompositeJob && (subJobs = (compositeJob = (CompositeJob)job).getJobs()) != null && !subJobs.isEmpty()) {
            for (Job subJob : subJobs) {
                JobHelper.setStatusRecursively(subJob, status);
            }
        }
    }

    public static Date getDateTime() {
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        return date;
    }
}

