/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorAdvisor;
import oracle.install.commons.util.exception.DefaultExceptionHandler;
import oracle.install.commons.util.exception.DefaultExceptionReporter;
import oracle.install.commons.util.exception.ErrorAdvisor;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionHandler;
import oracle.install.commons.util.exception.ExceptionReporter;
import oracle.install.commons.util.exception.Severity;

public class ExceptionManager {
    public static final String EXCEPTION_SEVERITY_PROPERTY_NAME = "exceptions.severity.property.name";
    public static final String DISABLE_PERFORM_ACTION_PROPERTY_NAME = "disable.performaction.property.name";
    public static ExceptionManager instance;
    private static String javaNewLine;
    protected ErrorAdvisor errorAdvisor;
    protected ExceptionReporter exceptionReporter;
    protected Map<Class<? extends Throwable>, List<ExceptionHandler>> registry;
    private Map<String, Severity> customSeverityMap = new HashMap<String, Severity>();
    private List<String> disablePerformActionErrorCodeList = new ArrayList<String>();

    public static ExceptionManager getInstance() {
        if (instance == null) {
            instance = new ExceptionManager();
            instance.addExceptionHandler(Throwable.class, new DefaultExceptionHandler());
        }
        return instance;
    }

    private ExceptionManager() {
        this.registry = new HashMap<Class<? extends Throwable>, List<ExceptionHandler>>();
        this.exceptionReporter = new DefaultExceptionReporter();
        this.errorAdvisor = new DefaultErrorAdvisor();
        this.loadCustomSeverityMap();
        this.loadDisablePerformActionList();
    }

    private void loadCustomSeverityMap() {
        Application application = Application.getInstance();
        String exceptionsSeverityProperty = application.getString(EXCEPTION_SEVERITY_PROPERTY_NAME, "application.exceptions.severity", new Object[0]);
        String value = Application.getInstance().getString(exceptionsSeverityProperty, null, new Object[0]);
        this.loadSeverityMap(value);
        value = System.getProperty(exceptionsSeverityProperty);
        this.loadSeverityMap(value);
    }

    private void loadSeverityMap(String severityValue) {
        String[] exceptionEntries;
        if (severityValue != null && (exceptionEntries = severityValue.split(",")) != null && exceptionEntries.length > 0) {
            for (String entry : exceptionEntries) {
                String[] keyValue = entry.split(":");
                if (keyValue == null || keyValue.length != 2) continue;
                this.customSeverityMap.put(keyValue[0].toUpperCase(), Severity.valueOf(keyValue[1].toUpperCase()));
            }
        }
    }

    private void loadDisablePerformActionList() {
        Application application = Application.getInstance();
        String exceptionsSeverityProperty = application.getString(DISABLE_PERFORM_ACTION_PROPERTY_NAME, "application.performaction.disable", new Object[0]);
        String value = Application.getInstance().getString(exceptionsSeverityProperty, null, new Object[0]);
        if (value != null && !value.isEmpty()) {
            value = value.toUpperCase();
            this.disablePerformActionErrorCodeList.addAll(Arrays.asList(value.split(",")));
        }
        if ((value = System.getProperty(exceptionsSeverityProperty)) != null && !value.isEmpty()) {
            value = value.toUpperCase();
            this.disablePerformActionErrorCodeList.addAll(Arrays.asList(value.split(",")));
        }
    }

    public Severity getCustomSeverityForErrorFQN(String errorFQN) {
        if (errorFQN != null && errorFQN.length() > 0) {
            return this.customSeverityMap.get(errorFQN.toUpperCase());
        }
        return null;
    }

    public boolean isPerformActionDisabled(String errorFQN) {
        if (errorFQN != null && errorFQN.length() > 0) {
            return this.disablePerformActionErrorCodeList.contains(errorFQN.toUpperCase());
        }
        return false;
    }

    public ErrorAdvisor getErrorAdvisor() {
        return this.errorAdvisor;
    }

    public void setErrorAdvisor(ErrorAdvisor errorAdvisor) {
        if (errorAdvisor != null) {
            this.errorAdvisor = errorAdvisor;
        }
    }

    public ExceptionReporter getExceptionReporter() {
        return this.exceptionReporter;
    }

    public void setExceptionReporter(ExceptionReporter exceptionReporter) {
        this.exceptionReporter = exceptionReporter;
    }

    public void addExceptionHandler(Class<? extends Throwable> exceptionType, ExceptionHandler exceptionHandler) {
        List<ExceptionHandler> exceptionHandlerList = this.registry.get(exceptionType);
        if (exceptionHandlerList == null) {
            exceptionHandlerList = new ArrayList<ExceptionHandler>();
            this.registry.put(exceptionType, exceptionHandlerList);
        }
        exceptionHandlerList.add(exceptionHandler);
    }

    public void removeExceptionHandler(Class<? extends Throwable> exceptionType, ExceptionHandler exceptionHandler) {
        List<ExceptionHandler> exceptionHandlerList = this.registry.get(exceptionType);
        if (exceptionHandlerList != null) {
            exceptionHandlerList.remove(exceptionHandler);
            if (exceptionHandlerList.isEmpty()) {
                this.registry.remove(exceptionType);
            }
        }
    }

    public void handleException(Throwable exception) {
        List<ExceptionHandler> exceptionHandlerList = this.findExceptionHandler(exception);
        if (exceptionHandlerList != null) {
            for (ExceptionHandler exceptionHandler : exceptionHandlerList) {
                exceptionHandler.handleException(exception);
            }
        }
    }

    public List<ExceptionHandler> findExceptionHandler(Throwable exception) {
        List<ExceptionHandler> exceptionHandlerList = this.registry.get(exception.getClass());
        if (exceptionHandlerList == null) {
            Class<?> givenClass = exception.getClass();
            ArrayList<Class<? extends Throwable>> superClasses = new ArrayList<Class<? extends Throwable>>();
            for (Map.Entry<Class<? extends Throwable>, List<ExceptionHandler>> entry : this.registry.entrySet()) {
                Class<? extends Throwable> throwableClass = entry.getKey();
                if (!throwableClass.isAssignableFrom(givenClass)) continue;
                superClasses.add(throwableClass);
            }
            int n = superClasses.size();
            if (n > 0) {
                Class bestMatch = (Class)superClasses.get(0);
                for (int i = 0; i < n - 1; ++i) {
                    bestMatch = (Class)superClasses.get(i);
                    if (i + 1 >= n || !bestMatch.isAssignableFrom((Class)superClasses.get(i + 1))) continue;
                    bestMatch = (Class)superClasses.get(i + 1);
                }
                exceptionHandlerList = this.registry.get(bestMatch);
                if (exceptionHandlerList != null) {
                    this.registry.put(givenClass, exceptionHandlerList);
                }
            }
        }
        return exceptionHandlerList;
    }

    public Option reportException(Throwable exception) {
        return this.reportException(null, exception, null, null, null, null, new Object[0]);
    }

    public Option reportException(Object observer, Throwable exception) {
        return this.reportException(observer, exception, null, null, null, null, new Object[0]);
    }

    public Option reportException(Throwable exception, Severity severity, ErrorCode errorCode, String hint) {
        return this.reportException(null, exception, severity, errorCode, hint, null, new Object[0]);
    }

    public Option reportException(Object observer, Throwable exception, Severity severity, ErrorCode errorCode, String hint) {
        return this.reportException(observer, exception, severity, errorCode, hint, null, new Object[0]);
    }

    public Option reportException(Throwable exception, Severity severity, ErrorCode errorCode, String hint, String message, Object ... errorArgs) {
        return this.reportException(null, exception, severity, errorCode, hint, message, errorArgs);
    }

    public Option reportException(Object observer, Throwable exception, Severity severity, ErrorCode errorCode, String hint, String message, Object ... errorArgs) {
        return this.exceptionReporter.reportException(observer, exception, severity, errorCode, hint, message, errorArgs);
    }

    public Advice adviseError(Object observer, ErrorMessage errorMessage) {
        StatusMessages<ErrorMessage> statusMessages = new StatusMessages<ErrorMessage>();
        statusMessages.add(errorMessage);
        return this.adviseError(observer, statusMessages);
    }

    public Advice adviseError(Object observer, StatusMessages<? extends ErrorMessage> errorMessages) {
        Advice advice = Advice.NONE;
        ErrorAdvisor errorAdvisor = this.getErrorAdvisor();
        if (errorAdvisor != null) {
            advice = errorAdvisor.advise(observer, errorMessages);
        }
        return advice;
    }

    public static void enumCauses(Throwable throwable, List<String> causes) {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            String message = cause.getLocalizedMessage();
            if (message != null) {
                causes.add(message);
            } else if (cause instanceof NullPointerException) {
                causes.add("java.lang.NullPointerException");
            }
            ExceptionManager.enumCauses(cause, causes);
        }
    }

    public static void handle(Throwable exception) {
        ExceptionManager exceptionManager = ExceptionManager.getInstance();
        exceptionManager.handleException(exception);
    }

    public static Option report(Throwable exception) {
        ExceptionManager exceptionManager = ExceptionManager.getInstance();
        return exceptionManager.reportException(exception);
    }

    public static Option report(Object observer, Throwable exception) {
        ExceptionManager exceptionManager = ExceptionManager.getInstance();
        return exceptionManager.reportException(observer, exception);
    }

    public static Advice advise(Object observer, ErrorMessage errorMessage) {
        ExceptionManager exceptionManager = ExceptionManager.getInstance();
        return exceptionManager.adviseError(observer, errorMessage);
    }

    public static Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages) {
        ExceptionManager exceptionManager = ExceptionManager.getInstance();
        return exceptionManager.adviseError(observer, errorMessages);
    }

    public static Advice advise(ErrorMessage errorMessage) {
        return ExceptionManager.advise(null, errorMessage);
    }

    public static Advice advise(StatusMessages<? extends ErrorMessage> errorMessages) {
        return ExceptionManager.advise(null, errorMessages);
    }

    public static Severity getSeverity(Level level) {
        return level == Level.SEVERE ? Severity.FATAL : (level == Level.WARNING ? Severity.WARNING : Severity.TRIVIAL);
    }

    public static Level getLevel(Severity severity) {
        if (severity != null) {
            switch (severity) {
                case FATAL: {
                    return Level.SEVERE;
                }
                case WARNING: {
                    return Level.WARNING;
                }
                case FATAL_ON_GRAPHICAL: {
                    if (Application.getInstance().getUIType() == UIType.GRAPHICAL) {
                        return Level.SEVERE;
                    }
                    return Level.WARNING;
                }
                case WARNING_ON_GRAPHICAL: {
                    if (Application.getInstance().getUIType() == UIType.GRAPHICAL) {
                        return Level.WARNING;
                    }
                    return Level.SEVERE;
                }
            }
            return Level.INFO;
        }
        return Level.INFO;
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] elements = throwable.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                sb.append(javaNewLine + elements[i].toString());
                continue;
            }
            sb.append(elements[i].toString());
        }
        return sb.toString();
    }

    static {
        javaNewLine = System.getProperty("line.separator", "");
    }
}

