/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyFactory {
    public static ProxyFactory instance = null;
    private static final Logger logger = Logger.getLogger(ProxyFactory.class.getName());

    public static ProxyFactory getInstance() {
        if (instance == null) {
            instance = new ProxyFactory();
            instance = instance.createProxy(ProxyFactory.class, instance);
        }
        return instance;
    }

    private ProxyFactory() {
    }

    public <A> A createProxy(Class<A> proxyType) {
        return this.createProxy(proxyType, null);
    }

    public <A> A createProxy(Class<A> proxyType, A defaultImpl) {
        Object instance = null;
        String className = System.getProperty(proxyType.getName());
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                instance = clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to load proxy named " + className + ". Reason: ", e);
            }
        }
        return (A)(instance == null ? defaultImpl : instance);
    }

    public void registerProxies(URL proxyMappings) throws IOException {
        if (proxyMappings != null) {
            Properties properties = new Properties();
            logger.log(Level.INFO, "Loading proxy mapping from {0}", proxyMappings);
            properties.load(proxyMappings.openStream());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                logger.log(Level.INFO, "Using class {1} as proxy for {0}", new Object[]{entry.getKey(), entry.getValue()});
            }
            System.getProperties().putAll((Map<?, ?>)properties);
            logger.log(Level.INFO, "Set proxy mappings to System.properties");
        }
    }
}

