/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class PrintStreamRedirector
extends PrintStream {
    private static PrintStream systemOut = System.out;
    private static PrintStream systemErr = System.err;
    private static String outFile;
    private static String errFile;
    private PrintStream primaryStream;
    private PrintWriter secondary;

    public PrintStreamRedirector(PrintStream primary) throws IOException {
        super(primary);
        this.primaryStream = primary;
    }

    public PrintStreamRedirector(PrintStream primary, String fileLoc) throws IOException {
        super(primary);
        this.primaryStream = primary;
        this.secondary = new PrintWriter(new FileOutputStream(fileLoc), true);
    }

    public void setSecondarySteam(String file) throws IOException {
        if (this.secondary != null) {
            this.secondary.close();
        }
        this.secondary = new PrintWriter(new FileOutputStream(file), true);
    }

    public void fulsh() {
        super.flush();
        if (this.secondary != null) {
            this.secondary.flush();
        }
    }

    public void removeSecondary() {
        if (this.secondary != null) {
            this.secondary.close();
            this.secondary = null;
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.secondary != null) {
            this.secondary.close();
        }
    }

    @Override
    public void write(int b) {
        super.write(b);
        if (this.secondary != null) {
            this.secondary.write(b);
            this.secondary.flush();
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
        if (this.secondary != null) {
            this.secondary.write(new String(buf, off, len));
            this.secondary.flush();
        }
    }

    @Override
    public boolean checkError() {
        boolean err = super.checkError();
        boolean secondaryErr = false;
        if (this.secondary != null) {
            secondaryErr = this.secondary.checkError();
        }
        return err || secondaryErr;
    }

    public static synchronized void setErrFile(String file) throws IOException {
        PrintStreamRedirector errStream = new PrintStreamRedirector(new PrintStream(new FileOutputStream(file)));
        System.setErr(errStream);
    }

    public static synchronized void setOutFile(String file, boolean isConsoleEnabled) throws IOException {
        PrintStream outStream = System.out;
        outStream = isConsoleEnabled ? new PrintStreamRedirector(outStream, file) : new PrintStreamRedirector(new PrintStream(new FileOutputStream(file)));
        System.setOut(outStream);
    }

    public static String getOutFile() {
        return outFile;
    }

    public static String getErrFile() {
        return errFile;
    }

    public static synchronized void restoreOutStream() {
        PrintStream outputStream = System.out;
        if (outputStream != systemOut) {
            outputStream.close();
        }
        System.setOut(systemOut);
    }

    public static synchronized void restoreErrStream() {
        PrintStream errStream = System.err;
        if (errStream != systemErr) {
            errStream.close();
        }
        System.setErr(systemErr);
    }
}

