/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.install.commons.swing.StatusPane;
import oracle.install.commons.util.StatusControl;

public class GraphicalStatusControl
extends StatusControl {
    private JComponent owner;
    private Stack<String> statusMessageStack;

    public GraphicalStatusControl(JComponent owner) {
        this.owner = owner;
        this.statusMessageStack = new Stack();
    }

    @Override
    public void close() {
        this.statusMessageStack.clear();
        this.hideMessage();
    }

    @Override
    public void open() {
        this.statusMessageStack.clear();
        this.clean();
    }

    @Override
    public void setTimeout(long timeout) {
    }

    @Override
    public void showMessage(String message) {
        if (message != null && !message.isEmpty()) {
            this.statusMessageStack.push(message);
        }
        super.showMessage(message);
        this.updateMessage(message);
    }

    private void updateMessage(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            StatusPane.showMessage(this.owner, message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPane.showMessage(GraphicalStatusControl.this.owner, message);
                }
            });
        }
    }

    private void hideMessage() {
        if (SwingUtilities.isEventDispatchThread()) {
            StatusPane.hideMessage(this.owner);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPane.hideMessage(GraphicalStatusControl.this.owner);
                }
            });
        }
    }

    @Override
    public void clean(boolean clearPanel) {
        if (!this.statusMessageStack.isEmpty()) {
            this.statusMessageStack.pop();
        }
        if (!this.statusMessageStack.isEmpty()) {
            String message = this.statusMessageStack.peek();
            this.updateMessage(message);
        } else if (clearPanel) {
            this.hideMessage();
        } else {
            this.updateMessage(null);
        }
    }

    @Override
    public void clean() {
        this.clean(false);
    }
}

