/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.validation;

import java.util.Collection;
import java.util.List;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ActionableStatusMessage;
import oracle.install.commons.flow.validation.ActionableValidationException;
import oracle.install.commons.flow.validation.ActionableValidator;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Bean;
import oracle.install.commons.util.StatusMessages;

public abstract class AbstractActionableValidator
implements CompositeValidator,
ActionableValidator {
    @Override
    public StatusMessages<ValidationStatusMessage> processResult(FlowContext flowContext, List<? extends ActionableStatusMessage> actionableStatusMessages) {
        StatusMessages<ValidationStatusMessage> messages = new StatusMessages<ValidationStatusMessage>();
        if (actionableStatusMessages != null && !actionableStatusMessages.isEmpty()) {
            Object bean = this.getBean(flowContext);
            for (ActionableStatusMessage actionableStatusMessage : actionableStatusMessages) {
                StatusMessages<ValidationStatusMessage> msgList = actionableStatusMessage.performAction(bean);
                if (msgList == null || msgList.isEmpty()) continue;
                messages.addAll((Collection<ValidationStatusMessage>)msgList);
            }
        }
        return messages;
    }

    @Override
    public StatusMessages<ValidationStatusMessage> processResult(FlowContext flowContext, ActionableValidationException actionableValidationException) {
        Object bean;
        StatusMessages<ValidationStatusMessage> msgList;
        StatusMessages<ValidationStatusMessage> messages = new StatusMessages<ValidationStatusMessage>();
        if (actionableValidationException != null && (msgList = actionableValidationException.performAction(bean = this.getBean(flowContext))) != null && !msgList.isEmpty()) {
            messages.addAll((Collection<ValidationStatusMessage>)msgList);
        }
        return messages;
    }

    protected abstract <T extends Bean> T getBean(FlowContext var1);
}

