/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.RoutePlanChangeEvent;
import oracle.install.commons.flow.RoutePlanChangeListener;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.UIPropertyDef;

public class WizardBottomPanelHandler
implements RoutePlanChangeListener {
    private BaseWizard wizard;
    private ValidationMessagePane pane;
    private Component billboard;
    private boolean bottomPaneUpdated = false;
    private static Logger logger = Logger.getLogger(WizardBottomPanelHandler.class.getName());

    public WizardBottomPanelHandler(BaseWizard wizard) {
        this.wizard = wizard;
    }

    @Override
    public void stateChanged(final RoutePlanChangeEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updatePanel(e);
        } else {
            FutureTask<Void> loadViewTask = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    WizardBottomPanelHandler.this.updatePanel(e);
                    return null;
                }
            });
            SwingUtilities.invokeLater(loadViewTask);
            try {
                loadViewTask.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updatePanel(RoutePlanChangeEvent e) {
        int eventId = e.getId();
        RoutePlan routePlan = e.getSource();
        if ((eventId & 1) == 1) {
            UIPropertyDef uiDef;
            State state = routePlan.getCurrentVertex().getValue();
            View view = state.getView();
            UIPropertyDef uIPropertyDef = uiDef = view == null ? null : view.getClass().getAnnotation(UIPropertyDef.class);
            if (uiDef != null && !uiDef.showValidationStatusPanel()) {
                ValidationMessagePane validationPane = this.wizard.getValidationMessagePane();
                Component billboardComp = this.wizard.getBillboard();
                if (validationPane != null || billboardComp != null) {
                    this.bottomPaneUpdated = true;
                    this.pane = validationPane;
                    this.billboard = billboardComp;
                    this.wizard.setValidationMessagePane(null);
                    this.wizard.setBillboard(null);
                }
            } else if (this.bottomPaneUpdated) {
                this.bottomPaneUpdated = false;
                if (this.wizard.getValidationMessagePane() == null) {
                    this.wizard.setValidationMessagePane(this.pane);
                }
                if (this.wizard.getBillboard() == null) {
                    this.wizard.setBillboard(this.billboard);
                }
            }
        }
    }
}

