/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import java.util.ArrayList;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreEvent;
import oracle.install.commons.bean.BeanStoreException;

public abstract class BeanStoreReader<T extends BeanStore> {
    protected BeanStoreReader() {
    }

    public abstract T getBeanStore();

    public abstract void open(T var1) throws BeanStoreException;

    public void close() throws BeanStoreException {
    }

    public void read(Object bean) throws BeanStoreException {
        try {
            Class<?> beanType = bean.getClass();
            BeanDefinition beanDefinition = BeanDefinition.getBeanDefinition(beanType, null);
            if (beanDefinition != null) {
                T beanStore = this.getBeanStore();
                ((BeanStore)beanStore).fireApplicationEvent(new BeanStoreEvent((BeanStore)beanStore, BeanStoreEvent.Type.BEAN_STORE_READ_STARTED, new Object[0]));
                this.readBean(beanDefinition, bean);
                ((BeanStore)beanStore).fireApplicationEvent(new BeanStoreEvent((BeanStore)beanStore, BeanStoreEvent.Type.BEAN_STORE_READ_ENDED, new Object[0]));
            }
        }
        catch (BeanStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanStoreException(e);
        }
    }

    public Object[] readAll(Class[] beanTypes) throws BeanStoreException {
        ArrayList list = new ArrayList();
        for (Class beanType : beanTypes) {
            Object value = this.read(beanType);
            if (value == null) continue;
            list.add(value);
        }
        return list.toArray();
    }

    public <A> A read(Class<A> beanType) throws BeanStoreException {
        return this.read(beanType, null);
    }

    public <A> A read(Class<A> beanType, String alias) throws BeanStoreException {
        Object bean = null;
        try {
            BeanDefinition beanDefinition = BeanDefinition.getBeanDefinition(beanType, alias);
            if (beanDefinition != null) {
                T beanStore = this.getBeanStore();
                ((BeanStore)beanStore).fireApplicationEvent(new BeanStoreEvent((BeanStore)beanStore, BeanStoreEvent.Type.BEAN_STORE_READ_STARTED, new Object[0]));
                bean = this.readBean(beanDefinition, null);
                ((BeanStore)beanStore).fireApplicationEvent(new BeanStoreEvent((BeanStore)beanStore, BeanStoreEvent.Type.BEAN_STORE_READ_ENDED, new Object[0]));
            }
        }
        catch (BeanStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanStoreException(e);
        }
        return (A)bean;
    }

    protected abstract Object readBean(BeanDefinition var1, Object var2) throws BeanStoreException;
}

