/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.view.JobTypeUIEnum;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.JobIndex;
import oracle.install.commons.util.progress.ProgressModelEvent;
import oracle.install.commons.util.progress.ProgressModelListener;

public class JobsTableModel
extends AbstractTableModel {
    private Resource resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
    private List<JobSettings> jobList = new ArrayList<JobSettings>();
    private boolean canEdit;
    String[] columnNames;
    private EventSupport<ProgressModelEvent> eventSupport = new EventSupport();
    public static final int JOBS_TYPE_COLUMN = 1;
    public static final int JOBS_VIEW_DETAILS_COLUMN = 2;

    public JobsTableModel(boolean canEdit) {
        this.columnNames = new String[3];
        this.canEdit = canEdit;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void addProgressModelListener(ProgressModelListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeProgressModelListener(ProgressModelListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public JobSettings getJob(int index) {
        if (this.jobList != null && index >= 0 && index < this.jobList.size()) {
            return this.jobList.get(index);
        }
        return null;
    }

    public void setJobs(List<JobSettings> jobsList) {
        if (jobsList != null) {
            this.jobList.clear();
            JobIndex jobIndex = new JobIndex();
            for (JobSettings job : jobsList) {
                job.setJobIndex(jobIndex);
                jobIndex = JobIndex.nextJobIndex(jobIndex);
                this.addJob(job, false, null);
            }
        }
    }

    protected void addJob(JobSettings job, boolean order, JobSettings parent) {
        if (job.getChildJobs() != null && !job.getChildJobs().isEmpty()) {
            this.addJobDirectly(job, order, parent);
            List<JobSettings> tasks = job.getChildJobs();
            if (tasks != null) {
                JobIndex jobIndex = null;
                jobIndex = JobIndex.newSubJobIndex(job.getJobIndex(), 1);
                if (tasks.size() > 0) {
                    for (JobSettings j : tasks) {
                        j.setJobIndex(jobIndex);
                        jobIndex = JobIndex.nextJobIndex(jobIndex);
                        this.addJob(j, order, job);
                    }
                }
            }
        } else {
            this.addJobDirectly(job, order, parent);
        }
        this.fireTableDataChanged();
    }

    private void addJobDirectly(JobSettings job, boolean order, JobSettings parent) {
        if (order) {
            int index = -1;
            if (parent != null) {
                index = this.jobList.indexOf(parent);
            }
            if (index >= 0) {
                List<JobSettings> jobs = parent.getChildJobs();
                ++index;
                while (index < this.jobList.size() && jobs.contains(this.jobList.get(index))) {
                    ++index;
                }
                JobIndex jobIndex = parent.getJobIndex();
                int offset = jobs.indexOf(job);
                offset = offset == -1 ? 1 : offset + 1;
                jobIndex = JobIndex.newSubJobIndex(jobIndex, offset);
                job.setJobIndex(jobIndex);
                this.jobList.add(index, job);
                return;
            }
        }
        this.jobList.add(job);
    }

    protected void removeJob(JobSettings job) {
        int index = this.jobList.indexOf(job);
        if (index != -1) {
            this.jobList.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 2) {
            return true;
        }
        return this.canEdit;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.jobList == null ? 0 : this.jobList.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = null;
        if (row < this.jobList.size()) {
            JobSettings job = this.jobList.get(row);
            value = this.getValueAt(job, column);
        }
        return value;
    }

    protected Object getValueAt(JobSettings task, int column) {
        Object value = null;
        if (task != null) {
            switch (column) {
                case 0: {
                    value = task;
                    break;
                }
                case 1: {
                    value = JobTypeUIEnum.getJobTypeUI(task.getType());
                    break;
                }
                case 2: {
                    value = this.resource.getString("JobsTableModel.viewdetails", "View Detail", new Object[0]);
                }
            }
        }
        return value;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class type = null;
        switch (columnIndex) {
            case 0: {
                type = String.class;
                break;
            }
            case 1: {
                type = JobTypeUIEnum.class;
                break;
            }
            case 2: {
                type = String.class;
            }
        }
        return type;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void clear() {
        this.jobList.clear();
        this.fireTableDataChanged();
    }
}

