/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.view.JobVariablesTableModel;
import oracle.install.commons.swing.HidableTableColumnModel;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class JobVariablesTablePane
extends JPanel {
    private JTable tblVariables;
    private JobVariablesTableModel variablesTableModel;
    private HidableTableColumnModel columnModel;
    private String paneName = "";
    private boolean canEdit;
    private ShowingContext context;

    public JobVariablesTablePane(String paneName, boolean canEdit, ShowingContext showingContext) {
        this.paneName = paneName;
        this.canEdit = canEdit;
        this.context = showingContext;
        this.buildUI();
    }

    public void buildUI() {
        this.columnModel = new HidableTableColumnModel();
        this.variablesTableModel = new JobVariablesTableModel(this.canEdit);
        this.tblVariables = new JTable(this.variablesTableModel, this.columnModel);
        this.tblVariables.createDefaultColumnsFromModel();
        this.tblVariables.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane jobsTableScrollPane = new JScrollPane(this.tblVariables);
        jobsTableScrollPane.getViewport().setBackground(this.tblVariables.getBackground());
        if (this.paneName != null && !this.paneName.isEmpty()) {
            this.setBorder(BorderFactory.createTitledBorder(this.paneName));
        }
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(jobsTableScrollPane, this, 0, 0, 1, 1, 1, 18, 1.0, 1.0, LayoutUtils.STANDARD_INSETS);
        this.tblVariables.setName("JobVariablesTablePane.tblJobs");
        this.tblVariables.getTableHeader().setReorderingAllowed(false);
        TableColumn col = this.columnModel.getColumn(2);
        col.setCellRenderer(new PasswordCellRendererModel());
        col.setCellEditor(new PasswordCellEditorModel());
        col.setPreferredWidth(100);
        col = this.columnModel.getColumn(0);
        col.setPreferredWidth(100);
        col = this.columnModel.getColumn(1);
        col.setPreferredWidth(200);
        col = this.columnModel.getColumn(3);
        col.setPreferredWidth(200);
        col = this.columnModel.getColumn(4);
        col.setCellRenderer(new CheckboxCellRenderer());
        col.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        col.setPreferredWidth(30);
        col = this.columnModel.getColumn(5);
        col.setCellRenderer(new CheckboxCellRenderer());
        col.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        col.setPreferredWidth(30);
        if (this.context != null) {
            switch (this.context) {
                case GLOBAL_VARS: 
                case PROPERTIES: 
                case ENV_VARIABLES: {
                    this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(2), false);
                    this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(3), false);
                    this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(4), false);
                    this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(5), false);
                    break;
                }
                case ARGUMENTS: {
                    this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(2), false);
                    this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(3), false);
                    break;
                }
                case PASSWORDS: {
                    this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(1), false);
                    this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(4), false);
                }
            }
        }
        this.localize(this.context);
        SwingUtils.setComponentEnabled(this, this.canEdit);
    }

    public void setVariables(List<VariableSettings> variables) {
        this.variablesTableModel.setVariables(variables);
    }

    public List<VariableSettings> getVariables() {
        return this.variablesTableModel.getVariables();
    }

    public void localize(ShowingContext showingContext) {
        Resource resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
        String[] tableColumnNames = null;
        if (this.context != null) {
            switch (this.context) {
                case GLOBAL_VARS: 
                case PROPERTIES: 
                case ENV_VARIABLES: {
                    tableColumnNames = new String[]{resource.getString("JobVariablesTablePane.tblVariables.column.Name", "Variable name*", new Object[0]), resource.getString("JobVariablesTablePane.tblVariables.column.value", "Value*", new Object[0]), "", "", "", ""};
                    break;
                }
                case ARGUMENTS: {
                    tableColumnNames = new String[]{resource.getString("JobVariablesTablePane.tblVariables.column.Name", "Variable name*", new Object[0]), resource.getString("JobVariablesTablePane.tblVariables.column.value", "Value*", new Object[0]), resource.getString("JobVariablesTablePane.tblVariables.column.valueExpected", "Value expected*", new Object[0]), resource.getString("JobVariablesTablePane.tblVariables.column.optional", "Optional*", new Object[0]), "", ""};
                    break;
                }
                case PASSWORDS: {
                    tableColumnNames = new String[]{resource.getString("JobVariablesTablePane.tblVariables.column.Name", "Variable name*", new Object[0]), resource.getString("JobVariablesTablePane.tblVariables.column.password", "Password*", new Object[0]), resource.getString("JobVariablesTablePane.tblVariables.column.promptString", "PromptString*", new Object[0]), resource.getString("JobVariablesTablePane.tblVariables.column.optional", "Optional*", new Object[0]), "", ""};
                }
            }
        }
        this.variablesTableModel.setColumnNames(tableColumnNames);
        TableColumnModel tcm = this.tblVariables.getColumnModel();
        for (int iLoop = 0; iLoop < tcm.getColumnCount(); ++iLoop) {
            tcm.getColumn(iLoop).setHeaderValue(tableColumnNames[iLoop]);
        }
    }

    private class CheckboxCellRenderer
    implements TableCellRenderer {
        private JCheckBox chkBxNodeSelection = new JCheckBox();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (table == null || value == null) {
                return null;
            }
            this.chkBxNodeSelection.setSelected((Boolean)value);
            this.chkBxNodeSelection.setEnabled(table.getModel().isCellEditable(rowIndex, vColIndex));
            if (isSelected) {
                this.chkBxNodeSelection.setForeground(table.getSelectionForeground());
                this.chkBxNodeSelection.setBackground(table.getSelectionBackground());
            } else {
                this.chkBxNodeSelection.setForeground(table.getForeground());
                this.chkBxNodeSelection.setBackground(table.getBackground());
            }
            return this.chkBxNodeSelection;
        }
    }

    private static class PasswordCellEditorModel
    extends AbstractCellEditor
    implements TableCellEditor {
        private JPasswordField pwdField = new JPasswordField();

        @Override
        public Object getCellEditorValue() {
            return String.valueOf(this.pwdField.getPassword());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null) {
                this.pwdField.setText(value.toString());
            }
            return this.pwdField;
        }
    }

    private static class PasswordCellRendererModel
    implements TableCellRenderer {
        private JPasswordField pwdField = new JPasswordField();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (table == null || value == null) {
                return null;
            }
            this.pwdField.setText(value.toString());
            this.pwdField.setEnabled(table.getModel().isCellEditable(rowIndex, vColIndex));
            if (isSelected) {
                this.pwdField.setForeground(table.getSelectionForeground());
                this.pwdField.setBackground(table.getSelectionBackground());
            } else {
                this.pwdField.setForeground(table.getForeground());
                this.pwdField.setBackground(table.getBackground());
            }
            this.pwdField.setBorder(new EmptyBorder(0, 0, 0, 0));
            return this.pwdField;
        }
    }

    public static enum ShowingContext {
        GLOBAL_VARS,
        ARGUMENTS,
        PASSWORDS,
        PROPERTIES,
        ENV_VARIABLES;

    }
}

