/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.JobType;
import oracle.install.commons.base.util.job.view.ChildJobsTableModel;
import oracle.install.commons.base.util.job.view.JobDetailsDialog;
import oracle.install.commons.base.util.job.view.JobSettingsCellRenderer;
import oracle.install.commons.base.util.job.view.JobTypeUIEnum;
import oracle.install.commons.base.util.job.view.JobsTableModel;
import oracle.install.commons.swing.HtmlPaneCellEditorRenderer;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class JobTablePane
extends JPanel {
    private String paneName = "Jobs";
    private boolean canEdit;
    private ViewMode viewMode;
    private JTable tblJobs;
    private JobsTableModel jobsTableModel;
    private ChildJobsTableModel childJobsTableModel;
    private List<JobSettings> jobs;
    private Resource resource;
    public static final String JOB_VIEW_DETAILS_PROPERTY = "JobTablePane.job.viewDetails.selected";
    public static final String JOB_ADD_PROPERTY = "JobTablePane.job.add.selected";
    public static final String JOB_REMOVE_PROPERTY = "JobTablePane.job.remove.selected";
    public static final String JOB_EDIT_PROPERTY = "JobTablePane.job.edit.selected";
    public static final String JOB_MOVE_UP_PROPERTY = "JobTablePane.job.moveup.selected";
    public static final String JOB_MOVE_DOWN_PROPERTY = "JobTablePane.job.movedown.selected";

    public JobTablePane(String paneName, boolean canEdit) {
        this(paneName, canEdit, null);
    }

    public JobTablePane(String paneName, boolean canEdit, ViewMode viewMode) {
        this.paneName = paneName;
        this.canEdit = canEdit;
        this.viewMode = viewMode;
        this.resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
        this.buildUI();
    }

    public void buildUI() {
        this.jobsTableModel = new JobsTableModel(this.canEdit);
        this.childJobsTableModel = new ChildJobsTableModel(this.canEdit);
        this.tblJobs = new JTable();
        if (this.viewMode == ViewMode.CHILD_JOBS) {
            this.tblJobs.setModel(this.childJobsTableModel);
        } else {
            this.tblJobs.setModel(this.jobsTableModel);
        }
        this.tblJobs.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane jobsTableScrollPane = new JScrollPane(this.tblJobs);
        jobsTableScrollPane.getViewport().setBackground(this.tblJobs.getBackground());
        this.setBorder(BorderFactory.createTitledBorder(this.paneName));
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(jobsTableScrollPane, this, 0, 0, 1, 1, 1, 18, 1.0, 1.0, LayoutUtils.STANDARD_INSETS);
        this.tblJobs.setName("JobApplicationDetailsPane.tblJobs");
        this.tblJobs.getTableHeader().setReorderingAllowed(false);
        if (this.viewMode != ViewMode.CHILD_JOBS) {
            TableColumnModel columnModel = this.tblJobs.getColumnModel();
            TableColumn column = columnModel.getColumn(0);
            column.setPreferredWidth(600);
            column.setCellRenderer(new JobSettingsCellRenderer());
            column = columnModel.getColumn(1);
            column.setPreferredWidth(180);
            column = columnModel.getColumn(2);
            column.setPreferredWidth(130);
            String showDetailsText = this.resource.getString("JobsTableModel.viewdetails", "Details*", new Object[0]);
            ViewDetailsHyperLinkListener listener = new ViewDetailsHyperLinkListener();
            column.setCellEditor(new HtmlPaneCellEditorRenderer(showDetailsText, "", listener));
            column.setCellRenderer(new HtmlPaneCellEditorRenderer(showDetailsText, "", listener));
        }
        InputMap inputMap = this.tblJobs.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0, true), "showMoreDetails");
        ActionMap actionMap = this.tblJobs.getActionMap();
        actionMap.put("showMoreDetails", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobSettings job = JobTablePane.this.getSelectedJob();
                if (job != null) {
                    JobTablePane.this.showDetailsDialog(job, false);
                    JobTablePane.this.setJobs(JobTablePane.this.jobs);
                }
            }
        });
        this.addPropertyChangeListener(JOB_ADD_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobSettings newJobToAdd = new JobSettings();
                JobSettings selectedJob = JobTablePane.this.getSelectedJob();
                if ((newJobToAdd = JobTablePane.this.showDetailsDialog(newJobToAdd, true)) != null) {
                    JobSettings parentJob = JobTablePane.this.getParentJob(selectedJob, JobTablePane.this.jobs, null);
                    if (parentJob != null && parentJob.getChildJobs() != null) {
                        parentJob.getChildJobs().add(newJobToAdd);
                    } else {
                        if (JobTablePane.this.jobs == null) {
                            JobTablePane.this.jobs = new ArrayList();
                        }
                        JobTablePane.this.jobs.add(newJobToAdd);
                    }
                    JobTablePane.this.setJobs(JobTablePane.this.jobs);
                }
            }
        });
        this.addPropertyChangeListener(JOB_EDIT_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobSettings selectedJob = JobTablePane.this.getSelectedJob();
                if (selectedJob != null) {
                    JobTablePane.this.showDetailsDialog(selectedJob, true);
                    JobTablePane.this.setJobs(JobTablePane.this.jobs);
                }
            }
        });
        this.addPropertyChangeListener(JOB_REMOVE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobSettings selectedJob = JobTablePane.this.getSelectedJob();
                if (selectedJob != null) {
                    JobSettings parentJob = JobTablePane.this.getParentJob(selectedJob, JobTablePane.this.jobs, null);
                    if (parentJob != null) {
                        parentJob.getChildJobs().remove(selectedJob);
                    } else {
                        JobTablePane.this.jobs.remove(selectedJob);
                    }
                    JobTablePane.this.setJobs(JobTablePane.this.jobs);
                }
            }
        });
        this.addPropertyChangeListener(JOB_MOVE_UP_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobSettings selectedJob = JobTablePane.this.getSelectedJob();
                if (selectedJob != null) {
                    JobSettings parentJob = JobTablePane.this.getParentJob(selectedJob, JobTablePane.this.jobs, null);
                    if (parentJob != null) {
                        int index = parentJob.getChildJobs().indexOf(selectedJob);
                        if (index > 0) {
                            parentJob.getChildJobs().remove(index);
                            parentJob.getChildJobs().add(index - 1, selectedJob);
                        }
                    } else {
                        int index = JobTablePane.this.jobs.indexOf(selectedJob);
                        if (index > 0) {
                            JobTablePane.this.jobs.remove(index);
                            JobTablePane.this.jobs.add(index - 1, selectedJob);
                        }
                    }
                    JobTablePane.this.setJobs(JobTablePane.this.jobs);
                }
            }
        });
        this.addPropertyChangeListener(JOB_MOVE_DOWN_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobSettings selectedJob = JobTablePane.this.getSelectedJob();
                if (selectedJob != null) {
                    JobSettings parentJob = JobTablePane.this.getParentJob(selectedJob, JobTablePane.this.jobs, null);
                    if (parentJob != null) {
                        int index = parentJob.getChildJobs().indexOf(selectedJob);
                        if (index >= 0) {
                            parentJob.getChildJobs().add(index + 1, selectedJob);
                            parentJob.getChildJobs().remove(index);
                        }
                    } else {
                        int index = JobTablePane.this.jobs.indexOf(selectedJob);
                        if (index >= 0) {
                            JobTablePane.this.jobs.add(index + 1, selectedJob);
                            JobTablePane.this.jobs.remove(index);
                        }
                    }
                    JobTablePane.this.setJobs(JobTablePane.this.jobs);
                }
            }
        });
        this.localize();
    }

    private JobSettings getParentJob(JobSettings jobSeetings, List<JobSettings> jobs, JobSettings parentJob) {
        if (jobSeetings != null && jobs != null) {
            for (JobSettings job : jobs) {
                JobSettings resultingJob;
                if (jobSeetings == job) {
                    return parentJob;
                }
                if (job.getChildJobs() == null || (resultingJob = this.getParentJob(jobSeetings, job.getChildJobs(), job)) == null) continue;
                return resultingJob;
            }
        }
        return null;
    }

    private JobSettings getSelectedJob() {
        int selectedRow = this.tblJobs.getSelectedRow();
        return this.jobsTableModel.getJob(selectedRow);
    }

    private JobSettings showDetailsDialog(JobSettings jobToShow, boolean canEdit) {
        JobDetailsDialog jobDetailsDialog = new JobDetailsDialog((Frame)SwingUtilities.windowForComponent(this), jobToShow, this.resource.getString("JobDetailsDialog.title", "Job details", new Object[0]), canEdit);
        jobDetailsDialog.setVisible(true);
        return jobDetailsDialog.getJob();
    }

    public void setJobs(List<JobSettings> jobs) {
        this.jobs = jobs;
        this.jobsTableModel.setJobs(this.jobs);
        this.childJobsTableModel.setChildJobs(jobs);
    }

    public List<JobSettings> getJobs() {
        if (this.viewMode == ViewMode.CHILD_JOBS) {
            return this.childJobsTableModel.getChildJobs();
        }
        return this.jobs;
    }

    public void localize() {
        String[] tableColumnNames = new String[]{this.resource.getString("JobApplicationDetailsPane.btlJobs.column.jobName", "Job ID", new Object[0]), this.resource.getString("JobApplicationDetailsPane.btlJobs.column.type", "Type", new Object[0]), this.resource.getString("JobApplicationDetailsPane.btlJobs.column.details", "Details", new Object[0])};
        this.jobsTableModel.setColumnNames(tableColumnNames);
        String[] childJobColumnNames = new String[]{this.resource.getString("JobApplicationDetailsPane.btlJobs.column.jobName", "Job ID", new Object[0])};
        this.childJobsTableModel.setColumnNames(childJobColumnNames);
        TableColumnModel tcm = this.tblJobs.getColumnModel();
        for (int iLoop = 0; iLoop < tcm.getColumnCount(); ++iLoop) {
            tcm.getColumn(iLoop).setHeaderValue(tableColumnNames[iLoop]);
        }
        HashMap<JobType, String> jobTypeNames = new HashMap<JobType, String>();
        jobTypeNames.put(JobType.COMPOSITE_JOB, this.resource.getString(JobType.COMPOSITE_JOB, new Object[0]));
        jobTypeNames.put(JobType.JAVA_CLASS, this.resource.getString(JobType.JAVA_CLASS, new Object[0]));
        jobTypeNames.put(JobType.PLAIN_COMMAND, this.resource.getString(JobType.PLAIN_COMMAND, new Object[0]));
        jobTypeNames.put(JobType.PERL_SCRIPT, this.resource.getString(JobType.PERL_SCRIPT, new Object[0]));
        jobTypeNames.put(JobType.SQL_COMMAND, this.resource.getString(JobType.SQL_COMMAND, new Object[0]));
        jobTypeNames.put(JobType.REMOTE_JOB, this.resource.getString(JobType.REMOTE_JOB, new Object[0]));
        JobTypeUIEnum.setNames(jobTypeNames);
    }

    private class ViewDetailsHyperLinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            JobSettings job;
            HyperlinkEvent.EventType eventType = e.getEventType();
            if (eventType == HyperlinkEvent.EventType.ACTIVATED && e.getSource() != null && (job = JobTablePane.this.getSelectedJob()) != null) {
                JobTablePane.this.showDetailsDialog(job, false);
                JobTablePane.this.setJobs(JobTablePane.this.jobs);
            }
        }
    }

    public static enum ViewMode {
        CHILD_JOBS,
        COMPLETE_LIST;

    }
}

