/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.view.JobArgsPane;
import oracle.install.commons.base.util.job.view.JobVariablesTablePane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class JobPropertiesPane
extends JPanel {
    private JobVariablesTablePane jobPropertiesPane;
    private JobVariablesTablePane jobEnvVarsPane;
    private boolean canEdit;
    private static final Logger logger = Logger.getLogger(JobArgsPane.class.getName());
    Resource resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");

    public JobPropertiesPane(boolean canEdit) {
        this.canEdit = canEdit;
        this.buildUI();
    }

    private void buildUI() {
        this.jobPropertiesPane = new JobVariablesTablePane(this.resource.getString("JobArgsPane.peroperties.name", "Properties", new Object[0]), this.canEdit, JobVariablesTablePane.ShowingContext.PROPERTIES);
        this.jobEnvVarsPane = new JobVariablesTablePane(this.resource.getString("JobArgsPane.envvars.name", "Environment variables", new Object[0]), this.canEdit, JobVariablesTablePane.ShowingContext.ENV_VARIABLES);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.jobPropertiesPane, this, 0, 0, 1, 1, 1, 18, 1.0, 1.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.jobEnvVarsPane, this, 0, 1, 1, 1, 1, 18, 1.0, 1.0, LayoutUtils.STANDARD_INSETS);
    }

    public void setJobPropsInfo(JobSettings jobSettings) {
        if (jobSettings.getCmdProperties() != null) {
            this.jobPropertiesPane.setVariables(new ArrayList<VariableSettings>(jobSettings.getCmdProperties().values()));
        } else {
            this.jobPropertiesPane.setVariables(new ArrayList<VariableSettings>());
        }
        if (jobSettings.getEnvVariables() != null) {
            this.jobEnvVarsPane.setVariables(new ArrayList<VariableSettings>(jobSettings.getEnvVariables().values()));
        } else {
            this.jobEnvVarsPane.setVariables(new ArrayList<VariableSettings>());
        }
    }

    protected void saveJobDetails(JobSettings jobSettings) {
        if (jobSettings != null) {
            List<VariableSettings> properties = this.jobPropertiesPane.getVariables();
            LinkedHashMap<String, VariableSettings> propertiesMap = new LinkedHashMap<String, VariableSettings>();
            if (properties != null) {
                for (VariableSettings var : properties) {
                    if (var.getName() != null && !var.getName().isEmpty()) {
                        var.setJobId(jobSettings.getId());
                        propertiesMap.put(var.getName(), var);
                        continue;
                    }
                    logger.log(Level.WARNING, "Variable name is null. So not adding the variable to the job object");
                }
            }
            jobSettings.setCmdProperties(propertiesMap);
            List<VariableSettings> args = this.jobEnvVarsPane.getVariables();
            LinkedHashMap<String, VariableSettings> argsMap = new LinkedHashMap<String, VariableSettings>();
            if (args != null) {
                for (VariableSettings var : args) {
                    if (var.getName() != null && !var.getName().isEmpty()) {
                        var.setJobId(jobSettings.getId());
                        argsMap.put(var.getName(), var);
                        continue;
                    }
                    logger.log(Level.WARNING, "Environment Variable name is null. So not adding the variable to the job object");
                }
            }
            jobSettings.setEnvVariables(argsMap);
        }
    }
}

