/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import oracle.install.commons.base.util.PasswordHelper;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ErrorCode;

public class JobVariableLoader {
    private static String GENERIC_JOB_ID = "Generic_job";
    private static final Logger logger = Logger.getLogger(JobVariableLoader.class.getName());
    private static JobVariableLoader instance;
    private boolean ignoreVariablesCase = true;

    private JobVariableLoader() {
    }

    public static JobVariableLoader getInstance() {
        if (instance == null) {
            instance = new JobVariableLoader();
        }
        return instance;
    }

    public void loadJobVariables(JobContext jobContext, Properties properties) {
        if (properties != null && !properties.isEmpty() && jobContext != null && jobContext.getJobCollection().getJobs() != null) {
            HashMap<String, Map<String, Object>> propertiesMap = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                if (key == null || key.isEmpty()) continue;
                String[] tokens = key.split(":");
                String jobId = null;
                String variableName = null;
                if (tokens != null && tokens.length > 1) {
                    jobId = tokens[0];
                    variableName = tokens[1];
                } else {
                    jobId = GENERIC_JOB_ID;
                    variableName = key;
                }
                if (this.ignoreVariablesCase) {
                    variableName = variableName.toLowerCase();
                    jobId = jobId.toLowerCase();
                }
                if (propertiesMap.get(jobId) == null) {
                    propertiesMap.put(jobId, new HashMap());
                }
                ((Map)propertiesMap.get(jobId)).put(variableName, entry.getValue() == null ? "" : entry.getValue());
            }
            for (JobSettings jobSettings : jobContext.getJobCollection().getJobs()) {
                this.loadVariables(jobSettings, propertiesMap);
            }
            if (jobContext.getJobIndependentVars() != null && jobContext.getJobIndependentVars().values() != null) {
                Map<String, Object> genericProperties = this.getValueByConsideringIgnoreCase(propertiesMap, GENERIC_JOB_ID);
                for (VariableSettings variableSettings : jobContext.getJobIndependentVars().values()) {
                    this.loadVariable(variableSettings, null, genericProperties);
                }
            }
        }
    }

    private void loadVariables(JobSettings jobSettings, Map<String, Map<String, Object>> propertiesMap) {
        if (jobSettings != null && propertiesMap != null) {
            String executeJobProperty;
            Map<String, Object> jobProperties = this.getValueByConsideringIgnoreCase(propertiesMap, jobSettings.getId());
            Map<String, Object> genericProperties = this.getValueByConsideringIgnoreCase(propertiesMap, GENERIC_JOB_ID);
            if (jobSettings.getArgs() != null) {
                for (VariableSettings variableSettings : jobSettings.getArgs().values()) {
                    this.loadVariable(variableSettings, jobProperties, genericProperties);
                }
            }
            if (jobSettings.getCmdProperties() != null) {
                for (VariableSettings variableSettings : jobSettings.getCmdProperties().values()) {
                    this.loadVariable(variableSettings, jobProperties, genericProperties);
                }
            }
            if (jobSettings.getEnvVariables() != null) {
                for (VariableSettings variableSettings : jobSettings.getEnvVariables().values()) {
                    this.loadVariable(variableSettings, jobProperties, genericProperties);
                }
            }
            if (jobSettings.getSecreteArgs() != null) {
                for (VariableSettings variableSettings : jobSettings.getSecreteArgs().values()) {
                    this.loadVariable(variableSettings, jobProperties, genericProperties);
                }
            }
            if (this.getValueByConsideringIgnoreCase(jobProperties, executeJobProperty = jobSettings.getId()) != null) {
                jobSettings.setExecute(Boolean.valueOf(this.getValueByConsideringIgnoreCase(jobProperties, executeJobProperty).toString()));
            } else if (this.getValueByConsideringIgnoreCase(genericProperties, executeJobProperty) != null) {
                jobSettings.setExecute(Boolean.valueOf(this.getValueByConsideringIgnoreCase(genericProperties, executeJobProperty).toString()));
            }
            if (jobSettings.getChildJobs() != null && !jobSettings.getChildJobs().isEmpty()) {
                for (JobSettings childJob : jobSettings.getChildJobs()) {
                    this.loadVariables(childJob, propertiesMap);
                }
            }
        }
    }

    private void loadVariable(VariableSettings variableSettings, Map<String, Object> jobProperties, Map<String, Object> genericProperties) {
        String variableName = variableSettings.getName();
        String varNameWithoutHyphen = null;
        if (variableName != null && variableName.length() > 1 && !Character.isLetter(variableName.charAt(0)) && !Character.isDigit(variableName.charAt(0))) {
            varNameWithoutHyphen = variableName.substring(1);
        }
        if (jobProperties != null && this.getValueByConsideringIgnoreCase(jobProperties, variableName) != null) {
            logger.log(Level.INFO, "Loading job specific value for variable:" + variableSettings.getName());
            variableSettings.setValue(this.getValueByConsideringIgnoreCase(jobProperties, variableName).toString());
        } else if (jobProperties != null && varNameWithoutHyphen != null && this.getValueByConsideringIgnoreCase(jobProperties, varNameWithoutHyphen) != null) {
            logger.log(Level.INFO, "Loading global variable value for variable:" + variableSettings.getName());
            variableSettings.setValue(this.getValueByConsideringIgnoreCase(jobProperties, varNameWithoutHyphen).toString());
        } else if (genericProperties != null && this.getValueByConsideringIgnoreCase(genericProperties, variableName) != null) {
            logger.log(Level.INFO, "Loading global variable value for variable:" + variableSettings.getName());
            variableSettings.setValue(this.getValueByConsideringIgnoreCase(genericProperties, variableName).toString());
        } else if (genericProperties != null && varNameWithoutHyphen != null && this.getValueByConsideringIgnoreCase(genericProperties, varNameWithoutHyphen) != null) {
            logger.log(Level.INFO, "Loading global variable value for variable:" + variableSettings.getName());
            variableSettings.setValue(this.getValueByConsideringIgnoreCase(genericProperties, varNameWithoutHyphen).toString());
        }
    }

    private <T> T getValueByConsideringIgnoreCase(Map<String, T> map, String key) {
        if (key != null && map != null) {
            if (this.isIgnoreVariablesCase()) {
                return map.get(key.toLowerCase());
            }
            return map.get(key);
        }
        return null;
    }

    public boolean isIgnoreVariablesCase() {
        return this.ignoreVariablesCase;
    }

    public void setIgnoreVariablesCase(boolean ignoreVariablesCase) {
        this.ignoreVariablesCase = ignoreVariablesCase;
    }

    public String replaceVariables(String value, Map<String, VariableSettings> genericVariables, Map<String, VariableSettings> jobSpecificVariables) throws JobApplicationException {
        if (value != null && !value.isEmpty()) {
            Matcher matcher = this.getGenericVariableMatcher(value);
            if (matcher.find()) {
                String variableNameWithMarker = matcher.group();
                String variableName = variableNameWithMarker.substring(1, variableNameWithMarker.length() - 1);
                VariableSettings variable = null;
                if (jobSpecificVariables != null) {
                    variable = jobSpecificVariables.get(variableName);
                }
                if (variable == null && genericVariables != null) {
                    variable = genericVariables.get(variableName);
                }
                if (variable != null) {
                    String strToReplace = variable.getValue();
                    if (strToReplace != null) {
                        strToReplace = strToReplace.replace("\\", "\\\\");
                        value = matcher.replaceFirst(strToReplace = strToReplace.replace("$", "\\$"));
                        if ((matcher = this.getGenericVariableMatcher(value)).find()) {
                            value = this.replaceVariables(value, genericVariables, jobSpecificVariables);
                        }
                    } else {
                        logger.log(Level.WARNING, "String value is null for a variable (" + variableName + "). So ignoring replacing variable in string:" + value);
                    }
                } else {
                    throw new JobApplicationException((ErrorCode)JobErrorCode.UNKNOWN_VARIABLE_FOUND_ERR, variableNameWithMarker, value);
                }
            }
            if (!(value.contains("{") && value.contains("}") || !value.contains("{") && !value.contains("}"))) {
                throw new JobApplicationException((ErrorCode)JobErrorCode.INCORRECT_VARIABLE_FORMAT_FOUND_ERR, value, "{", "}");
            }
        }
        return value;
    }

    public String replaceVariable(String value, VariableSettings variable) {
        Matcher matcher;
        if (value != null && value.length() > 0 && variable != null && (matcher = this.getVariableMatcher(value, variable.getName())).find()) {
            String strToReplace = variable.getValue();
            if (strToReplace != null) {
                strToReplace = strToReplace.replace("\\", "\\\\");
                value = matcher.replaceAll(strToReplace);
            } else {
                logger.log(Level.WARNING, "String value is null for a variable (" + variable.getName() + "). So ignoring replacing variable in string:" + value);
            }
        }
        return value;
    }

    public boolean containsVariable(String value, VariableSettings variable) {
        Matcher matcher;
        return value != null && value.length() > 0 && variable != null && (matcher = this.getVariableMatcher(value, variable.getName())).find();
    }

    public boolean isVariableIncluded(String value) {
        Matcher matcher;
        return value != null && value.length() > 0 && (matcher = this.getGenericVariableMatcher(value)).find();
    }

    private Matcher getGenericVariableMatcher(String value) {
        Pattern p = null;
        p = this.ignoreVariablesCase ? Pattern.compile("\\{[^\\{\\}]*\\}", 2) : Pattern.compile("\\{[^\\{\\}]*\\}");
        return p.matcher(value);
    }

    private Matcher getVariableMatcher(String value, String variableName) {
        Pattern p = null;
        p = this.ignoreVariablesCase ? Pattern.compile("\\{" + variableName + "\\}", 2) : Pattern.compile("\\{" + variableName + "\\}");
        return p.matcher(value);
    }

    public void replacePasswordVariables(List<JobSettings> jobSettingsList, JobContext jobContext, boolean recursive) throws JobApplicationException {
        if (jobSettingsList != null && jobContext != null) {
            for (JobSettings jobSettings : jobSettingsList) {
                if (jobSettings.getSecreteArgs() != null && !jobSettings.getSecreteArgs().isEmpty()) {
                    for (VariableSettings variableSettings : jobSettings.getSecreteArgs().values()) {
                        String value;
                        if (!variableSettings.isSecure() || variableSettings.getValue() == null || (value = variableSettings.getValue()) == null || value.length() <= 2 || !value.startsWith("{") || value.indexOf("}") != value.length() - 1) continue;
                        logger.log(Level.INFO, "Variable placeholder found for the variable name:" + variableSettings.getName());
                        value = this.replaceVariables(value, jobContext.getJobIndependentVars(), jobSettings.getSecreteArgs());
                        variableSettings.setValue(value);
                    }
                }
                if (!recursive || jobSettings.getChildJobs() == null) continue;
                this.replacePasswordVariables(jobSettings.getChildJobs(), jobContext, recursive);
            }
        }
    }

    public void promptSecreteArgs(List<JobSettings> jobSettingsList, JobContext jobContext, boolean recursive, boolean promptGlobalVars) {
        if (jobSettingsList != null && jobContext != null) {
            List<VariableSettings> secretGlobalVars;
            JPanel panel = null;
            JLabel lblPassword = null;
            JLabel lblConfirm = null;
            JPasswordField pwdPassword = null;
            JPasswordField pwdConfirm = null;
            Resource resource = null;
            if (Application.getInstance().getUIType() == UIType.GRAPHICAL) {
                resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
                panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                lblPassword = new JLabel("");
                pwdPassword = new JPasswordField(20);
                lblConfirm = new JLabel("");
                pwdConfirm = new JPasswordField(20);
                LayoutUtils.addComponent(lblPassword, panel, 0, 0, 1, 1, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
                LayoutUtils.addComponent(pwdPassword, panel, 1, 0, 1, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
                LayoutUtils.addComponent(lblConfirm, panel, 0, 1, 1, 1, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
                LayoutUtils.addComponent(pwdConfirm, panel, 1, 1, 1, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
            }
            for (JobSettings jobSettings : jobSettingsList) {
                if (jobSettings.getSecreteArgs() != null && !jobSettings.getSecreteArgs().isEmpty()) {
                    for (VariableSettings variableSettings : jobSettings.getSecreteArgs().values()) {
                        if (variableSettings.getValue() == null) {
                            String promptString = variableSettings.getPromptString();
                            variableSettings.setValue(this.promptPassword(Application.getInstance().getUIType(), promptString, resource, lblPassword, lblConfirm, panel, pwdPassword, pwdConfirm));
                            continue;
                        }
                        logger.log(Level.INFO, "Value is already set for secrete variable:" + variableSettings.getName());
                    }
                }
                if (!recursive || jobSettings.getChildJobs() == null) continue;
                this.promptSecreteArgs(jobSettings.getChildJobs(), jobContext, recursive, false);
            }
            if (jobContext.getJobIndependentVars() != null && (secretGlobalVars = this.getSecretGlobalVarToPrompt(jobContext.getJobIndependentVars(), jobSettingsList)) != null) {
                for (VariableSettings globalVar : secretGlobalVars) {
                    if (globalVar == null || !globalVar.isSecure()) continue;
                    if (globalVar.getValue() == null) {
                        String promptString = globalVar.getPromptString();
                        globalVar.setValue(this.promptPassword(Application.getInstance().getUIType(), promptString, resource, lblPassword, lblConfirm, panel, pwdPassword, pwdConfirm));
                        continue;
                    }
                    logger.log(Level.INFO, "Value is already set for secrete variable:" + globalVar.getName());
                }
            }
        }
    }

    private List<VariableSettings> getSecretGlobalVarToPrompt(Map<String, VariableSettings> globalVars, List<JobSettings> jobSettingsList) {
        ArrayList<VariableSettings> globalVarsToPrompt = new ArrayList<VariableSettings>();
        if (globalVars != null && jobSettingsList != null) {
            for (VariableSettings globalVar : globalVars.values()) {
                if (globalVar == null || !globalVar.isSecure()) continue;
                if (globalVar.getValue() == null) {
                    boolean used = false;
                    for (JobSettings jobSettings : jobSettingsList) {
                        if (jobSettings.getSecreteArgs() == null) continue;
                        for (VariableSettings secretVar : jobSettings.getSecreteArgs().values()) {
                            if (secretVar == null || secretVar.getValue() == null || !this.containsVariable(secretVar.getValue(), globalVar)) continue;
                            used = true;
                            break;
                        }
                        if (!used) continue;
                        break;
                    }
                    if (!used) continue;
                    globalVarsToPrompt.add(globalVar);
                    continue;
                }
                logger.log(Level.INFO, "Value is already set for secrete variable:" + globalVar.getName());
            }
        }
        return globalVarsToPrompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptPassword(UIType uiType, String prompt, Resource resource, JLabel lblPassword, JLabel lblConfirm, JPanel panel, JPasswordField passwordFiled, JPasswordField confirmPasswordField) {
        String newPassword = null;
        int trial = 0;
        boolean success = false;
        while (trial < 3 && !success) {
            try {
                if (Application.getInstance().getUIType() == UIType.GRAPHICAL) {
                    lblPassword.setText(prompt);
                    lblConfirm.setText(prompt + " (reconfirmation):");
                    String password = this.promptPassword(resource, panel, passwordFiled, confirmPasswordField);
                    if (password == null || password.isEmpty()) continue;
                    newPassword = password;
                    success = true;
                    continue;
                }
                char[] passwordArray = PasswordHelper.getPassword(prompt);
                if (passwordArray == null) continue;
                String password = String.valueOf(passwordArray);
                char[] reconfirmation = PasswordHelper.getPassword(prompt + " (reconfirmation):");
                if (reconfirmation == null) continue;
                String confirmPassword = String.valueOf(reconfirmation);
                if (!password.equals(confirmPassword)) {
                    System.out.println("Specified passwords are not matching. Re-enter the passwords");
                    continue;
                }
                newPassword = password;
                success = true;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "IOException occurred while prompting for password:" + prompt, e);
                System.out.println("IOException occurred while prompting for password. Re-enter the passwords");
            }
            finally {
                logger.log(Level.INFO, "Number of trials for prompting password for:" + prompt + " is:" + ++trial);
            }
        }
        return newPassword;
    }

    private String promptPassword(Resource resource, JPanel panel, JPasswordField passwordFiled, JPasswordField confirmPasswordField) {
        if (panel != null && passwordFiled != null && confirmPasswordField != null && StandardDialog.promptInput(null, resource.getString("JobVariableLoader.passworddialog.title", "Specify password", new Object[0]), panel)) {
            char[] pass = passwordFiled.getPassword();
            char[] passConfirm = confirmPasswordField.getPassword();
            if (pass == null || passConfirm == null || !String.valueOf(pass).equals(String.valueOf(passConfirm))) {
                StandardDialog.showWarning(null, resource.getString("JobVariableLoader.passwordnotmatching.warning", "Either password is not specified or specified passwords are not matching.", new Object[0]));
            } else {
                return String.valueOf(pass);
            }
        }
        return null;
    }

    public void updatePromptString(List<JobSettings> jobSettingsList, JobContext jobContext, boolean recursive, boolean updateGlobalVars) {
        Resource resource = Application.getInstance().getDefaultResource();
        if (jobSettingsList != null && jobContext != null) {
            for (JobSettings jobSettings : jobSettingsList) {
                if (jobSettings.getSecreteArgs() != null && !jobSettings.getSecreteArgs().isEmpty()) {
                    for (VariableSettings variableSettings : jobSettings.getSecreteArgs().values()) {
                        String promptString = variableSettings.getPromptString();
                        if (promptString != null && !promptString.isEmpty()) continue;
                        if (resource != null) {
                            promptString = resource.getString(variableSettings.getName() + ".promptString", "Enter password for " + variableSettings.getName() + ":", new Object[0]);
                        }
                        if (promptString == null || promptString.isEmpty()) {
                            promptString = "Enter password for " + variableSettings.getName();
                        }
                        variableSettings.setPromptString(promptString);
                    }
                }
                if (!recursive || jobSettings.getChildJobs() == null) continue;
                this.updatePromptString(jobSettings.getChildJobs(), jobContext, recursive, false);
            }
        }
        if (updateGlobalVars && jobContext.getJobIndependentVars() != null) {
            for (VariableSettings globalVar : jobContext.getJobIndependentVars().values()) {
                String promptString;
                if (globalVar == null || !globalVar.isSecure() || (promptString = globalVar.getPromptString()) != null && !promptString.isEmpty()) continue;
                if (resource != null) {
                    promptString = resource.getString(globalVar.getName() + ".promptString", "Enter password for " + globalVar.getName() + ":", new Object[0]);
                }
                if (promptString == null || promptString.isEmpty()) {
                    promptString = "Enter password for " + globalVar.getName() + ":";
                }
                globalVar.setPromptString(promptString);
            }
        }
    }
}

