/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.net.URL;
import java.text.ParsePosition;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.job.Checkpointable;
import oracle.install.commons.base.util.job.JobApplication;
import oracle.install.commons.base.util.job.JobApplicationConstants;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreFactory;
import oracle.install.commons.bean.xml.XmlBeanStore;
import oracle.install.commons.bean.xml.XmlBeanStoreFactory;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreSource;
import oracle.install.commons.bean.xml.XmlBeanStoreWriter;
import oracle.install.commons.util.exception.ErrorCode;

public class JobCheckPointer
implements Checkpointable {
    private static String raw2ext = "/oracle/install/commons/base/util/job/resource/jobs_raw2_ext_transformer.xsl";
    private static final Logger logger = Logger.getLogger(JobCheckPointer.class.getName());
    private static JobCheckPointer instance;
    private String checkPointWorkDir;
    private int currentCheckpointFileVersion = 1;

    public static JobCheckPointer getInstance() {
        if (instance == null) {
            instance = new JobCheckPointer();
        }
        return instance;
    }

    private JobCheckPointer() {
    }

    private String getCheckPointWorkDir() {
        return this.checkPointWorkDir;
    }

    public void setCheckPointWorkDir(String checkPointWorkDir) {
        this.checkPointWorkDir = checkPointWorkDir;
    }

    @Override
    public boolean createCheckpoint(JobContext jobContext) throws JobApplicationException {
        File checkPointFile = this.getNewCheckPointFile(jobContext);
        return this.createCheckpoint(checkPointFile, jobContext);
    }

    public boolean createCheckpoint(File checkPointFile, JobContext jobContext) throws JobApplicationException {
        try {
            if (checkPointFile != null) {
                File parent = checkPointFile.getParentFile();
                if (!parent.exists()) {
                    logger.log(Level.INFO, "Parent directory doesn't exist. So creating checkpoint directory:" + parent.getPath());
                    parent.mkdirs();
                } else if (parent.isFile()) {
                    throw new JobApplicationException((ErrorCode)JobErrorCode.FILE_WITH_CHECKPOINT_DIR_NAME_EXIST_ERR, parent.getPath());
                }
                if (checkPointFile.exists()) {
                    logger.log(Level.INFO, "check point file already present. So creating backup file", checkPointFile.getPath());
                    File backupFile = new File(checkPointFile.getPath() + "_bak");
                    if (backupFile.exists()) {
                        logger.log(Level.INFO, "Check point backup file already present. So deleting it before taking backup", backupFile.getPath());
                        backupFile.delete();
                    }
                    checkPointFile.renameTo(backupFile);
                }
                URL raw2extTransformer = JobCheckPointer.class.getResource(raw2ext);
                String namespaceURI = jobContext.getName();
                XmlBeanStoreFormat format = new XmlBeanStoreFormat(namespaceURI, raw2extTransformer, null, null);
                XmlBeanStoreFactory beanStoreFactory = BeanStoreFactory.getInstance(XmlBeanStoreFactory.class);
                XmlBeanStore beanStore = beanStoreFactory.newBeanStore(new XmlBeanStoreSource(format));
                beanStore.setFormat(format);
                XmlBeanStoreWriter writer = beanStore.newBeanStoreWriter();
                writer.write(jobContext);
                writer.close();
                beanStore.save(new FileOutputStream(checkPointFile));
                beanStore.close();
                if (!Boolean.getBoolean(JobApplicationConstants.DISABLE_VERSIONED_CHECKPOINTING)) {
                    ++this.currentCheckpointFileVersion;
                }
            } else {
                logger.log(Level.WARNING, "Checkpointing is disabled for this application");
            }
        }
        catch (BeanStoreException e) {
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_CHECKPOINT_FILE_ERR, checkPointFile);
        }
        catch (FileNotFoundException e) {
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_CHECKPOINT_FILE_ERR, checkPointFile);
        }
        catch (Exception e) {
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_CHECKPOINT_FILE_ERR, checkPointFile);
        }
        return true;
    }

    private File getNewCheckPointFile(JobContext jobContext) {
        File checkpointFile = null;
        if (this.checkPointWorkDir != null) {
            checkpointFile = new File(this.getCheckPointDir(jobContext), String.format(JobApplicationConstants.CHECK_POINT_FILE_NAME_FORMAT, this.currentCheckpointFileVersion));
        }
        return checkpointFile;
    }

    public File getCheckPointDir(JobContext jobContext) {
        File checkpointDir = null;
        if (this.checkPointWorkDir != null && jobContext != null && JobApplication.getInstance().getSessionTime() != null) {
            checkpointDir = new File(this.checkPointWorkDir, jobContext.getName() + "_" + JobApplicationConstants.TIME_STAMP_FORMATER.format(JobApplication.getInstance().getSessionTime()));
        } else {
            logger.log(Level.WARNING, "Either checkpoint work directory is null or session time stamp is not set");
        }
        return checkpointDir;
    }

    public File getLastCheckPointFile(String applicationName) {
        File latestCheckpointDir = this.getLastCheckPointDir(applicationName);
        File latestCheckPointFile = null;
        int latestCheckPointFileVersion = 0;
        if (latestCheckpointDir != null && latestCheckpointDir.list() != null) {
            logger.log(Level.INFO, "latest check point directory retrieved is:" + latestCheckpointDir.getPath());
            for (File file : latestCheckpointDir.listFiles()) {
                String fileName = file.getName();
                if (!fileName.startsWith(JobApplicationConstants.CHECK_POINT_FILE_NAME_PREFIX) || !fileName.endsWith(JobApplicationConstants.CHECK_POINT_FILE_NAME_EXTENSION)) continue;
                String version = fileName.substring(JobApplicationConstants.CHECK_POINT_FILE_NAME_PREFIX.length(), fileName.indexOf(JobApplicationConstants.CHECK_POINT_FILE_NAME_EXTENSION));
                if (latestCheckPointFile == null) {
                    latestCheckPointFile = file;
                    latestCheckPointFileVersion = Integer.parseInt(version);
                }
                if (Integer.parseInt(version) <= latestCheckPointFileVersion) continue;
                latestCheckPointFile = file;
                latestCheckPointFileVersion = Integer.parseInt(version);
            }
        } else {
            logger.log(Level.INFO, "Previous check point directory doesn't exist or there are no files in it:" + (latestCheckpointDir != null ? latestCheckpointDir.getPath() : "<empty>"));
        }
        return latestCheckPointFile;
    }

    private File getLastCheckPointDir(final String applicationName) {
        File checkPointDir;
        File latestCheckpointDir = null;
        Date latestCheckpointDirTime = null;
        if (this.checkPointWorkDir != null && !this.checkPointWorkDir.isEmpty() && (checkPointDir = new File(this.checkPointWorkDir)).exists()) {
            for (File dir : checkPointDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.startsWith(applicationName + "_");
                }
            })) {
                Date date = JobApplicationConstants.TIME_STAMP_FORMATER.parse(dir.getName(), new ParsePosition((applicationName + "_").length()));
                if (date != null) {
                    if (latestCheckpointDir == null) {
                        latestCheckpointDir = dir;
                        latestCheckpointDirTime = date;
                    }
                    if (latestCheckpointDirTime.compareTo(date) >= 0) continue;
                    latestCheckpointDir = dir;
                    latestCheckpointDirTime = date;
                    continue;
                }
                logger.log(Level.WARNING, "Unable to get time stamp from the directory:" + dir.getPath() + " so skipping this directory");
            }
        }
        return latestCheckpointDir;
    }

    @Override
    public boolean loadCheckpoint(JobContext jobContext) {
        return false;
    }
}

