/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.job.JobApplication;
import oracle.install.commons.base.util.job.JobApplicationConstants;
import oracle.install.commons.base.util.job.JobApplicationEvent;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.JobApplicationListener;
import oracle.install.commons.base.util.job.JobBuilder;
import oracle.install.commons.base.util.job.JobCheckPointer;
import oracle.install.commons.base.util.job.JobVariableLoader;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.engine.JobExecutionEngine;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.Job;

public class JobApplicationHandler {
    private static JobApplicationHandler instance;
    private static final Logger logger;

    public static JobApplicationHandler getInstance() {
        if (instance == null) {
            instance = new JobApplicationHandler();
        }
        return instance;
    }

    private JobApplicationHandler() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JobContext load(URL jobsXML, Properties properties, String checkPointDir, boolean reconcile) throws JobApplicationException {
        JobCheckPointer jobCheckPointer = JobCheckPointer.getInstance();
        jobCheckPointer.setCheckPointWorkDir(checkPointDir);
        JobBuilder jobBuilder = new JobBuilder();
        JobContext jobContext = null;
        if (reconcile) {
            String applicationName = jobBuilder.getApplicationName(jobsXML);
            File lastCheckPointFile = jobCheckPointer.getLastCheckPointFile(applicationName);
            if (lastCheckPointFile == null) throw new JobApplicationException((ErrorCode)JobErrorCode.UNABLE_RETRIEVE_LAST_CHECKPOINT_FILE_ERR, new Object[0]);
            try {
                jobContext = jobBuilder.buildJobs(lastCheckPointFile.toURI().toURL());
                JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOBS_XML_LOADED, jobContext, new Object[0]));
            }
            catch (MalformedURLException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_FIND_JOB_XML_ERR, lastCheckPointFile);
            }
        } else {
            jobContext = jobBuilder.buildJobs(jobsXML);
            JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOBS_XML_LOADED, jobContext, new Object[0]));
        }
        if (jobContext == null) return jobContext;
        JobVariableLoader.getInstance().loadJobVariables(jobContext, properties);
        JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.VARIABLES_LOADED, jobContext, new Object[0]));
        return jobContext;
    }

    public boolean run(JobContext jobContext) throws JobApplicationException {
        JobExecutionEngine jobExecutionEngine = JobExecutionEngine.getInstance();
        List<Job> jobs = jobExecutionEngine.populateJobs(jobContext);
        boolean success = true;
        if (jobs != null) {
            jobContext.setRuntimeJobs(jobs);
            JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOBS_LIST_POPULATED, jobContext, new Object[0]));
            this.addCheckPointListner(jobContext);
            List<JobSettings> jobSettingsList = jobExecutionEngine.getJobSettingsList(jobContext.getRuntimeJobs(), jobContext, true, true);
            JobVariableLoader.getInstance().updatePromptString(jobSettingsList, jobContext, false, true);
            if (!Boolean.getBoolean(JobApplicationConstants.DISABLE_PROMPT_FOR_PASSWORDS)) {
                JobVariableLoader.getInstance().promptSecreteArgs(jobSettingsList, jobContext, false, true);
            }
            JobVariableLoader.getInstance().replacePasswordVariables(jobSettingsList, jobContext, false);
            JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOBS_EXECUTION_STARTED, jobContext, new Object[0]));
            success = jobExecutionEngine.executeJobs(jobContext);
            JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOBS_EXECUTION_COMPLETED, jobContext, new Object[0]));
        }
        return success;
    }

    public boolean createJobsXML(String xmlFilePath, JobContext jobContext) throws JobApplicationException {
        boolean success = false;
        if (xmlFilePath != null && !xmlFilePath.isEmpty()) {
            File checkPoint = new File(xmlFilePath);
            success = JobCheckPointer.getInstance().createCheckpoint(checkPoint, jobContext);
        } else {
            logger.log(Level.WARNING, "Job XML file is null or empty. So not creating jobs XML file");
        }
        JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOBS_XML_GENERATED, jobContext, xmlFilePath, success));
        return success;
    }

    private void addCheckPointListner(final JobContext jobContext) {
        JobApplication.getInstance().addJobApplicationListener(new JobApplicationListener(){

            @Override
            public void update(JobApplicationEvent e) {
                if (e.getType() == JobApplicationEvent.Type.JOB_EXECUTED) {
                    try {
                        JobCheckPointer.getInstance().createCheckpoint(jobContext);
                    }
                    catch (JobApplicationException e1) {
                        logger.log(Level.WARNING, "Exception occurred while checkpointing");
                        ExceptionManager.handle(e1);
                    }
                }
            }
        });
    }

    protected boolean executeJobs(URL jobsXML, Properties properties, String checkPointDir, boolean reconcile) throws JobApplicationException {
        JobContext jobContext = this.load(jobsXML, properties, checkPointDir, reconcile);
        boolean success = this.run(jobContext);
        return success;
    }

    protected boolean executeJobs(File jobsXML, Properties properties, String checkPointDir, boolean reconcile) throws JobApplicationException {
        try {
            return this.executeJobs(jobsXML != null ? jobsXML.toURI().toURL() : null, properties, checkPointDir, reconcile);
        }
        catch (MalformedURLException e) {
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_FIND_JOB_XML_ERR, jobsXML);
        }
    }

    static {
        logger = Logger.getLogger(JobApplicationHandler.class.getName());
    }
}

