/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.job.DataDrivenJob;
import oracle.install.commons.base.util.job.ExecutionResult;
import oracle.install.commons.base.util.job.JobApplicationConstants;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.JobApplicationLogHandler;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.engine.CommandExecutor;
import oracle.install.commons.base.util.job.engine.ExecutionEngineFactory;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;

public class CommandExecutionJob
extends DataDrivenJob
implements Callable<Boolean>,
Retriable<CommandExecutionJob> {
    private static final Logger logger = Logger.getLogger(CommandExecutionJob.class.getName());
    private Resource resource;

    public CommandExecutionJob(JobContext jobContext, JobSettings jobSettings, String description) {
        super(jobContext, jobSettings, description);
        this.setRetryEnabled(jobSettings.isRetriable());
        this.setRetriable(this);
        this.resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    @Override
    public List<CommandExecutionJob> getRetriableJobs() {
        ArrayList<CommandExecutionJob> retriableJobs = new ArrayList<CommandExecutionJob>();
        Status status = this.getStatus();
        if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
            retriableJobs.add(this);
        }
        return retriableJobs;
    }

    @Override
    public void retry() throws Exception {
        this.call();
    }

    @Override
    public Boolean call() throws Exception {
        Map<String, VariableSettings> envVars;
        this.setStatus(Status.INPROGRESS);
        JobSettings jobSettings = this.getJobSettings();
        Map<String, ExecutionResult> resultMap = null;
        try {
            CommandExecutor commandExecutor = ExecutionEngineFactory.getInstance().getCommandExecutor();
            if (commandExecutor == null) {
                logger.log(Level.WARNING, "Command executor object is null");
                throw new JobApplicationException((ErrorCode)JobErrorCode.UNABLE_TO_CREATE_COMMAND_EXECUTOR_OBJ_ERR, new Object[0]);
            }
            resultMap = commandExecutor.execute(this.getJobContext(), jobSettings);
        }
        catch (Throwable e) {
            ExceptionManager.advise(new ValidationStatusMessage(e));
            jobSettings.setExitCode(-1);
            return false;
        }
        String successFulExitCodes = System.getProperty(String.format(JobApplicationConstants.JOB_SUCCESSFUL_STATUS_EXIT_CODES_PROPERTY, jobSettings.getId()));
        if ((successFulExitCodes == null || successFulExitCodes.isEmpty()) && (envVars = jobSettings.getEnvVariables()) != null && envVars.containsKey(JobApplicationConstants.SUCCESSFUL_STATUS_EXIT_CODES_PROPERTY) && envVars.get(JobApplicationConstants.SUCCESSFUL_STATUS_EXIT_CODES_PROPERTY) != null) {
            successFulExitCodes = envVars.get(JobApplicationConstants.SUCCESSFUL_STATUS_EXIT_CODES_PROPERTY).getValue();
        }
        ArrayList<Integer> sucessfulExitCodes = new ArrayList<Integer>();
        if (successFulExitCodes != null && !successFulExitCodes.isEmpty()) {
            String[] exitCodeArray = successFulExitCodes.split(",");
            for (int i = 0; i < exitCodeArray.length; ++i) {
                sucessfulExitCodes.add(Integer.valueOf(exitCodeArray[i].trim()));
            }
        }
        int status = 0;
        boolean succeededPartially = false;
        ExecutionResult result = null;
        if (resultMap != null) {
            for (String node : resultMap.keySet()) {
                if (resultMap.get(node) != null) {
                    result = resultMap.get(node);
                    int nodeExitCode = resultMap.get(node).getExitCode();
                    if (nodeExitCode == 0) continue;
                    if (sucessfulExitCodes.contains(nodeExitCode) && status == 0) {
                        succeededPartially = true;
                        continue;
                    }
                    status = nodeExitCode;
                    continue;
                }
                status = -1;
            }
        } else {
            status = -1;
        }
        jobSettings.setExitCode(status);
        logger.log(Level.INFO, "********Overall result for job execution:" + jobSettings.getId() + " ******");
        logger.log(Level.INFO, this.getExtraDetailsString(jobSettings.getCommand(), resultMap, null, false));
        logger.log(Level.INFO, "********End of overall result for job execution******");
        if (status != 0) {
            ValidationStatusMessage message;
            if (succeededPartially) {
                message = new ValidationStatusMessage((ErrorCode)JobErrorCode.JOB_COMPLETED_WITH_NON_ZERO_EXIT_CODE_WARN, result != null ? result.getCommands() : jobSettings.getCommand(), status, JobApplicationLogHandler.getLogFile());
                this.addStatusMessage(message);
                this.setStatus(Status.SUCCEEDED_PARTIALLY);
                return true;
            }
            message = new ValidationStatusMessage((ErrorCode)JobErrorCode.JOB_EXECUTION_FAILED_ERR, result != null ? result.getCommands() : jobSettings.getCommand());
            PlainContent content = new PlainContent(this.getExtraDetailsString(jobSettings.getCommand(), resultMap, null, true));
            ContentType contentType = ContentType.HTML;
            content.setContentType(contentType);
            message.getErrorInfo().setExtraDetails(content);
            this.addStatusMessage(message);
            this.setStatus(Status.FAILED);
            return false;
        }
        this.setStatus(Status.SUCCEEDED);
        return true;
    }

    public String getExtraDetailsString(String script, Map<String, ExecutionResult> resultSet, Throwable e, boolean htmlFormat) {
        String nodeStatusMsg;
        StringBuffer stringBuffer = new StringBuffer();
        List<Object> succeededNodes = new ArrayList();
        List<Object> failedNodes = new ArrayList();
        if (e == null && this.getStatus(resultSet)) {
            succeededNodes = this.getSucceededNodes(resultSet);
            stringBuffer.append(this.resource.getString("ExecutionJob.successful.nodes.message", "Execution of {0} script is successful on nodes : {1}", script, this.getNodeList(succeededNodes, false)));
            stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
        } else {
            succeededNodes = this.getSucceededNodes(resultSet);
            if (succeededNodes.size() > 0) {
                stringBuffer.append(this.resource.getString("ExecutionJob.successful.nodes.message", "Execution of {0} script is successful on nodes : {1}", script, this.getNodeList(succeededNodes, false)));
                stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
            }
            if ((failedNodes = this.getFailedNodes(resultSet)).size() > 0) {
                stringBuffer.append(this.resource.getString("ExecutionJob.failed.nodes.message", "Execution of {0} script is failed on nodes : {1}", script, this.getNodeList(failedNodes, htmlFormat)));
                stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
            }
        }
        if (e != null) {
            ArrayList<String> causes = new ArrayList<String>();
            ExceptionManager.enumCauses(e, causes);
            String string = this.resource.getString("ExecutionJob.exception.details", "Exception Details:", new Object[0]);
            stringBuffer.append(htmlFormat ? "<b>" : "");
            stringBuffer.append(string);
            stringBuffer.append(htmlFormat ? "</b>" : "");
            stringBuffer.append(htmlFormat ? "<br>" : "\n");
            stringBuffer.append(htmlFormat ? "&nbsp;-&nbsp;" : " - ");
            stringBuffer.append(e.getLocalizedMessage());
            if (!causes.isEmpty()) {
                for (String cause : causes) {
                    stringBuffer.append(htmlFormat ? "<br>" : "\n");
                    stringBuffer.append(htmlFormat ? "&nbsp;-&nbsp;" : " - ");
                    stringBuffer.append(cause);
                }
            }
            stringBuffer.append(htmlFormat ? "<br>" : "\n");
            stringBuffer.append(htmlFormat ? "<br>" : "\n");
        }
        if (failedNodes.size() > 0) {
            for (String string : failedNodes) {
                stringBuffer.append(htmlFormat ? "<a name=\"" + string + "\"></a>" : "");
                nodeStatusMsg = this.resource.getString("ExecutionJob.failed.node.execution.status", "Execution status of failed node:", new Object[0]);
                stringBuffer.append(htmlFormat ? "<b>" + nodeStatusMsg + "</b>" : nodeStatusMsg);
                stringBuffer.append(string);
                stringBuffer.append(this.getNodeStatus(resultSet.get(string), htmlFormat));
                stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
            }
        }
        if (!htmlFormat) {
            if (succeededNodes.size() > 0) {
                for (String string : succeededNodes) {
                    stringBuffer.append(htmlFormat ? "<a name=\"" + string + "\"></a>" : "");
                    nodeStatusMsg = this.resource.getString("ExecutionJob.succeeded.node.execution.status", "Execution status of succeeded node:", new Object[0]);
                    stringBuffer.append(htmlFormat ? "<b>" + nodeStatusMsg + "</b>" : nodeStatusMsg);
                    stringBuffer.append(string);
                    stringBuffer.append(this.getNodeStatus(resultSet.get(string), htmlFormat));
                    stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
                }
            }
            for (String string : resultSet.keySet()) {
                stringBuffer.append(" Execution status of " + string + " is:" + resultSet.get(string).isSuccess() + "\n");
                stringBuffer.append(" Execution exit code of " + string + " is:" + resultSet.get(string).getExitCode() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public List<String> getFailedNodes(Map<String, ExecutionResult> resultSet) {
        ArrayList<String> failedNodes = new ArrayList<String>();
        if (resultSet != null) {
            for (String node : resultSet.keySet()) {
                ExecutionResult nodeStatus = resultSet.get(node);
                if (nodeStatus.getExitCode() == 0 && nodeStatus.isSuccess()) continue;
                failedNodes.add(node);
            }
        }
        return failedNodes;
    }

    public List<String> getSucceededNodes(Map<String, ExecutionResult> resultSet) {
        ArrayList<String> succeededNodes = new ArrayList<String>();
        if (resultSet != null) {
            for (String node : resultSet.keySet()) {
                ExecutionResult nodeStatus = resultSet.get(node);
                if (nodeStatus.getExitCode() != 0 || !nodeStatus.isSuccess()) continue;
                succeededNodes.add(node);
            }
        }
        return succeededNodes;
    }

    private String getNodeList(List<String> nodeList, boolean htmlFormat) {
        int n = nodeList.size();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (int i = 0; i < n; ++i) {
            String node = nodeList.get(i);
            buffer.append(htmlFormat ? "<a href=\"#" + node + "\">" : "");
            buffer.append(node);
            buffer.append(htmlFormat ? "</a>" : "");
            if (i + 1 == n) continue;
            buffer.append(htmlFormat ? ", &nbsp;" : ", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private boolean getStatus(Map<String, ExecutionResult> resultSet) {
        return this.getFailedNodes(resultSet).size() == 0;
    }

    private String getNodeStatus(ExecutionResult nodeStatus, boolean htmlFormat) {
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append(htmlFormat ? "&nbsp;<table border=\"0\">" : " ");
        String errorHeading = this.resource.getString("ExecutionJob.errors.text", "Errors", new Object[0]);
        List<String> errorString = nodeStatus.getErrors();
        if (errorString != null && errorString.size() > 0) {
            String errors = errorString.toString();
            errors = errors.substring(1, errors.length() - 1);
            if (htmlFormat) {
                errors = errors.replaceAll("<", "&lt;");
                errors = errors.replaceAll(">", "&gt;");
            }
            messageBuffer.append(htmlFormat ? "<tr>" : "\n");
            messageBuffer.append(htmlFormat ? "<td valign=\"top\" align=\"left\" nowrap>" : "").append(htmlFormat ? "&nbsp;" + errorHeading + "&nbsp;" : " " + errorHeading + " ").append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "<td>" : "");
            messageBuffer.append(htmlFormat ? "&nbsp;:&nbsp;" : " : ");
            messageBuffer.append(htmlFormat ? errors.replaceAll("\n", "<br>") : errorString);
            messageBuffer.append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "</tr>" : "");
        }
        String stdOutHeader = this.resource.getString("ExecutionJob.standard.output.text", "Standard output", new Object[0]);
        List<String> outputList = nodeStatus.getOutput();
        if (outputList != null && outputList.size() > 0) {
            String outputString = outputList.toString();
            outputString = outputString.substring(1, outputString.length() - 1);
            if (htmlFormat) {
                outputString = outputString.replaceAll("<", "&lt;");
                outputString = outputString.replaceAll(">", "&gt;");
            }
            messageBuffer.append(htmlFormat ? "<tr>" : "\n");
            messageBuffer.append(htmlFormat ? "<td valign=\"top\" align=\"left\" nowrap>" : "").append(htmlFormat ? "&nbsp;" + stdOutHeader + "&nbsp;" : " " + stdOutHeader + " ").append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "<td>" : "");
            messageBuffer.append(htmlFormat ? "&nbsp;:&nbsp;" : " : ");
            messageBuffer.append(htmlFormat ? outputString.replaceAll("\n", "<br>") : outputString);
            messageBuffer.append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "</tr>" : "");
        }
        if (nodeStatus.getExitCode() != 0 || !nodeStatus.isSuccess()) {
            String exceptionHeader = this.resource.getString("ExecutionJob.exception.details", "Exception details", new Object[0]);
            List<Throwable> exceptionsList = nodeStatus.getException();
            if (exceptionsList != null && exceptionsList.size() > 0) {
                String exceptionString = "";
                for (Throwable e : exceptionsList) {
                    exceptionString = exceptionString + "\n" + e.getMessage();
                }
                if (htmlFormat) {
                    exceptionString = exceptionString.replaceAll("<", "&lt;");
                    exceptionString = exceptionString.replaceAll(">", "&gt;");
                }
                messageBuffer.append(htmlFormat ? "<tr>" : "\n");
                messageBuffer.append(htmlFormat ? "<td valign=\"top\" align=\"left\" nowrap>" : "").append(htmlFormat ? "&nbsp;" + exceptionHeader + "&nbsp;" : " " + exceptionHeader + " ").append(htmlFormat ? "</td>" : "");
                messageBuffer.append(htmlFormat ? "<td>" : "");
                messageBuffer.append(htmlFormat ? "&nbsp;:&nbsp;" : " : ");
                messageBuffer.append(htmlFormat ? exceptionString.replaceAll("\n", "<br>") : exceptionString);
                messageBuffer.append(htmlFormat ? "</td>" : "");
                messageBuffer.append(htmlFormat ? "</tr>" : "");
            }
        }
        messageBuffer.append(htmlFormat ? "</table>" : "");
        return messageBuffer.toString();
    }
}

