/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.install.commons.base.util.cli.CommandArgType;

public class CommandLineArgument {
    private String name;
    private String value;
    private List<String> multipleValueList;
    private boolean isValueExpected;
    private boolean isTopLevel;
    private List<String> mandatoryDependentArgs;
    private List<String> optionalDependentArgs;
    private List<String> aliasNames;
    private String mutualExclusivesGroupId;
    private CommandArgType type;
    private List<Platform> supportedPlatforms = Arrays.asList(Platform.ALL);
    private boolean isHidden;
    private boolean isDeprecated;
    private boolean isSecure;
    private String deprecatedBy;
    private String resourceId;
    private List<String> contextId;
    private boolean isOptional;
    private List<String> skipMandatoryCheckOnValue;
    private boolean allowMultipleOccurences;

    public List<String> getContextId() {
        return this.contextId;
    }

    public void setContextId(List<String> contextId) {
        this.contextId = contextId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        if (this.allowMultipleOccurences) {
            if (this.multipleValueList == null) {
                this.multipleValueList = new ArrayList<String>();
            }
            this.multipleValueList.add(value);
        }
    }

    public boolean isValueExpected() {
        return this.isValueExpected;
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public void setTopLevel(boolean isTopLevel) {
        this.isTopLevel = isTopLevel;
    }

    public List<String> getMandatoryDependentArgs() {
        return this.mandatoryDependentArgs;
    }

    public void setMandatoryDependentArgs(List<String> mandatoryDependentArgs) {
        this.mandatoryDependentArgs = mandatoryDependentArgs;
    }

    public List<String> getOptionalDependentArgs() {
        return this.optionalDependentArgs;
    }

    public void setOptionalDependentArgs(List<String> optionalDependentArgs) {
        this.optionalDependentArgs = optionalDependentArgs;
    }

    public String getMutualExclusivesGroupId() {
        return this.mutualExclusivesGroupId;
    }

    public void setMutualExclusivesGroupId(String mutualExclusivesGroupID) {
        this.mutualExclusivesGroupId = mutualExclusivesGroupID;
    }

    public CommandArgType getType() {
        return this.type;
    }

    public void setType(CommandArgType type) {
        this.type = type;
    }

    public List<Platform> getSupportedPlatforms() {
        return this.supportedPlatforms;
    }

    public void setSupportedPlatforms(List<Platform> supportedPlatforms) {
        this.supportedPlatforms = supportedPlatforms;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setValueExpected(boolean isValueExpeted) {
        this.isValueExpected = isValueExpeted;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void setDeprecated(boolean isDepricated) {
        this.isDeprecated = isDepricated;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public String getDeprecatedBy() {
        return this.deprecatedBy;
    }

    public void setDeprecatedBy(String deprecatedBy) {
        this.deprecatedBy = deprecatedBy;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public List<String> getSkipMandatoryCheckOnValue() {
        return this.skipMandatoryCheckOnValue;
    }

    public void setSkipMandatoryCheckOnValue(List<String> skipMandatoryCheckOnValue) {
        this.skipMandatoryCheckOnValue = skipMandatoryCheckOnValue;
    }

    public boolean isAllowMultipleOccurences() {
        return this.allowMultipleOccurences;
    }

    public void setAllowMultipleOccurences(boolean allowMultipleOccurences) {
        this.allowMultipleOccurences = allowMultipleOccurences;
    }

    public List<String> getMultipleValueList() {
        return this.multipleValueList;
    }

    public void setAliasNames(List<String> alias) {
        this.aliasNames = alias;
    }

    public List<String> getAliasNames() {
        return this.aliasNames;
    }

    public static enum Platform {
        ALL(-10),
        UNIX(-1),
        WINDOWS(-3),
        LINUX(46),
        LINUX_AMD64(226),
        LINUX_S390(211),
        LINUX_PPC(227),
        LINUX_LOP(249),
        HP_IA64(197),
        MACOSX(421),
        LINUX_IA64(110),
        LINUX_ITANIUM(214),
        WINDOWS_NT(912),
        WINDOWS_64(208),
        WINDOWS_AMD64(233),
        WINDOWS_95(615),
        WINDOWS_98(50),
        SOLARIS(453),
        SOLARIS_SPARC64(23),
        DEC_ALPHA_NT(601),
        SOLARIS_INTEL(173),
        SIEMENS_NIXDORF(467),
        SIEMENS_PYRAMID(295),
        DIGITAL_UNIX(87),
        AIX(610),
        AIX_PPC64(212),
        SEQUENT(198),
        UNIXWARE(918),
        DEC_ALPHA_VMS(913),
        DATA_GENERAL(162),
        HP_UX(2),
        HP_UX64(59),
        Z_OS(30),
        NETWARE_411(21),
        NETWARE_500(10021),
        NEC_UX_4800(111),
        HITACHI(90),
        SGI(168),
        NCOS(888);

        private int platformId;

        private Platform(int id) {
            this.platformId = id;
        }

        private int getPlatformId() {
            return this.platformId;
        }

        public static Platform getPlatform(int platformId) {
            for (Platform type : Platform.values()) {
                if (type.getPlatformId() != platformId) continue;
                return type;
            }
            return null;
        }
    }
}

