/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.cli.CommandLineArgErrorCode;
import oracle.install.commons.base.util.cli.CommandLineArgHelper;
import oracle.install.commons.base.util.cli.CommandLineArgValidator;
import oracle.install.commons.base.util.cli.CommandLineArgument;
import oracle.install.commons.base.util.cli.CommandLineArguments;
import oracle.install.commons.base.util.cli.MutualExclusiveArgsGroup;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.exception.ErrorInfo;

public class CommandLineArgValidatorImpl
implements CommandLineArgValidator {
    private static final Logger logger = Logger.getLogger(CommandLineArgValidatorImpl.class.getName());

    @Override
    public boolean validate(CommandLineArguments arguments) throws IllegalArgumentException, ApplicationException {
        try {
            if (arguments != null && arguments.getPassedArgs() != null) {
                for (CommandLineArgument argument : arguments.getPassedArgs().values()) {
                    if (argument.isValueExpected() && (argument.getValue() == null || argument.getValue().length() == 0)) {
                        ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.VALUE_EXPECTED_ERROR, CommandLineArguments.getArgumentStartCharacters().get(0) + argument.getName());
                        throw new IllegalArgumentException(errorInfo.getMessage());
                    }
                    this.validateForSupportedPlatform(argument);
                    this.validateContextSensitiveArguments(arguments, argument);
                    this.validateForMutualExclusives(argument, arguments);
                    if (!Boolean.getBoolean("application.commandline.validateForMandatoryDependentArgs")) continue;
                    this.validateForMandatoryDependents(argument, arguments);
                }
                Map<String, String> unsupportedPassedArgs = arguments.getUnsupportedPassedArgs();
                CommandLineArgValidator validationDelegator = this.getCommandListArgValidationDelegator();
                if (validationDelegator != null) {
                    validationDelegator.validate(arguments);
                } else if (unsupportedPassedArgs != null && unsupportedPassedArgs.size() > 0 && !Boolean.getBoolean("application.commandline.suppressUnsupportedArgEception")) {
                    ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.UNSUPPORTED_ARGUMENT_PASSED_ERROR, unsupportedPassedArgs.keySet());
                    throw new IllegalArgumentException(errorInfo.getMessage());
                }
            }
        }
        catch (IllegalArgumentException e) {
            if (Boolean.getBoolean("application.commandline.ignoreCommandLineArgEception")) {
                logger.log(Level.SEVERE, e.getMessage());
            }
            throw e;
        }
        catch (ApplicationException e) {
            if (Boolean.getBoolean("application.commandline.ignoreCommandLineArgEception")) {
                logger.log(Level.SEVERE, e.getMessage());
            }
            throw e;
        }
        return true;
    }

    public void validateForSupportedPlatform(CommandLineArgument argument) {
        List<CommandLineArgument.Platform> supportedPlatforms = argument.getSupportedPlatforms();
        if (supportedPlatforms == null || supportedPlatforms.size() == 0 || supportedPlatforms.contains((Object)CommandLineArgument.Platform.ALL)) {
            return;
        }
        if (supportedPlatforms.contains((Object)CommandLineArgument.Platform.UNIX) && !PlatformInfo.getInstance().isWindows()) {
            return;
        }
        if (supportedPlatforms.contains((Object)CommandLineArgument.Platform.WINDOWS) && PlatformInfo.getInstance().isWindows()) {
            return;
        }
        CommandLineArgument.Platform platform = this.getMachinePlatform();
        if (supportedPlatforms.contains((Object)platform)) {
            return;
        }
        ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.CMDLINE_ARG_NOT_SUPPORTED_ON_THIS_PLAT_ERROR, CommandLineArguments.getArgumentStartCharacters().get(0) + argument.getName());
        throw new IllegalArgumentException(errorInfo.getMessage());
    }

    private void validateContextSensitiveArguments(CommandLineArguments arguments, CommandLineArgument argument) {
        if (!arguments.isArgContextMatched(argument)) {
            ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.ARGUMENT_NOT_SUPPORTED_IN_CURRENT_CONTEXT, CommandLineArguments.getArgumentStartCharacters().get(0) + argument.getName(), arguments.getCurrentContextId() == null ? "" : arguments.getCurrentContextId());
            throw new IllegalArgumentException(errorInfo.getMessage());
        }
    }

    public void validateForMutualExclusives(CommandLineArgument argument, CommandLineArguments arguments) {
        String mutualExclusiveArgsGroupID = argument.getMutualExclusivesGroupId();
        Map<String, MutualExclusiveArgsGroup> mutualExclusiveGroups = arguments.getMutualExclusiveArgsGroups();
        if (mutualExclusiveGroups != null && mutualExclusiveArgsGroupID != null && mutualExclusiveGroups.get(mutualExclusiveArgsGroupID) != null) {
            List<String> mutualExclusiveArgsList = mutualExclusiveGroups.get(mutualExclusiveArgsGroupID).getArgsList();
            Set<String> keySet = arguments.getPassedArgs().keySet();
            for (String mutualExclusiveArg : keySet) {
                if (mutualExclusiveArg.equals(argument.getName()) || !mutualExclusiveArgsList.contains(mutualExclusiveArg)) continue;
                ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.MUTUAL_EXCLUSIVE_ARGUMENTS_PASSED_ERROR, CommandLineArguments.getArgumentStartCharacters().get(0) + argument.getName(), CommandLineArguments.getArgumentStartCharacters().get(0) + mutualExclusiveArg);
                throw new IllegalArgumentException(errorInfo.getMessage());
            }
        }
    }

    public void validateForMandatoryDependents(CommandLineArgument argument, CommandLineArguments arguments) throws IllegalArgumentException {
        List<String> mandatoryDependents = argument.getMandatoryDependentArgs();
        List<String> skipMandatoryCheckOnValue = argument.getSkipMandatoryCheckOnValue();
        Map<String, CommandLineArgument> passedArgs = arguments.getPassedArgs();
        if (mandatoryDependents != null && passedArgs != null) {
            String argValue;
            if (skipMandatoryCheckOnValue != null && !skipMandatoryCheckOnValue.isEmpty() && argument.isValueExpected() && (argValue = argument.getValue()) != null && !argValue.isEmpty() && StringUtils.containsIgnoreCase(skipMandatoryCheckOnValue, argValue)) {
                return;
            }
            Set<String> passedArgsSet = passedArgs.keySet();
            mandatoryDependents = CommandLineArgHelper.replaceArgPlaceHolders(mandatoryDependents, arguments);
            for (String dependent : mandatoryDependents) {
                Map<String, List<String>> groupedMandatoryDependents;
                logger.log(Level.FINEST, "Mandatory Dependent::" + dependent);
                if (dependent.contains("|")) {
                    ErrorInfo errorInfo;
                    String[] dependentAlternativeArgs = dependent.split("\\|");
                    groupedMandatoryDependents = this.getGroupedMandatoryDependents(Arrays.asList(dependentAlternativeArgs), arguments);
                    if (!groupedMandatoryDependents.isEmpty()) {
                        if (this.isTheMandatoryArgOrCompleteGroupPassed(Arrays.asList(dependentAlternativeArgs), groupedMandatoryDependents, arguments)) continue;
                        errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.MANDATORY_DEPENDENT_ARGUMENTS_NOT_PASSED_ERROR, CommandLineArguments.getArgumentStartCharacters().get(0) + argument.getName());
                        throw new IllegalArgumentException(errorInfo.getMessage());
                    }
                    if (this.isAtleastOneDependentArgPassed(Arrays.asList(dependentAlternativeArgs), arguments)) continue;
                    errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.MANDATORY_DEPENDENT_ARGUMENTS_NOT_PASSED_ERROR, CommandLineArguments.getArgumentStartCharacters().get(0) + argument.getName());
                    throw new IllegalArgumentException(errorInfo.getMessage());
                }
                ArrayList<CommandLineArgument> dependentArgumentList = new ArrayList<CommandLineArgument>();
                groupedMandatoryDependents = this.getGroupedMandatoryDependents(dependent, arguments);
                if (groupedMandatoryDependents != null && !groupedMandatoryDependents.isEmpty()) {
                    for (String keyset : groupedMandatoryDependents.keySet()) {
                        for (String degrouppedDependents : groupedMandatoryDependents.get(keyset)) {
                            dependentArgumentList.add(arguments.getSupportedArg(degrouppedDependents));
                        }
                    }
                } else {
                    dependentArgumentList.add(arguments.getSupportedArg(dependent));
                }
                for (CommandLineArgument dependentArgument : dependentArgumentList) {
                    if (dependentArgument == null || !arguments.isArgContextMatched(dependentArgument) || passedArgsSet != null && passedArgsSet.contains(dependentArgument.getName())) continue;
                    ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.MANDATORY_DEPENDENT_ARGUMENTS_NOT_PASSED_ERROR, CommandLineArguments.getArgumentStartCharacters().get(0) + argument.getName());
                    throw new IllegalArgumentException(errorInfo.getMessage());
                }
            }
        }
    }

    public boolean isAtleastOneDependentArgPassed(List<String> dependents, CommandLineArguments arguments) {
        Map<String, CommandLineArgument> passedArgs = arguments.getPassedArgs();
        boolean contextDependentPresent = false;
        if (passedArgs != null) {
            Set<String> passedArgsSet = passedArgs.keySet();
            for (String dependent : dependents) {
                CommandLineArgument dependentArgument = arguments.getSupportedArg(dependent);
                if (dependentArgument == null || !arguments.isArgContextMatched(dependentArgument)) continue;
                contextDependentPresent = true;
                if (passedArgsSet == null || !passedArgsSet.contains(dependentArgument.getName())) continue;
                return true;
            }
        }
        if (contextDependentPresent) {
            logger.log(Level.FINEST, "None of the dependents are passed ");
            return false;
        }
        return true;
    }

    public CommandLineArgument.Platform getMachinePlatform() {
        return CommandLineArgument.Platform.getPlatform(PlatformInfo.getInstance().getCurrentPlatform());
    }

    private CommandLineArgValidator getCommandListArgValidationDelegator() {
        CommandLineArgValidator validator = null;
        String delegator = System.getProperty("application.commandline.cmdLineArgValidationDeligator");
        if (delegator != null) {
            try {
                Class<?> clazz = Class.forName(delegator);
                validator = (CommandLineArgValidator)clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "unable to create command line validation delegator object for :" + delegator);
            }
        }
        return validator;
    }

    private Map<String, List<String>> getGroupedMandatoryDependents(List<String> dependentList, CommandLineArguments arguments) {
        Map<String, List<String>> mandatoryDependentGroups = arguments.getMandatoryDependentArgsGroups();
        HashMap<String, List<String>> groupedArgs = new HashMap<String, List<String>>();
        if (dependentList != null && !dependentList.isEmpty() && mandatoryDependentGroups != null && !mandatoryDependentGroups.isEmpty()) {
            for (String dependent : dependentList) {
                if (!mandatoryDependentGroups.containsKey(dependent)) continue;
                groupedArgs.put(dependent, mandatoryDependentGroups.get(dependent));
            }
        }
        return groupedArgs;
    }

    private Map<String, List<String>> getGroupedMandatoryDependents(String dependentString, CommandLineArguments arguments) {
        ArrayList<String> dependentList = new ArrayList<String>();
        dependentList.add(dependentString);
        return this.getGroupedMandatoryDependents(dependentList, arguments);
    }

    private boolean isTheMandatoryArgOrCompleteGroupPassed(List<String> dependentList, Map<String, List<String>> groupedMandatoryDependents, CommandLineArguments arguments) {
        boolean isTheArgOrCompleteGroupPassed = false;
        for (String dependent : dependentList) {
            if (groupedMandatoryDependents.containsKey(dependent)) {
                boolean isCompleteMandatoryGroupPassed = true;
                for (String degrouppedDependent : groupedMandatoryDependents.get(dependent)) {
                    if (this.isSupportedArgPassed(arguments, degrouppedDependent)) continue;
                    isCompleteMandatoryGroupPassed &= false;
                    break;
                }
                isTheArgOrCompleteGroupPassed |= isCompleteMandatoryGroupPassed;
                continue;
            }
            isTheArgOrCompleteGroupPassed |= this.isSupportedArgPassed(arguments, dependent);
        }
        return isTheArgOrCompleteGroupPassed;
    }

    private boolean isSupportedArgPassed(CommandLineArguments arguments, String arg) {
        CommandLineArgument argument;
        Set<String> passedArgsSet;
        Map<String, CommandLineArgument> passedArgs;
        boolean isArgPassed = true;
        if (!(arguments == null || arg == null || arg.isEmpty() || (passedArgs = arguments.getPassedArgs()) == null || passedArgs.isEmpty() || (passedArgsSet = passedArgs.keySet()) == null || passedArgsSet.isEmpty() || (argument = arguments.getSupportedArg(arg)) == null || !arguments.isArgContextMatched(argument) || passedArgsSet.contains(argument.getName()))) {
            isArgPassed = false;
        }
        return isArgPassed;
    }
}

