/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.cli;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.cli.CommandArgType;
import oracle.install.commons.base.util.cli.CommandLineArgConstants;
import oracle.install.commons.base.util.cli.CommandLineArgHelpConstructor;
import oracle.install.commons.base.util.cli.CommandLineArgHelper;
import oracle.install.commons.base.util.cli.CommandLineArgument;
import oracle.install.commons.base.util.cli.CommandLineArguments;
import oracle.install.commons.base.util.cli.MutualExclusiveArgsGroup;

public class CommandLineArgHelpConstructorImpl
implements CommandLineArgHelpConstructor {
    private static final String PIPE_DELIMITED_OPS_PLACE_HOLDER = "{pipeDelimitedOpsPlaceHolder}";
    private static final Logger logger = Logger.getLogger(CommandLineArgHelpConstructorImpl.class.getName());
    private CommandLineArgHelpConstructor delegator = this.getCommandListArgHelpConstructionDelegator();
    private String helpIndentor = System.getProperty("application.commandline.helpTextIndentionString", "\t");

    @Override
    public void showHelp(CommandLineArguments arguments, List<String> passedArgs) {
        if (arguments != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (passedArgs != null) {
                if (null != arguments.getCurrentContextId() && !arguments.getAvailableContextIds().contains(arguments.getCurrentContextId())) {
                    stringBuilder.append(arguments.getCurrentContextId() + " is not a valid context Id. General help is as below:").append("\n");
                    arguments.setCurrentContextId(null);
                }
                if (passedArgs.contains(CommandLineArguments.getArgumentStartCharacters().get(0) + "showCompleteHelp") || Boolean.getBoolean("application.commandline.showCompleteHelpByDefault")) {
                    stringBuilder.append(this.getToolHeader(arguments));
                    if (arguments.getFlagArgs().size() > 0) {
                        stringBuilder.append("\n");
                        stringBuilder.append(this.getFlagsHelpWithHeader(arguments));
                    }
                    if (arguments.getCommandArgs().size() > 0) {
                        stringBuilder.append("\n");
                        stringBuilder.append(this.getCommandHelpWithHeader(arguments, true));
                    } else if (arguments.getOptionArgs().size() > 0) {
                        stringBuilder.append("\n");
                        stringBuilder.append(this.getOptionsHelpWithHeader(arguments));
                    }
                    stringBuilder.append("\n");
                    stringBuilder.append(this.getExampleHelp(arguments));
                } else {
                    boolean commandMatchFound = false;
                    for (String passedArg : passedArgs) {
                        String cmdArg = this.getCommandArg(arguments, passedArg.substring(1));
                        if (null == cmdArg) continue;
                        stringBuilder.append(this.getCommandHelp(arguments, cmdArg));
                        commandMatchFound = true;
                    }
                    if (!commandMatchFound) {
                        stringBuilder.append(this.getTopLevelHelp(arguments));
                    }
                }
            } else {
                stringBuilder.append(this.getTopLevelHelp(arguments));
            }
            this.printHelp(stringBuilder.toString());
        }
    }

    private String getCommandArg(CommandLineArguments arguments, String passedArg) {
        String arg = null;
        if (arguments.getIgnoreCase()) {
            for (String cmdArg : arguments.getCommandArgs()) {
                if (!cmdArg.equalsIgnoreCase(passedArg)) continue;
                arg = cmdArg;
                break;
            }
        } else {
            arg = arguments.getCommandArgs().contains(passedArg) ? passedArg : null;
        }
        return arg;
    }

    public String getTopLevelHelp(CommandLineArguments arguments) {
        StringBuilder stringBuilder = new StringBuilder().append(this.getToolHeader(arguments));
        if (arguments.getFlagArgs().size() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(this.getFlagsHelpWithHeader(arguments));
        }
        if (arguments.getCommandArgs().size() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(this.getCommandHelpWithHeader(arguments, false));
        } else if (arguments.getOptionArgs().size() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(this.getOptionsHelpWithHeader(arguments));
        }
        stringBuilder.append("\n");
        stringBuilder.append(this.getExampleHelp(arguments));
        return stringBuilder.toString();
    }

    public String getToolHeader(CommandLineArguments arguments) {
        String toolHelp = arguments.getResourceBundle().getString("application.commandline.toolhelp.header", "", new Object[0]);
        if (toolHelp == null || toolHelp.length() == 0) {
            toolHelp = "Usage:  " + arguments.getToolName();
            if (arguments.getFlagArgs() != null && arguments.getFlagArgs().size() > 0) {
                toolHelp = toolHelp + " [<flag>]";
            }
            boolean commandArgsPresent = false;
            if (arguments.getCommandArgs() != null && arguments.getCommandArgs().size() > 0) {
                toolHelp = toolHelp + " [<command>";
                commandArgsPresent = true;
            }
            if (arguments.getOptionArgs() != null && arguments.getOptionArgs().size() > 0) {
                toolHelp = commandArgsPresent ? toolHelp + " <option>]" : toolHelp + " [<option>]";
            } else if (commandArgsPresent) {
                toolHelp = toolHelp + "]";
            }
        }
        return toolHelp;
    }

    public String getFlagsHelpWithHeader(CommandLineArguments arguments) {
        StringBuilder stringBuilder = new StringBuilder();
        String flagsHelp = this.getFlagsHelp(arguments);
        if (flagsHelp != null && flagsHelp.length() > 0) {
            String flagsHelpHeader = arguments.getResourceBundle().getString("application.commandline.flagshelp.header", "Following are the possible flags: \n", new Object[0]);
            stringBuilder.append(flagsHelpHeader);
            stringBuilder.append(flagsHelp);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getFlagsHelp(CommandLineArguments arguments) {
        StringBuilder stringBuilder = new StringBuilder();
        if (arguments.getFlagArgs().size() > 0) {
            ArrayList<String> processedFlags = new ArrayList<String>();
            for (String flag : arguments.getFlagArgs()) {
                CommandLineArgument argument = arguments.getSupportedArg(flag);
                MutualExclusiveArgsGroup mutualExclusiveArgsGroup = arguments.getMutualExclusiveArgsGroups().get(argument.getMutualExclusivesGroupId());
                if (null != mutualExclusiveArgsGroup && null != mutualExclusiveArgsGroup.getArgsList()) {
                    ArrayList<String> mutuallyExclusiveArgsList = new ArrayList<String>(mutualExclusiveArgsGroup.getArgsList());
                    ArrayList<String> argsToExclude = new ArrayList<String>();
                    for (String mutualExclusiveArg : mutuallyExclusiveArgsList) {
                        CommandLineArgument mutualExclArg = arguments.getSupportedArg(mutualExclusiveArg);
                        if (mutualExclArg != null && (mutualExclArg.isHidden() || mutualExclArg.isDeprecated())) {
                            argsToExclude.add(mutualExclArg.getName());
                            continue;
                        }
                        if (!Boolean.getBoolean("application.commandline.hideMutuallyExclusiveArgsNotMatchingContextOrPlatform") || mutualExclArg == null) continue;
                        if (!arguments.isArgContextMatched(mutualExclArg)) {
                            argsToExclude.add(mutualExclArg.getName());
                            continue;
                        }
                        if (this.isPlatformSupported(mutualExclArg)) continue;
                        argsToExclude.add(mutualExclArg.getName());
                    }
                    mutuallyExclusiveArgsList.removeAll(argsToExclude);
                    if (mutuallyExclusiveArgsList.size() > 1) {
                        String mutuallyExclusiveStr = ((Object)mutuallyExclusiveArgsList).toString().replace("[", CommandLineArguments.getArgumentStartCharacters().get(0)).replace(", ", " | " + CommandLineArguments.getArgumentStartCharacters().get(0)).replace("]", "");
                        if (!stringBuilder.toString().contains(mutuallyExclusiveStr)) {
                            stringBuilder.append(this.helpIndentor);
                            stringBuilder.append(mutuallyExclusiveStr);
                            stringBuilder.append("\n");
                        }
                        for (String mutualExclusiveArg : mutuallyExclusiveArgsList) {
                            CommandLineArgument mutualExclArg = arguments.getSupportedArg(mutualExclusiveArg);
                            if (mutualExclArg == null || processedFlags.contains(mutualExclArg.getName()) || !mutualExclArg.isTopLevel() || mutualExclArg.isHidden() || mutualExclArg.isDeprecated()) continue;
                            this.buildArgHelp(mutualExclArg.getName(), arguments, stringBuilder, this.helpIndentor, new ArrayList<String>(), EnumSet.of(CommandArgType.FLAG), "", "", true);
                            processedFlags.add(mutualExclArg.getName());
                        }
                    }
                }
                if (argument != null && !processedFlags.contains(argument.getName()) && argument.isTopLevel() && !argument.isHidden() && !argument.isDeprecated()) {
                    this.buildArgHelp(argument.getName(), arguments, stringBuilder, this.helpIndentor, new ArrayList<String>(), EnumSet.of(CommandArgType.FLAG), "", "", true);
                    processedFlags.add(argument.getName());
                }
                if (!"help".equalsIgnoreCase(flag) || !arguments.isDisplayContextIds() || arguments.getAvailableContextIds() == null || arguments.getAvailableContextIds().size() <= 0) continue;
                stringBuilder.append(this.helpIndentor).append(this.helpIndentor).append(CommandLineArguments.getArgumentStartCharacters().get(0)).append("contextId").append(" ").append(arguments.getAvailableContextIds().toString().replace("[", "<").replace("]", ">").replaceAll(", ", " | ")).append("\n");
            }
        }
        if (this.delegator != null) {
            stringBuilder.append(this.delegator.getFlagsHelp(arguments));
        }
        return stringBuilder.toString();
    }

    public boolean isPlatformSupported(CommandLineArgument argument) {
        List<CommandLineArgument.Platform> supportedPlatforms = argument.getSupportedPlatforms();
        if (supportedPlatforms == null || supportedPlatforms.size() == 0 || supportedPlatforms.contains((Object)CommandLineArgument.Platform.ALL)) {
            return true;
        }
        if (supportedPlatforms.contains((Object)CommandLineArgument.Platform.UNIX) && !PlatformInfo.getInstance().isWindows()) {
            return true;
        }
        if (supportedPlatforms.contains((Object)CommandLineArgument.Platform.WINDOWS) && PlatformInfo.getInstance().isWindows()) {
            return true;
        }
        CommandLineArgument.Platform platform = CommandLineArgument.Platform.getPlatform(PlatformInfo.getInstance().getCurrentPlatform());
        return supportedPlatforms.contains((Object)platform);
    }

    public String getCommandHelpWithHeader(CommandLineArguments arguments, boolean showCompleteHelp) {
        StringBuilder stringBuilder = new StringBuilder();
        String commandsHelp = this.getCommandsHelp(arguments, showCompleteHelp);
        if (commandsHelp != null && commandsHelp.length() > 0) {
            String commandsHelpHeader = arguments.getResourceBundle().getString("application.commandline.commandhelp.header", "Following are the possible commands: \n", new Object[0]);
            stringBuilder.append(commandsHelpHeader);
            stringBuilder.append(commandsHelp);
        }
        return stringBuilder.toString();
    }

    public String getOptionsHelpWithHeader(CommandLineArguments arguments) {
        StringBuilder stringBuilder = new StringBuilder();
        String optionsHelp = this.getOptionsHelp(arguments);
        if (optionsHelp != null && optionsHelp.length() > 0) {
            String optionsHelpHeader = arguments.getResourceBundle().getString("application.commandline.commandhelp.header", "Following are the possible options: \n", new Object[0]);
            stringBuilder.append(optionsHelpHeader);
            stringBuilder.append(optionsHelp);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCommandsHelp(CommandLineArguments arguments, boolean showCompleteHelp) {
        StringBuilder stringBuilder = new StringBuilder();
        if (arguments.getCommandArgs().size() > 0) {
            ArrayList<String> processedArgs = new ArrayList<String>();
            for (String command : arguments.getCommandArgs()) {
                CommandLineArgument argument = arguments.getSupportedArg(command);
                if (argument == null || !argument.isTopLevel() || argument.isHidden() || argument.isDeprecated()) continue;
                this.buildArgHelp(command, arguments, stringBuilder, this.helpIndentor, processedArgs, showCompleteHelp ? EnumSet.of(CommandArgType.COMMAND, CommandArgType.OPTION) : EnumSet.of(CommandArgType.COMMAND), "", "", showCompleteHelp);
                if (!showCompleteHelp) continue;
                stringBuilder.append("\n");
            }
        }
        if (this.delegator != null) {
            stringBuilder.append(this.delegator.getCommandsHelp(arguments, showCompleteHelp));
        }
        return stringBuilder.toString();
    }

    public String getOptionsHelp(CommandLineArguments arguments) {
        StringBuilder stringBuilder = new StringBuilder();
        if (arguments.getOptionArgs().size() > 0) {
            ArrayList<String> processedArgs = new ArrayList<String>();
            for (String option : arguments.getOptionArgs()) {
                CommandLineArgument argument = arguments.getSupportedArg(option);
                if (argument == null || !argument.isTopLevel() || argument.isHidden() || argument.isDeprecated()) continue;
                String startOptionalStr = "";
                String endOptionalStr = "";
                if (argument.isOptional()) {
                    startOptionalStr = "[";
                    endOptionalStr = "]";
                }
                this.buildArgHelp(option, arguments, stringBuilder, this.helpIndentor, processedArgs, EnumSet.of(CommandArgType.OPTION), startOptionalStr, endOptionalStr, true);
            }
        }
        if (this.delegator != null) {
            stringBuilder.append(this.delegator.getCommandsHelp(arguments, false));
        }
        return stringBuilder.toString();
    }

    public String getCommandHelp(CommandLineArguments arguments, String commandArg) {
        StringBuilder stringBuilder = new StringBuilder();
        if (commandArg != null && arguments.getSupportedArg(commandArg) != null) {
            this.buildArgHelp(commandArg, arguments, stringBuilder, this.helpIndentor, new ArrayList<String>(), EnumSet.of(CommandArgType.COMMAND, CommandArgType.OPTION), "", "", true);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getExampleHelp(CommandLineArguments arguments) {
        String exampleHelp = arguments.getResourceBundle().getString("application.commandline.tool.example.help", "", new Object[0]);
        return exampleHelp;
    }

    private void buildArgHelp(String arg, CommandLineArguments arguments, StringBuilder stringBuilder, String formatingString, List<String> processedFlags, EnumSet<CommandArgType> type, String startOptionalStr, String endOptionalStr, boolean showDependents) {
        CommandLineArgument argument = arguments.getSupportedArg(arg);
        if (arg != null && argument != null && !argument.isHidden() && !argument.isDeprecated() && !processedFlags.contains(arg) && type.contains((Object)argument.getType())) {
            String argHelp;
            argument = arguments.getSupportedArg(arg);
            if (!arguments.isArgContextMatched(argument)) {
                return;
            }
            String resourceId = argument.getResourceId();
            if (resourceId == null || resourceId.length() == 0) {
                resourceId = "application.commandline.cmdhelp." + arg;
                if (null != arguments.getCurrentContextId()) {
                    resourceId = resourceId + "." + arguments.getCurrentContextId();
                }
            }
            if ((argHelp = arguments.getResourceBundle().getString(resourceId, "", new Object[0])).isEmpty()) {
                resourceId = "application.commandline.cmdhelp." + arg;
                argHelp = arguments.getResourceBundle().getString(resourceId, argument.isValueExpected() ? "<value>" : "", new Object[0]);
            }
            stringBuilder.append(formatingString).append(startOptionalStr).append(CommandLineArguments.getArgumentStartCharacters().get(0)).append(arg).append(" ").append(argHelp + endOptionalStr);
            processedFlags.add(arg);
            boolean newLineAdded = false;
            if (showDependents) {
                List<String> optionalDependents;
                List<String> mandatoryDependents = arguments.getSupportedArg(arg).getMandatoryDependentArgs();
                if (mandatoryDependents != null && mandatoryDependents.size() > 0) {
                    stringBuilder.append("\n");
                    newLineAdded = true;
                    this.buildDependentArgsHelp(mandatoryDependents, arguments, stringBuilder, formatingString + this.helpIndentor, processedFlags, type, "", "");
                }
                if ((optionalDependents = arguments.getSupportedArg(arg).getOptionalDependentArgs()) != null && optionalDependents.size() > 0) {
                    if (!newLineAdded) {
                        stringBuilder.append("\n");
                        newLineAdded = true;
                    }
                    this.buildDependentArgsHelp(optionalDependents, arguments, stringBuilder, formatingString + this.helpIndentor, processedFlags, type, "[", "]");
                }
            }
            if (!newLineAdded) {
                stringBuilder.append("\n");
            }
            processedFlags.remove(arg);
        }
    }

    private void buildDependentArgsHelp(List<String> dependents, CommandLineArguments arguments, StringBuilder stringBuilder, String formatingString, List<String> processedFlags, EnumSet<CommandArgType> typeSet, String startOptionalStr, String endOptionalStr) {
        for (String dependent : dependents) {
            if (dependent.contains("|")) {
                dependent = this.replaceDeprecatedArg(dependent, arguments);
                stringBuilder.append(PIPE_DELIMITED_OPS_PLACE_HOLDER);
                String[] dependentAlternativeArgs = dependent.split("\\|");
                ArrayList<String> pipedSupportedArgs = new ArrayList<String>();
                for (String dependentAlternativeArg : dependentAlternativeArgs) {
                    List<String> grpMandDependents;
                    CommandLineArgument argument = arguments.getSupportedArg(dependentAlternativeArg);
                    if (argument != null) {
                        if (argument.isHidden() || argument.isDeprecated() || !arguments.isArgContextMatched(argument)) continue;
                        if (typeSet.contains((Object)argument.getType())) {
                            this.buildArgHelp(dependentAlternativeArg, arguments, stringBuilder, formatingString, processedFlags, typeSet, startOptionalStr, endOptionalStr, true);
                        } else if (argument.getType() != CommandArgType.FLAG) {
                            stringBuilder.append(formatingString + startOptionalStr + CommandLineArguments.getArgumentStartCharacters().get(0) + dependentAlternativeArg + endOptionalStr + "\n");
                        }
                        pipedSupportedArgs.add(dependentAlternativeArg);
                        continue;
                    }
                    if (CommandLineArgConstants.ARS_PLACE_HOLDER_LIST.contains(dependentAlternativeArg)) {
                        pipedSupportedArgs.add(dependentAlternativeArg);
                        continue;
                    }
                    Map<String, List<String>> groupedMandatoryDependents = arguments.getMandatoryDependentArgsGroups();
                    if (groupedMandatoryDependents == null || groupedMandatoryDependents.isEmpty() || !groupedMandatoryDependents.containsKey(dependentAlternativeArg) || (grpMandDependents = groupedMandatoryDependents.get(dependentAlternativeArg)) == null || grpMandDependents.size() <= 0) continue;
                    StringBuffer argsInMandatoryGroup = new StringBuffer();
                    argsInMandatoryGroup.append("(");
                    for (String degrouppedDependents : grpMandDependents) {
                        CommandLineArgument arg = arguments.getSupportedArg(degrouppedDependents);
                        if (arg == null || arg.isHidden() || arg.isDeprecated()) continue;
                        if (typeSet.contains((Object)arg.getType())) {
                            this.buildArgHelp(arg.getName(), arguments, stringBuilder, formatingString, processedFlags, typeSet, startOptionalStr, endOptionalStr, true);
                        } else if (arg.getType() != CommandArgType.FLAG) {
                            stringBuilder.append(formatingString).append(startOptionalStr).append(CommandLineArguments.getArgumentStartCharacters().get(0)).append(arg.getName() + endOptionalStr);
                        }
                        argsInMandatoryGroup.append(CommandLineArguments.getArgumentStartCharacters().get(0) + degrouppedDependents + ",");
                    }
                    String allArgsInMandatoryGroup = argsInMandatoryGroup.substring(0, argsInMandatoryGroup.length() - 1).concat(")");
                    pipedSupportedArgs.add(allArgsInMandatoryGroup);
                }
                String mutuallyExclusiveStr = ((Object)pipedSupportedArgs).toString().replace("[", CommandLineArguments.getArgumentStartCharacters().get(0)).replace(", ", " | " + CommandLineArguments.getArgumentStartCharacters().get(0)).replace("]", "");
                mutuallyExclusiveStr = mutuallyExclusiveStr.replace(CommandLineArguments.getArgumentStartCharacters().get(0) + "(", "(");
                StringBuilder tempSB = new StringBuilder();
                tempSB.append(formatingString).append(startOptionalStr).append(mutuallyExclusiveStr + endOptionalStr).append("\n");
                int startIdx = stringBuilder.indexOf(PIPE_DELIMITED_OPS_PLACE_HOLDER);
                int endIdx = startIdx + PIPE_DELIMITED_OPS_PLACE_HOLDER.length();
                if (pipedSupportedArgs.size() > 1) {
                    stringBuilder.replace(startIdx, endIdx, tempSB.toString());
                    continue;
                }
                stringBuilder.replace(startIdx, endIdx, "");
                continue;
            }
            CommandLineArgument argument = arguments.getSupportedArg(dependent = this.replaceDeprecatedArg(dependent, arguments));
            if (argument != null) {
                if (argument.isHidden() || argument.isDeprecated()) continue;
                if (typeSet.contains((Object)arguments.getSupportedArg(dependent).getType())) {
                    this.buildArgHelp(dependent, arguments, stringBuilder, formatingString, processedFlags, typeSet, startOptionalStr, endOptionalStr, true);
                    continue;
                }
                if (argument.getType() == CommandArgType.FLAG) continue;
                stringBuilder.append(formatingString).append(startOptionalStr).append(CommandLineArguments.getArgumentStartCharacters().get(0)).append(dependent + endOptionalStr).append("\n");
                continue;
            }
            if (!CommandLineArgConstants.ARS_PLACE_HOLDER_LIST.contains(dependent)) continue;
            stringBuilder.append(formatingString).append(startOptionalStr).append(CommandLineArguments.getArgumentStartCharacters().get(0)).append(dependent + endOptionalStr).append("\n");
        }
    }

    private void printHelp(String helpContent) {
        System.out.println(helpContent);
    }

    private CommandLineArgHelpConstructor getCommandListArgHelpConstructionDelegator() {
        CommandLineArgHelpConstructor helpConstructionDeligator = null;
        String delegator = System.getProperty("application.commandline.cmdLineArgHelpConstructionDeligator");
        if (delegator != null && delegator.length() > 0) {
            try {
                Class<?> clazz = Class.forName(delegator);
                helpConstructionDeligator = (CommandLineArgHelpConstructor)clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "unable to create command line arg help construction delegator object for :" + delegator);
            }
        }
        return helpConstructionDeligator;
    }

    private String replaceDeprecatedArg(String arg, CommandLineArguments arguments) {
        if (arg != null && arg.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            if (arg.contains("|")) {
                String[] args = arg.split("\\|");
                if (args.length > 0) {
                    for (int i = 0; i < args.length; ++i) {
                        CommandLineArgument argument = arguments.getSupportedArg(args[i].trim());
                        if (argument != null) {
                            if (!arguments.isArgContextMatched(argument)) continue;
                            if (argument.isDeprecated()) {
                                stringBuilder.append(argument.getDeprecatedBy());
                            } else {
                                stringBuilder.append(args[i].trim());
                            }
                            stringBuilder.append("|");
                            continue;
                        }
                        if (CommandLineArgHelper.isCommandArgType(args[i].trim())) {
                            stringBuilder.append("<" + args[i] + ">");
                            stringBuilder.append("|");
                            continue;
                        }
                        stringBuilder.append(args[i].trim());
                        stringBuilder.append("|");
                    }
                    if (stringBuilder.indexOf("|") != -1) {
                        return stringBuilder.substring(0, stringBuilder.lastIndexOf("|"));
                    }
                }
            } else {
                CommandLineArgument argument = arguments.getSupportedArg(arg.trim());
                if (argument != null) {
                    if (argument.isDeprecated()) {
                        stringBuilder.append(argument.getDeprecatedBy().trim());
                    } else {
                        stringBuilder.append(arg.trim());
                    }
                } else if (CommandLineArgHelper.isCommandArgType(arg.trim())) {
                    stringBuilder.append("<" + arg + ">");
                } else {
                    stringBuilder.append(arg.trim());
                }
                return stringBuilder.toString();
            }
        }
        return arg;
    }
}

