/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.prereq.PrereqCheckerEvent;
import oracle.install.commons.base.prereq.PrereqCheckerException;
import oracle.install.commons.base.prereq.PrereqCheckerListener;
import oracle.install.commons.base.prereq.ui.PrereqProgressCard;
import oracle.install.commons.base.prereq.ui.PrereqResultCard;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobTreeTable;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.ProgressModelEvent;
import oracle.install.commons.util.progress.ProgressModelListener;
import oracle.install.commons.util.progress.Status;

public class PrereqCheckerPane
extends JPanel
implements PrereqCheckerListener {
    private static final Logger logger = Logger.getLogger(PrereqCheckerPane.class.getName());
    private PrereqProgressCard progressCard;
    private PrereqResultCard resultCard;
    private CardLayout cardLayout;
    private boolean failedChecksIgnored;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Resource resource;
    private ProgressModel progressModel;
    private ViewMode viewMode;

    public PrereqCheckerPane() {
        Application application = Application.getInstance();
        this.resource = application.getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");
        this.progressModel = new ProgressModel();
        this.progressModel.addProgressModelListener(new ProgressModelListener(){

            @Override
            public void update(ProgressModelEvent e) {
                block0 : switch ((ProgressModelEvent.Type)e.getType()) {
                    case JOB_STATUS_CHANGED: {
                        final Job job = e.getJob();
                        switch (job.getStatus()) {
                            case INPROGRESS: {
                                if (SwingUtilities.isEventDispatchThread()) {
                                    PrereqCheckerPane.this.progressCard.setStatus(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.lblCheckInProgress.text", "Checking {0}", job.getDescription()));
                                    break block0;
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        PrereqCheckerPane.this.progressCard.setStatus(PrereqCheckerPane.this.resource.getString("prereqCheckerPane.lblCheckInProgress.text", "Checking {0}", job.getDescription()));
                                    }
                                });
                            }
                        }
                    }
                }
            }
        });
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.progressCard = new PrereqProgressCard(this.progressModel);
        this.resultCard = new PrereqResultCard(this.progressModel);
        this.resultCard.addPropertyChangeListener("PrereqResultCard.btnRetry.clicked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrereqCheckerPane.this.doRetry(false);
            }
        });
        this.resultCard.addPropertyChangeListener("PrereqResultCard.btnFixupRetry.clicked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrereqCheckerPane.this.doFixupRetry();
            }
        });
        this.resultCard.addPropertyChangeListener("PrereqResultCard.failedChecks.ignored", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean failedChecksIgnored = (Boolean)evt.getNewValue();
                PrereqCheckerPane.this.setFailedChecksIgnored(failedChecksIgnored);
            }
        });
        this.resultCard.addPropertyChangeListener("PrereqResultCard.showResult", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PrereqCheckerPane.this.showResults();
            }
        });
        this.add((Component)this.progressCard, "progress");
        this.add((Component)this.resultCard, "result");
        this.setViewMode(ViewMode.PROGRESS_MODE);
        this.resultCard.createDetailsPane();
    }

    private void setViewMode(ViewMode viewMode) {
        if (this.viewMode == viewMode) {
            return;
        }
        this.viewMode = viewMode;
        switch (viewMode) {
            case PROGRESS_MODE: {
                this.cardLayout.show(this, "progress");
                break;
            }
            case RESULT_MODE: {
                this.cardLayout.show(this, "result");
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.resultCard.disposeDetailsDialog();
    }

    protected void doFixupRetry() {
        boolean retry = false;
        PrereqChecker prereqChecker = PrereqChecker.getInstance();
        try {
            prereqChecker.fix(prereqChecker.getFixableVerificationTasks());
            retry = true;
        }
        catch (PrereqCheckerException e) {
            if (e.getErrorCode() == PrereqCheckerErrorCode.FIXUP_ROUTINES_NOT_AVAILABLE && StandardDialog.promptConfirmation(null, this.resource.getString("prereqCheckerPane.noFixupAvailablePrompt.text", "An exception occurred while generating the fixup routine. Do you want to perform the checks again ?", new Object[0]))) {
                retry = true;
            }
        }
        catch (Exception e) {
            ExceptionManager.handle(e);
        }
        if (retry) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PrereqCheckerPane.this.doRetry(true);
                }
            });
        }
    }

    protected void doRetry(final boolean fixAndRetry) {
        this.showProgress(true);
        this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                System.setProperty("CVU_CHECK_AGAIN", "TRUE");
                PrereqChecker prereqChecker = PrereqChecker.getInstance();
                if (fixAndRetry) {
                    StatusMessages<ErrorMessage> errorMessages = prereqChecker.runFixupAndVerify();
                    if (errorMessages != null) {
                        StandardDialog.showErrors(PrereqCheckerPane.this, errorMessages);
                    }
                } else {
                    prereqChecker.verify();
                }
                return null;
            }
        });
    }

    @Override
    public void update(PrereqCheckerEvent e) {
        Application application = Application.getInstance();
        StatusControl statusControl = application.getStatusControl();
        PrereqCheckerEvent.Type type = (PrereqCheckerEvent.Type)e.getType();
        final CompositePrereqCheckerJob job = e.getJob();
        final PrereqChecker source = (PrereqChecker)e.getSource();
        switch (type) {
            case NODE_PREPARATION_STARTED: {
                statusControl.open();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String text = PrereqCheckerPane.this.resource.getString("prereqCheckerPane.nodePreparation.started", "Preparing to perform checks...", new Object[0]);
                        PrereqCheckerPane.this.progressCard.setStatus(text);
                    }
                });
                break;
            }
            case NODE_PREPARATION_FAILED: 
            case NODE_PREPARATION_FINISHED: {
                statusControl.close();
                break;
            }
            case TASKS_CHANGED: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String[] nodes = source.getNodes();
                        PrereqCheckerPane.this.resultCard.setNodes(nodes);
                        if (nodes != null && nodes.length > 1) {
                            PrereqCheckerPane.this.resultCard.setCbxNodesVisible(true);
                        } else {
                            PrereqCheckerPane.this.resultCard.setCbxNodesVisible(false);
                            if (nodes != null && nodes.length == 1 && !PlatformInfo.getInstance().getFullHostName().contains(nodes[0])) {
                                PrereqCheckerPane.this.resultCard.setCbxNodesVisible(true);
                            }
                        }
                        PrereqCheckerPane.this.resultCard.getVerificationTable().setJob(job);
                        PrereqCheckerPane.this.resultCard.removeFixableTab();
                    }
                });
                break;
            }
            case VERIFICATION_STARTED: {
                statusControl.open();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrereqCheckerPane.this.showProgress();
                        PrereqCheckerPane.this.resultCard.setIgnoreAllEnabled(true);
                        PrereqCheckerPane.this.resultCard.setIgnoreAllSelected(false);
                        PrereqCheckerPane.this.resultCard.hideDetails();
                    }
                });
                break;
            }
            case VERIFICATION_COMPLETED: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrereqCheckerPane.this.progressCard.setStatus("");
                        boolean success = job.getStatus() == Status.SUCCEEDED;
                        boolean enableFixup = false;
                        if (!success) {
                            PrereqCheckerPane.this.setViewMode(ViewMode.RESULT_MODE);
                            PrereqCheckerPane.this.resultCard.showFailedChecksOnly();
                            if (job instanceof CompositePrereqCheckerJob) {
                                CompositePrereqCheckerJob prereqJob = (CompositePrereqCheckerJob)job;
                                enableFixup = prereqJob.isFixable();
                            }
                        } else {
                            PrereqCheckerPane.this.setFailedChecksIgnored(false);
                        }
                        PrereqCheckerPane.this.resultCard.setFixupAvailable(enableFixup);
                        PrereqCheckerPane.this.resultCard.setFixupRetryEnabled(enableFixup);
                        PrereqCheckerPane.this.resultCard.updatePane(success);
                    }
                });
                statusControl.close();
                break;
            }
            case FIXUP_COMPLETED: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrereqCheckerPane.this.resultCard.setFixableTasks(PrereqChecker.getInstance().getFixableVerificationTasks());
                    }
                });
                statusControl.close();
            }
        }
    }

    public boolean isFailedChecksIgnored() {
        return this.failedChecksIgnored;
    }

    public void setFailedChecksIgnored(boolean failedChecksIgnored) {
        if (this.failedChecksIgnored != failedChecksIgnored) {
            boolean oldValue = this.failedChecksIgnored;
            this.failedChecksIgnored = failedChecksIgnored;
            super.firePropertyChange("PrereqCheckerPane.failedChecksIgnored", oldValue, failedChecksIgnored);
        }
    }

    public void showProgress(final boolean reset) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (reset) {
                this.progressCard.resetProgress(0);
            }
            this.setViewMode(ViewMode.PROGRESS_MODE);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PrereqCheckerPane.this.showProgress(reset);
                }
            });
        }
    }

    public void showProgress() {
        this.showProgress(false);
    }

    public void showResults() {
        JobTreeTable verificationTable = this.resultCard.getVerificationTable();
        verificationTable.setSelectedNode(this.resultCard.getFirstDeepestLeaf(verificationTable.getRoot()));
        this.setViewMode(ViewMode.RESULT_MODE);
    }

    public Component getDetailsPane() {
        return this.resultCard.getDetailsPane();
    }

    public void showFailedChecksOnly() {
        this.setViewMode(ViewMode.RESULT_MODE);
        this.resultCard.showFailedChecksOnly();
    }

    public void showAllChecks() {
        this.setViewMode(ViewMode.RESULT_MODE);
        this.resultCard.showAllChecks();
    }

    public void loadListeners() {
        this.resultCard.addListSelectionListener();
    }

    public void removeListeners() {
        this.resultCard.removeListSelectionListene();
    }

    static enum ViewMode {
        PROGRESS_MODE,
        RESULT_MODE;

    }
}

