/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.DefaultPrereqChecker;
import oracle.install.commons.base.prereq.FixupScriptExecutionJob;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.prereq.PrereqCheckerEvent;
import oracle.install.commons.base.prereq.PrereqCheckerException;
import oracle.install.commons.base.prereq.PrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqCheckerListener;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobHelper;
import oracle.install.commons.util.progress.Status;

public abstract class PrereqChecker {
    private static final Logger logger = Logger.getLogger(PrereqChecker.class.getName());
    private static PrereqChecker instance = null;
    private CompositePrereqCheckerJob verificationJob;
    private VerificationTask[] verificationTasks;
    private List<VerificationTask> fixableVerificationTasks;
    private String[] nodes;
    private boolean initialized;
    private EventSupport<PrereqCheckerEvent> eventSupport = new EventSupport();
    private FixupScriptExecutionJob fixupScriptExecJob;
    private boolean enableFixupExecution;
    private CompositePrereqCheckerJob fixupAndVerificationJob;

    public static PrereqChecker getInstance() {
        if (instance == null) {
            ProxyFactory proxyFactory = ProxyFactory.getInstance();
            instance = proxyFactory.createProxy(PrereqChecker.class, new DefaultPrereqChecker());
        }
        return instance;
    }

    protected PrereqChecker() {
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public void setNodes(String[] nodes) throws VerificationException {
        this.nodes = nodes;
        this.initialized = false;
        this.prepare(nodes);
    }

    public VerificationTask[] getVerificationTasks() {
        return this.verificationTasks;
    }

    public void setVerificationTasks(VerificationTask ... verificationTasks) {
        this.verificationTasks = verificationTasks;
        this.fixableVerificationTasks = null;
        CompositePrereqCheckerJob verificationJob = this.buildVerificationJob(this.verificationTasks);
        this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.TASKS_CHANGED, verificationJob));
    }

    public CompositePrereqCheckerJob getVerificationJob() {
        return this.verificationJob;
    }

    public final void prepare(String ... nodes) throws VerificationException {
        if (!this.initialized) {
            try {
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.NODE_PREPARATION_STARTED));
                this.prepareNodes(nodes);
                this.initialized = true;
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.NODE_PREPARATION_FINISHED));
            }
            catch (VerificationException e) {
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.NODE_PREPARATION_FAILED));
                logger.log(Level.WARNING, "Failed while enabling tracing. Error: ", e);
                throw e;
            }
        }
    }

    protected abstract void prepareNodes(String ... var1) throws VerificationException;

    public void verify() throws Exception {
        this.prepare(this.nodes);
        if (this.verificationTasks != null && this.verificationTasks.length > 0) {
            CompositePrereqCheckerJob verificationJob = this.getVerificationJob();
            try {
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.VERIFICATION_STARTED, verificationJob));
                this.verifyJobs(verificationJob);
                this.performPostVerifyOper();
            }
            finally {
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.VERIFICATION_COMPLETED, verificationJob));
            }
        }
    }

    protected void performPostVerifyOper() throws Exception {
    }

    private void verifyJobs(CompositePrereqCheckerJob compositePrereqCheckerJob) throws Exception {
        if (compositePrereqCheckerJob != null) {
            this.changeConvertedJobsToLeaf(this.getConvertedFailedJobs(compositePrereqCheckerJob));
            this.resetFailedJobsOnly(compositePrereqCheckerJob);
            this.calibrateWeightage(compositePrereqCheckerJob);
            List<Job> jobs = this.getJobsToExecute(compositePrereqCheckerJob);
            JobHelper.executeJobs(jobs.toArray(new Job[0]));
            this.propagateStatus(compositePrereqCheckerJob);
        }
    }

    private void propagateStatus(Job job) {
        if (job instanceof CompositeJob) {
            List<Job> jobs = ((CompositeJob)job).getJobs();
            for (Job j : jobs) {
                this.propagateStatus(j);
            }
        } else {
            Status status = job.getStatus();
            if (status != Status.PENDING) {
                job.setStatus(Status.PENDING);
                job.setStatus(status);
            }
        }
    }

    private List<Job> getConvertedFailedJobs(Job job) {
        ArrayList<Job> convertedJobs = new ArrayList<Job>();
        if (job instanceof CompositePrereqCheckerJob) {
            CompositePrereqCheckerJob compositeJob = (CompositePrereqCheckerJob)job;
            boolean isConverted = compositeJob.isConverted();
            if (isConverted && compositeJob.getStatus() != Status.SUCCEEDED) {
                convertedJobs.add(job);
            } else {
                List<Job> jobs = compositeJob.getJobs();
                for (Job j : jobs) {
                    convertedJobs.addAll(this.getConvertedFailedJobs(j));
                }
            }
        }
        return convertedJobs;
    }

    private void changeConvertedJobsToLeaf(List<Job> convertedJobs) {
        if (convertedJobs != null && !convertedJobs.isEmpty()) {
            for (Job convertedJob : convertedJobs) {
                CompositeJob parent = convertedJob.getParent();
                if (!(convertedJob instanceof CompositePrereqCheckerJob)) continue;
                CompositePrereqCheckerJob compositeJob = (CompositePrereqCheckerJob)convertedJob;
                VerificationTask vt = compositeJob.getVerificationTask();
                parent.remove(convertedJob);
                PrereqCheckerJob leafJob = new PrereqCheckerJob(vt);
                parent.add(leafJob);
            }
        }
    }

    private List<Job> getJobsToExecute(Job job) {
        ArrayList<Job> jobsToExecute = new ArrayList<Job>();
        if (job instanceof CompositePrereqCheckerJob) {
            CompositePrereqCheckerJob compositeJob = (CompositePrereqCheckerJob)job;
            List<Job> jobs = compositeJob.getJobs();
            for (Job j : jobs) {
                jobsToExecute.addAll(this.getJobsToExecute(j));
            }
        } else {
            jobsToExecute.add(job);
        }
        return jobsToExecute;
    }

    private void resetFailedJobsOnly(Job job) {
        if (job instanceof CompositeJob) {
            List<Job> subJobs;
            CompositeJob compositeJob = (CompositeJob)job;
            if (compositeJob.getStatus() != Status.SUCCEEDED) {
                boolean resetSubJobs = false;
                compositeJob.reset(resetSubJobs);
            }
            if ((subJobs = compositeJob.getJobs()) != null && !subJobs.isEmpty()) {
                for (Job subJob : subJobs) {
                    this.resetFailedJobsOnly(subJob);
                }
            }
        } else if (job.getStatus() != Status.SUCCEEDED) {
            job.reset();
        }
    }

    private void calibrateWeightage(CompositeJob compositeJob) {
        float totalWeightage = 0.0f;
        for (Job job : compositeJob.getJobs()) {
            if (job.isCompleted()) continue;
            if (job instanceof CompositeJob) {
                this.calibrateWeightage((CompositeJob)job);
            }
            totalWeightage += job.getWeightage();
        }
        for (Job job : compositeJob.getJobs()) {
            if (job.isCompleted()) continue;
            job.setActualWeightage(job.getWeightage() / totalWeightage);
        }
    }

    public void fix() throws PrereqCheckerException {
        throw new PrereqCheckerException((ErrorCode)PrereqCheckerErrorCode.FIXUP_NOT_SUPPORTED, new Object[0]);
    }

    public void fix(List<VerificationTask> tasks) throws PrereqCheckerException {
        if (this.getFixupScriptExecutionJob() == null) {
            this.setFixupScriptExecutionJob(new FixupScriptExecutionJob(tasks, this.isFixupScriptExecutionSupported()));
        } else {
            this.getFixupScriptExecutionJob().setAutomaticFixupExecution(this.isFixupScriptExecutionSupported());
            this.getFixupScriptExecutionJob().setFixableTasks(tasks);
        }
        this.fix();
    }

    private CompositePrereqCheckerJob buildVerificationJob(VerificationTask ... verificationTasks) {
        this.verificationJob = new CompositePrereqCheckerJob();
        this.verificationJob.setId("root");
        Resource resource = Application.getInstance().getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");
        this.verificationJob.setDescription(resource.getString("PrereqChecker.checks.description", "Checks *", new Object[0]));
        if (verificationTasks != null) {
            for (VerificationTask verificationTask : verificationTasks) {
                this.buildJobTree(this.verificationJob, verificationTask);
            }
        }
        return this.verificationJob;
    }

    private void buildJobTree(CompositePrereqCheckerJob parentJob, VerificationTask verificationTask) {
        block6: {
            if (verificationTask.hasSubtasks()) {
                try {
                    List subtasks = verificationTask.getSubtasks();
                    if (subtasks != null && subtasks.size() > 0) {
                        CompositePrereqCheckerJob job = new CompositePrereqCheckerJob(verificationTask);
                        parentJob.add(job);
                        for (VerificationTask subtask : subtasks) {
                            this.buildJobTree(job, subtask);
                        }
                        break block6;
                    }
                    parentJob.add(new PrereqCheckerJob(verificationTask));
                }
                catch (SubtasksUnavailableException e) {
                    parentJob.add(new PrereqCheckerJob(verificationTask));
                }
            } else {
                parentJob.add(new PrereqCheckerJob(verificationTask));
            }
        }
    }

    public void addPrereqCheckerListener(PrereqCheckerListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removePrereqCheckerListener(PrereqCheckerListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public StatusMessages<ErrorMessage> runFixupAndVerify() throws Exception {
        if (this.fixupScriptExecJob == null) {
            logger.log(Level.INFO, "Script execution job is null. So skipping fixup script execution");
            this.verify();
            return null;
        }
        this.prepare(this.nodes);
        if (this.verificationTasks != null && this.verificationTasks.length > 0) {
            if (this.fixupAndVerificationJob == null) {
                this.fixupAndVerificationJob = new CompositePrereqCheckerJob();
                this.fixupAndVerificationJob.setHidden(true);
                this.fixupAndVerificationJob.add(this.fixupScriptExecJob);
                this.fixupAndVerificationJob.add(this.getVerificationJob());
            }
            if (this.verificationJob != null) {
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.FIXUP_STARTED, this.fixupAndVerificationJob));
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.TASKS_CHANGED, this.fixupAndVerificationJob));
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.VERIFICATION_STARTED, this.fixupAndVerificationJob));
                try {
                    this.verifyJobs(this.fixupAndVerificationJob);
                    this.performPostFixupAndVerifyOper();
                }
                finally {
                    this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.TASKS_CHANGED, this.getVerificationJob()));
                    this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.FIXUP_COMPLETED, this.getVerificationJob()));
                    this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.VERIFICATION_COMPLETED, this.getVerificationJob()));
                }
                if (this.fixupScriptExecJob.getStatus() != Status.SUCCEEDED) {
                    return this.fixupScriptExecJob.getErrorMessages();
                }
            }
        }
        return null;
    }

    protected void performPostFixupAndVerifyOper() throws Exception {
    }

    public void setFixupScriptExecutionSupported(Boolean value) {
        this.enableFixupExecution = value;
    }

    public boolean isFixupScriptExecutionSupported() {
        return this.enableFixupExecution;
    }

    protected FixupScriptExecutionJob getFixupScriptExecutionJob() {
        return this.fixupScriptExecJob;
    }

    protected void setFixupScriptExecutionJob(FixupScriptExecutionJob job) {
        this.fixupScriptExecJob = job;
    }

    public List<VerificationTask> getFixableVerificationTasks() {
        return this.fixableVerificationTasks;
    }

    public void setFixableVerificationTasks(List<VerificationTask> fixableTasks) {
        this.fixableVerificationTasks = fixableTasks;
    }

    public boolean isFixable(PrereqCheckerJob job) {
        if (this.fixableVerificationTasks != null && job != null) {
            return this.fixableVerificationTasks.contains(job.getVerificationTask());
        }
        return false;
    }
}

