/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.driver.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.install.commons.base.driver.common.InstallerErrorCode;
import oracle.install.commons.base.driver.common.InstallerException;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.flow.FlowDataSource;

public class ResponseFileSource
extends FlowDataSource {
    private File responseFile;

    public ResponseFileSource(File responseFile) throws FileNotFoundException, MalformedURLException {
        this(null, responseFile);
    }

    public ResponseFileSource(String beanStoreName, File responseFile) throws FileNotFoundException, MalformedURLException {
        super(beanStoreName);
        if (responseFile != null) {
            if (!responseFile.exists()) {
                throw new FileNotFoundException(responseFile.getPath());
            }
            URL url = responseFile.toURL();
            XmlBeanStoreFormatRegistry registry = XmlBeanStoreFormatRegistry.getInstance();
            XmlBeanStoreFormat format = null;
            try {
                format = registry.getFileFormat(responseFile);
            }
            catch (Exception e) {
                throw new InstallerException(e);
            }
            if (format == null) {
                registry = XmlBeanStoreFormatRegistry.getInstance();
                Object[] supportedFileExts = registry.getSupportFileExtensions();
                throw new InstallerException(InstallerErrorCode.UNKNOWN_RESPONSE_FILE_FORMAT, supportedFileExts);
            }
            this.setSourceURL(url);
            this.responseFile = responseFile;
            this.setFormat(format);
        }
    }

    public File getResponseFile() {
        return this.responseFile;
    }
}

