/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.net.Socket;
import java.net.SocketException;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.Receiver;
import oracle.ias.cache.group.ServerSocketEndPoint;
import oracle.ias.cache.group.ServerSocketHandler;

class ServerSocketReceiver
extends Thread
implements ServerSocketHandler {
    boolean run = true;
    ServerSocketEndPoint ssep;

    public ServerSocketReceiver(ServerSocketEndPoint serverSocketEndPoint) {
        this.ssep = serverSocketEndPoint;
        String string = null;
        if (this.ssep != null && this.ssep.ss != null) {
            string = this.ssep.ss.getInetAddress().getHostAddress() + ":" + this.ssep.ss.getLocalPort();
        }
        this.setName("Server Socket Receiver [" + string + "]");
        this.setDaemon(true);
    }

    public void run() {
        if (GroupCommunication.shouldLog(7)) {
            GroupCommunication.log(this.getName() + " is started.");
        }
        while (this.run) {
            try {
                if (this.ssep.ss == null) continue;
                Socket socket = this.ssep.ss.accept();
                Receiver receiver = new Receiver(socket);
                receiver.start();
            }
            catch (SocketException socketException) {
                try {
                    this.ssep.ss.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!GroupCommunication.isReady() || !GroupCommunication.shouldLog(10)) break;
                GroupCommunication.log("ServerSocketReceiver is closed.", socketException);
                break;
            }
            catch (Exception exception) {
                if (!GroupCommunication.isReady() || !GroupCommunication.shouldLog(3)) continue;
                GroupCommunication.log("accept failure.", exception);
            }
        }
    }

    public void stopit() {
        this.run = false;
    }
}

