/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

public class RWLock {
    private int waitingWriters = 0;
    private int activeWriters = 0;
    private int waitingReaders = 0;
    private int activeReaders = 0;
    private int id = counter++;
    static int counter = 0;

    private boolean allowReader() {
        return this.waitingWriters == 0 && this.activeWriters == 0;
    }

    private boolean allowWriter() {
        return this.activeReaders == 0 && this.activeWriters == 0;
    }

    public synchronized void acquireReadLock() throws InterruptedException {
        ++this.waitingReaders;
        while (!this.allowReader()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                --this.waitingReaders;
                throw interruptedException;
            }
        }
        --this.waitingReaders;
        ++this.activeReaders;
    }

    public synchronized void releaseReadLock() {
        --this.activeReaders;
        this.notifyAll();
    }

    public synchronized void acquireWriteLock() throws InterruptedException {
        ++this.waitingWriters;
        while (!this.allowWriter()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                --this.waitingWriters;
                throw interruptedException;
            }
        }
        --this.waitingWriters;
        ++this.activeWriters;
    }

    public synchronized void releaseWriteLock() {
        --this.activeWriters;
        this.notifyAll();
    }

    public String toString() {
        return new String("name: RWLock-" + this.id + " wr:" + this.waitingReaders + ", ar:" + this.activeReaders + ", ww:" + this.waitingWriters + ", aw:" + this.activeWriters);
    }
}

