/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.Transport;

public class Packet
implements Serializable {
    static final long serialVersionUID = -6576684917038865132L;
    public static final int PACKET_TOTAL = 24;
    public static final int REQ_COORDINATOR = 1;
    public static final int COORDINATOR = 2;
    public static final int REGISTER = 3;
    public static final int NEW_VIEW = 4;
    public static final int READY = 5;
    public static final int OPEN_CONNECTION = 6;
    public static final int FAILURE_DETECTED = 7;
    public static final int NEW_COORDINATOR = 8;
    public static final int BECOME_NODELISTENER = 9;
    public static final int PING = 10;
    public static final int PING_ACK = 11;
    public static final int FORWARD = 13;
    public static final int DELIVER = 14;
    public static final int FLUSH = 15;
    public static final int FLUSHOVER = 16;
    public static final int USER_MSG = 17;
    public static final int ELECT_COORDINATOR = 18;
    public static final int TERM = 20;
    public static final int ACK = 21;
    public static final int KILL = 22;
    public static final int STOP_NODELISTENER = 23;
    public static final String[] PACKET_NAMES = new String[24];
    public static final int NORMAL = 0;
    public static final int ATOMIC = 1;
    public static final int TOTAL = 2;
    int type;
    int attribute;
    int vid;
    int receiverIndex;
    int receiverPosition;
    int senderIndex;
    long serialNumber;
    boolean fromMyself;
    long gSequenceNumber;
    Vector receiveVector;
    Vector unDeliverableMsgList;
    long receivedTONumber;
    Address source;
    Serializable destination;
    Serializable message;
    boolean nodecast;
    long size;
    transient String attached_file_name = null;
    transient InputStream m_input_stream = null;
    transient long m_stream_size = 0L;
    public static final long HEADER_SIZE = 128L;
    static byte[] c_lock;
    static long counter;
    static byte[] to_lock;
    static long to_counter;
    static byte[] seq_lock;
    static long sequencer;

    public Packet(Object object, Serializable serializable) throws GroupException {
        this(0, object, serializable);
    }

    public Packet(int n, Object object, Serializable serializable) throws GroupException {
        this(17, n, Transport.ssep.addr, (Serializable)object, serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Packet(int n, int n2, Address address, Serializable serializable, Serializable serializable2) throws GroupException {
        if (n == 17 && !(serializable instanceof Address) && !(serializable instanceof String)) {
            throw new GroupException(GroupCommunication.EXP_GRP_INVALIDADDR);
        }
        this.destination = serializable;
        this.type = n;
        this.attribute = n2;
        if ((this.attribute & 1) != 0) {
            byte[] byArray = c_lock;
            // MONITORENTER : c_lock
            this.serialNumber = ++counter;
            // MONITOREXIT : byArray
        } else if ((this.attribute & 2) != 0) {
            byte[] byArray = to_lock;
            // MONITORENTER : to_lock
            this.serialNumber = --to_counter;
            // MONITOREXIT : byArray
        } else {
            this.serialNumber = 0L;
        }
        this.source = address;
        this.message = serializable2;
        this.vid = -1;
        this.senderIndex = -1;
        this.receiverIndex = -1;
        this.fromMyself = false;
        this.gSequenceNumber = -1L;
        this.receiveVector = null;
        this.unDeliverableMsgList = null;
        this.receivedTONumber = -1L;
        this.nodecast = false;
        this.size = 128L;
    }

    public int getAttributes() {
        return this.attribute;
    }

    public Object getSourceAddress() {
        return this.source;
    }

    public Object getDestinationAddress() {
        return this.destination;
    }

    public Serializable getMessage() {
        return this.message;
    }

    public boolean isFromMyself() {
        return this.fromMyself;
    }

    public int getVid() {
        return this.vid;
    }

    public int getReceiverIndex() {
        return this.receiverIndex;
    }

    public void setSenderIndex(int n) {
        this.senderIndex = n;
    }

    public int getSenderIndex() {
        return this.senderIndex;
    }

    public int getSenderPosition() {
        return this.source.getPosition();
    }

    public int getReceiverPosition() {
        return this.receiverPosition;
    }

    public boolean isAtomic() {
        return (this.attribute & 1) != 0;
    }

    public boolean isTotal() {
        return (this.attribute & 2) != 0;
    }

    long getSerialNumber() {
        return this.serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getSequencer() {
        byte[] byArray = seq_lock;
        synchronized (seq_lock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sequencer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setSequencer(long l) {
        byte[] byArray = seq_lock;
        synchronized (seq_lock) {
            sequencer = l;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long incSequencer() {
        byte[] byArray = seq_lock;
        synchronized (seq_lock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++sequencer;
        }
    }

    void setSequenceNumber(long l) {
        this.gSequenceNumber = l;
    }

    long getSequenceNumber() {
        return this.gSequenceNumber;
    }

    void setUnDeliverableMsgList(Vector vector) {
        if (vector != null) {
            this.unDeliverableMsgList = vector;
        }
    }

    Vector getUnDeliverableMsgList() {
        return this.unDeliverableMsgList;
    }

    synchronized void setReceiveVector(Vector vector) {
        this.receiveVector = vector;
    }

    synchronized void setReceiveArray(long[] lArray) {
        if (lArray == null) {
            this.receiveVector = null;
            return;
        }
        this.receiveVector = new Vector();
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                this.receiveVector.add(new Long(lArray[i]));
            }
        }
    }

    synchronized Vector getReceiveVector() {
        return this.receiveVector;
    }

    public synchronized long[] getReceiveArray() {
        if (this.receiveVector == null) {
            return null;
        }
        long[] lArray = new long[this.receiveVector.size()];
        for (int i = 0; i < this.receiveVector.size(); ++i) {
            lArray[i] = (Long)this.receiveVector.elementAt(i);
        }
        return lArray;
    }

    long getReceivedTONumber() {
        return this.receivedTONumber;
    }

    void setReceivedTONumber(long l) {
        this.receivedTONumber = l;
    }

    String getType() {
        if (this.type >= 0 && this.type < 24) {
            return PACKET_NAMES[this.type];
        }
        return Integer.toString(this.type);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("type=");
        if (this.type >= 0 && this.type < 24) {
            stringBuffer.append(PACKET_NAMES[this.type]);
        } else {
            stringBuffer.append(this.type);
        }
        stringBuffer.append(" attr=");
        stringBuffer.append(this.attribute);
        stringBuffer.append(", source=");
        stringBuffer.append(this.source);
        stringBuffer.append(", destination=");
        stringBuffer.append(this.destination);
        stringBuffer.append(", message=");
        stringBuffer.append(this.message);
        stringBuffer.append(", vid=");
        stringBuffer.append(this.vid);
        stringBuffer.append(", receiver-index=");
        stringBuffer.append(this.receiverIndex);
        stringBuffer.append(", sender-index=");
        stringBuffer.append(this.senderIndex);
        stringBuffer.append(", fromMyself=");
        stringBuffer.append(this.fromMyself);
        stringBuffer.append(", serialNumber=");
        stringBuffer.append(this.serialNumber);
        stringBuffer.append(", gSequenceNumber=");
        stringBuffer.append(this.gSequenceNumber);
        stringBuffer.append(", receiveVector=");
        stringBuffer.append(this.receiveVector);
        stringBuffer.append(", unDeliverableMsgList=");
        stringBuffer.append(this.unDeliverableMsgList);
        stringBuffer.append(", receivedTONumber=");
        stringBuffer.append(this.receivedTONumber);
        return stringBuffer.toString();
    }

    public synchronized void dump() {
        try {
            GroupCommunication.log("\nPacket=" + this.toString());
            if (this.receiveVector != null) {
                GroupCommunication.log("ReceiveVector=" + this.receiveVector);
            } else {
                GroupCommunication.log("Packet.ReceiveVector is null.");
            }
            if (this.unDeliverableMsgList != null) {
                GroupCommunication.log("unDeliverableMsgList=" + this.unDeliverableMsgList);
            } else {
                GroupCommunication.log("Packet.unDeliverableMsgList is null.");
            }
            GroupCommunication.log("receivedTONumber=" + this.receivedTONumber);
            GroupCommunication.log("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setNodeCast(boolean bl) {
        this.nodecast = bl;
    }

    boolean getNodeCast() {
        return this.nodecast;
    }

    void setSize(long l) {
        this.size = l + 128L;
    }

    long getSize() {
        if (this.size <= 128L) {
            this.size = 256L;
        }
        return this.size;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Packet packet = (Packet)object;
        return this.serialNumber == packet.serialNumber && this.gSequenceNumber == packet.gSequenceNumber && this.source.equals(packet.source);
    }

    public int compareTo(Object object) {
        Packet packet = (Packet)object;
        int n = 0;
        n = this.serialNumber == packet.serialNumber && this.gSequenceNumber == packet.gSequenceNumber && this.source.equals(packet.source) ? 0 : (this.gSequenceNumber > packet.gSequenceNumber ? 1 : -1);
        return n;
    }

    public void setAttachedFileName(String string) {
        this.attached_file_name = string;
    }

    public String getAttachedFileName() {
        return this.attached_file_name;
    }

    public void setInputStream(InputStream inputStream) {
        this.m_input_stream = inputStream;
    }

    public void setStreamSize(long l) {
        this.m_stream_size = l;
    }

    public InputStream getInputStream() {
        return this.m_input_stream;
    }

    public long getStreamSize() {
        return this.m_stream_size;
    }

    public void clear() {
        this.receiveVector = null;
        this.unDeliverableMsgList = null;
        this.source = null;
        this.destination = null;
        this.message = null;
    }

    static {
        Packet.PACKET_NAMES[0] = "UNKNOWN";
        Packet.PACKET_NAMES[1] = "REQ_COORDINATOR";
        Packet.PACKET_NAMES[2] = "COORDINATOR";
        Packet.PACKET_NAMES[3] = "REGISTER";
        Packet.PACKET_NAMES[4] = "NEW_VIEW";
        Packet.PACKET_NAMES[5] = "READY";
        Packet.PACKET_NAMES[6] = "OPEN_CONNECTION";
        Packet.PACKET_NAMES[7] = "FAILURE_DETECTED";
        Packet.PACKET_NAMES[8] = "NEW_COORDINATOR";
        Packet.PACKET_NAMES[9] = "BECOME_NODELISTENER";
        Packet.PACKET_NAMES[10] = "PING";
        Packet.PACKET_NAMES[11] = "PING_ACK";
        Packet.PACKET_NAMES[12] = "TOTAL_ACK";
        Packet.PACKET_NAMES[13] = "FORWARD";
        Packet.PACKET_NAMES[14] = "DELIVER";
        Packet.PACKET_NAMES[15] = "FLUSH";
        Packet.PACKET_NAMES[16] = "FLUSHOVER";
        Packet.PACKET_NAMES[17] = "USER_MSG";
        Packet.PACKET_NAMES[18] = "ELECT_COORDINATOR";
        Packet.PACKET_NAMES[19] = "UNKNOWN";
        Packet.PACKET_NAMES[20] = "TERM";
        Packet.PACKET_NAMES[21] = "ACK";
        Packet.PACKET_NAMES[22] = "KILL";
        Packet.PACKET_NAMES[23] = "STOP_NODELISTENER";
        c_lock = new byte[0];
        counter = 0L;
        to_lock = new byte[0];
        to_counter = 0L;
        seq_lock = new byte[0];
        sequencer = -1L;
    }
}

