/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.net.Socket;
import java.net.SocketException;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.NodeListenerHandler;
import oracle.ias.cache.group.ServerSocketEndPoint;
import oracle.ias.cache.group.ServerSocketHandler;

class NodeListener
extends Thread
implements ServerSocketHandler {
    boolean run = true;
    ServerSocketEndPoint ssep;

    public NodeListener(ServerSocketEndPoint serverSocketEndPoint) {
        this.ssep = serverSocketEndPoint;
        String string = null;
        if (this.ssep != null && this.ssep.ss != null) {
            string = this.ssep.ss.getInetAddress().getHostAddress() + ":" + this.ssep.ss.getLocalPort();
        }
        this.setName("Node Listener [" + string + "]");
        this.setDaemon(true);
    }

    public void run() {
        Socket socket = null;
        if (GroupCommunication.shouldLog(7)) {
            GroupCommunication.log(this.getName() + " is started.");
        }
        while (this.run) {
            try {
                if (this.ssep.ss == null) continue;
                socket = this.ssep.ss.accept();
                NodeListenerHandler nodeListenerHandler = new NodeListenerHandler(socket);
                nodeListenerHandler.start();
            }
            catch (SocketException socketException) {
                if (!this.run || !GroupCommunication.isReady() || !GroupCommunication.shouldLog(10)) continue;
                GroupCommunication.log("Got socket exception.", socketException);
            }
            catch (Exception exception) {
                if (!this.run || !GroupCommunication.isReady() || !GroupCommunication.shouldLog(3)) continue;
                GroupCommunication.log("NodeListener exception.", exception);
            }
        }
        if (GroupCommunication.shouldLog(7)) {
            GroupCommunication.log(this.getName() + " is terminated.");
        }
    }

    public void stopit() {
        this.run = false;
        try {
            this.ssep.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

