/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Enumeration;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHostInfo;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheLogger;
import oracle.ias.cache.CacheNotAvailableException;

public class Cache {
    public static void open() throws CacheException {
        CacheInternal.open("javacache.properties");
    }

    public static void open(String string) throws CacheException {
        CacheInternal.open(string);
    }

    public static void init(CacheAttributes cacheAttributes) throws CacheException {
        try {
            CacheInternal.init(cacheAttributes);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.init", exception);
        }
    }

    public static void close() {
        CacheInternal.close();
    }

    public static CacheAttributes getAttributes() throws CacheNotAvailableException {
        return CacheInternal.getAttributes();
    }

    public static int getObjectCount() throws CacheNotAvailableException {
        return CacheInternal.getObjectCount();
    }

    public static long getCacheSize() throws CacheNotAvailableException {
        return CacheInternal.getCacheSize();
    }

    public static long getLocalDiskCacheSize() throws CacheNotAvailableException {
        return CacheInternal.getLocalDiskCacheSize();
    }

    public static long getDistributedDiskCacheSize() throws CacheNotAvailableException {
        return CacheInternal.getDistributedDiskCacheSize();
    }

    public static void resetAttributes(CacheAttributes cacheAttributes) throws CacheNotAvailableException {
        CacheInternal.resetAttributes(cacheAttributes);
    }

    public static void invalidate() throws CacheException {
        try {
            CacheInternal.globalInvalidate(true);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.invalidate", exception);
        }
    }

    public static void invalidate(boolean bl) throws CacheException {
        try {
            CacheInternal.globalInvalidate(!bl);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.invalidate", exception);
        }
    }

    public static void destroy() throws CacheException {
        try {
            CacheInternal.globalDestroy(true);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.destroy", exception);
        }
    }

    public static void destroy(boolean bl) throws CacheException {
        try {
            CacheInternal.globalDestroy(!bl);
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.destroy", exception);
        }
    }

    public static String getVersion() {
        return CacheInternal.getVersion();
    }

    public static void dump() {
        CacheInternal.dump();
    }

    public static boolean isReady() {
        return CacheInternal.isReady();
    }

    public static boolean isDistributed() {
        return CacheInternal.isDistributed();
    }

    public static Enumeration listCacheObjects() {
        return CacheInternal.listCacheObjects();
    }

    public static Enumeration listCacheObjects(String string) {
        return CacheInternal.listCacheObjects(string);
    }

    public static void setLogSeverity(int n) {
        CacheInternal.setSeverity(n);
    }

    public static int getCacheId() {
        return CacheInternal.cacheId;
    }

    public static void updateStats() {
        CacheInternal.updateStats();
    }

    public static String getCacheAddress() {
        return CacheInternal.cacheAddress;
    }

    public static CacheAddress getCacheAddressObject() throws CacheException {
        try {
            return CacheInternal.getLocalAddressObject();
        }
        catch (Exception exception) {
            throw Cache.exceptionHandler("Cache.getCacheAddressObject", exception);
        }
    }

    public static CacheHostInfo[] getActiveHostInfo() throws CacheException {
        return CacheInternal.getActiveHostInfo();
    }

    public static CacheLogger getCacheLogger() {
        return CacheInternal.logger;
    }

    private static CacheException exceptionHandler(String string, Exception exception) {
        return CacheInternal.exceptionHandler(CacheInternal.EXP_EXCEPTIONIN + " " + string, exception);
    }
}

