﻿<%--<%@ Page Title="" Language="C#" MasterPageFile="~/Site1.Master" AutoEventWireup="true" CodeBehind="MapViewer.aspx.cs" Inherits="VMT.MapViewer" %>--%>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphJavaScriptContentPlaceHolder" runat="server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphPageTitleContentPlaceHolder" runat="server">
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="cphMainContentPlaceHolder" runat="server">
    <!DOCTYPE html>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <!--The viewport meta tag is used to improve the presentation and behavior of the samples 
      on iOS devices-->
    <meta name="viewport" content="initial-scale=1, maximum-scale=1,user-scalable=no">
    <title></title>

    <link rel="stylesheet" href="http://js.arcgis.com/3.12/dijit/themes/soria/soria.css">
    <link rel="stylesheet" href="http://js.arcgis.com/3.12/dojox/grid/resources/Grid.css">
    <link rel="stylesheet" href="http://js.arcgis.com/3.12/dojox/grid/resources/soriaGrid.css">
    <link rel="stylesheet" href="http://js.arcgis.com/3.12/esri/css/esri.css">
   <style>
      html, body, #mapDiv {
        padding:0;
        margin:0;
        height:100%;
        min-height: 100%;

      }
      #map1 {
      
        min-height: 100%;
      }

      #info {
        background: #fff;
        box-shadow: 0 0 5px #888;
        left: 1em;
        padding: 0.5em;
        position: absolute;
        top: 1em;
        z-index: 40;
      }
    </style>
    <script>var dojoConfig = { parseOnLoad: true };</script>
    <script src="http://js.arcgis.com/3.12/"></script>
    <script>
        dojo.require("dijit.layout.BorderContainer");
        dojo.require("dijit.layout.ContentPane");
        dojo.require("esri.map");
        dojo.require("esri.toolbars.draw");
        dojo.require("esri.layers.FeatureLayer");
        dojo.require("esri.tasks.query");
        dojo.require("dojox.grid.DataGrid");
        dojo.require("dojo.data.ItemFileReadStore");
        dojo.require("esri.virtualearth.VETiledLayer");
        dojo.require("esri.symbols.PictureMarkerSymbol");
        var map, toolbar, featureLayer, dialog;
        function init() {
            map = new esri.Map("map1", {
                basemap: "streets",
                center: [-81.0324, 33.9897],
                zoom: 15
            });

            veTileLayer = new esri.virtualearth.VETiledLayer({
                 bingMapsKey: '<%=ConfigurationManager.AppSettings["bingMapKey"].ToString() %>',
                mapStyle: esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD
            });
            map.addLayer(veTileLayer);

            dojo.connect(map, "onLoad", function (map) {
                //initialize the toolbar
                toolBar = new esri.toolbars.Draw(map);
                dojo.connect(toolBar, "onDrawEnd", onDrawEnd);
            });

            var featureLayerUrl = "http://gisadv02dv/arcgis/rest/services/TrimWeb/BaseMapTrimming/MapServer/23";
            featureLayer = new esri.layers.FeatureLayer(featureLayerUrl, {
                mode: esri.layers.FeatureLayer.MODE_ONDEMAND,
                outFields: ["PROJECTCODE", "SECTIONCODE", "TRIMYEAR", "WORKSTATUS "]
            });
            //featureLayer.setSelectionSymbol(new esri.symbol.PictureMarkerSymbol('images/premise_res_e.png', 20, 20));
            map.addLayer(featureLayer);

            var thisObject = this;

            this.showTooltip = function (evt) {
                var dialog = new dijit.TooltipDialog({
                    id: "tooltipDialog",
                    content: "PROJECTCODE : " + evt.graphic.attributes.PROJECTCODE + "<br>"
                    + "SECTIONCODE : " + evt.graphic.attributes.SECTIONCODE + "<br>"
                    + "TRIMYEAR : " + evt.graphic.attributes.TRIMYEAR,
                    style: "position: absolute; width: auto; font: normal normal bold 8pt Tahoma;z-index:100"
                });
                dialog.startup();
                dojo.style(dialog.domNode, "opacity", 0.85);
                dojo.style(dialog.domNode, "background", "#333");
                dojo.style(dialog.domNode, "color", "#EFEFEF");
                dijit.placeOnScreen(dialog.domNode, { x: evt.pageX, y: evt.pageY }, ["TL", "BL"], { x: 10, y: 10 });
            }
          

            this.closeDialog = function () {
                var widget = dijit.byId("tooltipDialog");
                if (widget) {
                    widget.destroy();
                }
            }
            dojo.connect(featureLayer, "onMouseOver", function (evt) {
                thisObject.closeDialog();
                thisObject.showTooltip(evt);
            });

            dojo.connect(featureLayer, "onMouseOut", this.closeDialog);
        }


        function onDrawEnd(extent) {<a href="Rpt_Workarea.aspx.designer.cs">Rpt_Workarea.aspx.designer.cs</a>
            toolBar.deactivate();
            //select features within the draw extent
            var query = new esri.tasks.Query();
            query.geometry = extent;
            featureLayer.selectFeatures(query, esri.layers.FeatureLayer.SELECTION_NEW, function (features, selectionMethod) {
                //add selected features to the grid
                var items = dojo.map(features, function (feature) {
                    return feature.attributes;
                });
                var data = { identifier: "OBJECTID", items: items };
                var store = new dojo.data.ItemFileReadStore({ data: data });
                grid.setStore(store);
            });
        }


        dojo.ready(init);
    </script>
  </head> 
  <body>


     <div style="position:relative;">
      <div id="map1" style="width:100%; height:auto; border:1px solid #000;">
      <div style="position:absolute; left:650px; top:10px; z-Index:999;">
        <button data-dojo-type="dijit.form.Button" onClick="veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL);">Aerial</button>
        <button data-dojo-type="dijit.form.Button" onClick="veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL_WITH_LABELS)">Aerial with labels</button>
        <button data-dojo-type="dijit.form.Button" onClick="veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD)">Roads</button>
      </div>
      </div>
    </div>


   

  </body>
</html>


</asp:Content>
