﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="MapView_PS.aspx.cs" Inherits="VMT.MapView_PS" %>

<!DOCTYPE html>
<html>
<head>
    <meta content="IE=10" http-equiv="X-UA-Compatible">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="initial-scale=1, maximum-scale=1,user-scalable=no">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <title>View Project - WA lines</title>

    <link rel="stylesheet" href="https://js.arcgis.com/3.20/esri/css/esri.css" />
    <style type="text/css">     
     @import "http://js.arcgis.com/3.12/dijit/themes/claro/claro.css";
      html, body, form, #mapDiv {
            height: 100%;
            width: 100%;
            margin: 0;
            padding: 0;
      }
       body {    
              font-family: Arial, Verdana, 'Times New Roman';
              font-size: 13px;
              background:#fff url('') no-repeat center center fixed;
              overflow:hidden;
              -webkit-background-size: cover;
              -moz-background-size: cover;
              -o-background-size: cover;
              background-size: cover;
              margin: 2px;
              padding: 0;
    }

       .MapNavIcon {
            width:26px; 
            height:26px;
        }
        .MapNavIcon:hover {
             width:32px; 
            height:32px;
        }
       .myDynamicButton {
           background-color: transparent;
           border: 0px;
           border-color: transparent
       }
      .zoominIcon {
        background-image: url(resource_gallery/graphics/nav_zoomin.png);
        width: 16px;
        height: 16px;
      }
      .zoomoutIcon {
        background-image: url(resource_gallery/graphics/nav_zoomout.png);
        width: 16px;
        height: 16px;
      }
      .zoomfullextIcon {
        background-image: url(resource_gallery/graphics/nav_fullextent.png);
        width: 16px;
        height: 16px;
      }
      .zoomprevIcon {
        background-image: url(resource_gallery/graphics/nav_previous.png);
        width: 16px;
        height: 16px;
      }
      .zoomnextIcon {
        background-image: url(resource_gallery/graphics/nav_next.png);
        width: 16px;
        height: 16px;
      }
      .panIcon {
        background-image: url(resource_gallery/graphics/nav_pan.png);
        width: 16px;
        height: 16px;
      }
      .deactivateIcon {
        background-image: url(resource_gallery/graphics/nav_decline.png);
        width: 16px;
        height: 16px;
      }
      #leftPane{
       
        border: solid 1px #343642;
        margin:5px 5px 5px 5px;
        color: #343642;        

        position:absolute; 
        z-index: 2; 
        background-color:white; 
        min-width:600px; height:50px; 
        margin: 20px 1px 1px 60px; 
        padding: 6px; 
        border-radius: 8px; 
        font-size:12px;
        /*letter-spacing: 0.05em;*/
      }
      /*#leftPane{
        width:90%;
        border: solid 1px #343642;
        margin:5px 5px 5px 5px;
        color: #343642;
        font:100% Georgia,"Times New Roman",Times,serif;
        
      }*/
    </style>


    <script src="https://js.arcgis.com/3.20/"></script>
    <script type="text/javascript">

          function Mapview(v) {
              //To Do
              switch (v) {
                  case "Road":
                      //Road
                      veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD); return false;
                      break;
                  case "Aerial":
                      //Aerial
                      veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL); return false;
                      break;
                  case "Aerialp":
                      //Aerial with Label
                      veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL_WITH_LABELS); return false;
                      break;
              }
          };

    </script>
    <script>

        function pageLoad(sender, args) {
            var map, locator;
            var imageParametersbmt;
            var dynamicMapServiceLayerbmt;
            var dynamicurlbmt = "<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_BASEMAP_DIST"].ToString() %>";
            
            var imageParametersbmtt;
            var dynamicMapServiceLayerbmtt;
            var dynamicurlbmtt = "<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_BASEMAP_TRANS"].ToString() %>";
          
            require([
              "esri/map",
               "esri/tasks/locator",
                "esri/graphic",
                "esri/toolbars/navigation",
                "dojo/on",
                "esri/tasks/QueryTask",
              "esri/tasks/query",
              "esri/InfoTemplate",
              "esri/symbols/SimpleMarkerSymbol",
              "dojo/_base/array",
              "esri/symbols/TextSymbol",
              "esri/Color",
              "esri/symbols/Font",
              "esri/layers/ArcGISDynamicMapServiceLayer",
              "esri/layers/ImageParameters",
              "dojo/parser",
              "dojo/dom",
              "dijit/registry",
               "esri/virtualearth/VETiledLayer",
              "dijit/Toolbar",

              "esri/layers/FeatureLayer",
              "dijit/form/Button",
              "dojo/number",
              "dijit/form/Textarea",
              "dijit/layout/BorderContainer",
              "dijit/layout/ContentPane",
              "dojo/domReady!"
            ],
              function (Map,
                       Locator,
                        Graphic,
                        Navigation,
                        on,
                        QueryTask,
                  Query,
                  InfoTemplate,
                  SimpleMarkerSymbol,
                  arrayUtils,
                  TextSymbol,
                  Color,
                  Font,
                        ArcGISDynamicMapServiceLayer,
                        ImageParameters,
                         parser,
                        dom,
                  registry,
                  FeatureLayer,
                  number) {

                  map = new Map("map", {
                      basemap: "streets",
                      center: [ <%= zlong %>, <%= zlat %>],
                      spatialReference: { wkid: 4269 },
                      zoom: 13
                  });

                  dojo.parser.parse();
                  var navToolbar;
                  var EVT_CODE;
                  var WA_ID;


                 

                  veTileLayer = new esri.virtualearth.VETiledLayer({
                       bingMapsKey: '<%=ConfigurationManager.AppSettings["bingMapKey"].ToString() %>',
                      mapStyle: esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD
                  });
                  map.addLayer(veTileLayer);

                  navToolbar = new Navigation(map);
                  on(navToolbar, "onExtentHistoryChange", extentHistoryChangeHandler);

                  registry.byId("zoomin").on("click", function () {
                      navToolbar.activate(Navigation.ZOOM_IN);
                  });

                  registry.byId("zoomout").on("click", function () {
                      navToolbar.activate(Navigation.ZOOM_OUT);
                  });

                  registry.byId("zoomfullext").on("click", function () {
                      navToolbar.zoomToFullExtent();
                  });

                  registry.byId("zoomprev").on("click", function () {
                      navToolbar.zoomToPrevExtent();
                  });

                  registry.byId("zoomnext").on("click", function () {
                      navToolbar.zoomToNextExtent();
                  });

                  registry.byId("pan").on("click", function () {
                      navToolbar.activate(Navigation.PAN);
                  });


                  function extentHistoryChangeHandler() {
                      registry.byId("zoomprev").disabled = navToolbar.isFirstExtent();
                      registry.byId("zoomnext").disabled = navToolbar.isLastExtent();
                  }

                  locator = new Locator("http://geocode.arcgis.com/arcgis/rest/services/World/GeocodeServer");
                  locator.on("address-to-locations-complete", showResults);

                  // listen for button click then geocode
                  registry.byId("locate").on("click", locate);

                  function locate() {
                      try {


                          map.graphics.clear();
                          var address = {
                              "SingleLine": dom.byId("address").value
                          };
                          locator.outSpatialReference = map.spatialReference;

                          var options = {
                              address: address,
                              outFields: ["Loc_name"]
                          };

                          locator.addressToLocations(options);

                      }
                      catch (e) {
                          alert("Error Message: " + e.message);
                      }

                  }


                  function showResults(evt) {
                      try {

                          var symbol = new SimpleMarkerSymbol();

                          var infoTemplate = new InfoTemplate(
                            "Location",
                            "Address: ${address}<br />Score: ${score}<br />Source locator: ${locatorName}"
                          );

                          symbol.setStyle(SimpleMarkerSymbol.STYLE_SQUARE);

                          symbol.setColor(new Color([153, 0, 51, 0.75]));

                          var geom;



                          arrayUtils.every(evt.addresses, function (candidate) {
                              console.log(candidate.score);

                              if (candidate.score > 80) {
                                  console.log(candidate.location);
                                  var attributes = {
                                      address: candidate.address,
                                      score: candidate.score,
                                      locatorName: candidate.attributes.Loc_name
                                  };
                                  geom = candidate.location;
                                  var graphic = new Graphic(geom, symbol, attributes, infoTemplate);
                                  //add a graphic to the map at the geocoded location

                                  map.graphics.add(graphic);
                                  //add a text symbol to the map listing the location of the matched address.
                                  var displayText = candidate.address;

                                  var font = new Font(
                                    "16pt",
                                    Font.STYLE_NORMAL,
                                    Font.VARIANT_NORMAL,
                                    Font.WEIGHT_BOLD,
                                    "Helvetica"
                                  );
                                  var textSymbol = new TextSymbol(
                                    displayText,
                                    font,
                                    new Color("#666633")
                                  );
                                  textSymbol.setOffset(0, 8);
                                  map.graphics.add(new Graphic(geom, textSymbol));

                                  return false; //break out of loop after one candidate with score greater  than 80 is found.
                              }
                          });



                          if (geom !== undefined) {
                              map.centerAndZoom(geom, 14);
                          }



                      }
                      catch (e) {
                          alert("Error Message: " + e.message);
                      }



                  }



                  function getParameterByName(name) {
                      name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
                      var regexString = "[\\?&]" + name + "=([^&#]*)";
                      var regex = new RegExp(regexString);
                      var found = regex.exec(window.location.search);
                      if (found == null)
                          return "";
                      else
                          return decodeURIComponent(found[1].replace(/\+/g, " "));
                  }

                  // document.getElementById('lblPjtValue').innerText = getParameterByName('nm');




                  var e = document.getElementById("ddl_EventCode");
                  var w = document.getElementById("ddl_WorkArea");
                  EVT_CODE = e.options[e.selectedIndex].value;
                  WA_ID = w.options[w.selectedIndex].value;

                  if (document.getElementById('chkbmt').checked == true) {
                      BindDistributionLayer();
                  }

                  if (document.getElementById('chkbmtt').checked == true) {
                      BindTransmissionLayer();
                  }

                  //Use the ImageParameters to set map service layer definitions and map service visible layers before adding to the client map.
                  var imageParameters = new ImageParameters();

                  //ImageParameters.layerDefinitions takes an array.  The index of the array corresponds to the layer id.
                  //In the sample below an element is added in the array at 3, 4, and 5 indexes.
                  //Those array elements correspond to the layer id within the remote ArcGISDynamicMapServiceLayer
                  var layerDefs = [];
                  var trimlinelayer = "<%= System.Configuration.ConfigurationManager.AppSettings["Layer_MapService_TL_TRIM_LINES"].ToString() %>";
                  //layerDefs[0] = "EVENT_CODE_ID= " + getParameterByName('EVENT_CODE_ID');
                  if (WA_ID == 0) {
                      layerDefs[trimlinelayer] = "EVENT_CODE_ID= " + EVT_CODE;
                  } else {
                      layerDefs[trimlinelayer] = "EVENT_CODE_ID= " + EVT_CODE;

                     // layerDefs[trimlinelayer] = "WORK_AREA_ID= " + WA_ID;
                      //layerDefs[0] = "WORK_AREA_ID= " + WA_ID;
                  }

                  //layerDefs[1] = "EVENT_CODE_ID=52";
                  imageParameters.layerDefinitions = layerDefs;

                  //I want layers 5,4, and 3 to be visible
                  imageParameters.layerIds = [trimlinelayer];
                  imageParameters.layerOption = ImageParameters.LAYER_OPTION_SHOW;
                  imageParameters.transparent = true;
              

                  //construct ArcGISDynamicMapServiceLayer with imageParameters from above
                  var dynamicMapServiceLayer = new ArcGISDynamicMapServiceLayer("<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_TRIM_LINES"].ToString() %>",
                    { "imageParameters": imageParameters });

                  map.addLayer(dynamicMapServiceLayer);


                  // added for dummy layer - start

                    //Use the ImageParameters to set map service layer definitions and map service visible layers before adding to the client map.
                  var imageParameters3 = new ImageParameters();

                  //ImageParameters.layerDefinitions takes an array.  The index of the array corresponds to the layer id.
                  //In the sample below an element is added in the array at 3, 4, and 5 indexes.
                  //Those array elements correspond to the layer id within the remote ArcGISDynamicMapServiceLayer
                  var layerDefs3 = [];
                  var trimlinelayer3 = "<%= System.Configuration.ConfigurationManager.AppSettings["Layer_MapService_TL_TRIM_LINES_WA"].ToString() %>";
                  //layerDefs[0] = "EVENT_CODE_ID= " + getParameterByName('EVENT_CODE_ID');
                  if (WA_ID == 0) {
                      layerDefs3[trimlinelayer3] = "EVENT_CODE_ID= " + EVT_CODE;
                  } else {
                      layerDefs3[trimlinelayer3] = "WORK_AREA_ID= " + WA_ID;

                     // layerDefs[trimlinelayer] = "WORK_AREA_ID= " + WA_ID;
                      //layerDefs[0] = "WORK_AREA_ID= " + WA_ID;
                  }

                  //layerDefs[1] = "EVENT_CODE_ID=52";
                  imageParameters3.layerDefinitions = layerDefs3;

                  //I want layers 5,4, and 3 to be visible
                  imageParameters3.layerIds = [trimlinelayer3];
                  imageParameters3.layerOption = ImageParameters.LAYER_OPTION_SHOW;
                  imageParameters3.transparent = true;
                

                  //construct ArcGISDynamicMapServiceLayer with imageParameters from above
                  var dynamicMapServiceLayer3 = new ArcGISDynamicMapServiceLayer("<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_TRIM_LINES"].ToString() %>",
                    { "imageParameters": imageParameters3 });

                  map.addLayer(dynamicMapServiceLayer3);
               



                  // dummy layer - ends
                  
                  var imageParameters2 = new ImageParameters();
                  var layerDefs2 = [];
                  var nonbillablelayer = "<%= System.Configuration.ConfigurationManager.AppSettings["Layer_MapService_TRC_NONBILLABLE"].ToString() %>";
                  var trimlayer = "<%= System.Configuration.ConfigurationManager.AppSettings["Layer_MapService_TRC_TRIM"].ToString() %>";
                  var climblayer = "<%= System.Configuration.ConfigurationManager.AppSettings["Layer_MapService_TRC_CLIMB"].ToString() %>";
                  var skippedlayer = "<%= System.Configuration.ConfigurationManager.AppSettings["Layer_MapService_TRC_SKIPPED"].ToString() %>";
                  if (WA_ID == 0) {
                      layerDefs2[nonbillablelayer] = "EVENT_CODE_ID= " + EVT_CODE;
                      layerDefs2[trimlayer] = "EVENT_CODE_ID= " + EVT_CODE;
                      layerDefs2[climblayer] = "EVENT_CODE_ID= " + EVT_CODE;
                      layerDefs2[skippedlayer] = "EVENT_CODE_ID= " + EVT_CODE;
                  } else {
                      layerDefs2[nonbillablelayer] = "WORK_AREA_ID= " + WA_ID;
                      layerDefs2[trimlayer] = "WORK_AREA_ID= " + WA_ID;
                      layerDefs2[climblayer] = "WORK_AREA_ID= " + WA_ID;
                      layerDefs2[skippedlayer] = "WORK_AREA_ID= " + WA_ID;
                  }

                  try {
                      imageParameters2.layerDefinitions = layerDefs2;                      
                      imageParameters2.layerIds = [nonbillablelayer, trimlayer, climblayer, skippedlayer];
                      imageParameters2.layerOption = ImageParameters.LAYER_OPTION_SHOW;
                      imageParameters2.transparent = true;

                      

                      //construct ArcGISDynamicMapServiceLayer with imageParameters from above
                      var serviceNew = "<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_TRIM_LINES_COMPANY"].ToString() %>";
                      var dynamicMapServiceLayer2 = new ArcGISDynamicMapServiceLayer(serviceNew, {"imageParameters": imageParameters2 });
                      map.addLayer(dynamicMapServiceLayer2);
                  }
                  catch (e) {
                      alert("Error Message: " + e.message);
                 }


                 

               
                  document.getElementById('chkbmt').onclick = function () {
                     
                      

                  }


                  document.getElementById('chkbmtt').onclick = function () {

                      BindTransmissionLayer();

                  }

                  function BindDistributionLayer()
                  {
                      if (document.getElementById('chkbmt').checked == true) {
                          imageParametersbmt = new ImageParameters();
                          imageParametersbmt.format = "jpeg"; //set the image type to PNG24, note default is PNG8.

                          //Takes a URL to a non cached map service.
                          dynamicMapServiceLayerbmt = new ArcGISDynamicMapServiceLayer(dynamicurlbmt, {
                              "opacity": 0.5,
                              visible: true,
                              "imageParameters": imageParametersbmt
                          });

                      }
                      else {
                          dynamicMapServiceLayerbmt.setVisibility();

                      }

                      map.addLayer(dynamicMapServiceLayerbmt);
                  }

                  function BindTransmissionLayer()
                  {
                      if (document.getElementById('chkbmtt').checked == true) {

                          imageParametersbmtt = new ImageParameters();
                          imageParametersbmtt.format = "jpeg"; //set the image type to PNG24, note default is PNG8.

                          //Takes a URL to a non cached map service.
                          dynamicMapServiceLayerbmtt = new ArcGISDynamicMapServiceLayer(dynamicurlbmtt, {
                              "opacity": 0.5,
                              visible: true,
                              "imageParameters": imageParametersbmtt
                          });

                      }
                      else {
                          dynamicMapServiceLayerbmtt.setVisibility();

                      }

                      map.addLayer(dynamicMapServiceLayerbmtt);
                  }

                  function AddDynamiclayer(imageParameters, dynamicMapServiceLayer, durl) {
                      imageParameters = new ImageParameters();
                      imageParameters.format = "jpeg"; //set the image type to PNG24, note default is PNG8.

                      //Takes a URL to a non cached map service.
                       dynamicMapServiceLayer = new ArcGISDynamicMapServiceLayer(durl, {
                          "opacity": 0.5,
                          "imageParameters": imageParameters
                      });

                      map.addLayer(dynamicMapServiceLayer);
                  };

              }



          )



        }

          ;
    </script>
</head>

<body>

    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" EnablePageMethods="true"></asp:ScriptManager>

        <%--  <asp:updatepanel id="UpdatePanel1" runat="server" EnableViewState="true"> 
             <ContentTemplate>--%>

        <div id="leftPane" style="height: 85px;"
            data-dojo-type="dijit/layout/ContentPane"
            data-dojo-props="region:'left'">
            Enter an address then click locate. 
        <br />
            <input type="text" id="address" style="width: 227px;" />
            <button id="locate" data-dojo-type="dijit/form/Button" style="width: 65px; height: 16px;">Locate</button>

            <select style="margin: 4px; color: #ff8400;" onchange="Mapview(this.value)">
                <option value="Road">Bing: Road</option>
                <option value="Aerial">Bing: Aerial</option>
                <option value="Aerialp">Bing: Aerial+</option>
            </select>
            <%-- History--%>
            <input type="checkbox" id="chkHist" style="visibility: collapse" />
            <asp:CheckBox ID="chkbmt" runat="server" />Show Distribution Map
        <br />
            <label id="lblPjt" style="color: #00008B;">PROJECT/EVENT: </label>

            <%-- <label id="lblPjtValue"></label> --%>
            <asp:DropDownList ID="ddl_EventCode" runat="server" AutoPostBack="True" OnDataBound="ddl_EventCode_DataBound" OnSelectedIndexChanged="ddl_EventCode_SelectedIndexChanged">
            </asp:DropDownList>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<asp:CheckBox ID="chkbmtt" runat="server" />Show Transmision Map
              <br />
            <label id="lbl_WA" style="color: #00008B; width: 103px; margin-top: 5px; display: inline-block;">WA/SECTION: </label>
            <asp:DropDownList ID="ddl_WorkArea" runat="server" AutoPostBack="True">
            </asp:DropDownList>
            <br />
            <%-- <label id="lblWa" runat="server" style="color:#00008B;" >SECTION/WA: </label>
        <label id="lblWaValue" runat="server" style="margin: 22px;"></label>   --%>
            <!--<input id="btnForIEZoom" type="submit" style="display:block;font-weight: bold;" />-->

        </div>



        <%--</ContentTemplate>
        </asp:updatepanel>--%>
        <div id="navToolbar" data-dojo-type="dijit/Toolbar" style="width: 44px; position: absolute; z-index: 2; margin: 100px 100px 1px 15px; background-color: white; border: solid 1px; border-radius: 8px;">
            <div data-dojo-type="dijit/form/Button" id="zoomin" style="width: 34px; float: left; margin: 5px;">
                <img src="resource_gallery/graphics/zoomin.png" alt="Zoom in" class="MapNavIcon" /></div>
            <div data-dojo-type="dijit/form/Button" id="zoomout" style="width: 34px; float: left; margin: 5px;">
                <img src="resource_gallery/graphics/zoomout.png" alt="Zoom Out" class="MapNavIcon" /></div>
            <div data-dojo-type="dijit/form/Button" id="zoomfullext" style="width: 34px; float: left; margin: 5px;">
                <img src="resource_gallery/graphics/fullextent.png" alt="Full Extent" class="MapNavIcon" /></div>
            <div data-dojo-type="dijit/form/Button" id="zoomprev" style="width: 34px; float: left; margin: 5px;">
                <img src="resource_gallery/graphics/prev.png" alt="Prev Extent" class="MapNavIcon" /></div>
            <div data-dojo-type="dijit/form/Button" id="zoomnext" style="width: 34px; float: left; margin: 5px;">
                <img src="resource_gallery/graphics/next.png" alt="Next Extent" class="MapNavIcon" /></div>
            <div data-dojo-type="dijit/form/Button" id="pan" style="width: 34px; float: left; margin: 5px;">
                <img src="resource_gallery/graphics/hand.png" alt="Pan" class="MapNavIcon" /></div>
            <!-- <div data-dojo-type="dijit/form/Button" id="deactivate"><img src="images/zoomin.png" alt="Deactivate" /></div>-->
        </div>
        <div id="map" style="width: 100%; height: 100%; z-index: 0;">
        </div>
        <asp:HiddenField ID="hdnEventCode" runat="server" />
        <asp:HiddenField ID="hdnWworkArea" runat="server" />


    </form>
</body>
</html>
