﻿<%@ Page Language="C#" AutoEventWireup="true" EnableEventValidation="false" CodeBehind="FlightIssueMapView.aspx.cs" Inherits="VMT.FlightIssueMapView" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta content="IE=Edge" http-equiv="X-UA-Compatible" />
    <title></title>
    <style type="text/css">
        html, body {
            height: 100%;
        }
        .wrapper {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        html > body .wrapper {
            height: 100%;
            /*overflow: hidden;*/
        }

        .wrapperRow {
            display: table-row;
        }

            .wrapperRow.wrapperExpand {
                height: 100%;
            }

        .weapperCell {
            display: table-cell;
            height: 100%;
        }

        .top {
            height: 70px;
        }

        .Tool {
            height: 30px;
        }

        .lightblue {
            background: lightblue;
        }

        .content {
            background: white;
        }



        /*body {

    

    font-family: Arial, Verdana, 'Times New Roman';

    font-size: 11px;

    background:#fff url('') no-repeat center center fixed;

    overflow:hidden;

    -webkit-background-size: cover;

    -moz-background-size: cover;

    -o-background-size: cover;

    background-size: cover;  

    padding: 0;   

    }*/






        #TopTitle {
            position: relative;
            top: 0;
            left: 0;
            height: 50px;
        }

        #MapIconBar {
            position: relative;
            top: 0;
            left: 0;
            height: 50px;
            background-color: #f1f1f1;
            border: 1px solid #ccc;
        }

        #map {
            width: 100%;
            position: absolute;
            background-color: white;
            height: 100%;
            z-index: 0;
            z-index: -1\9;
        }

        .container {
            position: relative;
            /*height: 100%;*/
        }









        /*.rightcontainer 

        {

          width:400px; 
          position:inherit;  
          float:right;        

          background-color:#fff;          

          z-index:10000;   
          height: 98.5%;       
          display:none;

          border: solid 1px #336666;

          padding: 2px 2px 2px 2px;         

          overflow-y:auto;

           

        }*/



















        .Togglebuttonright {
            position: absolute;
            margin: 1px 0px 0px 0px;
            z-index: 2000;
        }


        .RightTitle {
            float: right;
            margin : 0px,14px,170px,6px;
        }

        .TopRightTitle {
            float: right;
            width: 290px;
            margin: 24px 0px 0px 0px;
        }

        .TopLeftTitle {
            float: left;
            width: 295px;
            margin: 24px 0px 0px 0px;
        }




        .Level1Box {
            width: 263px;
            margin: 3px 3px 0px 0px;
            background-color: white;
            border: 1px solid #c4c4c4;
            padding: 2px 2px 2px 2px;
        }

        .Level1BoxNoColor {
            width: 223px;
            margin: 3px 3px 0px 0px;
            border: 1px solid #c4c4c4;
            padding: 2px 2px 2px 2px;
        }

        .BoxHeader {
            margin: 4px 2px 4px 2px;
            font-family: 'Arial Rounded MT', Verdana, Arial, 'Times New Roman';
            font-size: 10px;
            font-weight: bold;
            color: #012012;
        }

        .btn {
            border: none;
            color: white;
            padding: 10px 13px;
            text-align: center;
            display: inline-block;
            font-size: 13px;
            cursor: pointer;
            border-radius: 4px;
        }

        .button {
            border: none;
            color: white;
            padding: 3px 6px;
            text-align: center;
            display: inline-block;
            font-size: 13px;
            cursor: pointer;
            border-radius: 4px;
        }

        .info {
            background-color: #4CAF50;
        }
            /* Green */
            .info:hover {
                background-color: #46a049;
            }

        .alert {
            background-color: #2196F3;
        }
            /* Blue */
            .alert:hover {
                background: #0b7dda;
            }

        .warning {
            background-color: #ff9800;
        }
            /* Orange */
            .warning:hover {
                background: #e68a00;
            }

        .danger {
            background-color: #f44336;
        }
            /* Red */
            .danger:hover {
                background: #da190b;
            }

        .default {
            background-color: #e7e7e7;
            color: black;
        }
            /* Gray */
            .default:hover {
                background: #ddd;
            }
        /*search box css*/
        /*#floating-panel {
            position: absolute;
            top: 10px;
            right:5%;
            z-index: 5;
            background-color: #fff;
            padding: 5px;
            border: 1px solid #999;
            text-align: center;
            font-family: 'Roboto','sans-serif';
            line-height: 30px;
            padding-left: 10px;
        }*/

        /*Side panel*/
        #lefthidden_content {
            position: absolute;
            left: -300px;
            width: 300px;
            /*height: 800px;*/
            background-color: #fff;
        }

        #righthidden_content {
            position: absolute;
            right: -200px;
            width: 200px;
            height: 800px;
            background-color: #fff;
        }

        .Table {
            display: table;
        }

        .Row {
            display: table-row;
        }

        .Cell {
            display: table-cell;
            /*border: solid;
            padding-left: 5px;
            padding-right: 2px;*/
            border-width: thin;
            padding-top: 2px;
        }

        .hiddencol {
            display: none;
        }
    </style>

    <!-- Tab -->
    <link rel="stylesheet" type="text/css" href="resource_gallery/css/tabbed-pannels.css" />

    <!-- Slide -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
    <script type="text/javascript">


        $(document).ready(function () {
            $("#Link3").toggle(function () {
                $(this).text('<<');
                $("#lefthidden_content").animate({ left: "0px" }, 500);
            }, function () {
                $(this).text('>>');
                $("#lefthidden_content").animate({ left: "-300px" }, 500);
            })

            $("#Link4").toggle(function () {
                $(this).text('>>');
                $("#righthidden_content").animate({ right: "0px" }, 500);
            }, function () {
                $(this).text('<<');
                $("#righthidden_content").animate({ right: "-200px" }, 500);
            })
        });

    </script>


    <!-- Map -->
    <link rel="stylesheet" href="http://js.arcgis.com/3.12/esri/css/esri.css" />
    <style type="text/css">
        @import "http://js.arcgis.com/3.12/dijit/themes/claro/claro.css";

        html, body, form, #map {
            height: 100%;
            width: 100%;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, Verdana, 'Times New Roman';
            font-size: 13px;
            background: #fff url('') no-repeat center center fixed;
            overflow: hidden;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
            margin: 2px;
            padding: 0;
        }

        .rowcolor {
            background-color: gray;
        }
    </style>
    <script type="text/javascript">

        function Mapview(v) {
            //To Do
            switch (v) {
                case "Road":
                    //Road
                    veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD); return false;
                    break;
                case "Aerial":
                    //Aerial
                    veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL); return false;
                    break;
                case "Aerialp":
                    //Aerial with Label
                    veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL_WITH_LABELS); return false;
                    break;
            }
        };

    </script>
    <script src="http://js.arcgis.com/3.12/"></script>
    <script type="text/javascript">        
        var map, map1, map2, featureLayer, defaultSymbol, highlightSymbol, resultTemplate;
        var grap, graphicS, symbolS;
        var selectionToolbar;

        var imageParametersbmt;
        var dynamicMapServiceLayerbmt;
        var dynamicurlbmt = "<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_BASEMAP_DIST"].ToString() %>";

        var imageParametersbmtt;
        var dynamicMapServiceLayerbmtt;
        var dynamicurlbmtt = "<%= System.Configuration.ConfigurationManager.AppSettings["Dynamic_MapService_BASEMAP_TRANS"].ToString() %>";



      

        var flightUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_Flight_Issues"].ToString() %>";
        var trimUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_Trim_Dist_Lines"].ToString() %>";
        var distUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_Gas_Dist_Lines"].ToString() %>";
        var tranUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_Gas_Trans_Lines"].ToString() %>";





        require([
          "esri/map",
          "esri/tasks/locator",
          "esri/graphic",
          "esri/toolbars/navigation",
          "esri/toolbars/draw",
          "dojo/on",
          "esri/tasks/QueryTask",
          "esri/tasks/query",

          "esri/InfoTemplate",
          "esri/symbols/SimpleMarkerSymbol",
          "dojo/_base/array",
          "esri/symbols/TextSymbol",
          "esri/Color",
          "esri/symbols/Font",
          "esri/layers/ArcGISDynamicMapServiceLayer",
          "esri/layers/ImageParameters",
          "dojo/parser",
          "esri/SpatialReference",
          "dojo/dom",
          "dijit/registry",
           "esri/virtualearth/VETiledLayer",
          "dijit/Toolbar",

          "esri/layers/FeatureLayer",
          "dijit/form/Button",
          "dojo/number",
          "dijit/form/Textarea",
          "dijit/layout/BorderContainer",
          "dijit/layout/ContentPane",
          "dojo/domReady!"
        ],
          function (
              Map,
              Locator,
              Graphic,
              Navigation,
              Draw,
              on,
              QueryTask,
              Query,
              InfoTemplate,
              SimpleMarkerSymbol,
              arrayUtils,
              TextSymbol,
              Color,
              Font,
              ArcGISDynamicMapServiceLayer,
              ImageParameters,
              parser,
              SpatialReference,
              dom,
              registry,
              FeatureLayer,
              number

           ) {

              parser.parse();
              var navToolbar;

                  map = new Map("map", {
                      basemap: "streets",
                      center: [-81.0324, 33.9897],
                      spatialReference: { wkid: 4269 },
                      zoom: 15,
                      setDisableClientCaching: true
                  });

                  map.on("load", initSelectToolbar);                  
                 
                  $("#btnRemove").css({ display: "none" });

                  veTileLayer = new esri.virtualearth.VETiledLayer({
                       bingMapsKey: '<%=ConfigurationManager.AppSettings["bingMapKey"].ToString() %>',
                      mapStyle: esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD
                  });
                  map.addLayer(veTileLayer);

                  navToolbar = new Navigation(map);
                  on(navToolbar, "onExtentHistoryChange", extentHistoryChangeHandler);

                  registry.byId("zoomin").on("click", function () {
                      navToolbar.activate(Navigation.ZOOM_IN);
                  });

                  registry.byId("zoomout").on("click", function () {
                      navToolbar.activate(Navigation.ZOOM_OUT);
                  });

                  registry.byId("zoomfullext").on("click", function () {
                      navToolbar.zoomToFullExtent();
                  });

                  registry.byId("zoomprev").on("click", function () {
                      navToolbar.zoomToPrevExtent();
                  });

                  registry.byId("zoomnext").on("click", function () {
                      navToolbar.zoomToNextExtent();
                  });

                  registry.byId("pan").on("click", function () {
                      navToolbar.activate(Navigation.PAN);
                  });

                  registry.byId("select").on("click", function () {
                      //set drawing mode to extent
                      selectionToolbar.activate(esri.toolbars.Draw.EXTENT);
                  });

                  map.on("zoom-end", function () {
                      navToolbar.deactivate();
                  });

                  locator = new Locator("http://geocode.arcgis.com/arcgis/rest/services/World/GeocodeServer");
                  locator.on("address-to-locations-complete", showResults);
                  // listen for button click then geocode
                  registry.byId("locate").on("click", locate);
                  function locate() {
                      try {
                          map.graphics.clear();
                          var address = {
                              "SingleLine": dom.byId("address").value
                          };
                          locator.outSpatialReference = map.spatialReference;

                          var options = {
                              address: address,
                              outFields: ["Loc_name"]
                          };

                          locator.addressToLocations(options);

                      }
                      catch (e) {
                          alert("Error Message: " + e.message);
                      }
                  }

                  function showResults(evt) {
                      try {

                          var symbol = new SimpleMarkerSymbol();

                          var infoTemplate = new InfoTemplate(
                            "Location",
                            "Address: ${address}<br />Score: ${score}<br />Source locator: ${locatorName}"
                          );

                          symbol.setStyle(SimpleMarkerSymbol.STYLE_SQUARE);

                          symbol.setColor(new Color([153, 0, 51, 0.75]));

                          var geom;



                          arrayUtils.every(evt.addresses, function (candidate) {
                              console.log(candidate.score);

                              if (candidate.score > 80) {
                                  console.log(candidate.location);
                                  var attributes = {
                                      address: candidate.address,
                                      score: candidate.score,
                                      locatorName: candidate.attributes.Loc_name
                                  };
                                  geom = candidate.location;
                                  var graphic = new Graphic(geom, symbol, attributes, infoTemplate);
                                  //add a graphic to the map at the geocoded location

                                  map.graphics.add(graphic);
                                  //add a text symbol to the map listing the location of the matched address.
                                  var displayText = candidate.address;

                                  var font = new Font(
                                    "16pt",
                                    Font.STYLE_NORMAL,
                                    Font.VARIANT_NORMAL,
                                    Font.WEIGHT_BOLD,
                                    "Helvetica"
                                  );
                                  var textSymbol = new TextSymbol(
                                    displayText,
                                    font,
                                    new Color("#666633")
                                  );
                                  textSymbol.setOffset(0, 8);
                                  map.graphics.add(new Graphic(geom, textSymbol));

                                  return false; //break out of loop after one candidate with score greater  than 80 is found.
                              }
                          });



                          if (geom !== undefined) {
                              map.centerAndZoom(geom, 14);
                          }



                      }
                      catch (e) {
                          alert("Error Message: " + e.message);
                      }

                  }
                                   

                  function extentHistoryChangeHandler() {
                      registry.byId("zoomprev").disabled = navToolbar.isFirstExtent();
                      registry.byId("zoomnext").disabled = navToolbar.isLastExtent();
                  }

                  //initialize select toolbar
                  function initSelectToolbar(event) {
                      selectionToolbar = new esri.toolbars.Draw(event.map);
                      var selectQuery = new esri.tasks.Query();

                      on(selectionToolbar, "DrawEnd", function (geometry) {
                          selectionToolbar.deactivate();
                          selectQuery.geometry = geometry;
                          featureLayer.selectFeatures(selectQuery,
                            FeatureLayer.SELECTION_NEW);
                      });

                     
                  }

                  document.getElementById('chkElecLine').onclick = function () {

                      if (document.getElementById('chkElecLine').checked == true) {

                          imageParametersbmt = new ImageParameters();
                          imageParametersbmt.format = "jpeg"; //set the image type to PNG24, note default is PNG8.

                          //Takes a URL to a non cached map service.
                          dynamicMapServiceLayerbmt = new ArcGISDynamicMapServiceLayer(dynamicurlbmt, {
                              "opacity": 0.5,
                              visible: true,
                              "imageParameters": imageParametersbmt
                          });

                      }
                      else {
                          dynamicMapServiceLayerbmt.setVisibility();

                      }

                      map.addLayer(dynamicMapServiceLayerbmt);

                  }


                  document.getElementById('chkbmtt').onclick = function () {

                      if (document.getElementById('chkbmtt').checked == true) {

                          imageParametersbmtt = new ImageParameters();
                          imageParametersbmtt.format = "jpeg"; //set the image type to PNG24, note default is PNG8.

                          //Takes a URL to a non cached map service.
                          dynamicMapServiceLayerbmtt = new ArcGISDynamicMapServiceLayer(dynamicurlbmtt, {
                              "opacity": 0.5,
                              visible: true,
                              "imageParameters": imageParametersbmtt
                          });

                      }
                      else {
                          dynamicMapServiceLayerbmtt.setVisibility();

                      }

                      map.addLayer(dynamicMapServiceLayerbmtt);

                  }
                  function AddFeaturewithnoPopup(feature_layer) {
                      //info template for points returned
                      resultTemplate = new esri.InfoTemplate("SEQUENCER", "${SEQUENCER}");

                      var featureLayerUrl = feature_layer;
                      featureLayer = new esri.layers.FeatureLayer(featureLayerUrl, {
                          mode: esri.layers.FeatureLayer.MODE_ONDEMAND,
                          infoTemplate: resultTemplate,
                          outFields: ["OBJECTID", "SEQUENCER"]
                      });


                      //on selection of the region
                      featureLayer.on("selection-complete", findPointsInExtent);
                      map.addLayer(featureLayer);
                  }


                  if (document.getElementById('chkFlight').checked == true) {
                      AddFeaturewithnoPopup(flightUrl);
                  }


                  //For displaying message
                  map.on("click", function (event) {
                      map.infoWindow.hide();//To hide infotemplate 
                      var graphic = event.graphic;
                      if (graphic == undefined) {
                          return;
                      }

                      if (graphic.attributes != undefined) {
                          var sequencer = graphic.attributes.SEQUENCER;
                      }                     
                     

                      $(function () {
                          $.ajax({
                              type: "POST",
                              url: "FlightIssueMapView.aspx/GetSequencerDetails",
                              data: '{Sequencer:"' + sequencer + '"}',
                              contentType: "application/json; charset=utf-8",
                              dataType: "json",
                              success: OnSuccess,
                              failure: function (response) {
                                  alert(response.responseText);
                              },
                              error: function (response) {
                                  alert(response.responseText);
                              }
                          });
                      });

                      function OnSuccess(response) {
                          var records = $.parseJSON(response.d);
                          for (var i = 0; i < records.length; i++) {
                              alert(records[i].IDESC);
                          }
                      }
                  });

                  //
                  var trimlinelayer = new esri.layers.FeatureLayer(trimUrl, {
                      mode: esri.layers.FeatureLayer.MODE_ONDEMAND,
                      infoTemplate: resultTemplate,
                      outFields: ["OBJECTID", "SEQUENCER"]
                  });

                  var distlinelayer = new esri.layers.FeatureLayer(distUrl, {
                      mode: esri.layers.FeatureLayer.MODE_ONDEMAND,
                      infoTemplate: resultTemplate,
                      outFields: ["OBJECTID", "SEQUENCER"]
                  });

                  var tranlinelayer = new esri.layers.FeatureLayer(tranUrl, {
                      mode: esri.layers.FeatureLayer.MODE_ONDEMAND,
                      infoTemplate: resultTemplate,
                      outFields: ["OBJECTID", "SEQUENCER"]
                  });

                  document.getElementById('chkTrimLine').onclick = function () {
                      if (document.getElementById('chkTrimLine').checked == true) {
                          map.addLayer(trimlinelayer);
                      }
                      else {
                          map.removeLayer(trimlinelayer);
                      }
                  }
                  document.getElementById('chkGasDist').onclick = function () {
                      if (document.getElementById('chkGasDist').checked == true) {
                          map.addLayer(distlinelayer);
                      }
                      else {
                          map.removeLayer(distlinelayer);
                      }
                  }

                  document.getElementById('chkGasTran').onclick = function () {
                      if (document.getElementById('chkGasTran').checked == true) {
                          map.addLayer(tranlinelayer);
                      }
                      else {
                          map.removeLayer(tranlinelayer);
                      }
                  }                    
                  
              });
          
        //Top Filter Checkbox Click
        function onFilterClick() {
            InspectionGroupChange();
        }
        // Top Filter Dropdown Onchange
        function InspectionGroupChange() {
            var InspGrp = $('#ddlInspSubType').val();
            //Condition in feature layer
            //if (InspGrp != 0) {
            if (document.getElementById('chkFilter').checked == true) {
                featureLayer.setDefinitionExpression("INSPECTIONSUBTYPE = '" + InspGrp + "'");
            }
            else {
                featureLayer.setDefinitionExpression("INSPECTIONSUBTYPE <> '0'");
            }
        }

        //For creating circles outside flight
        function LoadNewLayer() {
            var firstlat, firstlan, firstsequencer;
            var str = '';
            var gvDrv = document.getElementById("<%=gdv_list.ClientID %>");
            if (gvDrv.rows.length > 0) {
                for (i = 0; i < gvDrv.rows.length; i++) {
                    var cell = gvDrv.rows[i].cells;
                    var strval = cell[0].innerHTML;
                    str = str + strval + ',';
                }


                str = str.substring(0, str.length - 1);

                map.graphics.clear();  //use the maps graphics layer as the highlight layer

                try {
                    //Define a new Query and QueryTask 
                    queryTask = new esri.tasks.QueryTask(flightUrl);
                    query = new esri.tasks.Query();
                    query.returnGeometry = true;
                    query.outFields = ["*"];

                    //The query's where clause will be attribute query to find the feature  
                    query.where = "SEQUENCER  IN (" + str + ")";

                    query.outSpatialReference = map.spatialReference;
                    //Run the query. Its results are returned in the function showResults  
                    queryTask.execute(query, showResults1);

                    //info template for points returned
                    resultTemplate = new esri.InfoTemplate("SEQUENCER", "${SEQUENCER}");



                    //results is an array of any found features. Assuming you only want the first feature:  
                    function showResults1(results) {
                        try {
                            //var result = results.features[0];
                            //var extent = result.geometry.getExtent();//.expand(5.2);
                            //// map.setExtent(extent);

                            //firstlat = result.attributes.X;
                            //firstlan = result.attributes.Y;
                            //firstsequencer = result.attributes.SEQUENCER;
                            ////var myFeatureExtent = esri.graphicsExtent(results.features);
                            ////map.setExtent(myFeatureExtent.expand(0.5));
                        }
                        catch (e) {
                            //alert("Error Message: " + e.message);
                        }


                        try {

                            //create symbol for selected features                      

                            symbolS = new esri.symbol.SimpleMarkerSymbol(esri.symbol.SimpleMarkerSymbol.STYLE_CIRCLE, 24,
                                 new esri.symbol.SimpleLineSymbol(esri.symbol.SimpleLineSymbol.STYLE_SOLID,
                                 new esri.Color([0, 0, 255]), 2.5),
                                 new esri.Color([0, 255, 0, 0.25]));

                            //Performance enhancer - assign featureSet array to a single variable.
                            var resultFeatures = results.features;

                            //Loop through each feature returned
                            for (var i = 0, il = resultFeatures.length; i < il; i++) {
                                //Get the current feature from the featureSet.
                                //Feature is a graphic
                                graphicS = resultFeatures[i];
                                graphicS.setSymbol(symbolS);
                                graphicS.setInfoTemplate(resultTemplate);
                                //Add graphic to the map graphics layer.
                                map.graphics.add(graphicS);
                            }
                        }
                        catch (e) {
                            //alert("Error Message: " + e.message);
                        }

                    }
                }
                catch (e) {
                    //alert("Error Message: " + e.message);
                }
            }
        }

        function ConfirmStatusMessage() {
            var selectedvalue = $('#<%= rblStatus.ClientID %> input:checked').val();
            var sequencer = document.getElementById("hfSequencer").value;
            if (selectedvalue == "0") {
                var x = confirm("Are you sure you want to update all?");
                if (x) {
                    UpdateAllStatus();
                    if (sequencer > 0) {
                        LoadDetailsAssignStatus(sequencer);
                    }
                    //Reload the gridtable after updation
                    ReloadGridTable();
                    return true;
                }
                else
                    return false;
            }
            else {
                return true;
            }
        }

        function ConfirmAssignMessage() {
            var selectedvalue = $('#<%= rblAssign.ClientID %> input:checked').val();
            var sequencer = document.getElementById("hfSequencer").value;
            if (selectedvalue == "0") {
                var x = confirm("Are you sure you want to assign all?");
                if (x) {
                    UpdateAllAssign();
                    if (sequencer > 0) {
                        LoadDetailsAssignStatus(sequencer);
                    }
                    //Reload the gridtable after updation
                    ReloadGridTable();
                    return true;
                }
                else
                    return false;
            }
            else {
                return true;
            }
        }


        function UpdateAllAssign() {
            var str = '';
            var AssignTo = $('#ddlAssignedTo').val();
            var Crew = $('#ddlCrew').val();
            if (Crew == 0) {
                alert("Please Select Crew.");
                return false;
            }
            var DueDt = $('#txtInspDueDt').val();
            var gvDrv = document.getElementById("<%=gdv_list.ClientID %>");
            if (gvDrv.rows.length > 0) {
                for (i = 0; i < gvDrv.rows.length; i++) {
                    var cell = gvDrv.rows[i].cells;
                    var strval = cell[0].innerHTML;
                    str = str + strval + ',';
                }
            }
            str = str.substring(0, str.length - 1);
            $.ajax({
                type: "POST",
                contentType: "application/json; charset=utf-8",
                url: "FlightIssueMapView.aspx/UpdateAllAssign",
                data: "{Sequencer:'" + str + "',Company:'" + AssignTo + "',InspDueDt:'" + DueDt + "',Crew:'" + Crew + "'}",
                dataType: "json",
                success: function (data) {
                    if (data.d == 1)
                        alert('Update successful');
                },
                error: function (data) {
                    var r = data.responseText;
                    var errorMessage = r.Message;
                    alert(errorMessage);
                }
            });
        }

        function UpdateAllStatus() {
            var str = '';
            var StatusId = $('#ddlUpdatedStatus').val();
            var gvDrv = document.getElementById("<%=gdv_list.ClientID %>");
            if (gvDrv.rows.length > 0) {
                for (i = 0; i < gvDrv.rows.length; i++) {
                    var cell = gvDrv.rows[i].cells;
                    var strval = cell[0].innerHTML;
                    str = str + strval + ',';
                }
            }
            str = str.substring(0, str.length - 1);
            $.ajax({
                type: "POST",
                contentType: "application/json; charset=utf-8",
                url: "FlightIssueMapView.aspx/UpdateAllStatus",
                data: "{Sequencer:'" + str + "',UpdStatus:'" + StatusId + "'}",
                dataType: "json",
                success: function (data) {
                    if (data.d == 1)
                        alert('Update successful')
                },
                error: function (data) {
                    var r = data.responseText;
                    var errorMessage = r.Message;
                    alert(errorMessage);
                }
            });
        }

        //find all points within argument extent
        function findPointsInExtent(event) {
            document.getElementById("hfSequencer").value = "";
            var result = '';
            var results = [];

            dojo.forEach(event.features, function (feature) {
                results.push(feature.attributes.SEQUENCER);
            });

            for (var j = 0; j < results.length; j++) {
                result += results[j] + ',';
            }

            result = result.substring(0, result.length - 1);
            $(function () {
                $.ajax({
                    type: "POST",
                    url: "FlightIssueMapView.aspx/GetSelectedSequencer",
                    data: "{Sequencer:'" + result + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: OnSuccess,
                    failure: function (response) {
                        alert(response.responseText);
                    },
                    error: function (response) {
                        alert(response.responseText);
                    }
                });
            });

            function OnSuccess(response) {
                try {
                    var xmlDoc = $.parseXML(response.d);
                    BindTable(xmlDoc);
                }
                catch (err) { }

            }
        }

        //Clear all contorls inside tab
        function ClearControls() {
            var ddlAssignedTo = document.getElementById("ddlAssignedTo");
            var ddlCrew = document.getElementById("ddlCrew");
            var ddlUpdatedStatus = document.getElementById("ddlUpdatedStatus");
            ddlAssignedTo.selectedIndex = 0;
            ddlCrew.selectedIndex = 0;
            ddlUpdatedStatus.selectedIndex = 0;
            document.getElementById('txtInspDueDt').value = "";
            document.getElementById('lblCrew').innerHTML = '';
            document.getElementById('lblSCEGNote').innerHTML = '';
            document.getElementById('lblFlagID').innerHTML = '';
            document.getElementById('lblContractor').innerHTML = '';
            document.getElementById('lblContractorNote').innerHTML = '';
            document.getElementById('lblAssignedTo').innerHTML = '';
            document.getElementById('lblAssignedDate').innerHTML = '';
            document.getElementById('lblTreeCnt').innerHTML = '';
            document.getElementById('lblLastUpdatedBy').innerHTML = '';
            document.getElementById('lblLastUpdatedOn').innerHTML = '';
            document.getElementById('lblCurrentStatus').innerHTML = '';
            document.getElementById("hfSequencer").value = "";
        }

        //Bind Gridview
        function BindGridview() {
            ClearControls();
            var EventCodeId = $('#ddlEventCode').val();
            var WorkAreaId = $('#ddlWorkArea').val();
            var InspSubType = $('#ddlInspSubType').val();
            var IssueType = $('#ddlIssueType').val();
            var IssueSubType = $('#ddlIssueSubType').val();
            var StatusId = $('#ddlIssueStatus').val();
            var AssignedTo = $('#ddlIssueAssignedTo').val();
            var FromDt = $('#txtFromDt').val();
            var ToDt = $('#txtToDt').val();

            if (document.getElementById('chkDate').checked == true) {
                if (FromDt == '') {
                    alert("Please select creation from date.");
                    return;
                }
                if (ToDt == '') {
                    alert("Please select creation to date.");
                    return;
                }
            }
            else {
                document.getElementById('txtFromDt').value = "";
                document.getElementById('txtToDt').value = "";
                FromDt = '';
                ToDt = '';
            }

            $(function () {
                $.ajax({
                    type: "POST",
                    url: "FlightIssueMapView.aspx/ReturnSearchResult",
                    data: "{eventCodeId:'" + EventCodeId + "',workAreaId:'" + WorkAreaId + "',inspSubType:'" + InspSubType + "',issueId:'" + IssueType + "',issueSubTypeId:'" + IssueSubType + "',issueStatusId:'" + StatusId + "',issueAssignedTo:'" + AssignedTo + "',frmdt:'" + FromDt + "',todt:'" + ToDt + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: OnSuccessGo,
                    failure: function (response) {
                        alert(response.responseText);
                    },
                    error: function (response) {
                        alert(response.responseText);
                    }
                });
            });

            function OnSuccessGo(response) {
                try {
                    var xmlDoc1 = $.parseXML(response.d);
                    BindTable(xmlDoc1);
                }
                catch (err) { }
            }
        }

        function BindTable(xmlDoc1) {
            var sequencer, lat, lang, point;
            var xml1 = $(xmlDoc1);
            var customers1 = xml1.find("Table");
            var row1 = $("[id*=gdv_list] tr:last-child").clone(true);
            $("[id*=gdv_list] tr").remove();
            //Remove tblblank css class from gridview
            //var el = document.getElementById("gdv_list");
            //el.classList.remove("rowcolor");
            $.each(customers1, function () {
                var customer1 = $(this);
                $("td", row1).eq(0).html($(this).find("SEQUENCER").text());
                $("td", row1).eq(1).html($(this).find("IDESC").text());
                $("td", row1).eq(2).html($(this).find("X").text());
                $("td", row1).eq(3).html($(this).find("Y").text());
                $("[id*=gdv_list]").append(row1);
                row1 = $("[id*=gdv_list] tr:last-child").clone(true);
            });

            //Added new row with No Records for blank grid
            var GridId = "<%=gdv_list.ClientID %>";
            var grid = document.getElementById(GridId);
            rowscount = grid.rows.length;
            if (rowscount == 0) {
                //document.getElementById("btnRemove").style.display = 'none';
                $("#btnRemove").css({ display: "none" });
                //$('#btnRemove').hide();
            } else {
                //document.getElementById("btnRemove").style.display = 'block';
                $("#btnRemove").css({ display: "block" });
                //$('#btnRemove').show();
            }

            var rowTemplate = "<tr><td class=hiddencol></td><td>No Records.</td><td class=hiddencol></td><td class=hiddencol></td></tr>";
            $("#lblNoRecords").text(rowscount + ' Records');
            if (rowscount == 0) {
                $("[id*=gdv_list]").append(rowTemplate);
                //clear the layers if there is no record in the grid
                map.graphics.clear();
                ClearControls();
            }
            else {
                LoadNewLayer();
                addRowHandlers();

                sequencer = $('#gdv_list tr:first-child td:first-child').text();
                lat = $('#gdv_list tr:first-child td:nth-child(3)').text();
                lang = $('#gdv_list tr:first-child td:nth-child(4)').text();
                //zoom
                //point = new esri.geometry.Point(lat, lang);
                //map.centerAndZoom(point, 14);

                //Set background color of the selected row after updation
                var seq = document.getElementById("hfSequencer").value;
                var gvDrv = document.getElementById("gdv_list");
                var rows = gvDrv.getElementsByTagName("tr");
                for (i = 0; i < rows.length; i++) {
                    rows[i].className = "";
                }
                if (gvDrv.rows.length > 0) {
                    for (i = 0; i < gvDrv.rows.length; i++) {
                        var cell = gvDrv.rows[i].cells;
                        var strval = cell[0].innerHTML;
                        if (strval == seq) {
                            rows[i].className = "rowcolor";
                        }
                    }
                }
                //end

                HighlightWithRedCircle(sequencer);
            }
        }

        function ReloadGridTable() {
            var InspSubType = $('#ddlInspSubType').val();
            var IssueType = $('#ddlIssueType').val();
            var IssueSubType = $('#ddlIssueSubType').val();
            var StatusId = $('#ddlIssueStatus').val();
            var AssignedTo = $('#ddlIssueAssignedTo').val();
            var FromDt = $('#txtFromDt').val();
            var ToDt = $('#txtToDt').val();

            $(function () {
                $.ajax({
                    type: "POST",
                    url: "FlightIssueMapView.aspx/ReturnSearchResult",
                    data: "{inspSubType:'" + InspSubType + "',issueId:'" + IssueType + "',issueSubTypeId:'" + IssueSubType + "',issueStatusId:'" + StatusId + "',issueAssignedTo:'" + AssignedTo + "',frmdt:'" + FromDt + "',todt:'" + ToDt + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: OnSuccessGo,
                    failure: function (response) {
                        alert(response.responseText);
                    },
                    error: function (response) {
                        alert(response.responseText);
                    }
                });
            });

            function OnSuccessGo(response) {
                try {
                    var xmlDoc1 = $.parseXML(response.d);
                    BindTable(xmlDoc1);
                }
                catch (err) { }
            }
        }

        //Add events to gridview rows
        function addRowHandlers() {
            var sequencer, lat, lang, point;
            //Add row clcick function to table
            var table = document.getElementById("gdv_list");
            var rows = table.getElementsByTagName("tr");
            sequencer = $('#gdv_list tr:first-child td:first-child').text();
            if (document.getElementById("hfSequencer").value == "") {
                document.getElementById("hfSequencer").value = sequencer;
            }
            
            //1st row background color
            //rows[0].className = "rowcolor";
            LoadDetailsAssignStatus(sequencer);

            for (i = 0; i < rows.length; i++) {
                var row = table.rows[i];
                row.onclick = function (myrow) {
                    return function () {                        
                        //remove all row background color
                        for (i = 0; i < rows.length; i++) {
                            rows[i].className = "";
                        }
                        //color the row on click
                        myrow.className = "rowcolor";
                        //get the cell values
                        var cell0 = myrow.getElementsByTagName("td")[0];
                        var cell2 = myrow.getElementsByTagName("td")[2];
                        var cell3 = myrow.getElementsByTagName("td")[3];
                        sequencer = cell0.innerHTML;
                        lat = cell2.innerHTML;
                        lang = cell3.innerHTML;
                        // alert(lat);
                        document.getElementById("hfSequencer").value = sequencer;

                        HighlightWithRedCircle(sequencer);

                        var extent = map.extent;
                        //queryTask = new esri.tasks.QueryTask(flightUrl);
                        //query = new esri.tasks.Query();
                        //query.returnGeometry = true;
                        //query.outFields = ["*"];

                        ////The query's where clause will be attribute query to find the feature  
                        //query.where = "SEQUENCER ='" + sequencer + "'";

                        //query.outSpatialReference = map.spatialReference;
                        ////Run the query. Its results are returned in the function showResults  
                        //queryTask.execute(query, showResultsRed);



                        ////results is an array of any found features. Assuming you only want the first feature:  
                        //function showResultsRed(results) {
                        //    try {

                                
                        //    }
                        //    catch (e) {
                        //        //alert("Error Message: " + e.message);
                        //    }
                        //}
                        //zoom
                        //point = new esri.geometry.Point(lat, lang);
                        //map.centerAndZoom(point, 14);

                        //Load Details,Assign and status
                        LoadDetailsAssignStatus(sequencer);


                    };
                }(row);
            }
        }

        function LoadDetailsAssignStatus(sequencer) {
            //PageMethods.GetAssignedTo(seq, OnSucceeded, OnFailed);
            //Select Assigned To Dropdown
            $(function () {
                $.ajax({
                    type: "POST",
                    url: "FlightIssueMapView.aspx/GetAssignedTo",
                    data: '{Sequencer:"' + sequencer + '"}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var strVal = response.d;
                        BindAssign(strVal);
                    },
                    failure: function (response) {
                        alert(response.responseText);
                    },
                    error: function (response) {
                        alert(response.responseText);
                    }
                });
            });

            //Select Status Dropdown
            $(function () {
                $.ajax({
                    type: "POST",
                    url: "FlightIssueMapView.aspx/GetSelectStatus",
                    data: '{Sequencer:"' + sequencer + '"}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var status = response.d;
                        BindStatus(status)
                    },
                    failure: function (response) {
                        alert(response.responseText);
                    },
                    error: function (response) {
                        alert(response.responseText);
                    }
                });
            });



            //Bind DETAIL labels
            $(function () {
                $.ajax({
                    type: "POST",
                    url: "FlightIssueMapView.aspx/getdetail",
                    data: '{Sequencer:"' + sequencer + '"}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var xmlDoc = $.parseXML(response.d);
                        BindDetail(xmlDoc);
                    },
                    failure: function (response) {
                        alert(response.responseText);
                    },
                    error: function (response) {
                        alert(response.responseText);
                    }
                });
            });
        }

        //Bind Status label
        function BindStatus(status) {
            //var selvalue = $('#<%= rblStatus.ClientID %> input:checked').val();
            //if (selvalue == "1") {
            $("#lblCurrentStatus").text(status);
            //}
        }

        //Bind Assign controls
        function BindAssign(strVal) {
            var strArr = strVal.split(',');
            var selvalue = $('#<%= rblAssign.ClientID %> input:checked').val();
            //if (selvalue == "1") {
            $("#txtInspDueDt").val(strArr[2]);
            $("#ddlAssignedTo").val(strArr[0]).change();
            $("#lblCrew").text(strArr[1]);
            //}
        }

        //Bind Details label
        function BindDetail(xmlDoc) {
            var xml = $(xmlDoc);
            var details = xml.find("Table");
            $.each(details, function () {
                var details = $(this);
                $("#lblSCEGNote").text($(this).find("NOTES").text());
                $("#lblFlagID").text($(this).find("FLAG_ID").text());
                $("#lblContractor").text($(this).find("COMPANY_NAME").text());
                $("#lblContractorNote").text($(this).find("CONTRACTOR_NOTES").text());
                $("#lblAssignedTo").text($(this).find("ASSIGNEDTO").text());
                $("#lblAssignedDate").text($(this).find("ASSIGNEDDATE").text());
                $("#lblTreeCnt").text($(this).find("TREE_COUNT").text());
                $("#lblLastUpdatedBy").text($(this).find("LAST_UPDATED_USER_ID").text());
                $("#lblLastUpdatedOn").text($(this).find("LAST_UPDATED_TIME_STAMP").text());
            });
        }
        //Border color red
        function HighlightWithRedCircle(Sequencer) {
            try {
                //Define a new Query and QueryTask 
                queryTask = new esri.tasks.QueryTask(flightUrl);
                query = new esri.tasks.Query();
                query.returnGeometry = true;
                query.outFields = ["*"];

                //The query's where clause will be attribute query to find the feature  
                query.where = "SEQUENCER ='" + Sequencer + "'";

                query.outSpatialReference = map.spatialReference;
                //Run the query. Its results are returned in the function showResults  
                queryTask.execute(query, showResultsRed);



                //results is an array of any found features. Assuming you only want the first feature:  
                function showResultsRed(results) {
                    try {

                        //create symbol for selected features                      

                        var symb = new esri.symbol.SimpleMarkerSymbol(esri.symbol.SimpleMarkerSymbol.STYLE_CIRCLE, 28,
                             new esri.symbol.SimpleLineSymbol(esri.symbol.SimpleLineSymbol.STYLE_SOLID,
                             new esri.Color([202, 0, 19]), 2.5),
                             new esri.Color([0, 255, 0, 0.25]));

                        //Performance enhancer - assign featureSet array to a single variable.
                        var FeatureSet = results.features;
                        map.graphics.remove(grap);
                        //Loop through each feature returned
                        //for (var i = 0, il = FeatureSet.length; i < il; i++) {
                        //Get the current feature from the featureSet.
                        //Feature is a graphic
                        grap = FeatureSet[0];
                        grap.setSymbol(symb);
                        //Add graphic to the map graphics layer.
                        map.graphics.add(grap);

                        //Zoom and center the sequencer,if it not in the present extent
                        var extent = map.extent;
                        var result = results.features[0];
                        if (!extent.contains(result.geometry)) {
                            point = new esri.geometry.Point(result.attributes.X, result.attributes.Y);
                            map.centerAndZoom(point, 14);
                        }
                        //}
                    }
                    catch (e) {
                        //alert("Error Message: " + e.message);
                    }
                }
            }
            catch (e) {
                //alert("Error Message: " + e.message);
            }
        }
              
        function Reset() {
            ClearControls();
            document.getElementById('address').value = "";

            var ddlInspSubType = document.getElementById("ddlInspSubType");
            var ddlIssueType = document.getElementById("ddlIssueType");
            var ddlIssueSubType = document.getElementById("ddlIssueSubType");
            var ddlIssueStatus = document.getElementById("ddlIssueStatus");
            var ddlIssueAssignedTo = document.getElementById("ddlIssueAssignedTo");

            ddlInspSubType.selectedIndex = 0;
            document.getElementById("chkFilter").checked = false;
            ddlIssueType.selectedIndex = 0;
            ddlIssueSubType.selectedIndex = 0;
            ddlIssueStatus.selectedIndex = 0;
            ddlIssueAssignedTo.selectedIndex = 0;
            document.getElementById("chkDate").checked = false;
            document.getElementById('txtFromDt').value = "";
            document.getElementById('txtToDt').value = "";

            $("[id*=gdv_list] tr").remove();
            //Added new row with No Records for blank grid
            var GridId = "<%=gdv_list.ClientID %>";
            var grid = document.getElementById(GridId);
            var rowTemplate = "<tr><td class=hiddencol></td><td>No Records.</td><td class=hiddencol></td><td class=hiddencol></td></tr>";
            $("#lblNoRecords").text('0 Records');
            $("[id*=gdv_list]").append(rowTemplate);
            map.graphics.clear();
            //zoom
            point = new esri.geometry.Point(-81.0324, 33.9897);
            map.centerAndZoom(point, 15);
            InspectionGroupChange();
        }

        //Remove button logic
        function RemoveSequencer() {
            try{
                var GridId = "<%=gdv_list.ClientID %>";
                var grid = document.getElementById(GridId);
                var sequencer = document.getElementById("hfSequencer").value;
                var nextSequencer = $("[id*=gdv_list] tr:contains('" + sequencer + "')").next('tr').find('td');
                if (nextSequencer[0] == null) {
                    //Added new row with No Records for blank grid
                    var rowTemplate = "<tr><td class=hiddencol></td><td>No Records.</td><td class=hiddencol></td><td class=hiddencol></td></tr>";
                    if (grid.rows.length == 1) {
                        $("#lblNoRecords").text('0 Records');
                        $("[id*=gdv_list]").append(rowTemplate);
                        map.graphics.clear();
                        //document.getElementById("btnRemove").style.display = 'none';
                        $("#btnRemove").css({ display: "none" });
                    }
                    ClearControls();
                } else {
                    document.getElementById("hfSequencer").value = nextSequencer[0].innerHTML;
                    var seq = nextSequencer[0].innerHTML;
                    HighlightWithRedCircle(seq);
                    //Load Details,Assign and status
                    LoadDetailsAssignStatus(seq);
                    //Background color
                    var gvDrv = document.getElementById("gdv_list");
                    var rows = gvDrv.getElementsByTagName("tr");
                    if (gvDrv.rows.length > 0) {
                        for (i = 0; i < gvDrv.rows.length; i++) {
                            var cell = gvDrv.rows[i].cells;
                            var strval = cell[0].innerHTML;
                            if (strval == seq) {
                                rows[i].className = "rowcolor";
                            }
                        }
                    }
                    //End
                }
            
                $("[id*=gdv_list] tr:contains('" + sequencer + "')").remove();
                map.graphics.remove(grap);//Remove the red circle
                LoadNewLayer();
            }
            catch (e) { alert("error");}
        }

    </script>


    <!--  Date Picker-->
    <link rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.6/themes/base/jquery-ui.css" type="text/css" media="all" />


    <script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.9/jquery-ui.min.js"></script>


    <script>
        function BindCalender() {
            $(document).ready(function () {
                $("#txtFromDt").datepicker({
                    dateFormat: 'dd-M-y',
                    showOn: "button",
                    buttonImage: "resource_gallery/graphics/calendar.gif",
                    buttonImageOnly: true
                });
                $("#txtToDt").datepicker({
                    dateFormat: 'dd-M-y',
                    showOn: "button",
                    buttonImage: "resource_gallery/graphics/calendar.gif",
                    buttonImageOnly: true
                });
                $("#txtInspDueDt").datepicker({
                    dateFormat: 'dd-M-y',
                    showOn: "button",
                    buttonImage: "resource_gallery/graphics/calendar.gif",
                    buttonImageOnly: true
                });
            });
        }

        function CheckDateChanged() {
            if (document.getElementById("chkDate").checked == true) {
            }
            else {
                document.getElementById('txtFromDt').value = "";
                document.getElementById('txtToDt').value = "";
            }
        }
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" EnablePageMethods="true"></asp:ScriptManager>

        <div class="wrapper">

            <div class="wrapperRow top">
                <div id="TopTitle">
                    <div class="TopLeftTitle">
                    </div>
                    <div class="TopRightTitle">
                    </div>
                </div>
            </div>
            <div class="wrapperRow Tool">
                <div id="MapIconBar">
                    <div style="width: 70px; float: left;">
                        <div style="float: left; width: 30px; padding-top: 7px;">
                            <button id="Link3" class="Togglebuttonright btn info">>></button>
                        </div>
                    </div>
                    <div style="width: 800px; float: left;">
                        <div style="padding-top: 8px; float: left;"><b style="font-size: 13px;">Location:</b>&nbsp;
                            <input type="text" id="address" style="width: 227px; height: 28px;" />&nbsp;
                            <button id="locate" data-dojo-type="dijit/form/Button">Go</button> <%--<button id="reset" data-dojo-type="dijit/form/Button">Reset</button>--%>  </div>
                        <div style="float: left;">
                            <select style="margin: 10px; color: #ff8400; height: 32px;" onchange="Mapview(this.value)">
                                <option value="Road">Bing: Road</option>
                                <option value="Aerial">Bing: Aerial</option>
                                <option value="Aerialp">Bing: Aerial+</option>
                            </select>
                        </div>
                        <div style="float: left;">
                            <div id="navToolbar" data-dojo-type="dijit/Toolbar" style="width: 320px; position: absolute; z-index: 2;">
                                <div data-dojo-type="dijit/form/Button" id="zoomin" style="width: 34px; float: left; margin: 5px;">
                                    <img src="resource_gallery/graphics/zoomin.png" alt="Zoom in" class="MapNavIcon" style="border: 0;" title="Zoom in" />
                                </div>
                                <div data-dojo-type="dijit/form/Button" id="zoomout" style="width: 34px; float: left; margin: 5px;">
                                    <img src="resource_gallery/graphics/zoomout.png" alt="Zoom Out" class="MapNavIcon" title="Zoom Out" />
                                </div>
                                <div data-dojo-type="dijit/form/Button" id="zoomfullext" style="width: 34px; float: left; margin: 5px;">
                                    <img src="resource_gallery/graphics/fullextent.png" alt="Full Extent" class="MapNavIcon" title="Full Extent" />
                                </div>
                                <div data-dojo-type="dijit/form/Button" id="zoomprev" style="width: 34px; float: left; margin: 5px;">
                                    <img src="resource_gallery/graphics/prev.png" alt="Prev Extent" class="MapNavIcon" title="Prev Extent" />
                                </div>
                                <div data-dojo-type="dijit/form/Button" id="zoomnext" style="width: 34px; float: left; margin: 5px;">
                                    <img src="resource_gallery/graphics/next.png" alt="Next Extent" class="MapNavIcon" title="Next Extent" />
                                </div>
                                <div data-dojo-type="dijit/form/Button" id="pan" style="width: 34px; float: left; margin: 5px;">
                                    <img src="resource_gallery/graphics/hand.png" alt="Pan" class="MapNavIcon" title="Pan" />
                                </div>
                                <div data-dojo-type="dijit/form/Button" id="select" style="width: 34px; float: left; margin: 5px;">
                                    <img src="resource_gallery/graphics/selection.png" alt="Select" class="MapNavIcon" title="Select" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="width: 300px; float: right;border:1px;">
                        <div style="float: left; width: 200px; padding-top: 7px; padding-right: 16px;">
                            <asp:UpdatePanel ID="UpdatePanel8" runat="server">
                                <ContentTemplate>         
                                    <%--<asp:CheckBox ID="chkFilter" runat="server" onclick="onFilterClick()" AutoPostBack="true"  OnCheckedChanged="chkFilter_CheckedChanged"/>
                                    <asp:DropDownList ID="ddlInspectionGroup" runat="server" onchange="InspectionGroupChange()" AutoPostBack="true" OnSelectedIndexChanged="ddlInspectionGroup_SelectedIndexChanged"></asp:DropDownList>                           --%>
                                    <asp:Button ID="btnResetAll" runat="server" class="Togglebuttonright btn info" Text="Reset" OnClientClick="Reset();" OnClick="btnResetAll_Click"/>
                                    <asp:Label ID="Label1" runat="server"></asp:Label>
                                </ContentTemplate>
                               <%-- <Triggers>
                                    <asp:AsyncPostBackTrigger ControlID="ddlInspectionGroup" EventName="SelectedIndexChanged" />
                                </Triggers> --%>                                                   
                            </asp:UpdatePanel>
                           <%-- <button id="locat" data-dojo-type="dijit/form/Button">Reset</button> --%>
                           
                        </div>
                        <div style="float: right; width: 30px; padding-top: 7px; padding-right: 16px;">
                            <button id="Link4" class="Togglebuttonright btn info"><<</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="wrapperRow wrapperExpand green">

                <div id="containermain" class="weapperCell content">
                    <div id="container" style="position: relative;">
                        <div id="map"></div>
                        <div id="lefthidden_content" style="height: 100vh; padding-bottom: 1px; overflow-y: scroll;">
                            <script type="text/javascript">
                                Sys.Application.add_load(BindCalender);
                            </script>
                            <br />
                            <asp:HiddenField ID="hfSequencer" runat="server" />
                            <asp:UpdatePanel ID="UpdatePanel1" runat="server" UpdateMode="Conditional">
                                <ContentTemplate>
                                    <fieldset>
                                        <legend>Search</legend>

                                        <div class="Table">
                                             <div class="Row">
                                                <div class="Cell">
                                                    Event Code:
                                                </div>
                                                <div class="Cell">
                                                    <asp:DropDownList ID="ddlEventCode" Width="100" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlEventCode_SelectedIndexChanged" OnDataBound="ddlEventCode_DataBound"></asp:DropDownList>
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    Work Area:
                                                </div>
                                                <div class="Cell">
                                                    <asp:DropDownList ID="ddlWorkArea" Width="100" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlWorkArea_SelectedIndexChanged" OnDataBound="ddlWorkArea_DataBound"></asp:DropDownList>
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    Inspection Group:
                                                </div>
                                                <div class="Cell">
                                                    <asp:DropDownList ID="ddlInspSubType" Width="85" runat="server" onchange="InspectionGroupChange()" AutoPostBack="True" OnDataBound="ddlInspSubType_DataBound" OnSelectedIndexChanged="ddlInspSubType_SelectedIndexChanged"></asp:DropDownList>
                                                    <asp:CheckBox ID="chkFilter" runat="server" Text="filter"  onclick="onFilterClick()"/>
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    Issue Type:
                                                </div>
                                                <div class="Cell">
                                                    <asp:DropDownList ID="ddlIssueType" Width="100" runat="server" AutoPostBack="true" OnDataBound="ddlIssueType_DataBound" OnSelectedIndexChanged="ddlIssueType_SelectedIndexChanged"></asp:DropDownList>
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    Issue Sub Type:
                                                </div>
                                                <div class="Cell">
                                                    <asp:DropDownList ID="ddlIssueSubType" Width="100" runat="server" AutoPostBack="True" OnDataBound="ddlIssueSubType_DataBound" OnSelectedIndexChanged="ddlIssueSubType_SelectedIndexChanged"></asp:DropDownList>
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    Issue Status:
                                                </div>
                                                <div class="Cell">
                                                    <asp:DropDownList ID="ddlIssueStatus" Width="100" runat="server" AutoPostBack="True" OnDataBound="ddlIssueStatus_DataBound" OnSelectedIndexChanged="ddlIssueStatus_SelectedIndexChanged"></asp:DropDownList>
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    Assigned To:
                                                </div>
                                                <div class="Cell">
                                                    <asp:DropDownList ID="ddlIssueAssignedTo" Width="100" runat="server"></asp:DropDownList>&nbsp; 
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    <asp:CheckBox ID="chkDate" runat="server" OnClick="javascript:CheckDateChanged();" />&nbsp;Filter By Creation 
                                                </div>
                                                <div class="Cell">
                                                    &nbsp;Date
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    From:
                                                </div>
                                                <div class="Cell">
                                                    <asp:TextBox ID="txtFromDt" Width="80" runat="server"></asp:TextBox>
                                                </div>
                                            </div>
                                            <div class="Row">
                                                <div class="Cell">
                                                    To:
                                                </div>
                                                <div class="Cell" style="width: 135px;">
                                                    <asp:TextBox ID="txtToDt" Width="80" runat="server"></asp:TextBox>&nbsp;<asp:Button ID="btnSearch" runat="server" Text="Go" ToolTip="Go" OnClientClick="BindGridview();" CssClass="button alert" />
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                   
                                </ContentTemplate>
                                <Triggers>
                                    <asp:AsyncPostBackTrigger ControlID="btnAssign" EventName="Click" />
                                    <asp:AsyncPostBackTrigger ControlID="btnUpdate" EventName="Click" />
                                    <asp:AsyncPostBackTrigger ControlID="btnResetAll" EventName="Click" />
                                </Triggers>
                            </asp:UpdatePanel>
                             <br />
                            <asp:UpdatePanel ID="UpdatePanel10" runat="server" UpdateMode="Conditional">
                                <ContentTemplate>
                                     <div>
                                             <div style="float:left;"></div>
                                             <div style="float:right;">
                                                 <input type="button" id="btnRemove" value="Remove" onclick="RemoveSequencer();" class="button alert"/>
                                             </div>
                                         </div> 
                                </ContentTemplate>
                            </asp:UpdatePanel>
                                        
                                   
                                 
                                    <br /><br />
                            <fieldset class="masterform">
                                <legend>Search Result(<asp:Label ID="lblNoRecords" runat="server" ForeColor="Blue"></asp:Label>)</legend>
                                <div style="width: 100%; height: 150px; overflow-y: scroll;">
                                    <asp:GridView ID="gdv_list" runat="server" AutoGenerateColumns="false" ShowHeader="false" OnRowDataBound="gdv_list_RowDataBound" Width="100%">
                                        <Columns>
                                            <asp:BoundField DataField="sequencer" HeaderText="sequencer" ItemStyle-CssClass="hiddencol" />
                                            <asp:BoundField DataField="Idesc" HeaderText="Idesc" />
                                            <asp:BoundField DataField="X" HeaderText="X" ItemStyle-CssClass="hiddencol" />
                                            <asp:BoundField DataField="Y" HeaderText="Y" ItemStyle-CssClass="hiddencol" />
                                        </Columns>
                                    </asp:GridView>
                                </div>
                            </fieldset>

                            <br />
                            <div class="tabbed" style="height: 450px;">
                                <input name="tabbed" id="tabbed1" type="radio" checked>
                                <section>
                                    <h1>
                                        <label for="tabbed1">Detail</label>
                                    </h1>
                                    <div>
                                        <asp:UpdatePanel ID="UpdatePanel2" runat="server" UpdateMode="Conditional">
                                            <ContentTemplate>
                                                <p><b>SCE&G Note:</b>&nbsp;<asp:Label ID="lblSCEGNote" runat="server"></asp:Label></p>
                                                <p><b>Flag ID:</b>&nbsp;<asp:Label ID="lblFlagID" runat="server"></asp:Label></p>
                                                <p><b>Contractor:</b>&nbsp;<asp:Label ID="lblContractor" runat="server"></asp:Label></p>
                                                <p><b>Contractor Note:</b>&nbsp;<asp:Label ID="lblContractorNote" runat="server"></asp:Label></p>
                                                <p><b>Assigned To:</b>&nbsp;<asp:Label ID="lblAssignedTo" runat="server"></asp:Label></p>
                                                <p><b>Assigned Date:</b>&nbsp;<asp:Label ID="lblAssignedDate" runat="server"></asp:Label></p>
                                                <p><b>Tree Count:</b>&nbsp;<asp:Label ID="lblTreeCnt" runat="server"></asp:Label></p>
                                                <p><b>Last Updated By:</b>&nbsp;<asp:Label ID="lblLastUpdatedBy" runat="server"></asp:Label></p>
                                                <p><b>Last Updated On:</b>&nbsp;<asp:Label ID="lblLastUpdatedOn" runat="server"></asp:Label></p>
                                            </ContentTemplate>
                                            <%--<Triggers>
                                                <asp:AsyncPostBackTrigger ControlID="btnResetAll" EventName="Click" />
                                            </Triggers>--%>
                                        </asp:UpdatePanel>
                                    </div>
                                </section>
                                <input name="tabbed" id="tabbed2" type="radio">
                                <section>
                                    <h1>
                                        <label for="tabbed2">Assign</label>
                                    </h1>
                                    <div>
                                        <asp:UpdatePanel ID="UpdatePanel6" runat="server" UpdateMode="Conditional">
                                            <ContentTemplate>
                                                <div>
                                                    <asp:RadioButtonList ID="rblAssign" runat="server" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="rblAssign_SelectedIndexChanged">
                                                        <asp:ListItem Text="All" Value="0"></asp:ListItem>
                                                        <asp:ListItem Text="Selected" Value="1" Selected="True"></asp:ListItem>
                                                    </asp:RadioButtonList>
                                                </div>
                                            </ContentTemplate>
                                        </asp:UpdatePanel>
                                        <div>
                                            <div class="Table">
                                                <div class="Row">
                                                    <div class="Cell">Company:</div>
                                                    <div class="Cell">
                                                        <asp:UpdatePanel ID="UpdatePanel5" runat="server">
                                                            <ContentTemplate>
                                                                <asp:DropDownList ID="ddlAssignedTo" Width="100" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlAssignedTo_SelectedIndexChanged" OnDataBound="ddlAssignedTo_DataBound"></asp:DropDownList>
                                                            </ContentTemplate>
                                                        </asp:UpdatePanel>
                                                    </div>
                                                </div>
                                                <div class="Row">
                                                    <div class="Cell">Current Crew:</div>
                                                    <div class="Cell">
                                                        <asp:Label ID="lblCrew" runat="server"></asp:Label>
                                                    </div>
                                                </div>
                                                <div class="Row">
                                                    <div class="Cell">Updated Crew:</div>
                                                    <div class="Cell">
                                                        <asp:UpdatePanel ID="UpdatePanel3" runat="server">
                                                            <ContentTemplate>
                                                                <asp:DropDownList ID="ddlCrew" Width="100" runat="server"></asp:DropDownList>
                                                            </ContentTemplate>
                                                        </asp:UpdatePanel>
                                                    </div>
                                                </div>
                                                <div class="Row">
                                                    <div class="Cell">Inspection Due Dt:</div>
                                                    <div class="Cell">
                                                        <asp:TextBox ID="txtInspDueDt" Width="100" runat="server"></asp:TextBox>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                        <div style="height: 10px;">&nbsp;</div>
                                        <br />
                                        <div style="bottom: 0;">
                                            <div style="float: right; text-align: right;">
                                                <asp:UpdatePanel ID="UpdatePanel7" runat="server" ChildrenAsTriggers="true" UpdateMode="Conditional">
                                                    <ContentTemplate>
                                                        <asp:Button ID="btnReset" runat="server" Text="Reset" CssClass="btn alert" OnClick="btnReset_Click" />
                                                        <asp:Button ID="btnAssign" runat="server" Text="Assign" CssClass="btn alert" OnClientClick="return ConfirmAssignMessage();" OnClick="btnAssign_Click" />
                                                    </ContentTemplate>
                                                    <Triggers>
                                                        <asp:AsyncPostBackTrigger ControlID="btnAssign" EventName="Click" />
                                                        <%--<asp:AsyncPostBackTrigger ControlID="ddlIssueAssignedTo" EventName="Click" />--%>
                                                    </Triggers>
                                                </asp:UpdatePanel>
                                            </div>
                                        </div>

                                    </div>
                                </section>
                                <input name="tabbed" id="tabbed3" type="radio">
                                <section>
                                    <h1>
                                        <label for="tabbed3">Status</label>
                                    </h1>
                                    <div>
                                        <asp:UpdatePanel ID="UpdatePanel4" runat="server" UpdateMode="Conditional">
                                            <ContentTemplate>
                                                <div>
                                                    <asp:RadioButtonList ID="rblStatus" runat="server" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="rblStatus_SelectedIndexChanged">
                                                        <asp:ListItem Text="All" Value="0"></asp:ListItem>
                                                        <asp:ListItem Text="Selected" Value="1" Selected="True"></asp:ListItem>
                                                    </asp:RadioButtonList>
                                                </div>
                                                <div>
                                                    <div style="float: left; border: 0px solid red;">
                                                        <p>Current Status:</p>
                                                        <p>Update Status:</p>
                                                    </div>
                                                    <div style="float: left;">
                                                        <p>
                                                            <%--<asp:DropDownList ID="dllCurrentStatus" Width="150px" runat="server"></asp:DropDownList>--%>
                                                            &nbsp;<asp:Label ID="lblCurrentStatus" runat="server" Text=""></asp:Label>
                                                        </p>
                                                        <p>
                                                            &nbsp;<asp:DropDownList ID="ddlUpdatedStatus" Width="150px" runat="server"></asp:DropDownList>
                                                        </p>
                                                    </div>
                                                </div>
                                                <br />
                                                <div style="bottom: 0;">
                                                    <div style="float: right;">
                                                        <asp:Button ID="btnStatusReset" runat="server" Text="Reset" CssClass="btn alert" OnClick="btnStatusReset_Click" />
                                                        <asp:Button ID="btnUpdate" runat="server" Text="Update" CssClass="btn alert" OnClientClick="return ConfirmStatusMessage();" OnClick="btnUpdate_Click" />
                                                    </div>
                                                </div>
                                            </ContentTemplate>
                                        </asp:UpdatePanel>
                                    </div>
                                </section>
                            </div>
                        </div>
                        <div id="righthidden_content">
                            <div style="background-color: #000000; height: 33px; color: #fff; text-align: center; padding-top: 10px;">Map Services</div>
                            <p>
                                <asp:CheckBox ID="chkTrimLine" runat="server" />&nbsp;Show Trim Lines
                            </p>
                            <p>
                                <asp:CheckBox ID="chkElecLine" runat="server" />&nbsp;Show Electric Distribution
                            </p>
                            <p>
                                <asp:CheckBox ID="chkbmtt" runat="server" />&nbsp;Show Electric Transmission
                            </p>
                            <p>
                                <asp:CheckBox ID="chkFlight" runat="server" Enabled="false" Checked="true" />&nbsp;Show Flight Issues
                            </p>
                            <p>
                                <asp:CheckBox ID="chkGasDist" runat="server" />&nbsp;Show Gas Lines
                            </p>
                            <p>
                                <asp:CheckBox ID="chkGasTran" runat="server" />&nbsp;Show Gas Transmission
                            </p>
                        </div>
                    </div>
                </div>

                <script type="text/javascript">

                    var height = document.documentElement.clientHeight ||

                                 document.body.clientHeight;

                    height = height - 100;

                    $("#container").height(height);

                    $("#containermain").height(height);

                </script>

            </div>
        </div>
    </form>
</body>
</html>
