﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;

namespace VMT
{
    public partial class forecast : System.Web.UI.Page
    {
        string m_SP_VDM_SELECT_BSUNIT_FORECAST = Properties.Settings.Default.SP_VDM_SELECT_BSUNIT_FORECAST;
        string m_SP_VDM_SELECT_YR_FORECAST = Properties.Settings.Default.SP_VDM_SELECT_YR_FORECAST;
        string m_SP_VDM_SELECT_FORECAST_ACTUAL = Properties.Settings.Default.SP_VDM_SELECT_BU_YEAR_FORECAST;
        string m_SP_VDM_FORECAST_BOE_REPORT = Properties.Settings.Default.SP_VDM_FORECAST_BOE_REPORT;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Forecast";
        string userRole = string.Empty;
         
        protected void Page_Load(object sender, EventArgs e)
        {
           

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                bindBusinessUnit();
                ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                bindYear();
                ViewState["SortDireaction"] = "ASC";
            }
        }

        void bindYear()
        {
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_YR_FORECAST, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_BSUNIT_FORECAST, ddl_Bunit);
                
            }
            catch
            {
            }
        }
        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();
            ddl_Year.SelectedIndex = 0;
            ddl_optionby.SelectedIndex = 0;
            ddl_groupby.SelectedIndex = 0;
            bindGrid();
        }

        //protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        bindYear();
        //        //ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
        //    }
        //    catch
        //    {
        //    }
        //}

        private void bindGrid()
        {
            if (ddl_optionby.SelectedIndex == 0 || ddl_groupby.SelectedIndex == 0 || ddl_Year.SelectedIndex == 0)
            {
                gdv_Rate_Company.DataSource = null;
                gdv_Rate_Company.DataBind();

                gdv_SectionWA.DataSource = null;
                gdv_SectionWA.DataBind();
                gdv_Company.DataSource = null;
                gdv_Company.DataBind();
                gdv_EventCode.DataSource = null;
                gdv_EventCode.DataBind();
                gdv_EventCode_Company.DataSource = null;
                gdv_EventCode_Company.DataBind();
                gdv_BOEReport.DataSource = null;
                gdv_BOEReport.DataBind();

                btnExportExcel.Visible = false;


                gdv_Rate_Company.Visible = false;
                gdv_SectionWA.Visible = false;
                gdv_Company.Visible = false;
                gdv_EventCode.Visible = false;
                gdv_EventCode_Company.Visible = false;
                gdv_BOEReport.Visible = false;
            }

            else
            {

                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;
                int V_CYCLE_YEAR = 0;
                int V_ACTUAL_YEAR = 0;
                string V_OPTIONBY = "";

                try
                {
                    V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                    V_OPTIONBY = ddl_optionby.SelectedValue;
                    if (V_OPTIONBY == "Work_Year")
                    {
                        V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                    }
                    else if (V_OPTIONBY == "Cycle_Year")
                    {
                        V_CYCLE_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                    }
                    else if (V_OPTIONBY == "Actual_Year")
                    {
                        V_ACTUAL_YEAR = 2000 + Convert.ToInt32(ddl_Year.SelectedValue);
                    }

                   // V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                    string V_GROUPBY = ddl_groupby.SelectedValue;
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                    OledbParams.Add(new OleDbParameter("V_CYCLE_YEAR", V_CYCLE_YEAR));
                    OledbParams.Add(new OleDbParameter("V_ACTUAL_YEAR", V_ACTUAL_YEAR));
                    OledbParams.Add(new OleDbParameter("V_GROUPBY", V_GROUPBY));
                    gdv_Rate_Company.Visible = false;
                    gdv_SectionWA.Visible = false;
                    gdv_Company.Visible = false;
                    gdv_EventCode.Visible = false;
                    gdv_EventCode_Company.Visible = false;
                    gdv_BOEReport.Visible = false;
                    griddiv.Style["width"] = "5440px";
                    if (V_GROUPBY=="BOE Report" )
                    {
                        gdv_BOEReport.Visible = true;
                        DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_FORECAST_BOE_REPORT, OledbParams, gdv_BOEReport);
                        ViewState["dataTable"] = gdv_BOEReport.DataSource as DataSet;
                        griddiv.Style["width"] = "5440px";
                    }
                    else if (V_GROUPBY == "Work Area")
                    {
                        gdv_SectionWA.Visible = true;
                        DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_FORECAST_ACTUAL, OledbParams, gdv_SectionWA);
                        ViewState["dataTable"] = gdv_SectionWA.DataSource as DataSet;
                        griddiv.Style["width"] = "1472px";
                    }

                    else if (V_GROUPBY == "Company")
                    {
                        gdv_Company.Visible = true;
                        DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_FORECAST_ACTUAL, OledbParams, gdv_Company);
                        ViewState["dataTable"] = gdv_Company.DataSource as DataSet;
                        griddiv.Style["width"] = "1172px";
                    }
                    else if (V_GROUPBY == "Event Code")
                    {
                        gdv_EventCode.Visible = true;
                        DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_FORECAST_ACTUAL, OledbParams, gdv_EventCode);
                        ViewState["dataTable"] = gdv_EventCode.DataSource as DataSet;
                        griddiv.Style["width"] = "1272px";
                    }
                    else if (V_GROUPBY == "Event Code-Company")
                    {
                        gdv_EventCode_Company.Visible = true;
                        DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_FORECAST_ACTUAL, OledbParams, gdv_EventCode_Company);
                        ViewState["dataTable"] = gdv_EventCode_Company.DataSource as DataSet;
                        griddiv.Style["width"] = "1392px";
                    }
                       
                    else
                    {
                        gdv_Rate_Company.Visible = true;
                        DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_FORECAST_ACTUAL, OledbParams, gdv_Rate_Company);
                        ViewState["dataTable"] = gdv_Rate_Company.DataSource as DataSet;
                    }                                   
                   
                }
                catch
                {
                }
            }

            if (gdv_Rate_Company.Rows.Count > 0 || gdv_BOEReport.Rows.Count > 0 || gdv_Company.Rows.Count > 0 || gdv_EventCode.Rows.Count > 0 || gdv_EventCode_Company.Rows.Count > 0 || gdv_SectionWA.Rows.Count > 0)
            {
               // gdv_Rate_Company.SelectedIndex = -1;
                btnExportExcel.Visible = true;
            }

            else
                btnExportExcel.Visible = false;
        }

        

        protected void btn_go_Click(object sender, EventArgs e)
        {
            bindGrid();
        }

        double gtotal = 0.00;
        double mtotal = 0.00;
        double btotal = 0.00;
        double nbtotal = 0.00;
        string rowvalue = "";
        protected void gdv_Rate_Company_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            try
            {
                for (int i = 0; i < e.Row.Cells.Count; i++)
                {
                    e.Row.Cells[i].Attributes.Add("style", "white-space: nowrap;");

                }
                if (e.Row.RowType == DataControlRowType.Header)
                {
                    int index;
                    foreach (TableCell tc in (e.Row.Cells))
                    {
                        index = (e.Row.Cells.GetCellIndex(tc));
                        LinkButton objHeader = new LinkButton();
                        objHeader.Text = e.Row.Cells[index].Text;
                        //e.Row.Cells[index].Controls.Clear();               
                        e.Row.Cells[index].Controls.Add(objHeader);
                        e.Row.Cells[index].ForeColor = System.Drawing.Color.Black;
                    }

                }

                else if (e.Row.RowType == DataControlRowType.DataRow)
                {
                    if (e.Row.Cells[3].Text == "Actual Total" || e.Row.Cells[2].Text == "Actual Total")
                    {
                        //e.Row.Font.Bold = true;
                        e.Row.ForeColor = System.Drawing.Color.DarkGreen;
                    }
                    else if (e.Row.Cells[3].Text == "Actual" || e.Row.Cells[2].Text == "Actual")
                    {
                        //  e.Row.Font.Bold = true;
                        e.Row.ForeColor = System.Drawing.Color.LimeGreen;
                    }
                    else if (e.Row.Cells[3].Text == "Forecast Total" || e.Row.Cells[2].Text == "Forecast Total")
                    {
                        //  e.Row.Font.Bold = true;
                        e.Row.ForeColor = System.Drawing.Color.Red;
                    }

                    else if (e.Row.Cells[3].Text == "Forecasted" || e.Row.Cells[2].Text == "Forecasted")
                    {
                        //  e.Row.Font.Bold = true;
                        e.Row.ForeColor = System.Drawing.Color.DarkOrange;
                    }




                    //else if (e.Row.Cells[2].Text == "Forecasted")
                    //{
                    //    e.Row.ForeColor = System.Drawing.Color.Red;
                    //}
                    //else if (e.Row.Cells[2].Text == "Actual")
                    //{
                    //   e.Row.ForeColor = System.Drawing.Color.Green;
                    //}
                    if (ddl_groupby.SelectedValue == "Work Area")
                    {
                        //mtotal = mtotal + Convert.ToDouble(e.Row.Cells[5].Text);
                        //gtotal = gtotal + Convert.ToDouble(e.Row.Cells[6].Text);
                        //btotal = btotal + Convert.ToDouble(e.Row.Cells[7].Text);
                        //nbtotal = nbtotal + Convert.ToDouble(e.Row.Cells[12].Text);


                        e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[8].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[9].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[10].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[11].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[12].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[13].HorizontalAlign = HorizontalAlign.Right;
                    }

                    else if (ddl_groupby.SelectedValue == "Event Code-Company")
                    {
                        //mtotal = mtotal + Convert.ToDouble(e.Row.Cells[2].Text);
                        //gtotal = gtotal + Convert.ToDouble(e.Row.Cells[3].Text);
                        //btotal = btotal + Convert.ToDouble(e.Row.Cells[4].Text);
                        // nbtotal = nbtotal + Convert.ToDouble(e.Row.Cells[5].Text);

                        e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[8].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[9].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[10].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[11].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[12].HorizontalAlign = HorizontalAlign.Right;

                    }

                    else if (ddl_groupby.SelectedValue == "Event Code-Company-Trim Type")
                    {
                        //mtotal = mtotal + Convert.ToDouble(e.Row.Cells[3].Text);
                        //gtotal = gtotal + Convert.ToDouble(e.Row.Cells[4].Text);
                        //btotal = btotal + Convert.ToDouble(e.Row.Cells[5].Text);
                        //nbtotal = nbtotal + Convert.ToDouble(e.Row.Cells[6].Text);
                        //e.Row.Cells[3].HorizontalAlign = HorizontalAlign.Right;
                        //e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Right;
                        //e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;
                        //e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                    }

                    else
                    {
                        //mtotal = mtotal + Convert.ToDouble(e.Row.Cells[1].Text);
                        //gtotal = gtotal + Convert.ToDouble(e.Row.Cells[2].Text);
                        //btotal = btotal + Convert.ToDouble(e.Row.Cells[3].Text);
                        //nbtotal = nbtotal + Convert.ToDouble(e.Row.Cells[4].Text);

                        e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[8].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[9].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[10].HorizontalAlign = HorizontalAlign.Right;
                        e.Row.Cells[11].HorizontalAlign = HorizontalAlign.Right;
                    }

                }

                else if (e.Row.RowType == DataControlRowType.Footer)
                {
                    //if (ddl_groupby.SelectedValue == "Work Area")
                    //{
                    //    e.Row.Cells[4].Text = "Total: ";
                    //    e.Row.Cells[5].Text = string.Format("{0:#.000}", Convert.ToDouble(mtotal));
                    //    e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;  
                    //    e.Row.Cells[6].Text = string.Format("{0:#.00}", Convert.ToDouble(gtotal));                    
                    //    e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[7].Text = string.Format("{0:#.00}", Convert.ToDouble(btotal));
                    //    e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[12].Text = string.Format("{0:#.00}", Convert.ToDouble(nbtotal));
                    //    e.Row.Cells[12].HorizontalAlign = HorizontalAlign.Right;   
                    //}
                    //else if (ddl_groupby.SelectedValue == "Event Code-Company")
                    //{
                    //    e.Row.Cells[1].Text = "Total: ";
                    //    e.Row.Cells[2].Text = string.Format("{0:#.000}", Convert.ToDouble(mtotal));
                    //    e.Row.Cells[2].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[3].Text = string.Format("{0:#.00}", Convert.ToDouble(gtotal));
                    //    e.Row.Cells[3].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[4].Text = string.Format("{0:#.00}", Convert.ToDouble(btotal));
                    //    e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[5].Text = string.Format("{0:#.00}", Convert.ToDouble(nbtotal));
                    //    e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;

                    //}
                    //else if (ddl_groupby.SelectedValue == "Event Code-Company-Trim Type")
                    //{
                    //    e.Row.Cells[2].Text = "Total: ";
                    //    e.Row.Cells[3].Text = string.Format("{0:#.000}", Convert.ToDouble(mtotal));
                    //    e.Row.Cells[3].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[4].Text = string.Format("{0:#.00}", Convert.ToDouble(gtotal));
                    //    e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[5].Text = string.Format("{0:#.00}", Convert.ToDouble(btotal));
                    //    e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[6].Text = string.Format("{0:#.00}", Convert.ToDouble(nbtotal));
                    //    e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                    //}
                    //else
                    //{
                    //    e.Row.Cells[0].Text = "Total: ";                   
                    //    e.Row.Cells[1].Text = string.Format("{0:#.000}", Convert.ToDouble(mtotal));
                    //    e.Row.Cells[1].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[2].Text = string.Format("{0:#.00}", Convert.ToDouble(gtotal));
                    //    e.Row.Cells[2].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[3].Text = string.Format("{0:#.00}", Convert.ToDouble(btotal));
                    //    e.Row.Cells[3].HorizontalAlign = HorizontalAlign.Right;
                    //    e.Row.Cells[4].Text = string.Format("{0:#.00}", Convert.ToDouble(nbtotal));
                    //    e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Right;

                    //}

                }
            }
            catch
            {
            }
        }

       
        protected void gdv_Rate_Company_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdv_Rate_Company, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        private void ExportGridToExcel()
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Group By", ddl_groupby.SelectedItem.Text);

                string V_GROUPBY = ddl_groupby.SelectedValue;
               

                if (V_GROUPBY == "BOE Report")
                {
                    VDMUtil.ExportGridToExcel(gdv_BOEReport, "BOE Report", "BOE_Report", dictionaryFilters, null);
                
                }
                else if (V_GROUPBY == "Work Area")
                {                    
                    VDMUtil.ExportGridToExcel(gdv_SectionWA, "Rates Forecast Report", "Rates_Forecast", dictionaryFilters, null);
                }

                else if (V_GROUPBY == "Company")
                {
                    VDMUtil.ExportGridToExcel(gdv_Company, "Rates Forecast Report", "Rates_Forecast", dictionaryFilters, null);
                }
                else if (V_GROUPBY == "Event Code")
                {                    
                    VDMUtil.ExportGridToExcel(gdv_EventCode, "Rates Forecast Report", "Rates_Forecast", dictionaryFilters, null);
                }
                else if (V_GROUPBY == "Event Code-Company")
                {
                    VDMUtil.ExportGridToExcel(gdv_EventCode_Company, "Rates Forecast Report", "Rates_Forecast", dictionaryFilters, null);
                }

                else
                {            
                    VDMUtil.ExportGridToExcel(gdv_Rate_Company, "Rates Forecast Report", "Rates_Forecast", dictionaryFilters, null);
                }
            }
            catch
            {
            }
        }
        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            ExportGridToExcel();
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void ddl_groupby_SelectedIndexChanged(object sender, EventArgs e)
        {
                bindGrid();           

        }

        

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
          
            //if (ddl_Year.SelectedIndex == 0)
            //{
                
            //    ddl_groupby.SelectedIndex = 0;                
               
            //}
            ddl_groupby.SelectedIndex = 0;   
            bindGrid();   
            
            //    ddl_groupby.Items.Insert(0, new ListItem("- Select -", "-1"));
        }

        protected void gdv_SectionWA_Sorting(object sender, GridViewSortEventArgs e)
        {
            VDMUtil.GridviewSorting(gdv_SectionWA, e.SortExpression, (DataSet)ViewState["dataTable"]);
        }

        protected void gdv_Company_Sorting(object sender, GridViewSortEventArgs e)
        {
            VDMUtil.GridviewSorting(gdv_SectionWA, e.SortExpression, (DataSet)ViewState["dataTable"]);
        }

        protected void gdv_EventCode_Sorting(object sender, GridViewSortEventArgs e)
        {
            VDMUtil.GridviewSorting(gdv_EventCode, e.SortExpression, (DataSet)ViewState["dataTable"]); 
        }

        protected void gdv_EventCode_Company_Sorting(object sender, GridViewSortEventArgs e)
        {
            VDMUtil.GridviewSorting(gdv_EventCode_Company, e.SortExpression, (DataSet)ViewState["dataTable"]); 
        }

        protected void gdv_BOEReport_Sorting(object sender, GridViewSortEventArgs e)
        {
            VDMUtil.GridviewSorting(gdv_BOEReport, e.SortExpression, (DataSet)ViewState["dataTable"]); 
        }

        protected void gdv_SectionWA_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label rowtype = (Label)e.Row.Cells[3].FindControl("ROWTYPE");
                if (rowtype.Text == "Actual Total" )
                {
                    //e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.DarkGreen;
                }
                else if (rowtype.Text == "Actual" )
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.LimeGreen;
                }
                else if (rowtype.Text == "Forecast Total" )
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.Red;
                }

                else if (rowtype.Text == "Forecasted" )
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.DarkOrange;
                }
            }
            if (ddl_groupby.SelectedValue == "Work Area")
            {
                //mtotal = mtotal + Convert.ToDouble(e.Row.Cells[5].Text);
                //gtotal = gtotal + Convert.ToDouble(e.Row.Cells[6].Text);
                //btotal = btotal + Convert.ToDouble(e.Row.Cells[7].Text);
                //nbtotal = nbtotal + Convert.ToDouble(e.Row.Cells[12].Text);


                e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[8].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[9].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[10].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[11].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[12].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[13].HorizontalAlign = HorizontalAlign.Right;
            }

            
        }

        protected void gdv_Company_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label rowtype = (Label)e.Row.Cells[3].FindControl("ROWTYPE");
                if (rowtype.Text == "Actual Total")
                {
                    //e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.DarkGreen;
                }
                else if (rowtype.Text == "Actual")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.LimeGreen;
                }
                else if (rowtype.Text == "Forecast Total")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.Red;
                }

                else if (rowtype.Text == "Forecasted")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.DarkOrange;
                }


                e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[8].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[9].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[10].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[11].HorizontalAlign = HorizontalAlign.Right;
            }
            

           
        }

        protected void gdv_EventCode_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label rowtype = (Label)e.Row.Cells[3].FindControl("ROWTYPE");
                if (rowtype.Text == "Actual Total")
                {
                    //e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.DarkGreen;
                }
                else if (rowtype.Text == "Actual")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.LimeGreen;
                }
                else if (rowtype.Text == "Forecast Total")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.Red;
                }

                else if (rowtype.Text == "Forecasted")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.DarkOrange;
                }

                e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[8].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[9].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[10].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[11].HorizontalAlign = HorizontalAlign.Right;
            }
        }

        protected void gdv_EventCode_Company_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label rowtype = (Label)e.Row.Cells[3].FindControl("ROWTYPE");
                if (rowtype.Text == "Actual Total")
                {
                    //e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.DarkGreen;
                }
                else if (rowtype.Text == "Actual")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.LimeGreen;
                }
                else if (rowtype.Text == "Forecast Total")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.Red;
                }

                else if (rowtype.Text == "Forecasted")
                {
                    //  e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.DarkOrange;
                }


                e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[8].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[9].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[10].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[11].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[12].HorizontalAlign = HorizontalAlign.Right;
            }


           
        }

        protected void gdv_BOEReport_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {

                e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[5].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[6].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[7].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[8].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[9].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[10].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[11].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[12].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[13].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[14].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[15].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[16].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[17].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[18].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[19].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[20].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[21].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[22].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[23].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[24].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[25].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[26].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[27].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[28].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[29].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[30].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[31].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[32].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[33].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[34].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[35].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[36].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[37].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[38].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[39].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[40].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[32].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[33].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[34].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[35].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[36].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[37].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[38].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[39].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[40].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[41].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[42].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[43].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[49].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[50].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[51].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[52].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[53].HorizontalAlign = HorizontalAlign.Right;

            }
        }

        protected void ddl_optionby_SelectedIndexChanged(object sender, EventArgs e)
        {
            ListItem item = ddl_groupby.Items.FindByText("BOE Report");
            if (ddl_optionby.SelectedValue == "Work_Year")
            {
                if (item == null)
                {
                    ddl_groupby.Items.Add(new ListItem("BOE Report", "BOE Report"));
                }
            }

            else

            {
                ddl_groupby.Items.Remove(ddl_groupby.Items.FindByValue("BOE Report"));
            }
            bindYear();
            ddl_Year.SelectedIndex = 0;           
            ddl_groupby.SelectedIndex = 0;
            bindGrid();
        }

        

    }
}