﻿using DataAccess;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.OleDb;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VMT
{
    public partial class WorkComments : System.Web.UI.Page
    {
        
       
        string m_SP_WC_SEL_EVENT_CODE = Properties.Settings.Default.SP_WC_SEL_EVENT_CODE;
        string m_SP_WC_SEL_WORK_AREA = Properties.Settings.Default.SP_WC_SEL_WORK_AREA;
        string m_SP_WC_SEL_WORK_COMMENTS = Properties.Settings.Default.SP_WC_SEL_WORK_COMMENTS;
        string m_SP_WC_SELECT_BUSINESS_UNIT = Properties.Settings.Default.SP_WC_SELECT_BUSINESS_UNIT;
        string m_SP_WC_WORKCOMMENTS_UPD_DEL = Properties.Settings.Default.SP_WC_WORKCOMMENTS_UPD_DEL;

       
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;     
        string pageName = "Work Notes";
        protected void Page_Load(object sender, EventArgs e)
        {
            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {
                ////checks user role


                //if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                //{
                //    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                //}
                //else
                //{
                //    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                //}
                BindBusinessUnit(); 
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_WC_SELECT_BUSINESS_UNIT, ddlBUnit);
            }
            catch
            {
            }
        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
            //BindWorkArea();
        }
        
        protected void ddlBUnit_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }

        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            //int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                // V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                //OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_WC_SEL_EVENT_CODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }
        }
        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        void BindWorkArea()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_WC_SEL_WORK_AREA, OledbParams, ddlWorkArea);
            }
            catch
            {
            }
        }

        protected void ddlWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindTreeRemoval();
        }

        protected void ddlWorkArea_DataBound(object sender, EventArgs e)
        {
            BindTreeRemoval();
        }

        private void BindTreeRemoval()
        {
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Int32.Parse(ddlBUnit.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Int32.Parse(ddlEventCode.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", Int32.Parse(ddlWorkArea.SelectedValue)));

                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_WC_SEL_WORK_COMMENTS, sqlParams, gdvBidProcess);
                ViewState["dataTable"] = gdvBidProcess.DataSource as DataSet;
                gdvBidProcess.SelectedIndex = -1;
                if (gdvBidProcess.Rows.Count > 0)
                    btnExportExcel.Visible = true;
                else
                    btnExportExcel.Visible = false;
            }
            catch(Exception ex)
            {
            }
        }       

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
                //dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                dictionaryFilters.Add("Work Area", ddlWorkArea.SelectedItem.Text);
                List<int> listHideColumns = new List<int>(new int[] { 3 });
                VDMUtil.ExportGridToExcel(gdvBidProcess, "Work Notess", "Work Notes", dictionaryFilters, listHideColumns);
            }
            catch
            {
            }
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void gdvBidProcess_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvBidProcess, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        protected void gdvBidProcess_RowEditing(object sender, GridViewEditEventArgs e)
        {
            gdvBidProcess.EditIndex = e.NewEditIndex;
            BindTreeRemoval();
        }

        protected void gdvBidProcess_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            gdvBidProcess.EditIndex = -1;
            BindTreeRemoval();
        }

        protected void gdvBidProcess_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = (GridViewRow)gdvBidProcess.Rows[e.RowIndex];
            try
            {
                int V_WORKCOMMENTS_ID = Convert.ToInt32((row.FindControl("lbl_WORKCOMMENT_ID") as Label).Text);

                EditDelete("DELETE", V_WORKCOMMENTS_ID, null);
                BindTreeRemoval();
            }
            catch (Exception ex)
            {
            }
        }

        protected void gdvBidProcess_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            GridViewRow row = (GridViewRow)gdvBidProcess.Rows[e.RowIndex];
            try
            {
                int V_WORKCOMMENTS_ID = Convert.ToInt32((row.FindControl("lbl_WORKCOMMENT_ID") as Label).Text);
                string V_WORKCOMMENTS_TEXT = ((TextBox)gdvBidProcess.Rows[e.RowIndex].Cells[4].Controls[1]).Text.ToString();
                if (V_WORKCOMMENTS_TEXT.Trim() == "")
                {
                    ((TextBox)gdvBidProcess.Rows[e.RowIndex].Cells[4].Controls[1]).Focus();
                    return;
                }
                EditDelete("UPDATE", V_WORKCOMMENTS_ID, V_WORKCOMMENTS_TEXT);
                gdvBidProcess.EditIndex = -1;
                BindTreeRemoval();                
            }
            catch(Exception ex)
            {
            }
        }

        private void EditDelete(string strOperation, int V_WORKCOMMENTS_ID, string V_COMMENT_TEXT)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_WORKCOMMENT_ID", V_WORKCOMMENTS_ID));
                sqlParams.Add(new OleDbParameter("V_COMMENT_TEXT", V_COMMENT_TEXT));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_WC_WORKCOMMENTS_UPD_DEL, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {

                 ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " successful.')", true);

            }
            else if (retVal == -1)
            {
                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " failed.')", true);
            }

        }

        protected void gdvBidProcess_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                // loop all data rows
                foreach (DataControlFieldCell cell in e.Row.Cells)
                {
                    // check all cells in one row
                    foreach (Control control in cell.Controls)
                    {
                        // Must use LinkButton here instead of ImageButton
                        // if you are having Links (not images) as the command button.
                        ImageButton button = control as ImageButton;
                        if (button != null && button.CommandName == "Delete")
                            // Add delete confirmation
                            button.OnClientClick = "if (!confirm('Are you sure " +
                                   "you want to delete this Note?')) return;";
                        
                    }
                }
            }
        }

    }
}