﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.IO;

namespace VMT
{
    public partial class WorkArea_Flight : System.Web.UI.Page
    {
        string m_SP_FL_WC_SEL_BUSINESS_UNIT = Properties.Settings.Default.SP_FL_WC_SEL_BUSINESS_UNIT;
        string m_SP_FL_WC_SEL_EVENTCODE = Properties.Settings.Default.SP_FL_WC_SEL_EVENTCODE;
        string m_SP_FL_WC_SEL_COMPANY = Properties.Settings.Default.SP_FL_WC_SEL_COMPANY;
        string m_SP_FL_WC_SEL_WORKAREA = Properties.Settings.Default.SP_FL_WC_SEL_WORKAREA;
        string m_SP_FL_WC_SEL_WORKAREA_COMP = Properties.Settings.Default.SP_FL_WC_SEL_WORKAREA_COMP;
        string m_SP_FL_WC_INS_DEL_WORKAREA_COMP = Properties.Settings.Default.SP_FL_WC_INS_DEL_WORKAREA_COMP;

        string m_SP_VDM_SELECT_EVCODE_INSPECTOR = Properties.Settings.Default.SP_VDM_SELECT_EVCODE_INSPECTOR;

        string userRole = string.Empty;
        string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        protected void Page_Load(object sender, EventArgs e)
        {
            //checks user role
            userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (userRole == "Edit")
            {
                btn_add1.Visible = true;
                // btnGo.Visible = true;
                btn_expExcel.Visible = true;
            }
            else
            {
                btn_add1.Visible = false;
                //  btnGo.Visible = false;
                btn_expExcel.Visible = false;
            }

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btn_expExcel);
            if (!Page.IsPostBack)
            {
                btn_expExcel.Visible = false;
                bindBusinessUnit();
                bindListCompany();
            } 

        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FL_WC_SEL_BUSINESS_UNIT, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FL_WC_SEL_EVENTCODE, OledbParams, ddl_eventcode);
            }
            catch
            {
            }
        }

        void bindListCompany()
        {
            try
            {
                DataAccessUtility.BindListboxWithoutConditionViaProcedure(m_SP_FL_WC_SEL_COMPANY, lst_Employee);
            }
            catch
            {
            }                   
           
        }
        void bindListWorkArea()
        {
            try
            {
                if (ddl_eventcode.SelectedIndex >= 0)
                {
                    lst_selWorkArea.Items.Clear();
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Convert.ToInt32(ddl_eventcode.SelectedValue)));
                    DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_FL_WC_SEL_WORKAREA, OledbParams, lst_WorkArea);
                }
                else
                {
                    lst_WorkArea.Items.Clear();
                    lst_selWorkArea.Items.Clear();
                }
            }
            catch
            {
            }
        }
        private void bindGrid()
        {
            gdv_EC_CompEmp.DataBind();

            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

                OleDbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Convert.ToInt32(ddl_eventcode.SelectedValue)));




                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_FL_WC_SEL_WORKAREA_COMP, OleDbParams, gdv_EC_CompEmp);
            }
            catch
            {
            }
        }
        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEventCode();
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            bindEventCode();
        }

        protected void ddl_eventcode_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindListWorkArea();
            bindGrid();
        }

        protected void ddl_eventcode_DataBound(object sender, EventArgs e)
        {
            bindListWorkArea();
            bindGrid();
        }

        protected void btnGo_Click(object sender, EventArgs e)
        {

        }

        protected void gdv_EC_CompEmp_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                GridViewRow row = (GridViewRow)gdv_EC_CompEmp.Rows[e.RowIndex];

                int V_WORK_AREA_ID = Convert.ToInt32((row.FindControl("lbl_WORK_AREA_ID") as Label).Text);
                int V_COMPANY_ID = Convert.ToInt32((row.FindControl("lbl_COMPANY_ID") as Label).Text);
                AddDelete("DELETE", V_WORK_AREA_ID, V_COMPANY_ID);

                bindGrid();
            }
            catch
            {
            }
        }

        protected void btn_addWA_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_WorkArea.SelectedValue.ToString().Trim() != "0")
                {
                    foreach (ListItem item in this.lst_WorkArea.Items)
                    {
                        if (item.Selected)
                        {
                            this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }


                    for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_WorkArea.Items[i].Selected)
                        {
                            lst_WorkArea.Items.RemoveAt(i);
                        }

                    }

                }
                else
                {
                    foreach (ListItem item in this.lst_WorkArea.Items)
                    {
                        if (item.Value.ToString().Trim() != "0")
                        {
                            this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_WorkArea.Items[i].Value.ToString() != "0")
                        {
                            lst_WorkArea.Items.RemoveAt(i);
                        }

                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remWA_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selWorkArea.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_WorkArea.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }


                for (int i = lst_selWorkArea.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selWorkArea.Items[i].Selected)
                    {
                        lst_selWorkArea.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_addEmp_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_Employee.SelectedValue.ToString().Trim() != "0")
                {
                    foreach (ListItem item in this.lst_Employee.Items)
                    {
                        if (item.Selected)
                        {
                            this.lst_selEmployee.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_Employee.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_Employee.Items[i].Selected)
                        {
                            lst_Employee.Items.RemoveAt(i);
                        }

                    }

                }
                else
                {
                    foreach (ListItem item in this.lst_Employee.Items)
                    {
                        if (item.Value.ToString().Trim() != "0")
                        {
                            this.lst_selEmployee.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_Employee.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_Employee.Items[i].Value.ToString() != "0")
                        {
                            lst_Employee.Items.RemoveAt(i);
                        }

                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remEmp_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selEmployee.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_Employee.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }

                for (int i = lst_selEmployee.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selEmployee.Items[i].Selected)
                    {
                        lst_selEmployee.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_expExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Event/Project", ddl_eventcode.SelectedItem.Text);               
                List<int> listColumnIndex = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdv_EC_CompEmp, "Flight-Workarea-Company", "Flight-Workarea-Company", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }

        protected void btn_add1_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_selWorkArea.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Section-WA Selected!')", true);
                    return;
                }

                if (lst_selEmployee.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Company Selected!')", true);
                    return;
                }


                foreach (ListItem itemC in this.lst_selEmployee.Items)
                {

                    foreach (ListItem itemW in this.lst_selWorkArea.Items)
                    {
                        AddDelete("INSERT", Int32.Parse(itemW.Value), Int32.Parse(itemC.Value));

                    }

                }


                bindGrid();
                ResetControl();
            }
            catch
            {
            }
        }

        private void AddDelete(string strOperation, int V_WORK_AREA_ID, int V_COMPANY_ID)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));               
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));               
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FL_WC_INS_DEL_WORKAREA_COMP, sqlParams);


            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {


                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Work_Area Company already exists')", true);
            }

        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
        private void ResetControl()
        {
            lst_selEmployee.Items.Clear();
            lst_selWorkArea.Items.Clear();

            bindListWorkArea();
            bindListCompany();

            if (gdv_EC_CompEmp.Rows.Count == 0)
            {
                btn_expExcel.Visible = false;
            }
            else
            {
                btn_expExcel.Visible = true;
            }
        }
        protected void gdv_EC_CompEmp_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[4].Visible = false;
            e.Row.Cells[5].Visible = false;
            //checks user role
            userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (userRole == "Edit")
            {
                e.Row.Cells[3].Visible = true;
            }
            else
            {
                e.Row.Cells[3].Visible = false;
            }
        }
    }
}