﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;

namespace VMT
{
    public partial class WA_Rates_Company : System.Web.UI.Page
    {
        
        
        string m_SP_SELECT_BU_FOR_RATE_ASSGN = Properties.Settings.Default.SP_SELECT_BU_FOR_RATE_ASSGN;
        string m_SP_SELECT_YEAR_FOR_RATE_ASSGN = Properties.Settings.Default.SP_SELECT_YEAR_FOR_RATE_ASSGN;
        string m_SP_SELECT_CMPNY_FOR_RATE_ASSGN = Properties.Settings.Default.SP_SELECT_CMPNY_FOR_RATE_ASSGN;
        string m_SP_SELECT_WA_FOR_RATE_ASSGN = Properties.Settings.Default.SP_SELECT_WA_FOR_RATE_ASSGN;
        string m_SP_SELECT_RTYPE_FOR_RATE_ASSGN = Properties.Settings.Default.SP_SELECT_RTYPE_FOR_RATE_ASSGN;
        string m_SP_VDM_SELECT_RATES_COMPANY_WA = Properties.Settings.Default.SP_VDM_SELECT_RATES_COMPANY_WA;
        string m_SP_SELECT_RATE_TYPES_DETAIL = Properties.Settings.Default.SP_SELECT_RATE_TYPES_DETAIL;
        string m_SP_VDM_RATES_WA_CMPNY_INS_DEL = Properties.Settings.Default.SP_VDM_RATES_WA_CMPNY_INS_DEL;
        string m_SP_SELECT_EC_FOR_RATE_ASSGN = Properties.Settings.Default.SP_SELECT_EC_FOR_RATE_ASSGN;
        string m_SP_SELECT_WA_GRID_RATE_ASSGN = Properties.Settings.Default.SP_SELECT_WA_GRID_RATE_ASSGN;
        string m_SP_SEL_WA_RATEASSIGNMENT_CHECK = Properties.Settings.Default.SP_SEL_WA_RATEASSIGNMENT_CHECK;
        string BU = "";
        string EC = "";
        string YR = "";
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Section/WA Rate Assignment";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {

                //checks user role
                //checks user role
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }
                hdn_role.Value = userRole;
                if (userRole == "0")
                {
                    Response.Redirect("default.aspx");
                }
                else if (userRole == "2" || userRole == "3")
                {
                    rowAdd.Visible = true;
                    rowAddBtn.Visible = true;
                }
                else
                {
                    rowAdd.Visible = false;
                    rowAddBtn.Visible = false;
                }

                bindBusinessUnit();
                if (Request.QueryString["BU"] != null)
                {
                    BU = Request.QueryString["BU"].Trim();
                }
                if (Request.QueryString["EC"] != null)
                {
                    EC = Request.QueryString["EC"].Trim();
                }
                if (Request.QueryString["YR"] != null)
                {
                    YR = Request.QueryString["YR"].Trim();
                }
               
                if (BU == "")
                {

                    ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                    bindYear();
                }
                else
                {
                    ddl_Bunit.SelectedValue = BU;
                    bindYear();

                }


                if (YR == "")
                {
                    //ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                    bindEventCode();
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                    bindEventCode();
                }
                if (EC != "")
                {
                    ddl_EventCode.SelectedValue = EC;
                    bindCompany();
                   // bindGrid();
                }
                CreateNew.Visible = false;
            }
        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_BU_FOR_RATE_ASSGN, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindYear()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_YEAR_FOR_RATE_ASSGN, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }
       
        void bindWorkAreas()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", ddl_Company.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddl_EventCode.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_WA_FOR_RATE_ASSGN, OledbParams, ddl_WorkArea);
            }
            catch
            {
            }
        }

        void bindGridWorkAreas()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", ddl_Company.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddl_EventCode.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", ddl_WorkArea.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_WA_GRID_RATE_ASSGN, OledbParams, ddl_gridWorkArea);
            }
            catch
            {
            }
        }
        void bindCompany()
         {
             try
             {
                 List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                 OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                 OledbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                 OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddl_EventCode.SelectedValue));
                 DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_CMPNY_FOR_RATE_ASSGN, OledbParams, ddl_Company);
             }
             catch
             {
             }
         }
        void bindEventCode()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_EC_FOR_RATE_ASSGN, OledbParams, ddl_EventCode);
            }
            catch
            {
            }
        }
        public int intnull(string inttext)
        {
            int value1 = 0;
            try
            {
                value1 = Convert.ToInt32(inttext);
            }
            catch (Exception ex)
            {
                value1 = 0;
            }
            return value1;
        }
        void bindrateType()
        {

            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_WORK_AREA_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);
                V_WORK_AREA_ID = intnull(ddl_gridWorkArea.SelectedValue);
                V_EVENT_CODE_ID = intnull(ddl_EventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_RTYPE_FOR_RATE_ASSGN, OledbParams, ddl_RateTypes);
            }
            catch
            {
            }
        }
        private void bindGrid()
        {

            int V_WORK_AREA_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_WORK_AREA_ID = Convert.ToInt32(ddl_WorkArea.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddl_EventCode.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();

                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_RATES_COMPANY_WA, OledbParams, gdv_Rate_Company);
            }
            catch
            {
            }
        }
        void getUOM()
        {
            try
            {
                if (ddl_RateTypes.SelectedIndex >= 0)
                {
                    DataSet ds = new DataSet();
                    List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                    OleDbParams.Add(new OleDbParameter("V_RATE_TYPE_ID", ddl_RateTypes.SelectedValue));
                    ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_RATE_TYPES_DETAIL, OleDbParams);

                    //bind the fields 

                    lbl_UOM.Text = ds.Tables[0].Rows[0]["UOM"].ToString();
                }
                else
                {
                    lbl_UOM.Text = "";
                }
            }
            catch
            {
            }
        }
        private void AddDelete(string strOperation, int V_RATE_YEAR_ID, int V_RATE_TYPE_ID, int V_COMPANY_ID, int V_EVENT_CODE_ID, int V_WORK_AREA_ID, double V_RATE_TYPE_AMOUNT)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_RATE_YEAR_ID", V_RATE_YEAR_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_ID", V_RATE_TYPE_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_AMOUNT", V_RATE_TYPE_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_RATES_WA_CMPNY_INS_DEL, sqlParams);


            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {


             //   ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
              //  ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " failed.')", true);
            }

        }

      
        void resetControl()
        {
            txt_Rateamount.Text = "";


        }
        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            bindYear();
        }
        
        protected void btn_addRates_Click(object sender, EventArgs e)
        {

            if (txt_Rateamount.Text.Trim() == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Amount could not be blank!')", true);
                txt_Rateamount.Focus();
                return;
            }

            if (ddl_RateTypes.SelectedIndex < 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Rate Type!')", true);
                ddl_RateTypes.Focus();
                return;
            }
            double V_RATE_TYPE_AMOUNT = 0.0;
            try
            {
                V_RATE_TYPE_AMOUNT = Convert.ToDouble(txt_Rateamount.Text.Trim());
            }
            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Amount could not be non-Numeric!')", true);
                txt_Rateamount.Focus();
                return;
            }

            string strOperation = "";
            int V_RATE_YEAR_ID = 0;
            int V_RATE_TYPE_ID = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;  
            int V_WORK_AREA_ID = 0;

            try
            {
                strOperation = "INSERT";
                V_RATE_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_RATE_TYPE_ID = Convert.ToInt32(ddl_RateTypes.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddl_EventCode.SelectedValue);
                V_WORK_AREA_ID = Convert.ToInt32(ddl_gridWorkArea.SelectedValue);



                AddDelete(strOperation, V_RATE_YEAR_ID, V_RATE_TYPE_ID, V_COMPANY_ID, V_EVENT_CODE_ID, V_WORK_AREA_ID, V_RATE_TYPE_AMOUNT);
                bindGrid();
                bindGridWorkAreas();
                bindrateType();
                resetControl();
            }
            catch
            {
            }
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindEventCode();
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            //if (!Page.IsPostBack)
            //{
            //    ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
            //}
            bindEventCode();
        }

        protected void ddl_Company_DataBound(object sender, EventArgs e)
        {
          
          bindWorkAreas();
        }

        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();
        }

        protected void ddl_Company_SelectedIndexChanged(object sender, EventArgs e)
        {
            
            bindWorkAreas();
        }

        protected void btnshowhide_Click(object sender, ImageClickEventArgs e)
        {
            if (CreateNew.Visible == true)
            {
                CreateNew.Visible = false;
                btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
            }
            else
            {
                btnshowhide.ImageUrl = "resource_gallery/graphics/minus.png";
                CreateNew.Visible = true;
            }
        }

        protected void ddl_WorkArea_DataBound(object sender, EventArgs e)
        {
            bindGridWorkAreas();
           // bindrateType();
            bindGrid();
        }

        protected void ddl_RateTypes_SelectedIndexChanged(object sender, EventArgs e)
        {
            getUOM();
        }

        protected void ddl_RateTypes_DataBound(object sender, EventArgs e)
        {
            getUOM();
        }

        protected void gdv_Rate_Company_RowCreated(object sender, GridViewRowEventArgs e)
        {
            
            e.Row.Cells[5].Visible = false;
            e.Row.Cells[6].Visible = false;
            e.Row.Cells[7].Visible = false;
            e.Row.Cells[8].Visible = false;
            e.Row.Cells[9].Visible = false;            
            //checks user role
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (hdn_role.Value == "2" || hdn_role.Value == "3")
            {
                e.Row.Cells[4].Visible = true;
            }
            else
            {
                e.Row.Cells[4].Visible = false;
            }
        }

        protected void ddl_WorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindGridWorkAreas();
            bindrateType();
            bindGrid();

            //Show and hide delete and add button
            int count = CheckRateAssignment();
            if (count == 0)
            {
                this.gdv_Rate_Company.Columns[4].Visible = false;
                rowAddBtn.Visible = false;
                rowAdd.Visible = false;
            }
            else
            {
                this.gdv_Rate_Company.Columns[4].Visible = true;
                rowAddBtn.Visible = true;
                rowAdd.Visible = true;
            }
        }

        protected void gdv_Rate_Company_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                GridViewRow row = (GridViewRow)gdv_Rate_Company.Rows[e.RowIndex];

                int V_RATE_YEAR_ID = Convert.ToInt32((row.FindControl("lbl_RATE_YEAR_ID") as Label).Text);
                int V_RATE_TYPE_ID = Convert.ToInt32((row.FindControl("lbl_RATE_TYPE_ID") as Label).Text);
                int V_COMPANY_ID = Convert.ToInt32((row.FindControl("lbl_COMPANY_ID") as Label).Text);
                int V_EVENT_CODE_ID = Convert.ToInt32((row.FindControl("lbl_EVENT_CODE_ID") as Label).Text);
                int V_WORK_AREA_ID = Convert.ToInt32((row.FindControl("lbl_WORK_AREA_ID") as Label).Text);

                double V_RATE_TYPE_AMOUNT = 0.0;
                AddDelete("DELETE", V_RATE_YEAR_ID, V_RATE_TYPE_ID, V_COMPANY_ID, V_EVENT_CODE_ID, V_WORK_AREA_ID, V_RATE_TYPE_AMOUNT);

                bindGrid();
                bindrateType();
                resetControl();
            }
            catch
            {
            }
        }

        protected void ddl_EventCode_DataBound(object sender, EventArgs e)
        {
            bindCompany();
           // bindWorkAreas();
        }

        protected void ddl_EventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindCompany();
           // bindWorkAreas();
        }

        protected void ddl_gridWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindrateType();
        }

        protected void ddl_gridWorkArea_DataBound(object sender, EventArgs e)
        {
            bindrateType();
        }

        protected void gdv_Rate_Company_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton btnDelete = (LinkButton)e.Row.FindControl("LinkButton1");
                Label lblWS = (Label)e.Row.FindControl("lbl_WS_ID");
                int ws = Convert.ToInt32(lblWS.Text.ToString());
                if (ws <= 3)
                {
                    btnDelete.Visible = false;
                }
            }   
        }

        //Rate can be changed for those company that are In-active when project still in contractor open.
        private int CheckRateAssignment()
        {
            int result = 0;
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            int V_WORK_AREA_ID = 0;

            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_COMPANY_ID = intnull(ddl_Company.SelectedValue);
                V_EVENT_CODE_ID = intnull(ddl_EventCode.SelectedValue);
                V_WORK_AREA_ID = intnull(ddl_WorkArea.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                result = DataAccessUtility.SelectSingleValueViaStoreProcedureParamWithOutPutParam(m_SP_SEL_WA_RATEASSIGNMENT_CHECK, OledbParams);
            }
            catch
            {
            }

            return result;
        }

    }
}