﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DataAccess;
using System.Data.OleDb;

namespace VMT
{

    public partial class VMSAccrual : System.Web.UI.Page
    {
        
        string m_SP_VAC_SELECT_OPR_MODE = Properties.Settings.Default.SP_VAC_SELECT_OPR_MODE;
        string m_SP_VAC_SELECT_ACCRUAL_YEAR = Properties.Settings.Default.SP_VAC_SELECT_ACCRUAL_YEAR;
        string m_SP_VAC_SELECT_BUSINESS_UNIT = Properties.Settings.Default.SP_VAC_SELECT_BUSINESS_UNIT;
        string m_SP_VAC_SELECT_ACCRUAL_EC = Properties.Settings.Default.SP_VAC_SELECT_ACCRUAL_EC;
        string m_SP_VAC_SELECT_ACCRUAL_WA = Properties.Settings.Default.SP_VAC_SELECT_ACCRUAL_WA;
        string m_SP_VAC_SELECT_YR_END_ACCRUAL = Properties.Settings.Default.SP_VAC_SELECT_YR_END_ACCRUAL;
        string m_SP_VAC_SELECT_ALL_ACCRUAL_WA = Properties.Settings.Default.SP_VAC_SELECT_ALL_ACCRUAL_WA;
        //string m_SP_VAC_YR_END_ACCRUAL_INS_DEL = Properties.Settings.Default.SP_VAC_YR_END_ACCRUAL_INS_DEL;
        string m_SP_VAC_SELECT_EVENT_CODE = Properties.Settings.Default.SP_VAC_SELECT_EVENT_CODE;
        string m_SP_VAC_SEL_WA_FOR_EVCODE = Properties.Settings.Default.SP_VAC_SEL_WA_FOR_EVCODE;
        string m_SP_VAC_SELECT_COMPANY = Properties.Settings.Default.SP_VAC_SELECT_COMPANY;
        string m_SP_VAC_SELECT_ACCRUAL_COMPANY = Properties.Settings.Default.SP_VAC_SELECT_ACCRUAL_COMPANY;
        
        string pageName = "Year End Accrual ";
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        public static string v_EVENT_CODE_ID;
        public static string v_WORK_AREA_ID;
        public static int v_COMPANY_ID;
        public static int v_YEAR_ID;

        protected void Page_Load(object sender, EventArgs e)
        {

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btn_expExcel);
            if (!Page.IsPostBack)
            {
                //checks user role
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }
                //CreateNew.Visible = false;
                //BindMode();
                BindBusinessUnit();
                //BindCompany();

                //BindAccrualYear();
                //BindEventCodeAll();
            }
        }


        //void BindMode()
        //{
        //    try
        //    {
        //        DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VAC_SELECT_OPR_MODE, ddl_Mode);
        //    }
        //    catch
        //    {
        //    }

        //}


        //void BindCompany()
        //{
        //    try
        //    {
        //        DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VAC_SELECT_COMPANY, ddlCompany);
        //    }
        //    catch
        //    {
        //    }

        //}

        void BindYear()
        {
            string V_OPR_MODE = string.Empty;
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_OPR_MODE = opr_mode();
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_BU.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_ACCRUAL_YEAR, OledbParams, ddl_Year);
            }
            catch
            {
            }
            //try
            //{
            //    DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VAC_SELECT_ACCRUAL_YEAR, ddl_Year);
            //}
            //catch
            //{
            //}

        }

        //void BindAccrualYear()
        //{
        //    string V_OPR_MODE = string.Empty;
        //    int V_BUSINESS_UNIT_ID = 0;
        //    try
        //    {
        //        V_OPR_MODE = opr_mode();
        //        V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_BU.SelectedValue);
        //        List<OleDbParameter> OledbParams = new List<OleDbParameter>();
        //        OledbParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
        //        OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
        //        DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_ACCRUAL_YEAR, OledbParams, ddlYear);
        //    }
        //    catch
        //    {
        //    }
        //}

        void BindBusinessUnit()
        {
            string V_OPR_MODE = string.Empty;
            try
            {
                V_OPR_MODE = opr_mode();
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_BUSINESS_UNIT, OledbParams, ddl_BU);
            }
            catch
            {
            }
                      

        }

        void BindEventCode()
        {
            try
            {
                int V_YEAR_ID = 0;
                int V_BUSINESS_UNIT_ID = 0;
                string V_OPR_MODE = string.Empty;
                V_OPR_MODE = opr_mode();
                V_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_BU.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_ACCRUAL_EC, OledbParams, ddl_EventCode);
            }
            catch
            {
            }
        }

        //void BindEventCodeAll()
        //{
        //    int V_BUSINESS_UNIT_ID = 0;
        //    int V_EVENT_CODE_ID = 0;
        //    try
        //    {
        //        V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_BU.SelectedValue);
        //        V_EVENT_CODE_ID = Convert.ToInt32(ddl_EventCode.SelectedValue);
        //        List<OleDbParameter> OledbParams = new List<OleDbParameter>();
        //        OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
        //        OledbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE_ID));
        //        DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_EVENT_CODE, OledbParams, ddlEventCode);
        //    }
        //    catch
        //    {
        //    }

        //    //try
        //    //{
        //    //    DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VAC_SELECT_EVENT_CODE, ddlEventCode);
        //    //}
        //    //catch
        //    //{
        //    //}
        //}

        void BindWorkArea()
        {
            string V_OPR_MODE = string.Empty;
            int V_YEAR_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_OPR_MODE = opr_mode();
                V_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddl_EventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_ACCRUAL_WA, OledbParams, ddl_WorkArea);
            }
            catch
            {
            }
        }

        void Bind_Company()
        {
            string V_OPR_MODE = string.Empty;
            int V_YEAR_ID = 0;
            int V_EVENT_CODE_ID = 0;
            int V_WORK_AREA_ID = 0;
            try
            {
                V_OPR_MODE = opr_mode();
                V_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddl_EventCode.SelectedValue);
                V_WORK_AREA_ID = Convert.ToInt32(ddl_WorkArea.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SELECT_ACCRUAL_COMPANY, OledbParams, ddl_Company);
            }
            catch
            {
            }
        }

        //void BindWorkAreaAll()
        //{
        //    try
        //    {
        //        List<OleDbParameter> OledbParams = new List<OleDbParameter>();
        //        OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", Convert.ToInt32(ddl_WorkArea.SelectedValue)));
        //        OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Convert.ToInt32(ddlEventCode.SelectedValue)));
        //        DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VAC_SEL_WA_FOR_EVCODE, OledbParams, ddlWorkArea);
        //    }
        //    catch
        //    {
        //    }
        //}

        //protected void btnshowhide_Click(object sender, ImageClickEventArgs e)
        //{
        //    if (CreateNew.Visible == true)
        //    {
        //        CreateNew.Visible = false;
        //        btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
        //    }
        //    else
        //    {
        //        btnshowhide.ImageUrl = "resource_gallery/graphics/minus.png";
        //        CreateNew.Visible = true;
        //    }
        //}

        private void BindAccrual()
        {
            string V_OPR_MODE = string.Empty;
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_OPR_MODE = opr_mode();
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_BU.SelectedValue);
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                sqlParams.Add(new OleDbParameter("V_YEAR_ID", Int32.Parse(ddl_Year.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Int32.Parse(ddl_EventCode.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", Int32.Parse(ddl_WorkArea.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", Int32.Parse(ddl_Company.SelectedValue)));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VAC_SELECT_YR_END_ACCRUAL, sqlParams, gdvAccrual);


                if (gdvAccrual.Rows.Count <= 0)
                {
                    gdvAccrualDetails.DataSource = null;
                    gdvAccrualDetails.DataBind();
                    btn_expExcel.Visible = false;
                }
                else
                {
                    btn_expExcel.Visible = true;
                }

                gdvAccrual.SelectedIndex = -1;
                this.gdvAccrual.SelectRow(0);

               

            }
            catch(Exception ex)
            {
            }
        }

        void BindAccrualDetail(int work_area_id)
        {
            string V_OPR_MODE = string.Empty;
            try
            {
                V_OPR_MODE = opr_mode();
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_OPR_MODE", V_OPR_MODE));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", Int32.Parse(ddl_Year.SelectedValue)));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", work_area_id));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VAC_SELECT_ALL_ACCRUAL_WA, OledbParams, gdvAccrualDetails);
                if (gdvAccrual.Rows.Count <= 0)
                {
                    gdvAccrualDetails.DataSource = null;
                    gdvAccrualDetails.DataBind();
                }
            }
            catch
            {
            }
        }

      

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddl_EventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            //BindEventCodeAll();
            BindWorkArea();
            BindAccrual();
        }

        protected void ddl_EventCode_DataBound(object sender, EventArgs e)
        {
            //BindEventCodeAll();
            BindWorkArea();
            BindAccrual();
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddl_WorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            Bind_Company();

            //BindWorkAreaAll();
            //BindAccrual();
        }

        protected void gdvAccrual_SelectedIndexChanged(object sender, EventArgs e)
        {
            int index = gdvAccrual.SelectedRow.RowIndex;
            GridViewRow row = gdvAccrual.SelectedRow;
            Label lblEventCodeId = row.FindControl("Label1") as Label;
            Label lblWorkAreaId = row.FindControl("Label5") as Label;
            Label lblCompanyId = row.FindControl("Label21") as Label;
            Label lblYrId = row.FindControl("lblYrId") as Label;

            v_EVENT_CODE_ID = lblEventCodeId.Text.ToString();
            v_WORK_AREA_ID = lblWorkAreaId.Text.ToString();
            v_COMPANY_ID = Convert.ToInt32(lblCompanyId.Text.ToString());
            v_YEAR_ID = Convert.ToInt32(lblYrId.Text.ToString());
            BindAccrualDetail(Convert.ToInt32(lblWorkAreaId.Text));
        }

        protected void gdvAccrual_RowCreated(object sender, GridViewRowEventArgs e)
        {
            //  e.Row.Cells[4].Visible = false;
            //e.Row.Cells[6].Visible = false;


            string om = opr_mode();

            if (om == "A")
            {
               
                e.Row.Cells[6].Visible = false;
                e.Row.Cells[7].Visible = false;
                e.Row.Cells[8].Visible = false;
                e.Row.Cells[9].Visible = false;
                e.Row.Cells[10].Visible = false;
                e.Row.Cells[11].Visible = false;
                e.Row.Cells[12].Visible = false;
                e.Row.Cells[13].Visible = false;
                e.Row.Cells[14].Visible = false;
                e.Row.Cells[15].Visible = false;
            }
            else
            {
               
                e.Row.Cells[6].Visible = true;
                e.Row.Cells[7].Visible = true;
                e.Row.Cells[8].Visible = true;
                e.Row.Cells[9].Visible = true;
                e.Row.Cells[10].Visible = true;
                e.Row.Cells[11].Visible = true;
                e.Row.Cells[12].Visible = true;
                e.Row.Cells[13].Visible = true;
                e.Row.Cells[14].Visible = true;
                e.Row.Cells[15].Visible = true;
            }
        }

        protected void gdvAccrual_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Attributes["onclick"] = Page.ClientScript.GetPostBackClientHyperlink(gdvAccrual, "Select$" + e.Row.RowIndex);
                e.Row.Attributes["style"] = "cursor:pointer";
            }
        }

        //private void AddDelete(Accrual obj)
        //{
        //    int retVal = 0;
        //    try
        //    {
        //        List<OleDbParameter> sqlParams = new List<OleDbParameter>();
        //        sqlParams.Add(new OleDbParameter("V_OPERATION", obj.V_OPERATION));
        //        sqlParams.Add(new OleDbParameter("V_OPR_MODE", obj.V_OPR_MODE));
        //        sqlParams.Add(new OleDbParameter("V_OBJECTID", obj.V_OBJECTID));
        //        sqlParams.Add(new OleDbParameter("V_YEAR_ID", obj.V_YEAR_ID));
        //        sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", obj.V_WORK_AREA_ID));
        //        sqlParams.Add(new OleDbParameter("V_ACCRUED_AMOUNT", obj.V_ACCRUED_AMOUNT));
        //        sqlParams.Add(new OleDbParameter("V_COMPANY_ID", obj.V_COMPANY_ID));
        //        sqlParams.Add(new OleDbParameter("V_MILEAGE", obj.V_MILEAGE));
        //        //sqlParams.Add(new OleDbParameter("V_EFFECTIVE_DATE", V_EFFECTIVE_DATE));
        //        sqlParams.Add(new OleDbParameter("V_BILLABLE", obj.V_BILLABLE));
        //        sqlParams.Add(new OleDbParameter("V_NON_BILLABLE", obj.V_NON_BILLABLE));
        //        sqlParams.Add(new OleDbParameter("V_URBAN_MILES", obj.V_URBAN_MILE));
        //        sqlParams.Add(new OleDbParameter("V_RURAL_MILES", obj.V_RURAL_MILE));
        //        sqlParams.Add(new OleDbParameter("V_CLIMBING_MILES", obj.V_CLIMBING_MILE));
        //        sqlParams.Add(new OleDbParameter("V_HELICOPTER_MILES", obj.V_HELICOPTER_MILE));
        //        sqlParams.Add(new OleDbParameter("V_URBAN_AMT", obj.V_URBAN_AMOUNT));
        //        sqlParams.Add(new OleDbParameter("V_RURAL_AMT", obj.V_RURAL_AMOUNT));
        //        sqlParams.Add(new OleDbParameter("V_CLIMBING_AMT", obj.V_CLIMBING_AMOUNT));
        //        sqlParams.Add(new OleDbParameter("V_HELICOPTER_AMT", obj.V_HELICOPTER_AMOUNT));
        //        sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
        //        retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VAC_YR_END_ACCRUAL_INS_DEL, sqlParams);

        //    }
        //    catch { }
        //    finally
        //    {
        //    }

        //    if (retVal == 1)
        //    {

        //         ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + obj.V_OPERATION.ToLower() + " successful.')", true);

        //    }
        //    else if (retVal == -1)
        //    {
        //        // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " failed.')", true);
        //    }

        //}

        protected void btn_addRates_Click(object sender, EventArgs e)
        {
            //    if (txtAccruedAmt.Text.Trim() == "")
            //    {
            //        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Accrued amount could not be blank!')", true);
            //        txtAccruedAmt.Focus();
            //        return;
            //    }

            //    //string strOperation = "";
            //    //string V_OPR_MODE = string.Empty;
            //    //int V_OBJECTID = 0;
            //    //int V_YEAR_ID = 0;
            //    //int V_WORK_AREA_ID = 0;
            //    //int V_COMPANY_ID = 0;
            //    //double V_ACCRUED_AMOUNT = 0;
            //    //double V_MILEAGE = 0;

            //    //double V_BILLABLE = 0;
            //    //double V_NON_BILLABLE = 0;
            //    //double V_URBAN_MILE = 0;
            //    //double V_RURAL_MILE = 0;
            //    //double V_CLIMBING_MILE = 0;
            //    //double V_HELICOPTER_MILE = 0;
            //    //double V_URBAN_AMOUNT = 0;
            //    //double V_RURAL_AMOUNT = 0;
            //    //double V_CLIMBING_AMOUNT = 0;
            //    //double V_HELICOPTER_AMOUNT = 0;
            //    //  DateTime V_EFFECTIVE_DATE;
            //    Accrual obj = new Accrual();

            //    try
            //    {
            //        obj.V_OPERATION = "INSERT";
            //        obj.V_OPR_MODE = opr_mode();
            //        obj.V_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
            //        obj.V_WORK_AREA_ID = Convert.ToInt32(ddlWorkArea.SelectedValue);
            //        obj.V_ACCRUED_AMOUNT = Convert.ToDouble(txtAccruedAmt.Text);
            //        //V_EFFECTIVE_DATE = Convert.ToDateTime(txtEffectiveDate.Text);
            //        obj.V_COMPANY_ID = Convert.ToInt32(ddlCompany.SelectedValue);
            //        obj.V_MILEAGE = txtMileage.Text == "" ? 0 : Convert.ToDouble(txtMileage.Text);
            //        obj.V_BILLABLE = txtBillable.Text == "" ? 0 : Convert.ToDouble(txtBillable.Text.Trim());
            //        obj.V_NON_BILLABLE = txtNonBillable.Text == "" ? 0 : Convert.ToDouble(txtNonBillable.Text.Trim());
            //        obj.V_URBAN_MILE = txtUrbanMiles.Text == "" ? 0 : Convert.ToDouble(txtUrbanMiles.Text.Trim());
            //        obj.V_RURAL_MILE = txtRuralMiles.Text == "" ? 0 : Convert.ToDouble(txtRuralMiles.Text.Trim());
            //        obj.V_CLIMBING_MILE = txtClimbingMiles.Text == "" ? 0 : Convert.ToDouble(txtClimbingMiles.Text.Trim());
            //        obj.V_HELICOPTER_MILE = txtHelicopterMiles.Text == "" ? 0 : Convert.ToDouble(txtHelicopterMiles.Text.Trim());
            //        obj.V_URBAN_AMOUNT = txtUrbanAmount.Text == "" ? 0 : Convert.ToDouble(txtUrbanAmount.Text.Trim());
            //        obj.V_RURAL_AMOUNT = txtRuralAmount.Text == "" ? 0 : Convert.ToDouble(txtRuralAmount.Text.Trim());
            //        obj.V_CLIMBING_AMOUNT = txtClimbingAmount.Text == "" ? 0 : Convert.ToDouble(txtClimbingAmount.Text.Trim());
            //        obj.V_HELICOPTER_AMOUNT = txtHelicopterAmount.Text == "" ? 0 : Convert.ToDouble(txtHelicopterAmount.Text.Trim()); 


            //        //AddDelete(obj);

            //        BindEventCode();
            //        ddl_EventCode.SelectedValue = ddlEventCode.SelectedValue;
            //        BindWorkArea();
            BindAccrual();

            //        txtAccruedAmt.Text = "";
            //        txtMileage.Text = "";
            //    }
            //    catch(Exception ex)
            //    {
            //    }
        }

        //protected void ddlEventCode_DataBound(object sender, EventArgs e)
        //{
        //    BindWorkAreaAll();
        //}

        //protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    BindWorkAreaAll();
        //}

        //protected void ddl_Mode_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    BindBusinessUnit();
        //    BindYear();

        //    if (opr_mode() == "M")
        //    {
        //        lbl_headercol.Text = "MILEAGE";
        //    }
        //    else
        //    {
        //        lbl_headercol.Text = "AMOUNT";
        //    }
        //}

        //protected void ddl_Mode_DataBound(object sender, EventArgs e)
        //{
        //    BindBusinessUnit();
        //    BindYear();
        //    if (opr_mode() == "M")
        //        {
        //            lbl_headercol.Text = "MILEAGE";
        //        }
        //        else
        //        {
        //            lbl_headercol.Text = "AMOUNT";
        //        }

        //}

        protected void ddl_BU_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
            //BindEventCodeAll();
        }

        protected void ddl_BU_DataBound(object sender, EventArgs e)
        {
            BindYear();
            //BindEventCodeAll();

        }

        protected string opr_mode()
        {
            string oprmode = string.Empty;
            if (rbt_accrual.Checked)
            {
                oprmode = "A";
            }
           else
            {
                oprmode = "F";

            }


            

            return oprmode;
        }

        protected void rbt_accrual_CheckedChanged(object sender, EventArgs e)
        {


            
         //   lbl_headercol.Text = "AMOUNT";
         
            BindBusinessUnit();
            BindYear();
        }

        protected void rbt_forecast_CheckedChanged(object sender, EventArgs e)
        {
           
         //   lbl_headercol.Text = "MILEAGE";

            BindBusinessUnit();
            BindYear();
        }

        protected void ddl_WorkArea_DataBound(object sender, EventArgs e)
        {
            Bind_Company();

            //BindWorkAreaAll();
            //BindAccrual();
        }

        protected void ddl_Company_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindAccrual();
        }

        protected void ddl_Company_DataBound(object sender, EventArgs e)
        {
            BindAccrual();
        }

        protected void btn_expExcel_Click(object sender, EventArgs e)
        {
            try
            {
                string oprmode = string.Empty;
                if (rbt_accrual.Checked)
                {
                    oprmode = "ACCRUAL";
                }
                else
                {
                    oprmode = "FORECAST";

                }
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Operation Mode", oprmode);
                dictionaryFilters.Add("Business Unit", ddl_BU.SelectedItem.Text);
                dictionaryFilters.Add("Work Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Project/Event", ddl_EventCode.SelectedItem.Text);
                dictionaryFilters.Add("Section/WA", ddl_WorkArea.SelectedItem.Text);
                dictionaryFilters.Add("Company", ddl_Company.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { 6 });
                VDMUtil.ExportGridToExcel(gdvAccrual, "Section/WA - Accrued/Forecasted List", "Accrued_Forecasted_List", dictionaryFilters, listColumnIndex);
            }
            catch(Exception ex)
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            string om = opr_mode();
            string url = "AddVMSAccrual.aspx?bu="+ ddl_BU.SelectedValue.ToString() + "&ec=" + v_EVENT_CODE_ID + "&wa=" + v_WORK_AREA_ID + "&om=" + om + "&ci=" + v_COMPANY_ID + "&yr=" + v_YEAR_ID;
            string s = "window.open('" + url + "', 'popup_window', 'width=700,height=300,left=100,top=100,resizable=yes');";
            ScriptManager.RegisterStartupScript(this, this.GetType(), "script", s, true);
        }

        protected void gdvAccrualDetails_RowCreated(object sender, GridViewRowEventArgs e)
        {
            string om = opr_mode();

            if (om == "A")
            {
                e.Row.Cells[5].Visible = false;
                e.Row.Cells[6].Visible = false;
                e.Row.Cells[7].Visible = false;
                e.Row.Cells[8].Visible = false;
                e.Row.Cells[9].Visible = false;
                e.Row.Cells[10].Visible = false;
                e.Row.Cells[11].Visible = false;
                e.Row.Cells[12].Visible = false;
                e.Row.Cells[13].Visible = false;
                e.Row.Cells[14].Visible = false;
            }
            else
            {
                e.Row.Cells[5].Visible = true;
                e.Row.Cells[6].Visible = true;
                e.Row.Cells[7].Visible = true;
                e.Row.Cells[8].Visible = true;
                e.Row.Cells[9].Visible = true;
                e.Row.Cells[10].Visible = true;
                e.Row.Cells[11].Visible = true;
                e.Row.Cells[12].Visible = true;
                e.Row.Cells[13].Visible = true;
                e.Row.Cells[14].Visible = true;
            }
        }
    }


    public class AccrualDetails
    {
        string eventcode = string.Empty;
        string workarea = string.Empty;
        string accruedamt = string.Empty;
        string effectdate = string.Empty;
        string updatedby = string.Empty;
        string timestamp = string.Empty;

        public AccrualDetails(string ec,string wa,string accamt,string effdate,string updateby,string time)
        {
            eventcode = ec;
            workarea = wa;
            accruedamt = accamt;
            effectdate = effdate;
            updatedby = updateby;
            timestamp = time;
        }

        public string EventCode
        {
            get { return eventcode; }
            set { eventcode = value; }
        }

        public string WorkArea
        {
            get { return workarea; }
            set { workarea = value; }
        }

        public string AccruedAmt
        {
            get { return accruedamt; }
            set { accruedamt = value; }
        }

        public string EffectDate
        {
            get { return effectdate; }
            set { effectdate = value; }
        }

        public string UpdatedBy
        {
            get { return updatedby; }
            set { updatedby = value; }
        }

        public string TimeStamp
        {
            get { return timestamp; }
            set { timestamp = value; }
        }
    }

    public class Accrual
    {
        public string V_OPERATION { get; set; }
        public string V_OPR_MODE { get; set; }
        public int V_OBJECTID { get; set; }
        public int V_YEAR_ID { get; set; }
        public int V_WORK_AREA_ID { get; set; }
        public int V_COMPANY_ID { get; set; }
        public double V_ACCRUED_AMOUNT { get; set; }
        public double V_MILEAGE { get; set; }
        public double V_FLAT_AMOUNT { get; set; }
        public double V_BILLABLE { get; set; }
        public double V_NON_BILLABLE { get; set; }
        public double V_URBAN_MILE { get; set; }
        public double V_RURAL_MILE { get; set; }
        public double V_CLIMBING_MILE { get; set; }
        public double V_HELICOPTER_MILE { get; set; }
        public double V_URBAN_AMOUNT { get; set; }
        public double V_RURAL_AMOUNT { get; set; }
        public double V_CLIMBING_AMOUNT { get; set; }
        public double V_HELICOPTER_AMOUNT { get; set; }
    }
}