﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;

namespace VMT
{
    public partial class TrimIssue_Map : System.Web.UI.Page
    {
        string m_SP_MAP_SELECT_WA_EVT_CODE_DESC = Properties.Settings.Default.SP_MAP_SELECT_WA_EVT_CODE_DESC;
        string m_SP_MAP_SELECT_WA_EC_BY_LINEID = Properties.Settings.Default.SP_MAP_SELECT_WA_EC_BY_LINEID;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!String.IsNullOrEmpty(Request.QueryString["WORK_AREA_ID"]))
            {
                lblWa.Visible = true;
                lblWaValue.Visible = true;
                int V_WORK_AREA_ID = Convert.ToInt32(Request.QueryString["WORK_AREA_ID"].ToString());
                GetEventCodeDesc(V_WORK_AREA_ID);

            }
            else if (!String.IsNullOrEmpty(Request.QueryString["LINE_ID"]))
            {
                lblWa.Visible = true;
                lblWaValue.Visible = true;
                if (Request.QueryString["LINE_ID"] == "Summary")
                {
                    int V_WORK_AREA_ID = Convert.ToInt32(Request.QueryString["WkID"].ToString());
                    GetEventCodeDesc(V_WORK_AREA_ID);
                }
                else
                {
                    int V_LINE_ID = Convert.ToInt32(Request.QueryString["LINE_ID"].ToString());
                    GetEventCodeDescByLine(V_LINE_ID);
                }
            }
            else
            {
                lblWa.Visible = false;
                lblWaValue.Visible = false;
                return;
            }
        }

        private void GetEventCodeDesc(int V_WORK_AREA_ID)
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));

            ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_MAP_SELECT_WA_EVT_CODE_DESC, OleDbParams);
            if (ds.Tables[0].Rows.Count > 0)
            {
                hdnEventCode.Value = ds.Tables[0].Rows[0][0].ToString();
                hdnWworkArea.Value = ds.Tables[0].Rows[0][1].ToString();
            }
        }

        private void GetEventCodeDescByLine(int V_LINE_ID)
        {
            int V_WkID = Convert.ToInt32(Request.QueryString["WkID"].ToString());
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            OleDbParams.Add(new OleDbParameter("V_LINE_ID", V_LINE_ID));
            OleDbParams.Add(new OleDbParameter("V_WkID", V_WkID));
            ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_MAP_SELECT_WA_EC_BY_LINEID, OleDbParams);
            if (ds.Tables[0].Rows.Count > 0)
            {
                hdnEventCode.Value = ds.Tables[0].Rows[0][0].ToString();
                hdnWworkArea.Value = ds.Tables[0].Rows[0][1].ToString();
            }
        }
    }
}