﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TreeRemoval_Map.aspx.cs" Inherits="VMT.TreeRemoval_Map" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta content="IE=10" http-equiv="X-UA-Compatible">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="initial-scale=1, maximum-scale=1,user-scalable=no">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <!--The viewport meta tag is used to improve the presentation and behavior of the samples 
      on iOS devices-->
    <title>Locate Work Area</title>
    
    <link rel="stylesheet" href="http://js.arcgis.com/3.12/esri/css/esri.css">


   <style type="text/css">     
     @import "http://js.arcgis.com/3.12/dijit/themes/claro/claro.css";
      html, body, form, #map {
            height: 100%;
            width: 100%;
            margin: 0;
            padding: 0;
      }
       body {    
              font-family: Arial, Verdana, 'Times New Roman';
              font-size: 13px;
              background:#fff url('') no-repeat center center fixed;
              overflow:hidden;
              -webkit-background-size: cover;
              -moz-background-size: cover;
              -o-background-size: cover;
              background-size: cover;
              margin: 2px;
              padding: 0;
    }

       .MapNavIcon {
            width:26px; 
            height:26px;
        }
        .MapNavIcon:hover {
             width:32px; 
            height:32px;
        }
       .myDynamicButton {
           background-color: transparent;
           border: 0px;
           border-color: transparent
       }
      .zoominIcon {
        background-image: url(resource_gallery/graphics/nav_zoomin.png);
        width: 16px;
        height: 16px;
      }
      .zoomoutIcon {
        background-image: url(resource_gallery/graphics/nav_zoomout.png);
        width: 16px;
        height: 16px;
      }
      .zoomfullextIcon {
        background-image: url(resource_gallery/graphics/nav_fullextent.png);
        width: 16px;
        height: 16px;
      }
      .zoomprevIcon {
        background-image: url(resource_gallery/graphics/nav_previous.png);
        width: 16px;
        height: 16px;
      }
      .zoomnextIcon {
        background-image: url(resource_gallery/graphics/nav_next.png);
        width: 16px;
        height: 16px;
      }
      .panIcon {
        background-image: url(resource_gallery/graphics/nav_pan.png);
        width: 16px;
        height: 16px;
      }
      .deactivateIcon {
        background-image: url(resource_gallery/graphics/nav_decline.png);
        width: 16px;
        height: 16px;
      }
      #leftPane{
       
        border: solid 1px #343642;
        margin:5px 5px 5px 5px;
        color: #343642;        

        position:absolute; 
        z-index: 2; 
        background-color:white; 
        width:440px; height:50px; 
        margin: 20px 1px 1px 60px; 
        padding: 6px; 
        border-radius: 8px; 
        font-size:12px;
        /*letter-spacing: 0.05em;*/
      }
      /*#leftPane{
        width:90%;
        border: solid 1px #343642;
        margin:5px 5px 5px 5px;
        color: #343642;
        font:100% Georgia,"Times New Roman",Times,serif;
        
      }*/
    </style>
    
    <script src="http://js.arcgis.com/3.12/"></script>
      <script type="text/javascript">

          function Mapview(v) {
              //To Do
              switch (v) {
                  case "Road":
                      //Road
                      veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD); return false;
                      break;
                  case "Aerial":
                      //Aerial
                      veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL); return false;
                      break;
                  case "Aerialp":
                      //Aerial with Label
                      veTileLayer.setMapStyle(esri.virtualearth.VETiledLayer.MAP_STYLE_AERIAL_WITH_LABELS); return false;
                      break;
              }
          };

      </script>
    <script type="text/javascript">
        var map, locator;
        require([
          "esri/map",
          "esri/tasks/locator",
          "esri/graphic",
          "esri/toolbars/navigation",
          "dojo/on",
          "esri/tasks/QueryTask",
          "esri/tasks/query",

          "esri/InfoTemplate",
          "esri/symbols/SimpleMarkerSymbol",
          "dojo/_base/array",
          "esri/symbols/TextSymbol",
          "esri/Color",
          "esri/symbols/Font",
          "dojo/parser",
          "dojo/dom",
          "dijit/registry",
           "esri/virtualearth/VETiledLayer",
          "dijit/Toolbar",

          "esri/layers/FeatureLayer",
          "dijit/form/Button",
          "dojo/number",
          "dijit/form/Textarea",
          "dijit/layout/BorderContainer",
          "dijit/layout/ContentPane",
          "dojo/domReady!"
        ],
          function (
              Map,
              Locator,
              Graphic,
              Navigation,
              on,
              QueryTask,
              Query,
              InfoTemplate,
              SimpleMarkerSymbol,
              arrayUtils,
              TextSymbol,
              Color,
              Font,
              parser,
              dom,
              registry,
              FeatureLayer,
              number

           ) {

              parser.parse();
              var navToolbar;

              map = new Map("map", {
                  basemap: "streets",
                  center: [-81.0324, 33.9897],
                  //center: [getParameterByName('lat'), getParameterByName('lon')],
                  spatialReference: { wkid: 4269 },
                  zoom: 15
              });

              veTileLayer = new esri.virtualearth.VETiledLayer({
                   bingMapsKey: '<%=ConfigurationManager.AppSettings["bingMapKey"].ToString() %>',
                  mapStyle: esri.virtualearth.VETiledLayer.MAP_STYLE_ROAD
              });
              map.addLayer(veTileLayer);

              navToolbar = new Navigation(map);
              on(navToolbar, "onExtentHistoryChange", extentHistoryChangeHandler);

              registry.byId("zoomin").on("click", function () {
                  navToolbar.activate(Navigation.ZOOM_IN);
              });

              registry.byId("zoomout").on("click", function () {
                  navToolbar.activate(Navigation.ZOOM_OUT);
              });

              registry.byId("zoomfullext").on("click", function () {
                  navToolbar.zoomToFullExtent();
              });

              registry.byId("zoomprev").on("click", function () {
                  navToolbar.zoomToPrevExtent();
              });

              registry.byId("zoomnext").on("click", function () {
                  navToolbar.zoomToNextExtent();
              });

              registry.byId("pan").on("click", function () {
                  navToolbar.activate(Navigation.PAN);
              });


              function extentHistoryChangeHandler() {
                  registry.byId("zoomprev").disabled = navToolbar.isFirstExtent();
                  registry.byId("zoomnext").disabled = navToolbar.isLastExtent();
              }

              var fetLayer;
              var histFetLayer;
              var url = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_TREE_REMOVAL"].ToString() %>"
              var histUrl = "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_TRIM_LINES"].ToString() %>"

              function AddFeaturewithnoPopup(feature_layer) {
                  //alert(feature_layer)
                  var featureLayerUrl = feature_layer;
                  featureLayer = new esri.layers.FeatureLayer(featureLayerUrl, {
                      mode: esri.layers.FeatureLayer.MODE_ONDEMAND,
                      outFields: ["*.*"]
                  });

                  map.addLayer(featureLayer);
                  if (feature_layer == "<%= System.Configuration.ConfigurationManager.AppSettings["MapService_TREE_REMOVAL"].ToString() %>")
                      fetLayer = featureLayer;
                  else
                      histFetLayer = featureLayer;

              }



              AddFeaturewithnoPopup(url);
              AddFeaturewithnoPopup(histUrl);



              if (getParameterByName('INSPECTION_NAME') != '') {
                  searchObjectId(getParameterByName('INSPECTION_NAME'), url);
              }


              try {


                  var infoTemplate = new InfoTemplate();
                  infoTemplate.setTitle("${WORK_AREA_ID}");
                  infoTemplate.setContent("<b>RATE TYPE NAME  : </b>${RATE_TYPE_NAME}<br/>" +
                                          "<b>WORK AREA ID  : </b>${WORK_AREA_ID}<br/>" +
                                          "<b>FOREMAN  : </b>${FOREMAN}<br/>" +

                                          "<br/>");


                  ProjectLayer = new esri.layers.FeatureLayer(url, {
                      infoTemplate: infoTemplate,
                      outFields: ["RATE_TYPE_NAME", "WORK_AREA_ID ", "FOREMAN"]
                  });

                  var histInfoTemplate = new InfoTemplate();
                  histInfoTemplate.setTitle("${OBJECTID }");
                  histInfoTemplate.setContent("<b>FOREMAN  : </b>${FOREMAN }<br/>" +
                                          "<b>HIST SECTION/WA  : </b>${WORK_AREA_ID}<br/>" +
                                          "<b>HIST PROJECT/EVENT  : </b>${EVENT_CODE_ID}<br/>" + "<br/>");

                  histProjectLayer = new esri.layers.FeatureLayer(histUrl, {
                      infoTemplate: histInfoTemplate,
                      outFields: ["OBJECTID", "FOREMAN", "WORK_AREA_ID", "EVENT_CODE_ID"]
                  });

                  //apply a renderer
                  var symbol = new esri.symbol.SimpleFillSymbol(esri.symbol.SimpleFillSymbol.STYLE_SOLID,
                    new esri.symbol.SimpleLineSymbol(esri.symbol.SimpleLineSymbol.STYLE_SOLID,
                      new Color([255, 255, 255, 0.35]), 1),
                    new Color([109, 146, 155, 0.35]));


                  ProjectLayer.setRenderer(new esri.renderer.SimpleRenderer(symbol));
                  histProjectLayer.setRenderer(new esri.renderer.SimpleRenderer(symbol));

                  map.addLayer(histProjectLayer);
                  map.addLayer(ProjectLayer);
              }
              catch (e) {
                  alert("Error Message: " + e.message);
              }



              locator = new Locator("http://geocode.arcgis.com/arcgis/rest/services/World/GeocodeServer");
              locator.on("address-to-locations-complete", showResults);

              // listen for button click then geocode
              registry.byId("locate").on("click", locate);

              map.infoWindow.resize(200, 125);

              if (navigator.userAgent.indexOf("Chrome") != -1) {
                  window.onload = searchproject;
              }

              if ((navigator.userAgent.indexOf("MSIE") != -1) || (!!document.documentMode == true)) //IF IE > 10
              {
                  window.onload = searchproject;
              }


              function searchprojectProject(proj_id, UrlToYourLayer) {
                  var incr = 0;

                  if (proj_id != '') {

                      try {
                          //Define a new Query and QueryTask 
                          queryTask = new esri.tasks.QueryTask(UrlToYourLayer);
                          query = new esri.tasks.Query();
                          query.returnGeometry = true;
                          query.outFields = ["*"];

                          //The query's where clause will be attribute query to find the feature  
                          query.where = "WORK_AREA_ID = '" + proj_id + "'";

                          query.outSpatialReference = map.spatialReference;
                          //Run the query. Its results are returned in the function showResults  
                          queryTask.execute(query, showResults1);

                          //results is an array of any found features. Assuming you only want the first feature:  
                          function showResults1(results) {
                              try {
                                  // var result = results.features[0];
                                  //  var extent = result.geometry.getExtent().expand(5.2);
                                  //  map.setExtent(extent);

                                  var myFeatureExtent = esri.graphicsExtent(results.features);
                                  map.setExtent(myFeatureExtent.expand(1.3));
                              }
                              catch (e) {
                                  //alert("Error Message: " + e.message);
                              }

                              try {

                                  //create symbol for selected features
                                  symbolS = new esri.symbol.SimpleLineSymbol();
                                  symbolS.setStyle(esri.symbol.SimpleLineSymbol.STYLE_SOLID);
                                  symbolS.setWidth(3);
                                  if (UrlToYourLayer == url) {
                                      map.graphics.clear();
                                      symbolS.setColor(new Color([4, 143, 10, 1.5]));
                                  }
                                  else
                                      symbolS.setColor(new Color([4, 5, 10, 1.5]));

                                  //remove all graphics on the maps graphics layer
                                  //map.graphics.clear();

                                  //Performance enhancer - assign featureSet array to a single variable.
                                  var resultFeatures = results.features;

                                  //Loop through each feature returned
                                  for (var i = 0, il = resultFeatures.length; i < il; i++) {
                                      //Get the current feature from the featureSet.
                                      //Feature is a graphic
                                      var graphicS = resultFeatures[i];
                                      graphicS.setSymbol(symbolS);

                                      //Set the infoTemplate.
                                      // graphic.setInfoTemplate(infoTemplate);

                                      //Add graphic to the map graphics layer.
                                      map.graphics.add(graphicS);

                                  }

                              }
                              catch (e) {
                                  //  alert("Error Message: " + e.message);
                              }
                          }
                      }
                      catch (e) {
                          //  alert("Error Message: " + e.message);
                      }
                  }
              }

              function searchObjectId(proj_id, UrlToYourLayer) {
                  var incr = 0;
                  //alert("Project Id:" + proj_id);
                  if (proj_id != '') {

                      try {



                          //Define a new Query and QueryTask  
                          queryTask = new esri.tasks.QueryTask(UrlToYourLayer);
                          query = new esri.tasks.Query();
                          query.returnGeometry = true;
                          query.outFields = ["*"];

                          //The query's where clause will be attribute query to find the feature  
                          query.where = "OBJECTID = '" + proj_id + "'";
                          query.outSpatialReference = map.spatialReference;

                          //Run the query. Its results are returned in the function showResults  
                          queryTask.execute(query, showResults1);


                          //results is an array of any found features. Assuming you only want the first feature:  
                          function showResults1(results) {
                              try {
                                  var myFeatureExtent = esri.graphicsExtent(results.features);
                                  map.setExtent(myFeatureExtent.expand(0.4));



                              }
                              catch (e) {
                                  alert("Error Message: " + e.message);
                              }

                              try {
                                  var symbol1 = new esri.symbol.SimpleMarkerSymbol();
                                  symbol1.setStyle(esri.symbol.SimpleMarkerSymbol.STYLE_SQUARE);
                                  symbol1.setColor(new Color([153, 0, 51, 0.75]));


                                  //create symbol for selected features
                                  symbolS = new esri.symbol.SimpleLineSymbol();
                                  symbolS.setStyle(esri.symbol.SimpleLineSymbol.STYLE_SOLID);
                                  symbolS.setWidth(3);
                                  if (UrlToYourLayer == url) {
                                      map.graphics.clear();
                                      symbolS.setColor(new Color([4, 143, 10, 1.5]));
                                  }
                                  else
                                      symbolS.setColor(new Color([4, 5, 10, 1.5]));

                                  //remove all graphics on the maps graphics layer
                                  //map.graphics.clear();

                                  //Performance enhancer - assign featureSet array to a single variable.
                                  var resultFeatures = results.features;

                                  //Loop through each feature returned
                                  for (var i = 0, il = resultFeatures.length; i < il; i++) {
                                      //Get the current feature from the featureSet.
                                      //Feature is a graphic
                                      var graphicS = resultFeatures[i];
                                      graphicS.setSymbol(symbolS);

                                      //Set the infoTemplate.
                                      // graphic.setInfoTemplate(infoTemplate);

                                      //Add graphic to the map graphics layer.
                                      map.graphics.add(graphicS);


                                      var graphics1 = resultFeatures[i];
                                      graphics1.setSymbol(symbol1);

                                      //Set the infoTemplate.
                                      // graphic.setInfoTemplate(infoTemplate);

                                      //Add graphic to the map graphics layer.
                                      map.graphics.add(graphics1);

                                  }


                              }
                              catch (e) {
                                  //   alert("Error Message: " + e.message);
                              }
                          }
                      }
                      catch (e) {
                          // alert("Error Message: " + e.message);
                      }
                  }
              }

              function searchLine(LINE_ID, UrlToYourLayer) {
                  var incr = 0;

                  if (LINE_ID != '') {

                      try {



                          //Define a new Query and QueryTask  
                          queryTask = new esri.tasks.QueryTask(UrlToYourLayer);
                          query = new esri.tasks.Query();
                          query.returnGeometry = true;
                          query.outFields = ["*"];

                          //The query's where clause will be attribute query to find the feature  
                          query.where = "LINE_ID = '" + LINE_ID + "'";
                          query.outSpatialReference = map.spatialReference;

                          //Run the query. Its results are returned in the function showResults  
                          queryTask.execute(query, showResults1);


                          //results is an array of any found features. Assuming you only want the first feature:  
                          function showResults1(results) {
                              try {
                                  //  var result = results.features[0];
                                  //   var extent = result.geometry.getExtent().expand(5.2);
                                  //  map.setExtent(extent);

                                  var myFeatureExtent = esri.graphicsExtent(results.features);
                                  map.setExtent(myFeatureExtent.expand(0.4));
                              }
                              catch (e) {
                                  alert("Error Message: " + e.message);
                              }

                              try {

                                  //create symbol for selected features
                                  symbolS = new esri.symbol.SimpleLineSymbol();
                                  symbolS.setStyle(esri.symbol.SimpleLineSymbol.STYLE_SOLID);
                                  symbolS.setWidth(3);
                                  if (UrlToYourLayer == url) {
                                      map.graphics.clear();
                                      symbolS.setColor(new Color([4, 143, 10, 1.5]));
                                  }
                                  else
                                      symbolS.setColor(new Color([4, 5, 10, 1.5]));

                                  //remove all graphics on the maps graphics layer
                                  //map.graphics.clear();

                                  //Performance enhancer - assign featureSet array to a single variable.
                                  var resultFeatures = results.features;

                                  //Loop through each feature returned
                                  for (var i = 0, il = resultFeatures.length; i < il; i++) {
                                      //Get the current feature from the featureSet.
                                      //Feature is a graphic
                                      var graphicS = resultFeatures[i];
                                      graphicS.setSymbol(symbolS);

                                      //Set the infoTemplate.
                                      // graphic.setInfoTemplate(infoTemplate);

                                      //Add graphic to the map graphics layer.
                                      map.graphics.add(graphicS);

                                  }


                              }
                              catch (e) {
                                  //   alert("Error Message: " + e.message);
                              }
                          }
                      }
                      catch (e) {
                          // alert("Error Message: " + e.message);
                      }
                  }
              }

              function searchLineByNameOff(NAME_OFFICIAL, WORK_AREA_ID, UrlToYourLayer) {
                  var incr = 0;
                  if (NAME_OFFICIAL != '') {

                      try {



                          //Define a new Query and QueryTask  
                          queryTask = new esri.tasks.QueryTask(UrlToYourLayer);
                          query = new esri.tasks.Query();
                          query.returnGeometry = true;
                          query.outFields = ["*"];

                          //The query's where clause will be attribute query to find the feature  
                          query.where = "WORK_AREA_ID = '" + WORK_AREA_ID + "'" + "AND NAME_OFFICIAL = '" + NAME_OFFICIAL + "'";
                          query.outSpatialReference = map.spatialReference;
                          //Run the query. Its results are returned in the function showResults  
                          queryTask.execute(query, showResults1);


                          //results is an array of any found features. Assuming you only want the first feature:  
                          function showResults1(results) {
                              try {
                                  //  var result = results.features[0];
                                  //   var extent = result.geometry.getExtent().expand(5.2);
                                  //  map.setExtent(extent);

                                  var myFeatureExtent = esri.graphicsExtent(results.features);
                                  map.setExtent(myFeatureExtent.expand(0.4));
                              }
                              catch (e) {
                                  alert("Error Message: " + e.message);
                              }

                              try {

                                  //create symbol for selected features
                                  symbolS = new esri.symbol.SimpleLineSymbol();
                                  symbolS.setStyle(esri.symbol.SimpleLineSymbol.STYLE_SOLID);
                                  symbolS.setWidth(3);
                                  if (UrlToYourLayer == url) {
                                      map.graphics.clear();
                                      symbolS.setColor(new Color([4, 143, 10, 1.5]));
                                  }
                                  else
                                      symbolS.setColor(new Color([4, 5, 10, 1.5]));

                                  //remove all graphics on the maps graphics layer
                                  //map.graphics.clear();

                                  //Performance enhancer - assign featureSet array to a single variable.
                                  var resultFeatures = results.features;

                                  //Loop through each feature returned
                                  for (var i = 0, il = resultFeatures.length; i < il; i++) {
                                      //Get the current feature from the featureSet.
                                      //Feature is a graphic
                                      var graphicS = resultFeatures[i];
                                      graphicS.setSymbol(symbolS);

                                      //Set the infoTemplate.
                                      // graphic.setInfoTemplate(infoTemplate);

                                      //Add graphic to the map graphics layer.
                                      map.graphics.add(graphicS);

                                  }


                              }
                              catch (e) {
                                  //   alert("Error Message: " + e.message);
                              }
                          }
                      }
                      catch (e) {
                          // alert("Error Message: " + e.message);
                      }
                  }
              }
              function searchproject() {


                  if (getParameterByName('INSPECTION_NAME') != '') {
                      document.getElementById('lblPjtValue').innerText = getParameterByName('nm');
                      alert("Zooming to Rate Type : " + getParameterByName('nm'));
                      searchObjectId(getParameterByName('INSPECTION_NAME'), url);

                  }
              }

              function getParameterByName(name) {
                  name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
                  var regexString = "[\\?&]" + name + "=([^&#]*)";
                  var regex = new RegExp(regexString);
                  var found = regex.exec(window.location.search);
                  if (found == null)
                      return "";
                  else
                      return decodeURIComponent(found[1].replace(/\+/g, " "));
              }

              function locate() {

                  map.graphics.clear();
                  var address = {
                      "SingleLine": dom.byId("address").value
                  };
                  locator.outSpatialReference = map.spatialReference;

                  var options = {
                      address: address,
                      outFields: ["Loc_name"]
                  };

                  locator.addressToLocations(options);

              }
              function showResults(evt) {

                  var symbol = new SimpleMarkerSymbol();

                  var infoTemplate = new InfoTemplate(
                    "Location",
                    "Address: ${address}<br />Score: ${score}<br />Source locator: ${locatorName}"
                  );

                  symbol.setStyle(SimpleMarkerSymbol.STYLE_SQUARE);

                  symbol.setColor(new Color([153, 0, 51, 0.75]));

                  var geom;

                  arrayUtils.every(evt.addresses, function (candidate) {
                      console.log(candidate.score);

                      if (candidate.score > 80) {
                          console.log(candidate.location);
                          var attributes = {
                              address: candidate.address,
                              score: candidate.score,
                              locatorName: candidate.attributes.Loc_name
                          };
                          geom = candidate.location;
                          var graphic = new Graphic(geom, symbol, attributes, infoTemplate);
                          //add a graphic to the map at the geocoded location

                          map.graphics.add(graphic);
                          //add a text symbol to the map listing the location of the matched address.
                          var displayText = candidate.address;

                          var font = new Font(
                            "16pt",
                            Font.STYLE_NORMAL,
                            Font.VARIANT_NORMAL,
                            Font.WEIGHT_BOLD,
                            "Helvetica"
                          );
                          var textSymbol = new TextSymbol(
                            displayText,
                            font,
                            new Color("#666633")
                          );
                          textSymbol.setOffset(0, 8);
                          map.graphics.add(new Graphic(geom, textSymbol));

                          return false; //break out of loop after one candidate with score greater  than 80 is found.
                      }
                  });


                  if (geom !== undefined) {
                      //map.centerAndZoom(geom, 14);
                  }
              }
          });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server" EnablePageMethods="true"></asp:ScriptManager>
        <div id="leftPane" style="height:67px;"
               data-dojo-type="dijit/layout/ContentPane" 
               data-dojo-props="region:'left'" style="">
            Enter an address then click locate. 
            <br/>
            <input type="text" id="address"  style="width:140px;" />        
            <button id="locate" data-dojo-type="dijit/form/Button"  style="width:60px; height:16px;">Locate</button>
        
            <select style="margin: 4px; color:#ff8400;" onchange="Mapview(this.value)"> 
                <option value="Road">Bing: Road</option>
                <option value="Aerial">Bing: Aerial</option>
                <option value="Aerialp">Bing: Aerial+</option>
            </select>
           <%-- History
            <input type="checkbox" id="chkHist" />--%>
            <br/>
            <label id="lblPjt" style="color:#00008B;">RATE TYPE: </label>
            <label id="lblPjtValue"></label> 
            <br/>  
            <label id="lblWa" runat="server" style="color:#00008B;" ></label>
            <label id="lblWaValue" runat="server" style="margin: 22px;"></label>     
            <!--<input id="btnForIEZoom" type="submit" style="display:block;font-weight: bold;" />-->
          </div>


         <div id="navToolbar" data-dojo-type="dijit/Toolbar" style="width:44px; position:absolute; z-index: 2; margin: 100px 100px 1px 15px; background-color:white; border:solid 1px; border-radius: 8px; ">
          <div data-dojo-type="dijit/form/Button" id="zoomin" style="width:34px; float:left; margin: 5px;" ><img src="resource_gallery/graphics/zoomin.png" alt="Zoom in" class="MapNavIcon"   /></div>
          <div data-dojo-type="dijit/form/Button" id="zoomout" style="width:34px;  float:left; margin: 5px;"><img src="resource_gallery/graphics/zoomout.png" alt="Zoom Out" class="MapNavIcon" /></div>
          <div data-dojo-type="dijit/form/Button" id="zoomfullext" style="width:34px; float:left;  margin: 5px;"><img src="resource_gallery/graphics/fullextent.png" alt="Full Extent" class="MapNavIcon"  /></div>
          <div data-dojo-type="dijit/form/Button" id="zoomprev" style="width:34px; float:left;  margin: 5px;"><img src="resource_gallery/graphics/prev.png" alt="Prev Extent" class="MapNavIcon"  /></div>
          <div data-dojo-type="dijit/form/Button" id="zoomnext" style="width:34px; float:left;  margin: 5px;"><img src="resource_gallery/graphics/next.png" alt="Next Extent" class="MapNavIcon"  /></div>
          <div data-dojo-type="dijit/form/Button" id="pan" style="width:34px; float:left;  margin: 5px;"><img src="resource_gallery/graphics/hand.png" alt="Pan" class="MapNavIcon"  /></div>
          <!-- <div data-dojo-type="dijit/form/Button" id="deactivate"><img src="images/zoomin.png" alt="Deactivate" /></div>-->
          </div>
         <div id="map" style="width:100%; height:100%; z-index: 0; ">

          

         
         </div>
        <asp:HiddenField ID="hdnEventCode" runat="server" />
        <asp:HiddenField ID="hdnWworkArea" runat="server" />
    </form>
</body>
</html>
