﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;

namespace VMT
{
    public partial class TreeRemovalView : System.Web.UI.Page
    {
        string m_SP_TR_SELECT_BU = Properties.Settings.Default.SP_TR_SELECT_BU;
        string m_SP_TR_SELECT_YEAR = Properties.Settings.Default.SP_TR_SELECT_YEAR;
        string m_SP_TR_SELECT_EVENTCODE = Properties.Settings.Default.SP_TR_SELECT_EVENTCODE;
        string m_SP_TR_SELECT_WA = Properties.Settings.Default.SP_TR_SELECT_WA;
        string m_SP_TR_SELECT_COMPANY = Properties.Settings.Default.SP_TR_SELECT_COMPANY;
        string m_SP_TR_SELECT_DETAILS = Properties.Settings.Default.SP_TR_SELECT_DETAILS;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Tree Removal";

        protected void Page_Load(object sender, EventArgs e)
        {
            
            //checks user role
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
                //btnSubmitBid.Visible = true;
            //}
            //else
            //{
                //btnSubmitBid.Visible = false;
            //}

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {


                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }


                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
                ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                BindEventCode();
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_TR_SELECT_BU, ddlBUnit);
            }
            catch
            {
            }
        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
            BindEventCode();
            BindWorkArea();
        }

        void BindYear()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();

                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_TR_SELECT_YEAR, sqlParams, ddlYear);
            }
            catch
            {
            }

        }

        protected void ddlBUnit_DataBound(object sender, EventArgs e)
        {
            BindYear();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
            //BindWorkArea();
        }

        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_TR_SELECT_EVENTCODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }
        }

        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
            //BindWorkArea();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        void BindWorkArea()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_TR_SELECT_WA, OledbParams, ddlWorkArea);
            }
            catch
            {
            }
        }

        void BindCompany()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_EVENT_CODE_ID = 0;
            int V_WORK_AREA_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                V_WORK_AREA_ID = Convert.ToInt32(ddlWorkArea.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_TR_SELECT_COMPANY, OledbParams, ddlCompany);
            }
            catch
            {
            }
        }
        protected void ddlWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            //if (ddlWorkArea.SelectedIndex != -1)
            //    btnGo.Enabled = true;
            //ViewState["BUnit"] = ddlBUnit.SelectedValue;
            //ViewState["Year"] = ddlYear.SelectedValue;
            //ViewState["EventCode"] = ddlEventCode.SelectedValue;
            //ViewState["WorkArea"] = ddlWorkArea.SelectedValue;
            BindCompany();
        }

        protected void ddlWorkArea_DataBound(object sender, EventArgs e)
        {
            //ViewState["BUnit"] = ddlBUnit.SelectedValue;
            //ViewState["Year"] = ddlYear.SelectedValue;
            //ViewState["EventCode"] = ddlEventCode.SelectedValue;
            //ViewState["WorkArea"] = ddlWorkArea.SelectedValue;
            BindCompany();
        }

        private void BindTreeRemoval()
        {
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT", Int32.Parse(ddlBUnit.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_YEAR", Int32.Parse(ddlYear.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE", Int32.Parse(ddlEventCode.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA", Int32.Parse(ddlWorkArea.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", Int32.Parse(ddlCompany.SelectedValue)));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_TR_SELECT_DETAILS, sqlParams, gdvBidProcess);
                ViewState["dataTable"] = gdvBidProcess.DataSource as DataSet;
                gdvBidProcess.SelectedIndex = -1;
                if (gdvBidProcess.Rows.Count > 0)
                    btnExportExcel.Visible = true;
                else
                    btnExportExcel.Visible = false;
            }
            catch
            {
            }
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                dictionaryFilters.Add("Work Area", ddlWorkArea.SelectedItem.Text);
                List<int> listHideColumns = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdvBidProcess, "Tree Removal", "Tree_Removal", dictionaryFilters, listHideColumns);
            }
            catch
            {
            }
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void gdvBidProcess_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvBidProcess, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        protected void ddlCompany_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindTreeRemoval();
        }

        protected void ddlCompany_DataBound(object sender, EventArgs e)
        {
            BindTreeRemoval();
        }
    }
}