﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.IO;

namespace VMT
{
    public partial class Spray_Workarea_Company : System.Web.UI.Page
    {
        int m_TreatStatus; 
        string m_SP_SPRAWC_SEL_BSUNIT = Properties.Settings.Default.SP_SPRAWC_SEL_BSUNIT;
        string m_SP_SPRAWC_SEL_YEAR = Properties.Settings.Default.SP_SPRAWC_SEL_YEAR;
        string m_SP_SPRAWC_SEL_EVENTCODE = Properties.Settings.Default.SP_SPRAWC_SEL_EVENTCODE;
        string m_SP_SPRAWC_SEL_COMPANY_S = Properties.Settings.Default.SP_SPRAWC_SEL_COMPANY;
        //string m_SP_SPRAWC_SEL_WA_FOR_EVCODE = Properties.Settings.Default.SP_SPRAWC_SEL_WA_FOR_EVCODE;
        string m_SP_SPRAWC_SEL_WA_COMPANY_S = Properties.Settings.Default.SP_SPRAWC_SEL_WA_COMPANY;
        string m_SP_SPRAWC_WA_COMPANY_INS_DEL_S = Properties.Settings.Default.SP_SPRAWC_WA_COMPANY_INS_DEL;
        //string m_SP_SPRAWC_WA_RATES_COMP_ASSGN = Properties.Settings.Default.SP_SPRAWC_WA_RATES_COMP_ASSGN;

        string m_SP_SPRAWC_GET_EDITABLE = Properties.Settings.Default.SP_SPRAWC_GET_EDITABLE;
        string m_SP_SPRAWC_SEL_COMPANY_ASSIGN = Properties.Settings.Default.SP_SPRAWC_SEL_COMPANY_ASSIGN;
        
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string AssgnEdit = string.Empty;
        string BU = "";
        string EC = "";
        string YR = "";
        string RTF = "";
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Assign Spray Project/Event to Company";

        protected void Page_Load(object sender, EventArgs e)
        {
            

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btn_expExcel);
            InspectionStatus();
            if (!Page.IsPostBack)
            {


                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }
                if (userRole == "0")
                {
                    Response.Redirect("default.aspx");
                }
                hdn_role.Value = userRole;
                btn_expExcel.Visible = false;

                if (Request.QueryString["RTF"] != null)
                {
                    RTF = Request.QueryString["RTF"].Trim();
                    if (RTF == "1") { rbt_close.Checked = true; }
                    else if (RTF == "0") { rbt_open.Checked = true;  }
                    InspectionStatus();
                }

                //bindBusinessUnit();

                if (Request.QueryString["BU"] != null)
                {
                    BU = Request.QueryString["BU"].Trim();
                }
                if (Request.QueryString["EC"] != null)
                {
                    EC = Request.QueryString["EC"].Trim();
                }
                if (Request.QueryString["YR"] != null)
                {
                    YR = Request.QueryString["YR"].Trim();
                }

                if (BU == "")
                {
                    rbt_open.Checked = true;
                    InspectionStatus();
                    bindBusinessUnit();
                    ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                    bindYear();
                }
                else
                {
                    InspectionStatus();
                    bindBusinessUnit();
                    ddl_Bunit.SelectedValue = BU;
                    bindYear();
                }
                if (YR == "")
                {
                    BindEventCode();
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                    BindEventCode();
                }
                if (EC != "")
                {
                    ddl_eventcode.SelectedValue = EC;
                    BindCompany();
                    if (ddl_Company.Items.Count == 2)
                    {
                        ddl_Company.SelectedIndex = 1;
                    }
                    else
                    {
                        ddl_Company.SelectedIndex = -1;
                    }
                    GetAssgnEdit();
                    bindGrid();
                    ResetControl();
                    btn_add1.Visible = false;
                }
                
            }

        }
        protected void GetAssgnEdit()
        {
          
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_TREAT_STATUS = 0;
            int V_EVENT_CODE_ID = 0;
            int V_COMPANY_ID = 0;
            V_TREAT_STATUS = m_TreatStatus;
            int retVal = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddl_eventcode.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);
                if (V_COMPANY_ID > 0)
                {
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    sqlParams.Add(new OleDbParameter("V_TREAT_STATUS", V_TREAT_STATUS));
                    sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    sqlParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR));
                    sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                    sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                    // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPRAWC_GET_EDITABLE, sqlParams);

                }
                else
                {
                    retVal = 0;
                }
                if (retVal == 1)
                { AssgnEdit = "Y"; }
                }
                catch { }
                finally
                {
                }
            if (hdn_role.Value == "2" & AssgnEdit == "Y")
            {
                if (gdv_WA_Company.Rows.Count > 0)
                { btn_add1.Visible = false; }
                else
                { btn_add1.Visible = true; }
               
                //btnAddRate.Visible = true;
                gdv_WA_Company.Columns[2].Visible = true;  
            }
            else if (hdn_role.Value == "3" & AssgnEdit == "Y")
            {
                if (gdv_WA_Company.Rows.Count > 0)
                { btn_add1.Visible = false; }
                else
                { btn_add1.Visible = true; }

                //btnAddRate.Visible = true;
                gdv_WA_Company.Columns[2].Visible = true;
            }
            else
            {
                btn_add1.Visible = false;
                //btnAddRate.Visible = false;
                gdv_WA_Company.Columns[2].Visible = false;   
            }
        }
        protected void InspectionStatus()
        {
            if (rbt_open.Checked == true)
            {
                m_TreatStatus = 1;
            }

            else
            {
                m_TreatStatus = 9;
            }
        }
        void bindBusinessUnit()
        {
            try
            {

                int V_TREAT_STATUS = 0;

                V_TREAT_STATUS = m_TreatStatus;

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_TREAT_STATUS", V_TREAT_STATUS));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRAWC_SEL_BSUNIT, OledbParams, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindYear()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_TREAT_STATUS = 0;

            V_TREAT_STATUS = m_TreatStatus;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_TREAT_STATUS", V_TREAT_STATUS));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRAWC_SEL_YEAR, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }
        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_TREAT_STATUS = 0;

            V_TREAT_STATUS = m_TreatStatus;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_TREAT_STATUS", V_TREAT_STATUS));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRAWC_SEL_EVENTCODE, OledbParams, ddl_eventcode);
            }
            catch
            {
            }
        }
        void BindCompany()
        {
            try
            {
               // DataAccessUtility.BindListboxWithoutConditionViaProcedure(m_SP_SPRAWC_SEL_COMPANY, lst_Company);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                //DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SPRAWC_SEL_COMPANY, OledbParams, lst_Company);
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRAWC_SEL_COMPANY_S, OledbParams, ddl_Company);
            }
            catch
            {
            }
            //if (ddl_Company.Items.Count == 2)
            //{
            //    ddl_Company.SelectedIndex = 1;
            //}
            //else
            //{
            //    ddl_Company.SelectedIndex = -1;
            //}
        }
        //void bindWorkAreas()
        //{
        //    try
        //    {
        //        if (ddl_eventcode.SelectedIndex >= 0)
        //        {
        //            lst_selWorkArea.Items.Clear();
        //            List<OleDbParameter> OledbParams = new List<OleDbParameter>();
        //            OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
        //            OledbParams.Add(new OleDbParameter("V_YEAR", Convert.ToInt32(ddl_Year.SelectedValue)));
        //            OledbParams.Add(new OleDbParameter("V_EVENT_CODE", ddl_eventcode.SelectedValue));
        //            DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SPRAWC_SEL_WA_FOR_EVCODE, OledbParams, lst_WorkArea);
        //        }
        //        else
        //        {
        //            lst_WorkArea.Items.Clear();
        //            lst_selWorkArea.Items.Clear();
        //        }
        //    }
        //    catch
        //    {
        //    }
        //}

        protected void ddl_eventcode_SelectedIndexChanged(object sender, EventArgs e)
        {
           
            BindCompany();
           // GetAssgnEdit();
           // bindGrid();
          //  ResetControl();
        }

        protected void ddl_eventcode_DataBound(object sender, EventArgs e)
        {
            BindCompany();
            // bindWorkAreas();
           // GetAssgnEdit();
           // bindGrid();
           // ResetControl();
        }

        //protected void btn_addWA_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        if (lst_WorkArea.SelectedValue.ToString().Trim() != "")
        //        {
        //            foreach (ListItem item in this.lst_WorkArea.Items)
        //            {
        //                if (item.Selected)
        //                {
        //                    this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
        //                }
        //            }


        //            for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
        //            {
        //                if (lst_WorkArea.Items[i].Selected)
        //                {
        //                    lst_WorkArea.Items.RemoveAt(i);
        //                }

        //            }

        //        }
        //        else
        //        {
        //            foreach (ListItem item in this.lst_WorkArea.Items)
        //            {
        //                if (item.Value.ToString().Trim() != "")
        //                {
        //                    this.lst_selWorkArea.Items.Add(new ListItem(item.Text, item.Value));
        //                }
        //            }

        //            for (int i = lst_WorkArea.Items.Count - 1; i >= 0; i--)
        //            {
        //                if (lst_WorkArea.Items[i].Value.ToString() != "")
        //                {
        //                    lst_WorkArea.Items.RemoveAt(i);
        //                }

        //            }

        //        }
        //    }
        //    catch
        //    {
        //    }
        //}

        //protected void btn_addComp_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        if (lst_Company.SelectedValue.ToString().Trim() != "")
        //        {
        //            foreach (ListItem item in this.lst_Company.Items)
        //            {
        //                if (item.Selected)
        //                {
        //                    this.lst_selCompany.Items.Add(new ListItem(item.Text, item.Value));
        //                }
        //            }

        //            for (int i = lst_Company.Items.Count - 1; i >= 0; i--)
        //            {
        //                if (lst_Company.Items[i].Selected)
        //                {
        //                    lst_Company.Items.RemoveAt(i);
        //                }

        //            }

        //        }
        //        else
        //        {
        //            foreach (ListItem item in this.lst_Company.Items)
        //            {
        //                if (item.Value.ToString().Trim() != "")
        //                {
        //                    this.lst_selCompany.Items.Add(new ListItem(item.Text, item.Value));
        //                }
        //            }

        //            for (int i = lst_Company.Items.Count - 1; i >= 0; i--)
        //            {
        //                if (lst_Company.Items[i].Value.ToString() != "")
        //                {
        //                    lst_Company.Items.RemoveAt(i);
        //                }

        //            }

        //        }
        //    }
        //    catch
        //    {
        //    }
        //}

        //protected void btn_remWA_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        foreach (ListItem item in this.lst_selWorkArea.Items)
        //        {
        //            if (item.Selected)
        //            {
        //                this.lst_WorkArea.Items.Add(new ListItem(item.Text, item.Value));
        //            }
        //        }


        //        for (int i = lst_selWorkArea.Items.Count - 1; i >= 0; i--)
        //        {
        //            if (lst_selWorkArea.Items[i].Selected)
        //            {
        //                lst_selWorkArea.Items.RemoveAt(i);
        //            }

        //        }
        //    }
        //    catch
        //    {
        //    }
        //}

        //protected void btn_remComp_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        foreach (ListItem item in this.lst_selCompany.Items)
        //        {
        //            if (item.Selected)
        //            {
        //                this.lst_Company.Items.Add(new ListItem(item.Text, item.Value));
        //            }
        //        }

        //        for (int i = lst_selCompany.Items.Count - 1; i >= 0; i--)
        //        {
        //            if (lst_selCompany.Items[i].Selected)
        //            {
        //                lst_selCompany.Items.RemoveAt(i);
        //            }

        //        }
        //    }
        //    catch
        //    {
        //    }
        //}

        protected void btn_add1_Click(object sender, EventArgs e)
        {
            //try
            //{
            //    if (lst_selWorkArea.Items.Count == 0)
            //    {
            //        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No WorkArea Selected!')", true);
            //        return;
            //    }

            //    if (lst_selCompany.Items.Count == 0)
            //    {
            //        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Company Selected!')", true);
            //        return;
            //    }


            //    foreach (ListItem itemC in this.lst_selCompany.Items)
            //    {

            //foreach (GridViewRow row in gdv_WA_Company.Rows)
            //{
                int V_COMPANY_ID = ddl_Company.SelectedValue == "0"?0: Int32.Parse(ddl_Company.SelectedValue);
                AddDelete("INSERT", Int32.Parse(ddl_Year.SelectedValue), Int32.Parse(ddl_eventcode.SelectedValue), V_COMPANY_ID);

            //}
             //       createrateassign(Int32.Parse(ddl_Bunit.SelectedValue), Int32.Parse(ddl_Year.SelectedValue), Int32.Parse(ddl_eventcode.SelectedValue), Int32.Parse(itemC.Value));
            //    }


               bindGrid();
               GetAssgnEdit();
              
              //  ResetControl();
            //}
            //catch
            //{
            //}
        }

        //private void createrateassign(Int32 V_BUSINESS_UNIT_ID, Int32 V_RATE_YEAR_ID, Int32 V_EVENT_CODE_ID, Int32 V_COMPANY_ID)
        //{
        //    int retVal = 0;
        //    try
        //    {
        //        List<OleDbParameter> sqlParams = new List<OleDbParameter>();
        //        sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
        //        sqlParams.Add(new OleDbParameter("V_RATE_YEAR_ID", V_RATE_YEAR_ID));
        //        sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
        //        sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
        //        sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
        //        // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
        //        retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPRAWC_WA_RATES_COMP_ASSGN, sqlParams);


        //    }
        //    catch { }
        //    finally
        //    {
        //    }
        //}


        private void bindGrid()
        {
            gdv_WA_Company.DataBind();
            string V_EVENT_CODE = "";
            int V_TREAT_STATUS = 0;

            V_TREAT_STATUS = m_TreatStatus;
            try
            {
                V_EVENT_CODE = ddl_eventcode.SelectedValue;

                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_TREAT_STATUS", m_TreatStatus));
                OleDbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_YEAR", Convert.ToInt32(ddl_Year.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE));
                OleDbParams.Add(new OleDbParameter("V_COMPANY_ID", Convert.ToInt32(ddl_Company.SelectedValue)));

                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPRAWC_SEL_WA_COMPANY_S, OleDbParams, gdv_WA_Company);
            }
            catch
            {
            }
        }

        private void ResetControl()
        {
            //lst_selCompany.Items.Clear();
            //lst_selWorkArea.Items.Clear();

            //bindWorkAreas();
           // BindCompany();

            if (gdv_WA_Company.Rows.Count == 0)
            {
                btn_expExcel.Visible = false;
            }
            else
            {
                btn_expExcel.Visible = true;
            }
        }

        private void AddDelete(string strOperation, int YEAR_ID, int EVENT_CODE_ID, int COMPANY_ID)
        {
            int retVal = 0;
            int V_TREAT_STATUS = 0;

            V_TREAT_STATUS = m_TreatStatus;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_TREAT_STATUS", m_TreatStatus));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                sqlParams.Add(new OleDbParameter("V_YEAR_ID", YEAR_ID));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE", EVENT_CODE_ID));
                //sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", WORK_AREA_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPRAWC_WA_COMPANY_INS_DEL_S, sqlParams);


            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {


                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == 2)
            {
                 ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('This assignment can not be deleted.')", true);
            }

        }

        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            try
            {
                bindYear();
                // ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
            }
            catch
            {
            }
        }

        protected void gdv_WA_Company_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                GridViewRow row = (GridViewRow)gdv_WA_Company.Rows[e.RowIndex];
                int YEAR_ID = Int32.Parse(ddl_Year.SelectedValue);
                int EVENT_CODE_ID = Int32.Parse(ddl_eventcode.SelectedValue);
                int COMPANY_ID = Convert.ToInt32((row.FindControl("lbl_COMPANY_ID") as Label).Text);
                //int WORK_AREA_ID = Convert.ToInt32((row.FindControl("lbl_WORK_AREA_ID") as Label).Text);
                AddDelete("DELETE", YEAR_ID, EVENT_CODE_ID, COMPANY_ID);

                bindGrid();
                GetAssgnEdit();
            }
            catch
            {
            }
        }

        protected void gdv_WA_Company_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[3].Visible = false;
            //e.Row.Cells[5].Visible = false;
            //checks user role
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (hdn_role.Value == "2")
            {
                e.Row.Cells[2].Visible = true;
            }
            else if (hdn_role.Value == "3")
            {
                e.Row.Cells[2].Visible = true;
            }
            else
            {
                e.Row.Cells[2].Visible = false;
            }
        }

        protected void btnAddRate_Click(object sender, EventArgs e)
        {
            Response.Redirect("SprayProjectChemical.aspx?RTF=" + SelectedRetreatmentFlag() + "&BU=" + ddl_Bunit.SelectedValue + "&EC=" + ddl_eventcode.SelectedValue + "&YR=" + ddl_Year.SelectedValue);
        }

        int SelectedRetreatmentFlag()
        {
            int v_treatement_flag = 0;
            if (rbt_open.Checked)
                v_treatement_flag = 0;
            else if (rbt_close.Checked)
                v_treatement_flag = 1;
            return v_treatement_flag;
        }
        protected void btn_expExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddl_eventcode.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { 3 });
                VDMUtil.ExportGridToExcel(gdv_WA_Company, "Spray-Project-WorkArea-Company", "Spray_Workarea_Company", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void LinkButton1_Click(object sender, EventArgs e)
        {

        }

        protected void ddl_Company_SelectedIndexChanged(object seder, EventArgs e)
        {
            
            bindGrid();
            GetAssgnEdit();
            ResetControl();
            CheckApplyButtonVisibility();
        }

        protected void rbt_open_CheckedChanged(object sender, EventArgs e)
        {
            InspectionStatus();
            bindBusinessUnit();
       
            //btnSave.Visible = false;
          //  btnExportExcel.Visible = false;
        }

        protected void rbt_close_CheckedChanged(object sender, EventArgs e)
        {
            InspectionStatus();
            bindBusinessUnit();

            //btnSave.Visible = false;
            //  btnExportExcel.Visible = false;
        }

        protected void ddl_Company_DataBound(object sender, EventArgs e)
        {
            GetAssgnEdit();
             bindGrid();
             ResetControl();
        }

        private void CheckApplyButtonVisibility()
        {
            string V_EVENT_CODE = "";
            int V_TREAT_STATUS = 0;

            V_TREAT_STATUS = m_TreatStatus;
            try
            {
                V_EVENT_CODE = ddl_eventcode.SelectedValue;

                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                OleDbParams.Add(new OleDbParameter("V_TREAT_STATUS", m_TreatStatus));
                OleDbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_YEAR", Convert.ToInt32(ddl_Year.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE));

                DataSet ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SPRAWC_SEL_COMPANY_ASSIGN, OleDbParams);

                if (ds.Tables[0].Rows.Count > 0)
                {
                    btn_add1.Visible = false;
                }
            }
            catch
            {
            }
        }

    }
}