﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;

namespace VMT
{
    public partial class SprayOpenForContractor1 : System.Web.UI.Page
    {
        string m_SP_SPROC_SEL_BUSINESS_UNIT = Properties.Settings.Default.SP_SPROC_SEL_BUSINESS_UNIT;
        string m_SP_SPROC_SEL_YEAR = Properties.Settings.Default.SP_SPROC_SEL_YEAR;
        string m_SP_SPROC_SEL_ALL_EVENTCODE = Properties.Settings.Default.SP_SPROC_SEL_ALL_EVENTCODE;
        string m_SP_SPROC_SEL_EVENTCODE = Properties.Settings.Default.SP_SPROC_SEL_EVENTCODE;
        string m_SP_SPROC_OPEN_CONTRACTOR = Properties.Settings.Default.SP_SPROC_OPEN_CONTRACTOR;
        string m_SP_SPROC_UPD_OPEN_CONT_STATUS = Properties.Settings.Default.SP_SPROC_UPD_OPEN_CONT_STATUS;

        string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {
                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
                // ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                //BindEventCode();
                //BindGrid();
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPROC_SEL_BUSINESS_UNIT, ddlBUnit);
            }
            catch
            {
            }
        }

        void BindYear()
        {
            try
            {

                int V_BUSINESS_UNIT_ID = 0;

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPROC_SEL_YEAR, OledbParams, ddlYear);
            }
            catch
            {
            }


        }

        void BindEventCode()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPROC_SEL_EVENTCODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }


        }


        void BindGrid()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;
                int V_EVENT_CODE_ID = 0;
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPROC_OPEN_CONTRACTOR, OledbParams, gdvOpenContractor);
                ViewState["dataTable"] = gdvOpenContractor.DataSource as DataSet;
                gdvOpenContractor.SelectedIndex = -1;

                if (gdvOpenContractor.Rows.Count > 0)
                {
                    //btnSave.Visible = true;
                    btnExportExcel.Visible = true;
                }
                else
                {
                    // btnSave.Visible = false;
                    btnExportExcel.Visible = false;
                }

                //checks user role
                userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
                if (gdvOpenContractor.Rows.Count > 0 && userRole == "Edit")
                {
                    btnSave.Visible = true;
                }
                else
                {
                    btnSave.Visible = false;
                }
            }

            catch
            {
            }


        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
            //BindEventCode();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindGrid();
        }

        //protected void btnGo_Click(object sender, EventArgs e)
        //{
        //    BindGrid();
        //}



        protected void cbSelectAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ChkBoxHeader = (CheckBox)gdvOpenContractor.HeaderRow.FindControl("cbSelectAll");
            foreach (GridViewRow row in gdvOpenContractor.Rows)
            {
                CheckBox ChkBoxRows = (CheckBox)row.FindControl("cbSelect");
                if (ChkBoxRows.Enabled == true)
                {
                    if (ChkBoxHeader.Checked == true)
                    {
                        ChkBoxRows.Checked = true;
                    }
                    else
                    {
                        ChkBoxRows.Checked = false;
                    }
                }
            }
        }


        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                List<int> listHideColumns = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdvOpenContractor, "Open for Contractor", "Open_for_Contractor", dictionaryFilters, null);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
        protected void btnSave_Click(object sender, EventArgs e)
        {
            int retVal = 0;
            int V_WORK_AREA_ID;
            int V_WORK_STATUS_ID;
            int V_COMPANY_ID;
            foreach (GridViewRow row in gdvOpenContractor.Rows)
            {
                if (((CheckBox)row.FindControl("cbSelect")).Checked)
                {

                    V_WORK_AREA_ID = Convert.ToInt32(((Label)row.FindControl("lbl_WORK_AREA_ID")).Text);
                    V_WORK_STATUS_ID = 4;
                }

                else
                {
                    V_WORK_AREA_ID = Convert.ToInt32(((Label)row.FindControl("lbl_WORK_AREA_ID")).Text);
                    V_WORK_STATUS_ID = 3;
                }

                V_COMPANY_ID = Convert.ToInt32(((Label)row.FindControl("lbl_COMPANY_ID")).Text);
                try
                {
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    //sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                    sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                    sqlParams.Add(new OleDbParameter("V_WORK_STATUS_ID", V_WORK_STATUS_ID));
                    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPROC_UPD_OPEN_CONT_STATUS, sqlParams);
                }
                catch
                {
                }
            }

            if (retVal == 1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful')", true);
            }
            BindGrid();
        }

        protected void gdvOpenContractor_Sorting(object sender, System.Web.UI.WebControls.GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvOpenContractor, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }
    }
}