﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DataAccess;
using System.Data.OleDb;
using System.Data;

namespace VMT
{
    public partial class Spray_EC_WA : System.Web.UI.Page
    {
        string m_SP_SPRECWA_VDM_SEL_BU = Properties.Settings.Default.SP_SPRECWA_VDM_SEL_BU;
        string m_SP_SPRECWA_SELECT_EC = Properties.Settings.Default.SP_SPRECWA_SELECT_EC;
        string m_SP_SPRECWA_DISTRICT = Properties.Settings.Default.SP_SPRECWA_DISTRICT;
        string m_SP_SPRECWA_CYCLE = Properties.Settings.Default.SP_SPRECWA_CYCLE;
        string m_SP_SPRECWA_SEL_EVENT_CODE_DET = Properties.Settings.Default.SP_SPRECWA_SEL_EVENT_CODE_DET;
        string m_SP_SPRECWA_EC_WA_INS_UPD = Properties.Settings.Default.SP_SPRECWA_EC_WA_INS_UPD;
        string m_SP_SPRECWA_SEL_EXIST_EVENTCODE = Properties.Settings.Default.SP_SPRECWA_SEL_EXIST_EVENTCODE;
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Spray Event Code Maintenance";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
                //string userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
                //if (userRole == "Edit")
                //{
                //    btnSubmit.Visible = true;
                //}
                //else
                //{
                //    btnSubmit.Visible = false;
                //}

                bindBusinessUnit();
                bindDistrict();
                BindCycle(ddlCycle);

                BindYear(ddlCycleYear);
                BindYear(ddlSprayYear);
                ddlCycleYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                ddlSprayYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                
                CalculateTrimYearTgt();
                ////btnDelete.Visible = false;
                //BindNewText(ddlEventCode);
               

                //BindEventCode();
              
            }
        }
        void clearfield()
        {
            
            txtEventCode.Text = "";
            txtEventDescription.Text = "";
            txtEventCode.Enabled = true;
            ddlCycle.Enabled = true;
            ddlCycleYear.Enabled = true;
            txtFSYT.Enabled = true;
            BindCycle(ddlCycle);
            txtComment.Text = "";
            ddlCycleYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
            ddlSprayYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
        
        }
        void CalculateTrimYearTgt()
        {
            txtFSYT.Text = (Int32.Parse(ddlCycleYear.SelectedValue) + Int32.Parse(ddlCycle.SelectedValue)).ToString();
        }
        void BindCycle(DropDownList ddlCycle)
        {
            ddlCycle.Items.Clear();
            ddlCycle.Items.AddRange(Enumerable.Range(1, 9).Select(e => new ListItem(e.ToString())).ToArray());
            ddlCycle.SelectedValue = Properties.Settings.Default.SELECTED_CYCLE;
        }
        void BindYear(DropDownList ddlYr)
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPRECWA_CYCLE, ddlYr);
            }
            catch
            {
            }
        }
        void bindDistrict()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPRECWA_DISTRICT, ddlDistrict);
            }
            catch
            {
            }
        }
        void BindNewText(DropDownList ddl)
        {
            Dictionary<string, string> EC = new Dictionary<string, string>();
            EC.Add("-1", "-New-");
            ddl.DataSource = EC;
            ddl.DataValueField = "Key";
            ddl.DataTextField = "Value";
            ddl.DataBind();
        }

       

        protected void ddlCycle_SelectedIndexChanged(object sender, EventArgs e)
        {
            CalculateTrimYearTgt();
        }

       
        protected void ddlCycleYear_SelectedIndexChanged1(object sender, EventArgs e)
        {
            CalculateTrimYearTgt();
        }
       

        protected void rblEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (rblEventCode.SelectedValue == "0")
            {
                ddlEventCode.ClearSelection();
                ddlEventCode.Enabled = false;
                txtEventCode.Text = "";
                txtEventDescription.Text = "";
                ddlDistrict.ClearSelection();
                txtEventCode.Enabled = true;
                ddlCycle.Enabled = true;
                ddlCycleYear.Enabled = true;
                txtFSYT.Enabled = true;

                BindNewText(ddlEventCode);               
               
                txtComment.Text = "";
                
            }
            else
            {
                BindEventCode();
                ddlEventCode.Enabled = true;
                txtEventCode.Enabled = true;
                txtEventCode.Text = "";
                txtEventDescription.Text = "";
                ddlDistrict.ClearSelection();
            }

          
        }
        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
          
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBunit.SelectedValue);
                //V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

                if (rblEventCode.SelectedValue != "0")
                {
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));

                    DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRECWA_SELECT_EC, OledbParams, ddlEventCode);
                }
            }
            catch
            {
            }
        }
        protected void ddlBunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            clearfield();
            BindEventCode();
        }

        protected void txtEventCode_TextChanged(object sender, EventArgs e)
        {
            string V_EVENT_CODE;
            try
            {
                V_EVENT_CODE = txtEventCode.Text.Trim().ToUpper();
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE));

                int result = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPRECWA_SEL_EXIST_EVENTCODE, OledbParams);
                if (result > 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('This event code exists.')", true);
                    txtEventCode.Text = "";
                    txtEventCode.Focus();
                }
            }
            catch
            {
            }
        }

        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPRECWA_VDM_SEL_BU, ddlBunit);
            }
            catch
            {

            }
        }

        protected void ddlBunit_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlEventCode_SelectedIndexChanged1(object sender, EventArgs e)
        {
            BindEventCodeTextBox();
           
        }
        void BindEventCodeTextBox()
        {
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));

                DataSet ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SPRECWA_SEL_EVENT_CODE_DET, OledbParams);
                txtEventCode.Text = ds.Tables[0].Rows[0]["EVENT_CODE"].ToString();
                if (ds.Tables[0].Rows[0]["event_code_description"].ToString() != "")
                {
                    txtEventDescription.Text = ds.Tables[0].Rows[0]["event_code_description"].ToString();
                }
                if (ds.Tables[0].Rows[0]["SPRAY_CYCLE"].ToString() != "")
                {
                    ddlCycle.SelectedValue = ds.Tables[0].Rows[0]["SPRAY_CYCLE"].ToString();
                }
                if (ds.Tables[0].Rows[0]["SYSTEM_ASSIGNED_YEAR"].ToString() != "")
                {
                    ddlCycleYear.SelectedValue = ds.Tables[0].Rows[0]["SYSTEM_ASSIGNED_YEAR"].ToString();
                }
                if (ds.Tables[0].Rows[0]["SPRAY_YEAR_TARGET"].ToString() != "")
                {
                    ddlSprayYear.SelectedValue = ds.Tables[0].Rows[0]["SPRAY_YEAR_TARGET"].ToString();
                }
                if (ds.Tables[0].Rows[0]["FUTURE_SPRAY_YR_TGT"].ToString() != "")
                {
                    txtFSYT.Text = ds.Tables[0].Rows[0]["FUTURE_SPRAY_YR_TGT"].ToString();
                }
                if (ds.Tables[0].Rows[0]["INSPECTION_DUE_DATE"].ToString() != "")
                {
                    txtTrimDate.Text = ds.Tables[0].Rows[0]["INSPECTION_DUE_DATE"].ToString();
                }
                if (ds.Tables[0].Rows[0]["DISTRICT_ID"].ToString() != "")
                {
                    ddlDistrict.SelectedValue = ds.Tables[0].Rows[0]["DISTRICT_ID"].ToString();
                }
            }
            catch
            {
            }
        }

        protected void btnSubmit_Click1(object sender, EventArgs e)
        {

            string retVal = string.Empty;
            string V_EC_OPTION = string.Empty;
            int V_BUSINESS_UNIT_ID = 0;
            Int32 V_EVENT_CODE_ID = 0;
            string V_EVENT_CODE= string.Empty;
            string V_EVENT_DESCRIPTION = string.Empty;
            int V_SPRAY_CYCLE = 0;
            int V_SYSTEM_ASSIGNED_YEAR = 0;
            int V_SPRAY_YEAR_TARGET = 0;
            int V_FUTURE_SPRAY_YR_TGT = 0;
            int V_DISTRICT_ID = 0;
            string V_TRANSACTION_COMMENT= string.Empty;
            string V_LAST_UPDATED_USER_ID= string.Empty;


           

             if (txtEventCode.Text.Trim().Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Project / EventCode could not be blank!')", true);
                txtEventCode.Focus();
                return;
            }
             if (Convert.ToInt32(ddlEventCode.SelectedValue) == -1)
             {
                 V_EC_OPTION = "INSERT";
             }
             else
             {
                 V_EC_OPTION = "UPDATE";
             }
             V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBunit.SelectedValue);
             V_EVENT_CODE = txtEventCode.Text.Trim();
             V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
             V_EVENT_DESCRIPTION = txtEventDescription.Text;
             V_SPRAY_CYCLE = Convert.ToInt32(ddlCycle.SelectedValue);
             V_SYSTEM_ASSIGNED_YEAR = Convert.ToInt32(ddlCycleYear.SelectedValue);
             V_SPRAY_YEAR_TARGET = Convert.ToInt32(ddlSprayYear.SelectedValue);
             V_FUTURE_SPRAY_YR_TGT = Convert.ToInt32(txtFSYT.Text);
             if (ddlDistrict.SelectedIndex > 0)
             {
                 V_DISTRICT_ID = Convert.ToInt32(ddlDistrict.SelectedValue.ToString());
             }
             V_TRANSACTION_COMMENT = txtComment.Text;
             V_LAST_UPDATED_USER_ID = System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper();

           
             try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();

                 sqlParams.Add(new OleDbParameter("V_EC_OPTION", V_EC_OPTION));
                 sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                 sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                 sqlParams.Add(new OleDbParameter("V_EVENT_CODE", V_EVENT_CODE));
                 sqlParams.Add(new OleDbParameter("V_EVENT_DESCRIPTION", V_EVENT_DESCRIPTION));
                 sqlParams.Add(new OleDbParameter("V_SPRAY_CYCLE", V_SPRAY_CYCLE));
                 sqlParams.Add(new OleDbParameter("V_SYSTEM_ASSIGNED_YEAR", V_SYSTEM_ASSIGNED_YEAR));
                 sqlParams.Add(new OleDbParameter("V_SPRAY_YEAR_TARGET", V_SPRAY_YEAR_TARGET));
                 sqlParams.Add(new OleDbParameter("V_FUTURE_SPRAY_YR_TGT", V_FUTURE_SPRAY_YR_TGT));
                 sqlParams.Add(new OleDbParameter("V_DISTRICT_ID", V_DISTRICT_ID));
                 sqlParams.Add(new OleDbParameter("V_TRANSACTION_COMMENT", V_TRANSACTION_COMMENT));
                 sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", V_LAST_UPDATED_USER_ID));
                 // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                 retVal = DataAccessUtility.InsUpdDelViaStoreProcedureParam(m_SP_SPRECWA_EC_WA_INS_UPD, sqlParams);
                if (retVal == "1")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Project/EventCode already exists.')", true);
                    
                }
                else if (retVal != "")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Spray Event code saved successfully.')", true);
                    string EventCodeID = retVal;
                    rblEventCode.SelectedValue = "1";
                    ddlEventCode.Enabled = true;
                    BindEventCode();
                    ddlEventCode.SelectedValue = EventCodeID;
                    
                }
            }
            catch { }
            finally
            {
            }
        }

       

       
    }
}