﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using DataAccess;

namespace VMT
{
    public partial class Spray_CloseBid : System.Web.UI.Page
    {
        string m_SP_SPR_BID_STATUS_UPD_DEL_S = Properties.Settings.Default.SP_SPR_BID_STATUS_UPD_DEL;
        string m_SP_SPR_SELECT_BID_DESC_S = Properties.Settings.Default.SP_SPR_SELECT_BID_DESC;
        string m_SP_SPR_SELECT_BID_WORKAREA_S = Properties.Settings.Default.SP_SPR_SELECT_BID_WORKAREA;
        string m_SP_SPR_BID_HEADER_DEL_ALL_S = Properties.Settings.Default.SP_SPR_BID_HEADER_DEL_ALL;
        //string m_SP_SELECT_WORK_STATUS = Properties.Settings.Default.SP_SPR_SELECT_WORK_STATUS;
        string m_SP_SPR_SELECT_BID_STATUS_S = Properties.Settings.Default.SP_SPR_SELECT_BID_STATUS;
        string m_SELECTED_BID_STATUS = Properties.Settings.Default.SELECTED_BID_STATUS;
        string m_SP_SPR_SELECT_YEAR_BU_BC_S = Properties.Settings.Default.SP_SPR_SELECT_YEAR_BU_BC;
        string m_SP_SPR_SELECT_BSUNIT_BO_S = Properties.Settings.Default.SP_SPR_SELECT_BSUNIT_BO;
        string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;

        protected void Page_Load(object sender, EventArgs e)
        {
            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {

                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
                ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                BindBidStatus();
                BindBidDescription();
                //select bid status
                if (ddlBidStatus.Items.Count > 0)
                {
                    ListItem item = ddlBidStatus.Items.FindByValue(m_SELECTED_BID_STATUS);
                    if (item != null)
                    {
                        ddlBidStatus.SelectedValue = m_SELECTED_BID_STATUS;
                        BindBidDescription();
                        //BindBidGrid();
                    }
                }
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_SELECT_BSUNIT_BO_S, ddlBUnit);
            }
            catch
            {
            }
        }

        void BindYear()
        {
            //DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_SELECT_YEAR_BU_BC, ddlYear); //SP_SPR_SELECT_BID_MNTN_YEAR
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_SELECT_YEAR_BU_BC_S, sqlParams, ddlYear);

            }

            catch { }
            finally
            {

            }
        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
            //BindBidDescription();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindBidStatus();
            BindBidDescription();
        }

        void BindBidDescription()
        {
            try
            {
                //DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_SELECT_BID_DESCRIPTION, ddlBidDesc);            
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUNIT", Int32.Parse(ddlBUnit.SelectedValue.ToString())));
                sqlParams.Add(new OleDbParameter("V_YEAR", Int32.Parse(ddlYear.SelectedValue.ToString())));
                sqlParams.Add(new OleDbParameter("V_BID_STATUS", Int32.Parse(ddlBidStatus.SelectedValue.ToString())));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_SELECT_BID_DESC_S, sqlParams, ddlBidDesc);
            }
            catch
            {
            }

        }

        void BindBidStatus()
        {
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Int32.Parse(ddlBUnit.SelectedValue.ToString())));
                sqlParams.Add(new OleDbParameter("V_YEAR_ID", Int32.Parse(ddlYear.SelectedValue.ToString())));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_SELECT_BID_STATUS_S, sqlParams, ddlBidStatus);
                //DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_SELECT_BID_STATUS, ddlBidStatus);
            }
            catch
            {
            }
        }

        //void BindBidDescription()
        //{
        //    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
        //    sqlParams.Add(new OleDbParameter("V_BUNIT", Int32.Parse(ddlBUnit.SelectedValue.ToString())));
        //    sqlParams.Add(new OleDbParameter("V_YEAR", Int32.Parse(ddlYear.SelectedValue.ToString())));
        //    sqlParams.Add(new OleDbParameter("V_BID_STATUS", Int32.Parse(ddlBidStatus.SelectedValue.ToString())));
        //    DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_SELECT_BID_DESCRIPTION, sqlParams, ddlBidDesc);
        //}

        void BindBidGrid()
        {
            int bidId;
            //checks user role
            userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            try
            {
                if (ddlBidDesc.SelectedValue == "")
                    bidId = 0;
                else
                    bidId = Int32.Parse(ddlBidDesc.SelectedValue.ToString());
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BID_ID", bidId));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPR_SELECT_BID_WORKAREA_S, sqlParams, gdvBidClose);
                ViewState["dataTable"] = gdvBidClose.DataSource as DataSet;
                gdvBidClose.SelectedIndex = -1;

                if (gdvBidClose.Rows.Count > 0)
                {
                    btnExportExcel.Visible = true;
                    if (ddlBidStatus.SelectedValue.ToString() == "2" && userRole == "Edit")
                    {
                        btnCloseBid.Visible = true;
                        btnDeleteBid.Visible = true;
                    }
                    else
                    {
                        btnCloseBid.Visible = false;
                        btnDeleteBid.Visible = false;
                    }

                }
                else
                {
                    btnExportExcel.Visible = false;
                    btnCloseBid.Visible = false;
                    btnDeleteBid.Visible = false;
                }
            }
            catch
            {
            }

            string wkStatus = string.Empty;
            wkStatus = ddlBidDesc.Items[ddlBidDesc.SelectedIndex].Text;
            //if (wkStatus.Substring(wkStatus.IndexOf('-') + 1, wkStatus.Length - (wkStatus.IndexOf('-') + 1)) == "Bid Close")
            //{
            //    //btnCloseBid.Enabled = false;
            //    //btnDeleteBid.Enabled = false;
            //}
            //else
            //{
            //    //btnCloseBid.Enabled = true;
            //    //btnDeleteBid.Enabled = true;
            //}

        }

        protected void gdvBidClose_RowDataBound(object sender,
        System.Web.UI.WebControls.GridViewRowEventArgs e)
        {
            //checks user role
            userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);

            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton lkBtnDelete = (LinkButton)e.Row.FindControl("lkBtnDelete");
                HiddenField hdn_WkStsID = (HiddenField)e.Row.FindControl("hdn_WkStsID");
                if (Convert.ToInt32(hdn_WkStsID.Value) == 3 || userRole == "View")
                {
                    if (gdvBidClose.Rows.Count == 0)
                        gdvBidClose.Columns[1].Visible = false;
                    lkBtnDelete.Visible = false;
                    gdvBidClose.HeaderRow.Cells[1].Visible = false;
                }
                else
                {
                    gdvBidClose.Columns[1].Visible = true;
                    lkBtnDelete.Visible = true;
                    gdvBidClose.HeaderRow.Cells[1].Visible = true;
                }
            }

        }

        protected void ddlBidDesc_SelectedIndexChanged(object sender, EventArgs e)
        {

            BindBidGrid();
        }

        protected void chkboxSelectAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ChkBoxHeader = (CheckBox)gdvBidClose.HeaderRow.FindControl("cbSelectAll");
            foreach (GridViewRow row in gdvBidClose.Rows)
            {
                CheckBox ChkBoxRows = (CheckBox)row.FindControl("cbSelect");
                if (ChkBoxHeader.Checked == true)
                {
                    ChkBoxRows.Checked = true;
                }
                else
                {
                    ChkBoxRows.Checked = false;
                }
            }
        }




        protected void btnCloseBid_Click(object sender, EventArgs e)
        {
            try
            {
                if (ddlBidDesc.SelectedValue == "" || ddlBidStatus.SelectedValue != "2")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Could not able to close the Bid ')", true);
                }
                else
                {
                    foreach (GridViewRow row in gdvBidClose.Rows)
                    {

                        int V_BID_ID = Convert.ToInt32((row.FindControl("hdn_BidID") as HiddenField).Value);
                        int V_EVENT_CODE_ID = Convert.ToInt32((row.FindControl("hdn_EVENT_CODE_ID") as HiddenField).Value);
                        UpdateDelete("UPDATE", V_BID_ID, V_EVENT_CODE_ID);
                    }
                }
            }

            catch { }
            finally
            {

            }
        }

        protected void btnDeleteBid_Click(object sender, EventArgs e)
        {
            int retVal = 0;
            //ScriptManager.RegisterStartupScript(this, this.GetType(), "script", "javascript:if(confirm('Are you sure you want to delete?') == false) return false;", true);
            List<OleDbParameter> sqlParams = new List<OleDbParameter>();
            try
            {
                if (ddlBidDesc.SelectedValue == "")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('could not able to delete the Bid ')", true);
                }
                else
                {
                    //GridViewRow row = (GridViewRow)gdvBidClose.Rows[e.RowIndex];
                    //int V_EVENT_CODE_ID = Convert.ToInt32((row.FindControl("hdn_EVENT_CODE_ID") as HiddenField).Value);

                    //sqlParams.Add(new OleDbParameter("V_BID_ID", Int32.Parse(ddlBidDesc.SelectedValue)));
                    sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", Int32.Parse(ddlBidDesc.SelectedValue)));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPR_BID_HEADER_DEL_ALL_S, sqlParams);
                    if (retVal == 1)
                    {
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Bid details deleted successfully')", true);
                        BindBidDescription();
                        BindBidGrid();
                    }
                    else
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('could not able to delete the Bid ')", true);
                }
            }
            catch
            {
            }

        }
        protected void gdvBidClose_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                GridViewRow row = (GridViewRow)gdvBidClose.Rows[e.RowIndex];
                int V_BID_ID = Convert.ToInt32((row.FindControl("hdn_BidID") as HiddenField).Value);
                int V_EVENT_CODE_ID = Convert.ToInt32((row.FindControl("hdn_EVENT_CODE_ID") as HiddenField).Value);
                UpdateDelete("DELETE", V_BID_ID, V_EVENT_CODE_ID);
            }
            catch
            {
            }
        }

        private void UpdateDelete(string strOperation, int V_BID_ID, int V_EVENT_CODE_ID)
        {
            int retVal = 0;
            int insCnt = 0;
            int selBidIndex = ddlBidDesc.SelectedIndex;
            try
            {
                List<OleDbParameter> sqlParamsBD = new List<OleDbParameter>();
                sqlParamsBD.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParamsBD.Add(new OleDbParameter("V_BID_ID", V_BID_ID));
                sqlParamsBD.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                sqlParamsBD.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPR_BID_STATUS_UPD_DEL_S, sqlParamsBD);

                if (retVal == 1)
                    insCnt++;
                else if (retVal == -1)
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('could not able to " + strOperation.ToLower() + "')", true);

                else if (retVal == 2)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Bid detail deleted successfully')", true);
                    BindBidDescription();
                    BindBidGrid();
                }

                if (insCnt > 0 && strOperation == "UPDATE")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Bid closed successfully')", true);
                    BindBidDescription();
                    ddlBidDesc.SelectedIndex = selBidIndex;
                    BindBidGrid();
                }
                else if (insCnt > 0 && strOperation == "DELETE")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Bid detail deleted successfully')", true);
                    BindBidGrid();
                }
            }
            catch { }
            finally
            {

            }
        }

        protected void ddlBidStatus_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindBidDescription();

        }

        protected void ddlBidDesc_DataBound(object sender, EventArgs e)
        {
            BindBidGrid();
        }


        protected void gdvBidClose_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvBidClose, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }


        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
                dictionaryFilters.Add("Bid Status", ddlBidStatus.SelectedItem.Text);
                dictionaryFilters.Add("Bid Description", ddlBidDesc.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { });
                VDMUtil.ExportGridToExcel(gdvBidClose, "Bid Maintain", "Bid_Maintain", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        //protected void btnGo_Click(object sender, EventArgs e)
        //{
        //    BindBidGrid(); 
        //}



        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindBidStatus();
        }

        protected void ddlBUnit_DataBound(object sender, EventArgs e)
        {
            BindYear();
        }

        protected void ddlBidStatus_DataBound(object sender, EventArgs e)
        {
            BindBidDescription();
        }
    }
}