﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;

namespace VMT
{
    public partial class Spray_Chemicals : System.Web.UI.Page
    {
        string m_SP_SELECT_SPRAY_CHEMICAL = Properties.Settings.Default.SP_SELECT_SPRAY_CHEMICAL;
        string m_SP_SELECT_SPR_CHEMICAL_DETAIL = Properties.Settings.Default.SP_SELECT_SPR_CHEMICAL_DETAIL;
        string m_SP_VDM_SPRAY_CHEMICAL_INS_UPD = Properties.Settings.Default.SP_VDM_SPRAY_CHEMICAL_INS_UPD;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Spray Chemical";

        protected void Page_Load(object sender, EventArgs e)
        {
          
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    btn_add.Visible = true;
            //}
            //else
            //{
            //    btn_add.Visible = false;
            //}

            if (!Page.IsPostBack)
            {
                //checks user role
                // userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                BindGrid();
                btn_create.Visible = false;
                btn_delete.Visible = false;

            }
        }

        protected void BindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_SELECT_SPRAY_CHEMICAL, gdv_SprayChemical);
                gdv_SprayChemical.SelectedIndex = -1;
            }
            catch
            {
            }
        }

        protected void btn_add_Click(object sender, EventArgs e)
        {

            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            AddUpdate("UPDATE");
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            ClearFields();
        }

        void ClearFields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txtSprayChemical.Text = "";
        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                ClearFields();
            }

            else
            {
                GetDetail();
            }
        }

        void GetDetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_CHEMICAL_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_SPR_CHEMICAL_DETAIL, OleDbParams);
                txtSprayChemical.Text = ds.Tables[0].Rows[0]["CHEMICAL_DESCRIPTION"].ToString();
            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }
        protected void gdv_SprayChemical_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_SprayChemical.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;

         //   if (userRole == "3")
           // {
                btn_add.Text = "Update";
                btn_create.Visible = true;
                btn_delete.Visible = true;
         //   }
            GetDetail();
        }

        private void AddUpdate(string strOperation)
        {
            if (txtSprayChemical.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Spray chemical could not be blank!')", true);
                txtSprayChemical.Focus();
                return;
            }

            int spraychemical_id = 0;
            if (strOperation == "INSERT")
            {
                spraychemical_id = 0;
            }
            else
            {
                spraychemical_id = Int32.Parse(hdn_keyid.Value);
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_CHEMICAL_DESCRIPTION", txtSprayChemical.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_CHEMICAL_ID", spraychemical_id));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_SPRAY_CHEMICAL_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                BindGrid();
                ClearFields();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Spray chemical already exists.')", true);
            }
            else if (retVal == 2)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Spray chemical already in use.')", true);
            }

        }

        protected void gdv_SprayChemical_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }
    }
}