﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.IO;
 

namespace VMT
{
    public partial class SprayRatesCompany : System.Web.UI.Page
    {


        string m_SP_SPR_PRA_SELECT_BU = Properties.Settings.Default.SP_SPR_PRA_SELECT_BU; //SP_SELECT_BUSINESS_UNIT
        string m_SP_SPR_PRA_RATE_YEARS_BU = Properties.Settings.Default.SP_SPR_PRA_RATE_YEARS_BU; //SP_SELECT_RATE_YEARS_BU
        string m_SP_SPR_PRA_SELECT_CMP_FOR_EC = Properties.Settings.Default.SP_SPR_PRA_SELECT_CMP_FOR_EC;//SP_SELECT_COMPANY_FOR_EC;
        string m_SP_SPR_PRA_SELECT_RATE_FOR_CMP = Properties.Settings.Default.SP_SPR_PRA_SELECT_RATE_FOR_CMP;//SP_SELECT_RATES_FOR_COMPANY;
        string m_SP_SPR_PRA_SELECT_RATES_CMP = Properties.Settings.Default.SP_SPR_PRA_SELECT_RATES_CMP;//SP_VDM_SELECT_RATES_COMPANY;
        string m_SP_SPR_PRA_RATES_CMP_INS_DEL = Properties.Settings.Default.SP_SPR_PRA_RATES_CMP_INS_DEL;//SP_VDM_RATES_COMPANY_INS_DEL;
        string m_SP_SPR_PRA_SELECT_RATETYPE_DET = Properties.Settings.Default.SP_SPR_PRA_SELECT_RATETYPE_DET;//SP_SELECT_RATE_TYPES_DETAIL;
        string m_SP_VDM_WA_RATES_COMPANY_ASSGN = Properties.Settings.Default.SP_VDM_WA_RATES_COMPANY_ASSGN;
        string m_SP_SPR_PRA_SELECT_EC_RATE_CMP = Properties.Settings.Default.SP_SPR_PRA_SELECT_EC_RATE_CMP;//SP_SELECT_EC_FOR_RATE_COMP;
        string BU = "";
        string EC = "";
        string YR = "";
        string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;

        protected void Page_Load(object sender, EventArgs e)
        {
            //checks user role
            userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (userRole == "Edit")
            {
                rowAdd.Visible = true;
                rowAddBtn.Visible = true;
            }
            else
            {
                rowAdd.Visible = false;
                rowAddBtn.Visible = false;
            }

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(btn_expExcel);
           
            if (!Page.IsPostBack)
            {
                btn_expExcel.Visible = false;

                bindBusinessUnit();

                

                 if (Request.QueryString["BU"] != null )
                 {
                     BU = Request.QueryString["BU"].Trim();
                 }
                 if (Request.QueryString["EC"] != null)
                 {
                     EC = Request.QueryString["EC"].Trim();
                 }
                 if (Request.QueryString["YR"] != null)
                 {
                     YR = Request.QueryString["YR"].Trim();
                 }

                 if (BU == "")
                 {
                     ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                     bindYear();
                 }
                 else
                 {
                     ddl_Bunit.SelectedValue = BU;
                     bindYear();                    
                 }
                 if (YR == "")
                 {
                    // ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                     BindEventCode();
                 }
                 else
                 {
                     ddl_Year.SelectedValue = YR;
                     BindEventCode();
                 }
                 if (EC != "")
                 {
                     ddlEventCode.SelectedValue = EC;
                     bindCompany();
                     bindGrid();
                 }
                CreateNew.Visible = false;
            }
        }

        void bindrateType()
        {

            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRA_SELECT_RATE_FOR_CMP, OledbParams, ddl_RateTypes);
            }
            catch
            {
            }
        }

        void bindCompany()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRA_SELECT_CMP_FOR_EC, OledbParams, ddl_Company);
            }
            catch
            {
            }
            if (ddl_Company.Items.Count == 2)
            {
                ddl_Company.SelectedIndex = 1;
            }
            else
            {
                ddl_Company.SelectedIndex = -1;
            }
        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPR_PRA_SELECT_BU, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindYear()
        {
            ddl_Year.Items.Clear();
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRA_RATE_YEARS_BU, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }
        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();
            bindrateType();           
            bindGrid();
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            bindYear();
            if (!Page.IsPostBack)
            {
                if (YR == "")
                {
                  //  ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                }
            }
            
          
           
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
           // bindrateType();
            BindEventCode();
            bindGrid();
        }

        void BindEventCode()
        {
            ddlEventCode.Items.Clear();
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRA_SELECT_EC_RATE_CMP, OledbParams, ddlEventCode);
            }
            catch
            {
            }
        }
        protected void gdv_WA_Rate_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[4].Visible = false;
            e.Row.Cells[5].Visible = false;
            e.Row.Cells[6].Visible = false;
            e.Row.Cells[7].Visible = false;
            e.Row.Cells[8].Visible = false;
            //checks user role
            userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (userRole == "Edit")
            {
                e.Row.Cells[3].Visible = true;
            }
            else
            {
                e.Row.Cells[3].Visible = false;
            }
        }

        protected void ddl_RateTypes_SelectedIndexChanged(object sender, EventArgs e)
        {
           // bindrateType();
            bindGrid();
            getUOM();
        }

        void getUOM()
        {
            try
            {
                if (ddl_RateTypes.SelectedIndex >= 0)
                {
                    DataSet ds = new DataSet();
                    List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                    OleDbParams.Add(new OleDbParameter("V_RATE_TYPE_ID", ddl_RateTypes.SelectedValue));
                    ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SPR_PRA_SELECT_RATETYPE_DET, OleDbParams);
                    //bind the fields 
                    lbl_UOM.Text = ds.Tables[0].Rows[0]["UOM"].ToString();
                }
                else
                {
                    lbl_UOM.Text = "";
                }
            }
            catch
            {
            }
        }
        protected void ddl_Company_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindrateType();
            bindGrid();
            resetControl();
        }

        public int intnull(string inttext)
        {
            int value1 = 0;
            try
            {
                value1 = Convert.ToInt32(inttext);
            }
            catch (Exception ex)
            {          
                value1 = 0;
            }
            return value1;
        }
        private void bindGrid()
        {

            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_COMPANY_ID = intnull(ddl_Company.SelectedValue);

                V_EVENT_CODE_ID = intnull(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPR_PRA_SELECT_RATES_CMP, OledbParams, gdv_Rate_Company);
            }
            catch
            {
            }
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                if (YR == "")
                {
                   // ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                }
            }

            BindEventCode();
        }

        protected void ddl_Company_DataBound(object sender, EventArgs e)
        {
           
          
            bindrateType();
            bindGrid();
            resetControl();
        }

        protected void btn_addRates_Click(object sender, EventArgs e)
        {
            if (Convert.ToInt32(ddl_Company.SelectedValue) <= 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select a Company!')", true);
                ddl_Company.Focus();
                return;
            }

            if (txt_Rateamount.Text.Trim() == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Amount could not be blank!')", true);
                txt_Rateamount.Focus();
                return;
            }

            if (ddl_RateTypes.SelectedIndex < 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Rate Type!')", true);
                ddl_RateTypes.Focus();
                return;
            }
             double V_RATE_TYPE_AMOUNT = 0.0;
            try 
            {
                V_RATE_TYPE_AMOUNT = Convert.ToDouble(txt_Rateamount.Text.Trim());
            }
            catch (Exception ex)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Amount could not be non-Numeric!')", true);
                    txt_Rateamount.Focus();
                    return;
            }
                
            string strOperation = "";
            int V_RATE_YEAR_ID = 0;
            int V_RATE_TYPE_ID = 0;
            int V_COMPANY_ID = 0;
            string V_RATE_LOCK = " ";
            int V_BUSINESS_UNIT_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                strOperation = "INSERT";
                V_RATE_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_RATE_TYPE_ID = Convert.ToInt32(ddl_RateTypes.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);
                V_RATE_LOCK = "";
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);


                AddDelete(strOperation, V_RATE_YEAR_ID, V_RATE_TYPE_ID, V_COMPANY_ID, V_RATE_LOCK, V_BUSINESS_UNIT_ID, V_RATE_TYPE_AMOUNT, V_EVENT_CODE_ID);




                bindGrid();
                bindrateType();

                resetControl();
            }
            catch
            {
            }
        }

       

        protected void gdv_Rate_Company_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {

           GridViewRow row = (GridViewRow)gdv_Rate_Company.Rows[e.RowIndex];
           try
           {
               int V_RATE_YEAR_ID = Convert.ToInt32((row.FindControl("lbl_RATE_YEAR_ID") as Label).Text);
               int V_RATE_TYPE_ID = Convert.ToInt32((row.FindControl("lbl_RATE_TYPE_ID") as Label).Text);
               int V_COMPANY_ID = Convert.ToInt32((row.FindControl("lbl_COMPANY_ID") as Label).Text);
               string V_RATE_LOCK = " ";
               int V_BUSINESS_UNIT_ID = Convert.ToInt32((row.FindControl("lbl_BUSINESS_UNIT_ID") as Label).Text);
               double V_RATE_TYPE_AMOUNT = 0.0;
               int V_EVENT_CODE_ID = Convert.ToInt32((row.FindControl("lbl_EVENT_CODE_ID") as Label).Text);
               AddDelete("DELETE", V_RATE_YEAR_ID, V_RATE_TYPE_ID, V_COMPANY_ID, V_RATE_LOCK, V_BUSINESS_UNIT_ID, V_RATE_TYPE_AMOUNT, V_EVENT_CODE_ID);
               bindGrid();
               bindrateType();
               resetControl();
           }
           catch
           {
           }
        }
        void resetControl()
        {
            txt_Rateamount.Text = "";
            if (gdv_Rate_Company.Rows.Count == 0)
            {
                btn_expExcel.Visible = false;
            }
            else
            {
                btn_expExcel.Visible = true;
            }
           
        }
        private void AddDelete(string strOperation, int V_RATE_YEAR_ID, int V_RATE_TYPE_ID, int V_COMPANY_ID, string V_RATE_LOCK, int V_BUSINESS_UNIT_ID, double V_RATE_TYPE_AMOUNT, int V_EVENT_CODE_ID)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_RATE_YEAR_ID", V_RATE_YEAR_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_ID", V_RATE_TYPE_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_LOCK", V_RATE_LOCK));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_AMOUNT", V_RATE_TYPE_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPR_PRA_RATES_CMP_INS_DEL, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {

                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " successful.')", true);

            }
            else if (retVal == -1)
            {
               // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " failed.')", true);
            }

        }

      

        protected void btnshowhide_Click(object sender, ImageClickEventArgs e)
        {
            if (CreateNew.Visible == true)
            {
                CreateNew.Visible = false;
                btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
            }
            else
            {
                btnshowhide.ImageUrl = "resource_gallery/graphics/minus.png";
                CreateNew.Visible = true;
            }
        }

        protected void ddl_RateTypes_DataBound(object sender, EventArgs e)
        {
            getUOM();

        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            if (ddl_Bunit.SelectedIndex < 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Business Unit!')", true);
                ddl_RateTypes.Focus();
                return;
            }
            if ( ddlEventCode.SelectedIndex < 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Event Code!')", true);
                ddlEventCode.Focus();
                return;
            }

            if (gdv_Rate_Company.Rows.Count == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Add Rates for Company!')", true);
               
                return;
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue.ToString().Trim()));
                sqlParams.Add(new OleDbParameter("V_RATE_YEAR_ID", ddl_Year.SelectedValue.ToString().Trim()));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", ddl_Company.SelectedValue.ToString().Trim()));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", ddlEventCode.SelectedValue.ToString().Trim())); 
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_WA_RATES_COMPANY_ASSGN, sqlParams);


            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {


                 ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate assignment successful')", true);

            }
            else if (retVal == -1)
            {
                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Work_Area Company already exists')", true);
            }
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            bindCompany();
            
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindCompany();
            bindGrid();
            resetControl();
        }

        protected void btn_WA_COMP_Click(object sender, EventArgs e)
        {
            Response.Redirect("Spray_Workarea_Company.aspx?BU=" + ddl_Bunit.SelectedValue + "&EC=" + ddlEventCode.SelectedValue + "&YR=" + ddl_Year.SelectedValue);
        }

        protected void btn_warateComp_Click(object sender, EventArgs e)
        {
            Response.Redirect("WA_Rates_Company.aspx?BU=" + ddl_Bunit.SelectedValue + "&EC=" + ddlEventCode.SelectedValue + "&YR=" + ddl_Year.SelectedValue);
        }
        private void ExportGridToExcel()
        {
            
           

            try
            {
                Response.Clear();
                Response.Buffer = true;
                Response.ClearContent();
                Response.ClearHeaders();
                Response.Charset = "";
                string FileName = "RateCompany" + DateTime.Now + ".xls";
                StringWriter strwritter = new StringWriter();
                HtmlTextWriter htmltextwrtter = new HtmlTextWriter(strwritter);
                Response.Cache.SetCacheability(HttpCacheability.NoCache);
                Response.ContentType = "application/vnd.ms-excel";
                Response.AddHeader("Content-Disposition", "attachment;filename=" + FileName);
                gdv_Rate_Company.GridLines = GridLines.Both;
                gdv_Rate_Company.HeaderStyle.Font.Bold = true;
                gdv_Rate_Company.RenderControl(htmltextwrtter);
                Response.Write(strwritter.ToString());
                Response.End();


            }
            catch { }
            finally
            {
            }

        }
        protected void btn_expExcel_Click(object sender, EventArgs e)
        {
            try
            {
                gdv_Rate_Company.ShowHeader = true;
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                dictionaryFilters.Add("Company", ddl_Company.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { 3 });
                VDMUtil.ExportGridToExcel(gdv_Rate_Company, "Rate Company", "RateCompany", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
    }
}