﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.IO;

namespace VMT
{
    public partial class SprayProjectChemical : System.Web.UI.Page
    {
        int m_TreatStatus; 
        string m_SP_SPR_PRCA_SELECT_BU = Properties.Settings.Default.SP_SPR_PRCA_SELECT_BU;
        string m_SP_SPR_PRACA_YEARS_BU = Properties.Settings.Default.SP_SPR_PRACA_YEARS_BU;
        string m_SP_SPR_PRCA_SELECT_EC_CHEM = Properties.Settings.Default.SP_SPR_PRCA_SELECT_EC_CHEM;
        string m_SP_SPR_PRCA_SELECT_CHEMICAL = Properties.Settings.Default.SP_SPR_PRCA_SELECT_CHEMICAL;
        string m_SP_SPR_PRCA_SELECT_UOM_DET = Properties.Settings.Default.SP_SPR_PRCA_SELECT_UOM_DET;
        string m_SP_SPR_PRCA_CHEMICAL_INS_DEL = Properties.Settings.Default.SP_SPR_PRCA_CHEMICAL_INS_DEL;
        string m_SP_SPR_PRCA_SELECT_CHEMICALS = Properties.Settings.Default.SP_SPR_PRCA_SELECT_CHEMICALS;
        string m_SP_PRCA_SEL_COMPANY = Properties.Settings.Default.SP_PRCA_SEL_COMPANY;
        string m_SP_SPRAWC_GET_EDITABLE = Properties.Settings.Default.SP_SPRAWC_GET_EDITABLE;


        string BU = "";
        string EC = "";
        string YR = "";
        string RTF = "";
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string AssgnEdit = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Spray Project Chemical Assignment";

        protected void Page_Load(object sender, EventArgs e)
        {
            
            InspectionStatus();
            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(btn_expExcel);
            //InspectionStatus();
            if (!Page.IsPostBack)
            {


                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }
                hdn_role.Value = userRole;

                if (userRole == "0")
                {
                    Response.Redirect("default.aspx");
                }
                else if (userRole == "2" || userRole == "3")
                {
                    rowAdd.Visible = true;
                    rowAddBtn.Visible = true;
                }
                else
                {
                    rowAdd.Visible = false;
                    rowAddBtn.Visible = false;
                }

                btn_expExcel.Visible = false;

                if (Request.QueryString["RTF"] != null)
                {
                    RTF = Request.QueryString["RTF"].Trim();
                    if (RTF == "1") { rdSprayRetreat.Checked = true; }
                    else if (RTF == "0") { rdSprayTreat.Checked = true; }
                    InspectionStatus();
                }

                

                if (Request.QueryString["BU"] != null)
                {
                    BU = Request.QueryString["BU"].Trim();
                }
                if (Request.QueryString["EC"] != null)
                {
                    EC = Request.QueryString["EC"].Trim();
                }
                if (Request.QueryString["YR"] != null)
                {
                    YR = Request.QueryString["YR"].Trim();
                }

                if (BU == "")
                {
                    rdSprayTreat.Checked = true;
                    InspectionStatus();
                    bindBusinessUnit();
                    ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                    bindYear();
                }
                else
                {
                    InspectionStatus();
                    bindBusinessUnit();
                    ddl_Bunit.SelectedValue = BU;
                    bindYear();
                }
                if (YR == "")
                {
                    BindEventCode();
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                    BindEventCode();
                }
                if (EC != "")
                {
                    ddlEventCode.SelectedValue = EC;
                    BindCompany();
                    bindChemical();
                    getUOM();
                    bindGrid();
                    resetControl();
                }

                CreateNew.Visible = false;
            }
        }

        void bindChemical()
        {

            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            //int V_COMPANY_ID = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("v_business_unit_id", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("v_event_code_id", V_EVENT_CODE_ID));
                OledbParams.Add(new OleDbParameter("v_treatment_type_id", SelectedRetreatmentFlag()));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRCA_SELECT_CHEMICAL, OledbParams, ddl_Chemical);
            }
            catch
            {
            }
        }

        void BindCompany()
        {
             try
            {
                lbl_ddl_Company_id.Text = "";
                lbl_ddl_Company.Text = "";
                int V_EVENT_CODE_ID = intnull(ddlEventCode.SelectedValue);
                int V_YEAR_ID = intnull(ddl_Year.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", Convert.ToInt32(ddl_Bunit.SelectedValue)));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                //DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_PRCA_SEL_COMPANY, OledbParams, ddl_Company);
                DataSet ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_PRCA_SEL_COMPANY, OledbParams);
                if (ds.Tables[0].Rows.Count > 1)
                {
                    lbl_ddl_Company_id.Text = ds.Tables[0].Rows[1]["ID"].ToString();
                    lbl_ddl_Company.Text = ds.Tables[0].Rows[1]["NAME"].ToString();
                    GetAssgnEdit();
                }
            }
             catch
             {
             }
        }
        void bindBusinessUnit()
        {           
            try
            {
                int V_TREAT_STATUS = 0;
                V_TREAT_STATUS = m_TreatStatus;
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_TREAT_STATUS", V_TREAT_STATUS));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRCA_SELECT_BU, OledbParams, ddl_Bunit);
            }
            catch
            {
            }
        }

        int  SelectedRetreatmentFlag()
        {
            int v_treatement_flag = 0;
            if (rdSprayTreat.Checked)
                v_treatement_flag = 0;
            else if (rdSprayRetreat.Checked)
                v_treatement_flag = 1;
            return v_treatement_flag;
        }
        void bindYear()
        {
            ddl_Year.Items.Clear();
            int V_TREAT_STATUS =  m_TreatStatus;
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_TREAT_STATUS", V_TREAT_STATUS));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRACA_YEARS_BU, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }
        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();
            bindChemical();
            bindGrid();
        }

        protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        {
            bindYear();
            if (!Page.IsPostBack)
            {
                if (YR == "")
                {
                    //  ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                }
            }


          
            bindChemical();
            bindGrid();
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            // bindChemical();
            BindEventCode();
            bindGrid();
        }

        void BindEventCode()
        {
            ddlEventCode.Items.Clear();
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_TREAT_STATUS = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_TREAT_STATUS = m_TreatStatus;

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_TREAT_STATUS", V_TREAT_STATUS));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRCA_SELECT_EC_CHEM, OledbParams, ddlEventCode);
            }
            catch
            {
            }

        }
        protected void gdv_WA_Rate_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[3].Visible = false;
            e.Row.Cells[4].Visible = false;
            e.Row.Cells[5].Visible = false;
            e.Row.Cells[6].Visible = false;
            //e.Row.Cells[7].Visible = false;
            //e.Row.Cells[8].Visible = false;
            //checks user role
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (hdn_role.Value == "2" || hdn_role.Value == "3")
            {
                e.Row.Cells[2].Visible = true;
            }
            else
            {
                e.Row.Cells[2].Visible = false;
            }
        }

        protected void ddl_Chemical_SelectedIndexChanged(object sender, EventArgs e)
        {
            // bindChemical();
            bindGrid();
            getUOM();
            AddPannelShowHide();
        }

        void getUOM()
        {
            lbl_UOM.Text = "";
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                if (ddl_Chemical.SelectedIndex >= 0)
                {
                    V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                    DataSet ds = new DataSet();
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();                    
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    OledbParams.Add(new OleDbParameter("v_chemical_id", ddl_Chemical.SelectedValue));
                    ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SPR_PRCA_SELECT_UOM_DET, OledbParams);
                    //bind the fields 
                    if (ds.Tables[0].Rows.Count > 0)
                    {
                        lbl_UOM.Text = ds.Tables[0].Rows[0]["Name"].ToString();
                    }
                   // DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPR_PRCA_SELECT_UOM_DET, OledbParams, ddl_UOM);
                }
                else
                {
                    lbl_UOM.Text = "";
                    //ddl_UOM.SelectedItem.Text = "";
                }
            }
            catch
            {
            }
        }
        

        public int intnull(string inttext)
        {
            int value1 = 0;
            try
            {
                value1 = Convert.ToInt32(inttext);
            }
            catch (Exception ex)
            {
                value1 = 0;
            }
            return value1;
        }
        private void bindGrid()
        {
            gdv_Rate_Company.DataBind();
            //int V_COMPANY_ID = ddl_Company.SelectedValue == "0" ? 0 : Int32.Parse(ddl_Company.SelectedValue);  
            //int V_COMPANY_ID = lbl_ddl_Company_id.Text == "0" ? 0 : Int32.Parse(lbl_ddl_Company_id.Text);   
            int V_BUSINESS_UNIT_ID = 0;
            int V_CHEMICAL_ID = 0;
            int V_EVENT_CODE_ID = 0;
            int V_TREAT_STATUS = 0;
            V_TREAT_STATUS = m_TreatStatus;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_CHEMICAL_ID = intnull(ddl_Chemical.SelectedValue);
                V_EVENT_CODE_ID = intnull(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_TREAT_STATUS", m_TreatStatus));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", Convert.ToInt32(ddl_Year.SelectedValue)));
                //OledbParams.Add(new OleDbParameter("V_CHEMICAL_ID", V_CHEMICAL_ID));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                //OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPR_PRCA_SELECT_CHEMICALS, OledbParams, gdv_Rate_Company);
            }
            catch
            {
            }
        }

        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                if (YR == "")
                {
                    // ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                }
                else
                {
                    ddl_Year.SelectedValue = YR;
                }
            }

            BindEventCode();
        }

       

        protected void btn_addRates_Click(object sender, EventArgs e)
        
        {
            //if (Convert.ToInt32(ddl_Company.SelectedValue) <= 0)
            //{
            //    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select a Company!')", true);
            //    ddl_Company.Focus();
            //    return;
            //}

            if (Convert.ToInt32(ddlEventCode.SelectedValue) <= 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select a Eventcode!')", true);
                ddlEventCode.Focus();
                return;
            }



            if (ddl_Chemical.SelectedIndex < 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Chemical!')", true);
                ddl_Chemical.Focus();
                return;
            }

            //if (ddl_UOM.SelectedIndex < 0)
            //{
            //    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select UOM!')", true);
            //    ddl_UOM.Focus();
            //    return;
            //}
            string strOperation = "";
            int V_BUSINESS_UNIT_ID = 0;
            int V_EVENT_CODE_ID = 0;
            int V_CHEMICAL_ID = 0;
            try
            {
                strOperation = "INSERT";

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_CHEMICAL_ID = Convert.ToInt32(ddl_Chemical.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);


                AddDelete(strOperation, V_CHEMICAL_ID, V_BUSINESS_UNIT_ID, V_EVENT_CODE_ID);

                bindGrid();
                bindChemical();
                getUOM();
                resetControl();
                AddPannelShowHide();
            }
            catch
            {
            }
        }



        protected void gdv_Rate_Company_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {

            GridViewRow row = (GridViewRow)gdv_Rate_Company.Rows[e.RowIndex];
            try
            {
                int V_CHEMICAL_ID = Convert.ToInt32((row.FindControl("lbl_CHEMICAL_ID") as Label).Text);
                int V_BUSINESS_UNIT_ID = Convert.ToInt32((row.FindControl("lbl_BUSINESS_UNIT_ID") as Label).Text);
                int V_EVENT_CODE_ID = Convert.ToInt32((row.FindControl("lbl_EVENT_CODE_ID") as Label).Text);
                AddDelete("DELETE", V_CHEMICAL_ID, V_BUSINESS_UNIT_ID, V_EVENT_CODE_ID);
                bindGrid();
                bindChemical();
                resetControl();
                
                    AddPannelShowHide();
            }
            catch
            {
            }
        }
        void resetControl()
        {

            if (gdv_Rate_Company.Rows.Count == 0)
            {
                btn_expExcel.Visible = false;
            }
            else
            {
                btn_expExcel.Visible = true;
            }

        }
        private void AddDelete(string strOperation, int V_CHEMICAL_ID, int V_BUSINESS_UNIT_ID, int V_EVENT_CODE_ID)
        {
            
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));

                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                sqlParams.Add(new OleDbParameter("V_CHEMICAL_ID", V_CHEMICAL_ID));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                sqlParams.Add(new OleDbParameter("V_RETREATMENT_FLAG", SelectedRetreatmentFlag()));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPR_PRCA_CHEMICAL_INS_DEL, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {

                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " successful.')", true);

            }
            else if (retVal == -1)
            {
                // ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation.ToLower() + " failed.')", true);
            }

        }



        protected void btnshowhide_Click(object sender, ImageClickEventArgs e)
        {
            if (CreateNew.Visible == true)
            {
                CreateNew.Visible = false;
                btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
            }
            else
            {
                btnshowhide.ImageUrl = "resource_gallery/graphics/minus.png";
                CreateNew.Visible = true;
            }
        }

        protected void AddPannelShowHide()
        {
            CreateNew.Visible = true;
            if (CreateNew.Visible == true)
            {
                btnshowhide.ImageUrl = "resource_gallery/graphics/minus.png"; 
            }
            else
            {
                btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
            }
            
        }

        protected void ddl_Chemical_DataBound(object sender, EventArgs e)
        {
            getUOM();
            
        }

        void ShowHideAdd()
        {
            if (ddl_Chemical.Items.Count > 0)
            {
                btn_addRates.Visible = true;
            }
            else
            {
                btn_addRates.Visible = false;
            }
        }
       
        

        void DisplayAddPannel()
        {
            if (ddlEventCode.SelectedItem.Text.Contains("(Bid Close)") == true || ddlEventCode.SelectedItem.Text.Contains("(Re-treat Open)") == true)
                AddPannel.Visible = true;
            else
                AddPannel.Visible = false;

        }

        protected void btn_WA_COMP_Click(object sender, EventArgs e)
        {
            Response.Redirect("Spray_Workarea_Company.aspx?RTF=" + SelectedRetreatmentFlag() + "&BU=" + ddl_Bunit.SelectedValue + "&EC=" + ddlEventCode.SelectedValue + "&YR=" + ddl_Year.SelectedValue);
        }

        protected void btn_warateComp_Click(object sender, EventArgs e)
        {
            Response.Redirect("WA_Rates_Company.aspx?BU=" + ddl_Bunit.SelectedValue + "&EC=" + ddlEventCode.SelectedValue + "&YR=" + ddl_Year.SelectedValue);
        }
        private void ExportGridToExcel()
        {
            try
            {
                Response.Clear();
                Response.Buffer = true;
                Response.ClearContent();
                Response.ClearHeaders();
                Response.Charset = "";
                string FileName = "RateCompany" + DateTime.Now + ".xls";
                StringWriter strwritter = new StringWriter();
                HtmlTextWriter htmltextwrtter = new HtmlTextWriter(strwritter);
                Response.Cache.SetCacheability(HttpCacheability.NoCache);
                Response.ContentType = "application/vnd.ms-excel";
                Response.AddHeader("Content-Disposition", "attachment;filename=" + FileName);
                gdv_Rate_Company.GridLines = GridLines.Both;
                gdv_Rate_Company.HeaderStyle.Font.Bold = true;
                gdv_Rate_Company.RenderControl(htmltextwrtter);
                Response.Write(strwritter.ToString());
                Response.End();


            }
            catch { }
            finally
            {
            }

        }
        protected void btn_expExcel_Click(object sender, EventArgs e)
        {
            try
            {
                gdv_Rate_Company.ShowHeader = true;
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                dictionaryFilters.Add("Chemical", ddl_Chemical.SelectedItem.Text);
                List<int> listColumnIndex = new List<int>(new int[] { 2 });
                VDMUtil.ExportGridToExcel(gdv_Rate_Company, "Spray Project Chemical", "SprayProjectChemical", dictionaryFilters, listColumnIndex);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void rdSprayTreat_CheckedChanged(object sender, EventArgs e)
        {
            InspectionStatus();
            bindBusinessUnit();
            
        }
        protected void rdSprayRetreat_CheckedChanged(object sender, EventArgs e)
        {
            InspectionStatus();
            bindBusinessUnit();
        }

        protected void InspectionStatus()
        {
            if (rdSprayTreat.Checked == true)
            {
                m_TreatStatus = 1;
            }

            else
            {
                m_TreatStatus = 9;
            }
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            GetAssgnEdit();
            BindCompany();
            bindChemical();
            getUOM();
            bindGrid();
            resetControl();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            GetAssgnEdit();
            BindCompany();
            bindChemical();
            getUOM();
            bindGrid();
            resetControl();
        }

        
        protected void GetAssgnEdit()
        {

            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_TREAT_STATUS = 0;
            int V_EVENT_CODE_ID = 0;
            int V_COMPANY_ID = 0;
            V_TREAT_STATUS = m_TreatStatus;
            int retVal = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(lbl_ddl_Company_id.Text);
                if (V_COMPANY_ID > 0)
                {
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    sqlParams.Add(new OleDbParameter("V_TREAT_STATUS", V_TREAT_STATUS));
                    sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    sqlParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR));
                    sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                    sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                    // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPRAWC_GET_EDITABLE, sqlParams);

                }
                else
                {
                    retVal = 0;
                }
                if (retVal == 1)
                { AssgnEdit = "Y"; }
            }
            catch { }
            finally
            {
            }

           

            if (ddlEventCode.SelectedIndex > 0)
            {
                

                if ((hdn_role.Value == "2" || hdn_role.Value == "3" ) & AssgnEdit == "Y")
                //if (userRole == "Edit" & (ddlEventCode.SelectedItem.Text.Contains("(Bid Close)") == true || ddlEventCode.SelectedItem.Text.Contains("(Re-treat Open)") == true))
                {
                    //AddPannel.Visible = true;
                    btnshowhide.Visible = true;
                    btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
                    CreateNew.Visible = false;
                    //gdv_Rate_Company.Columns[2].Visible = true;
                    
                    
                }
                else
                {
                    //AddPannel.Visible = false;
                    btnshowhide.Visible = false;
                    CreateNew.Visible = false;
                    //gdv_Rate_Company.Columns[2].Visible = false;
                    
                   
                }
            }
            else
            {
                //AddPannel.Visible = false;
                btnshowhide.Visible = false;
                CreateNew.Visible = false;
                //gdv_Rate_Company.Columns[2].Visible = false;
                
            }
        }

        protected void gdv_Rate_Company_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                GetAssgnEdit();
                LinkButton lnkDelete = (LinkButton)e.Row.FindControl("lnkDelete");
                if ((hdn_role.Value == "2" || hdn_role.Value == "3") & AssgnEdit == "Y")
                    lnkDelete.Visible = true;
                else
                    lnkDelete.Visible = false;
            }
        }


    }
}