﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data;
using System.Data.OleDb;
using DataAccess;

namespace VMT
{
    public partial class SprayCloseProject : System.Web.UI.Page
    {
        string m_SP_SPRPI_VDM_SEL_BU = Properties.Settings.Default.SP_SPRPI_VDM_SEL_BU;
        string m_SP_SPRPI_VDM_SEL_YEAR_CC = Properties.Settings.Default.SP_SPRPI_VDM_SEL_YEAR_CC;
        //string m_SP_VDM_SELECT_ALL_EVENTCODE = Properties.Settings.Default.SP_SPRPI_VDM_SEL_ALL_EC;
        string m_SP_SPRPI_VDM_SEL_EC = Properties.Settings.Default.SP_SPRPI_VDM_SEL_EC;

        string m_SP_SPRPI_SEL_CLOSED_PROJECT_S = Properties.Settings.Default.SP_SPRPI_SEL_CLOSED_PROJECT;
        string m_SP_SPRPI_UPD_STATUS_PJTCLOSE_S = Properties.Settings.Default.SP_SPRPI_UPD_STATUS_PJTCLOSE;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Close Spray Project/Event";
        int cnt = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                hdn_role.Value = userRole;
                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
                // ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                BindEventCode();
                BindGrid();
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPRPI_VDM_SEL_BU, ddlBUnit);
            }
            catch
            {

            }
        }

        void BindYear()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRPI_VDM_SEL_YEAR_CC,OledbParams, ddlYear);
            }
            catch
            {

            }

        }

        void BindEventCode()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRPI_VDM_SEL_EC, OledbParams, ddlEventCode);
            }
            catch
            {

            }

        }

        protected void ResertEventcode()
        {
            int ECposition = 0;
            ECposition = Convert.ToInt32(ddlEventCode.SelectedValue);
            BindEventCode();
            ddlEventCode.SelectedValue = ECposition.ToString();
        }
        void BindGrid()
        {
            if (ddlYear.SelectedIndex == 0 || ddlEventCode.SelectedIndex == 0)
            {
                gdvCloseProject.DataSource = null;
                gdvCloseProject.DataBind();
                btnExportExcel.Visible = false;
                btnSubmit.Visible = false;
            }

            else
            {
                try
                {
                    int V_BUSINESS_UNIT_ID = 0;
                    int V_YEAR = 0;
                    int V_EVENT_CODE_ID = 0;
                    V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                    V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                    V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                    OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                    DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPRPI_SEL_CLOSED_PROJECT_S, OledbParams, gdvCloseProject);
                    ViewState["dataTable"] = gdvCloseProject.DataSource as DataSet;
                    gdvCloseProject.SelectedIndex = -1;
                }
                catch
                {

                }
            }

            if (gdvCloseProject.Rows.Count > 0)
            {
                gdvCloseProject.SelectedIndex = -1;
                btnExportExcel.Visible = true;
                // btnSubmit.Visible = true;
            }

            else
            {
                btnExportExcel.Visible = false;
                // btnSubmit.Visible = false;
            }
            //checks user role
            if (gdvCloseProject.Rows.Count > 0 && hdn_role.Value == "2")
            {
                btnSubmit.Visible = true;
            }
            else if (gdvCloseProject.Rows.Count > 0 && hdn_role.Value == "3")
            {
                btnSubmit.Visible = true;
            }
            else if (gdvCloseProject.Rows.Count > 0 && hdn_role.Value == "1")
            {
                btnSubmit.Visible = false;
            }
            else if (hdn_role.Value == "0")
            {
                Response.Redirect("Default.aspx");
            }
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (gdvCloseProject.Rows.Count > 0 && userRole == "Edit")
            //{
            //    btnSubmit.Visible = true;
            //}
            //else
            //{
            //    btnSubmit.Visible = false;
            //}

            foreach (GridViewRow row in gdvCloseProject.Rows)
            {
                if (((CheckBox)row.FindControl("cbSelect")).Enabled)
                {
                    cnt += 1;            
                }
            }

            if (cnt >= 1)
            {
                btnSubmit.Visible = true;
                cnt = 0;
            }
            else
            {
                btnSubmit.Visible = false;
            }
        }
        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            // BindEventCode();
            BindYear();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
            BindGrid();
        }
        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
            BindGrid();
        }
        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void btnGo_Click(object sender, EventArgs e)
        {
            BindGrid();
        }


        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            string str = string.Empty;
            int retVal = 0;
            //int V_WORK_AREA_ID;
            int V_WORK_STATUS_ID = 7; //project closed     
            int V_EVENT_CODE_ID;
            string V_EVENT_CODE;

            foreach (GridViewRow row in gdvCloseProject.Rows)
            {
                if (((CheckBox)row.FindControl("cbSelect")).Checked)
                {

                    V_EVENT_CODE = ((Label)row.FindControl("lbl_event_code")).Text;
                    V_EVENT_CODE_ID = Convert.ToInt32(((Label)row.FindControl("lbl_event_code_id")).Text);

                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                    sqlParams.Add(new OleDbParameter("V_WORK_STATUS_ID", V_WORK_STATUS_ID));
                    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPRPI_UPD_STATUS_PJTCLOSE_S, sqlParams);
                    if (retVal == 2)
                    {
                        str = str + ',' + V_EVENT_CODE;
                    }
                }
            }

            if (str != "")
            {
                str = str.Substring(1, str.Length-1);
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('The following event code could not be updated:"+str+"')", true);
            }
            else
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful')", true);
            }
            //if (retVal == 1)
            //{
            //    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful')", true);
            //}
            ResertEventcode();
            BindGrid();
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                List<int> listHideColumns = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdvCloseProject, "Close Project", "Close_Project", dictionaryFilters, null);
            }
            catch
            {
            }
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void cbSelectAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ChkBoxHeader = (CheckBox)gdvCloseProject.HeaderRow.FindControl("cbSelectAll");
            foreach (GridViewRow row in gdvCloseProject.Rows)
            {
                CheckBox ChkBoxRows = (CheckBox)row.FindControl("cbSelect");
                if (ChkBoxRows.Enabled == true)
                {
                    if (ChkBoxHeader.Checked == true)
                    {
                        ChkBoxRows.Checked = true;
                    }
                    else
                    {
                        ChkBoxRows.Checked = false;
                    }
                }
            }
        }

        protected void gdvCloseProject_Sorting(object sender, System.Web.UI.WebControls.GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvCloseProject, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

    }
}