﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;

namespace VMT
{
    public partial class Rpt_Workarea : System.Web.UI.Page
    {
        string m_SP_VDM_SELECT_BUSINESS_UNIT = Properties.Settings.Default.SP_VDM_SELECT_BUSINESS_UNIT;
        string m_SP_VDM_SELECT_YEAR = Properties.Settings.Default.SP_VDM_SELECT_YEAR;
        string m_SP_VDM_SELECT_ALL_EVENTCODE = Properties.Settings.Default.SP_VDM_SELECT_ALL_EVENTCODE;
        string m_SP_VDM_RPT_WORKAREA = Properties.Settings.Default.SP_VDM_RPT_WORKAREA;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                BindBusinessUnit();
                BindYear();
                BindEventCode();

                ViewState["BUnit"] = "0";
                ViewState["Year"] = "0";
                ViewState["EventCode"] = "";
                BindGrid();
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_BUSINESS_UNIT, ddlBUnit);
            }
            catch
            {
            }
        }

        void BindYear()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_YEAR, ddlYear);
            }
            catch
            {
            }
        }

        void BindEventCode()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_ALL_EVENTCODE, ddlEventCode);
            }
            catch
            {
            }
        }
              

        protected void btn_go_Click(object sender, EventArgs e)
        {
            ViewState["BUnit"] = ddlBUnit.SelectedValue;
            ViewState["Year"] = ddlYear.SelectedValue;
            ViewState["EventCode"] = ddlEventCode.SelectedValue;
            BindGrid();
        }
        private void BindGrid()
        {
            List<OleDbParameter> sqlParams = new List<OleDbParameter>();
            try
            {
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT", Int32.Parse(ViewState["BUnit"].ToString())));
                sqlParams.Add(new OleDbParameter("V_YEAR", Int32.Parse(ViewState["Year"].ToString())));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE", ViewState["EventCode"]));

                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_RPT_WORKAREA, sqlParams, gdvRptWorkarea);
                gdvRptWorkarea.SelectedIndex = -1;
            }
            catch
            {
            }
        }
    }
}