﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;

namespace VMT
{
    public partial class Retreatment : System.Web.UI.Page
    {
        string m_SP_SPRRT_VDM_SELECT_BU = Properties.Settings.Default.SP_SPRRT_VDM_SELECT_BU;
        string m_SP_SPRRT_VDM_SELECT_YR = Properties.Settings.Default.SP_SPRRT_VDM_SELECT_YR;
        //string m_SP_SPROC_SEL_ALL_EVENTCODE_S = Properties.Settings.Default.SP_SPROC_SEL_ALL_EVENTCODE;
        string m_SP_SPRRT_VDM_SELECT_EC = Properties.Settings.Default.SP_SPRRT_VDM_SELECT_EC;
        string m_SP_SPRRT_VDM_SELECT_WA = Properties.Settings.Default.SP_SPRRT_VDM_SELECT_WA;
        string m_SP_SPRRT_VDM_UPD_STATUS = Properties.Settings.Default.SP_SPRRT_VDM_UPD_STATUS;

        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Open for Re-treatment";

        protected void Page_Load(object sender, EventArgs e)
        {
            

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                hdn_role.Value = userRole;
                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
                // ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                //BindEventCode();
                //BindGrid();
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SPRRT_VDM_SELECT_BU, ddlBUnit);
            }
            catch
            {
            }
        }

        void BindYear()
        {
            try
            {

                int V_BUSINESS_UNIT_ID = 0;

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRRT_VDM_SELECT_YR, OledbParams, ddlYear);
            }
            catch
            {
            }


        }

        void BindEventCode()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;

                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SPRRT_VDM_SELECT_EC, OledbParams, ddlEventCode);
            }
            catch
            {
            }


        }

        protected void ResertEventcode()
        {
            int ECposition = 0;
            ECposition = Convert.ToInt32(ddlEventCode.SelectedValue);
            BindEventCode();
            ddlEventCode.SelectedValue = ECposition.ToString();
        }
        void BindGrid()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;
                int V_EVENT_CODE_ID = 0;
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_SPRRT_VDM_SELECT_WA, OledbParams, gdvOpenRetreatment);
                ViewState["dataTable"] = gdvOpenRetreatment.DataSource as DataSet;
                gdvOpenRetreatment.SelectedIndex = -1;

                if (gdvOpenRetreatment.Rows.Count > 0)
                {
                    //btnSave.Visible = true;
                    btnExportExcel.Visible = true;
                }
                else
                {
                    // btnSave.Visible = false;
                    btnExportExcel.Visible = false;
                }

                //checks user role
                if (gdvOpenRetreatment.Rows.Count > 0 && hdn_role.Value == "2")
                {
                    btnSave.Visible = true;
                }
                else if (gdvOpenRetreatment.Rows.Count > 0 && hdn_role.Value == "3")
                {
                    btnSave.Visible = true;
                }
                else if (gdvOpenRetreatment.Rows.Count > 0 && hdn_role.Value == "1")
                {
                    btnSave.Visible = false;
                }
                else if (hdn_role.Value == "0")
                {
                    Response.Redirect("Default.aspx");
                }
                //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
                //if (gdvOpenRetreatment.Rows.Count > 0 && userRole == "Edit")
                //{
                //    btnSave.Visible = true;
                //}
                //else
                //{
                //    btnSave.Visible = false;
                //}
            }

            catch
            {
            }


        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
            //BindEventCode();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindGrid();
        }

        //protected void btnGo_Click(object sender, EventArgs e)
        //{
        //    BindGrid();
        //}



        protected void cbSelectAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ChkBoxHeader = (CheckBox)gdvOpenRetreatment.HeaderRow.FindControl("cbSelectAll");
            foreach (GridViewRow row in gdvOpenRetreatment.Rows)
            {
                CheckBox ChkBoxRows = (CheckBox)row.FindControl("cbSelect");
                if (ChkBoxRows.Enabled == true)
                {
                    if (ChkBoxHeader.Checked == true)
                    {
                        ChkBoxRows.Checked = true;
                    }
                    else
                    {
                        ChkBoxRows.Checked = false;
                    }
                }
            }
        }


        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                List<int> listHideColumns = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdvOpenRetreatment, "Open for Retreatment", "Open_for_Retreatment", dictionaryFilters, null);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
        protected void btnSave_Click(object sender, EventArgs e)
        {
            int V_BUSINESS_UNIT_ID = 0;
            int retVal = 0;
            int V_EVENT_CODE_ID;
            int V_WORK_STATUS_ID;
            int V_COMPANY_ID;
            V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);

            foreach (GridViewRow row in gdvOpenRetreatment.Rows)
            {
                if (((CheckBox)row.FindControl("cbSelect")).Checked)
                {

                    V_EVENT_CODE_ID = Convert.ToInt32(((Label)row.FindControl("lbl_EVENT_CODE_ID")).Text);
                    V_WORK_STATUS_ID = 9;
                }

                else
                {
                    V_EVENT_CODE_ID = Convert.ToInt32(((Label)row.FindControl("lbl_EVENT_CODE_ID")).Text);
                    V_WORK_STATUS_ID = 8;
                }

                V_COMPANY_ID = Convert.ToInt32(((Label)row.FindControl("lbl_COMPANY_ID")).Text);
                try
                {
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    sqlParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                    sqlParams.Add(new OleDbParameter("V_WORK_STATUS_ID", V_WORK_STATUS_ID));
                    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_SPRRT_VDM_UPD_STATUS, sqlParams);
                }
                catch
                {
                }
            }

            if (retVal == 1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful')", true);
            }
            ResertEventcode();
            BindGrid();
        }

        protected void gdvOpenRetreatment_Sorting(object sender, System.Web.UI.WebControls.GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvOpenRetreatment, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }
    }
}