﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.SqlClient;

namespace VMT
{
    public partial class Rate_year : System.Web.UI.Page
    {
        string m_SP_SELECT_RATE_YEARS = Properties.Settings.Default.SP_SELECT_RATE_YEARS;
        string m_SP_VDM_RATE_YEARS_INS_UPD = Properties.Settings.Default.SP_VDM_RATE_YEARS_INS_UPD;
        string m_SP_SELECT_RATE_YEARS_DETAIL = Properties.Settings.Default.SP_SELECT_RATE_YEARS_DETAIL;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Cycle Year";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    btn_add.Visible = true;
            //}
            //else
            //{
            //    btn_add.Visible = false;
            //}

            if (!Page.IsPostBack)
            {
                //checks user role
                // userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                bindGrid();
                btn_create.Visible = false;
                btn_delete.Visible = false;

            }
        }
        private void bindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_SELECT_RATE_YEARS, gdv_list);
                gdv_list.SelectedIndex = -1;
            }
            catch
            {
            }
        }
        protected void btn_add_Click(object sender, EventArgs e)
        {
            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        private void AddUpdate(string strOperation)
        {
            if (txt_rateyear.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Year could not be blank!')", true);
               
                return;
            }
            int year_id = 0;
            if (strOperation == "INSERT")
            {
                year_id = 0;
            }
            else
            {
                year_id = Int32.Parse(hdn_keyid.Value);
            }

            string V_START_DATE = string.Empty;
            string V_END_DATE = string.Empty;

            try
            {
                if (txtStartDate.Text.Trim() != "")
                {
                    V_START_DATE = txtStartDate.Text.Trim();
                }
                else
                {
                    V_START_DATE = DBNull.Value.ToString();
                }

                if (txtEndDate.Text.Trim() != "")
                {
                    V_END_DATE = txtEndDate.Text.Trim();
                }
                else
                {
                    V_END_DATE = DBNull.Value.ToString();
                }
            }
            catch { }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));

                sqlParams.Add(new OleDbParameter("V_YEAR_ID", year_id));
                sqlParams.Add(new OleDbParameter("V_YEAR", txt_rateyear.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_START_DATE", V_START_DATE));
                sqlParams.Add(new OleDbParameter("V_END_DATE", V_END_DATE));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
               // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_RATE_YEARS_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                bindGrid();
              clearfields();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Year already exists')", true);
            }

        }

        void clearfields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txt_rateyear.Text = "";
            txtStartDate.Text = "";
            txtEndDate.Text = "";

        }

        protected void gdv_list_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_list.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;

          //  if (userRole == "3")
          //  {
                btn_add.Text = "Update";
                btn_create.Visible = true;
                btn_delete.Visible = true;
         //   }
            getdetail();
        }
        void getdetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_YEAR_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_RATE_YEARS_DETAIL, OleDbParams);


                //bind the fields 

                txt_rateyear.Text = ds.Tables[0].Rows[0]["YEAR"].ToString();
                string startdate = ds.Tables[0].Rows[0]["REPORT_START_DATE"].ToString();
                string enddate = ds.Tables[0].Rows[0]["REPORT_END_DATE"].ToString();
                if (startdate != "")
                {
                    txtStartDate.Text = String.Format("{0:MM-dd-yyyy}", Convert.ToDateTime(startdate));
                }
                else
                {
                    txtStartDate.Text = "";
                }

                if (enddate != "")
                {
                    txtEndDate.Text = String.Format("{0:MM-dd-yyyy}", Convert.ToDateTime(enddate));
                }
                else
                {
                    txtEndDate.Text = "";
                }
            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                clearfields();
            }

            else
            {
                getdetail();
            }
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            clearfields();
        }

        protected void gdv_list_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }
    }
}